/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.tempdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.execution.QueryExecPlugin;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.tempdata.TempTableStore;

public class TempTableStoreImpl
implements TempTableStore {
    private BufferManager buffer;
    private TempMetadataStore tempMetadataStore = new TempMetadataStore();
    private Map<String, TupleBuffer> groupToTupleSourceID = new HashMap<String, TupleBuffer>();
    private String sessionID;
    private TempTableStore parentTempTableStore;

    public TempTableStoreImpl(BufferManager buffer, String sessionID, TempTableStore parentTempTableStore) {
        this.buffer = buffer;
        this.sessionID = sessionID;
        this.parentTempTableStore = parentTempTableStore;
    }

    public void addTempTable(String tempTableName, List columns, boolean removeExistingTable) throws TeiidComponentException, QueryProcessingException {
        if (this.tempMetadataStore.getTempGroupID(tempTableName) != null) {
            if (!removeExistingTable) {
                throw new QueryProcessingException(QueryExecPlugin.Util.getString("TempTableStore.table_exist_error", new Object[]{tempTableName}));
            }
            this.removeTempTableByName(tempTableName);
        }
        this.tempMetadataStore.addTempGroup(tempTableName, columns, false, true);
        TupleBuffer tupleBuffer = this.buffer.createTupleBuffer(columns, this.sessionID, BufferManager.TupleSourceType.PROCESSOR);
        tupleBuffer.setFinal(true);
        this.groupToTupleSourceID.put(tempTableName, tupleBuffer);
    }

    @Override
    public void removeTempTableByName(String tempTableName) throws TeiidComponentException {
        this.tempMetadataStore.removeTempGroup(tempTableName);
        TupleBuffer tsId = this.groupToTupleSourceID.remove(tempTableName);
        if (tsId != null) {
            tsId.remove();
        }
    }

    @Override
    public TempMetadataStore getMetadataStore() {
        return this.tempMetadataStore;
    }

    @Override
    public TupleSource registerRequest(Command command) throws TeiidComponentException, ExpressionEvaluationException, QueryProcessingException {
        if (command instanceof Query) {
            Query query = (Query)command;
            GroupSymbol group = (GroupSymbol)query.getFrom().getGroups().get(0);
            if (!group.isTempGroupSymbol()) {
                return null;
            }
            TupleBuffer tsId = this.getTupleSourceID(group.getNonCorrelationName().toUpperCase(), command);
            return tsId.createIndexedTupleSource();
        }
        if (command instanceof ProcedureContainer) {
            GroupSymbol group = ((ProcedureContainer)command).getGroup();
            if (!group.isTempGroupSymbol()) {
                return null;
            }
            String groupKey = group.getNonCorrelationName().toUpperCase();
            TupleBuffer tsId = this.getTupleSourceID(groupKey, command);
            if (command instanceof Insert) {
                return this.addTuple((Insert)command, tsId);
            }
            if (command instanceof Update) {
                final Update update = (Update)command;
                Criteria crit = update.getCriteria();
                return new UpdateTupleSource(groupKey, tsId, crit){

                    @Override
                    protected void tuplePassed(List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
                        ArrayList newTuple = new ArrayList(tuple);
                        for (Map.Entry<ElementSymbol, Expression> entry : update.getChangeList().getClauseMap().entrySet()) {
                            newTuple.set((Integer)this.lookup.get(entry.getKey()), this.eval.evaluate(entry.getValue(), tuple));
                        }
                        ++this.updateCount;
                        this.addTuple(newTuple);
                    }

                    @Override
                    protected void tupleFailed(List<?> tuple) throws TeiidComponentException {
                        this.addTuple(tuple);
                    }
                };
            }
            if (command instanceof Delete) {
                Delete delete = (Delete)command;
                Criteria crit = delete.getCriteria();
                if (crit == null) {
                    int rows = tsId.getRowCount();
                    this.addTempTable(groupKey, tsId.getSchema(), true);
                    return CollectionTupleSource.createUpdateCountTupleSource(rows);
                }
                return new UpdateTupleSource(groupKey, tsId, crit){

                    @Override
                    protected void tuplePassed(List<?> tuple) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
                        ++this.updateCount;
                    }

                    @Override
                    protected void tupleFailed(List<?> tuple) throws TeiidComponentException {
                        this.addTuple(tuple);
                    }
                };
            }
        }
        if (command instanceof Create) {
            this.addTempTable(((Create)command).getTable().getName().toUpperCase(), ((Create)command).getColumns(), false);
            return CollectionTupleSource.createUpdateCountTupleSource(0);
        }
        if (command instanceof Drop) {
            String tempTableName = ((Drop)command).getTable().getName().toUpperCase();
            this.removeTempTableByName(tempTableName);
            return CollectionTupleSource.createUpdateCountTupleSource(0);
        }
        return null;
    }

    @Override
    public void removeTempTables() throws TeiidComponentException {
        for (String name : new ArrayList<String>(this.groupToTupleSourceID.keySet())) {
            this.removeTempTableByName(name);
        }
    }

    private TupleBuffer getTupleSourceID(String tempTableID, Command command) throws TeiidComponentException, QueryProcessingException {
        Insert insert;
        GroupSymbol group;
        TupleBuffer tsID = this.groupToTupleSourceID.get(tempTableID);
        if (tsID != null) {
            return tsID;
        }
        if (this.parentTempTableStore != null && (tsID = this.parentTempTableStore.getTupleSourceID(tempTableID)) != null) {
            return tsID;
        }
        List columns = null;
        if (command instanceof Insert && (group = (insert = (Insert)command).getGroup()).isImplicitTempGroupSymbol()) {
            columns = insert.getVariables();
        }
        if (columns == null) {
            throw new QueryProcessingException(QueryExecPlugin.Util.getString("TempTableStore.table_doesnt_exist_error", new Object[]{tempTableID}));
        }
        this.addTempTable(tempTableID, columns, true);
        return this.groupToTupleSourceID.get(tempTableID);
    }

    private TupleSource addTuple(Insert insert, TupleBuffer tsId) throws TeiidComponentException, ExpressionEvaluationException {
        GroupSymbol group = insert.getGroup();
        int tuplesAdded = 0;
        try {
            List<ElementSymbol> elements = ResolverUtil.resolveElementsInGroup(group, new TempMetadataAdapter(null, this.tempMetadataStore));
            List<List<Object>> tuples = TempTableStoreImpl.getBulkRows(insert, elements);
            for (List<Object> list : tuples) {
                tsId.addTuple(list);
            }
            tsId.saveBatch();
            tuplesAdded = tuples.size();
        }
        catch (QueryMetadataException err) {
            throw new TeiidComponentException((Throwable)((Object)err));
        }
        return CollectionTupleSource.createUpdateCountTupleSource(tuplesAdded);
    }

    public static List<List<Object>> getBulkRows(Insert insert, List<ElementSymbol> elements) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        int bulkRowCount = 1;
        if (insert.isBulk()) {
            Constant c = (Constant)insert.getValues().get(0);
            bulkRowCount = ((List)c.getValue()).size();
        }
        ArrayList<List<Object>> tuples = new ArrayList<List<Object>>(bulkRowCount);
        for (int row = 0; row < bulkRowCount; ++row) {
            ArrayList<Object> currentRow = new ArrayList<Object>(insert.getValues().size());
            for (ElementSymbol symbol : elements) {
                int index = insert.getVariables().indexOf(symbol);
                Object value = null;
                if (index != -1) {
                    if (insert.isBulk()) {
                        Constant multiValue = (Constant)insert.getValues().get(index);
                        value = ((List)multiValue.getValue()).get(row);
                    } else {
                        Expression expr = (Expression)insert.getValues().get(index);
                        value = Evaluator.evaluate(expr);
                    }
                }
                currentRow.add(value);
            }
            tuples.add(currentRow);
        }
        return tuples;
    }

    @Override
    public boolean hasTempTable(Command command) {
        switch (command.getType()) {
            case 2: {
                Insert insert = (Insert)command;
                GroupSymbol group = insert.getGroup();
                return group.isTempGroupSymbol();
            }
            case 1: {
                if (!(command instanceof Query)) break;
                Query query = (Query)command;
                GroupSymbol group = (GroupSymbol)query.getFrom().getGroups().get(0);
                return group.isTempGroupSymbol();
            }
            case 11: {
                return true;
            }
            case 12: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<String> getAllTempTables() {
        return new HashSet<String>(this.groupToTupleSourceID.keySet());
    }

    @Override
    public TupleBuffer getTupleSourceID(String tempTableName) {
        return this.groupToTupleSourceID.get(tempTableName.toUpperCase());
    }

    private abstract class UpdateTupleSource
    implements TupleSource {
        private final String groupKey;
        private final TupleBuffer oldBuffer;
        private final TupleSource ts;
        protected final Map lookup;
        private final TupleBuffer newBuffer;
        protected final Evaluator eval;
        private final Criteria crit;
        protected int updateCount = 0;
        private boolean done;
        private List<?> currentTuple;

        private UpdateTupleSource(String groupKey, TupleBuffer tsId, Criteria crit) throws TeiidComponentException {
            this.groupKey = groupKey;
            this.oldBuffer = tsId;
            this.ts = tsId.createIndexedTupleSource();
            List<?> columns = tsId.getSchema();
            this.lookup = RelationalNode.createLookupMap(columns);
            this.newBuffer = TempTableStoreImpl.this.buffer.createTupleBuffer(columns, TempTableStoreImpl.this.sessionID, BufferManager.TupleSourceType.PROCESSOR);
            this.eval = new Evaluator(this.lookup, null, null);
            this.crit = crit;
        }

        @Override
        public List<?> nextTuple() throws TeiidComponentException, TeiidProcessingException {
            if (this.done) {
                return null;
            }
            while (this.currentTuple != null || (this.currentTuple = this.ts.nextTuple()) != null) {
                if (this.eval.evaluate(this.crit, this.currentTuple)) {
                    this.tuplePassed(this.currentTuple);
                } else {
                    this.tupleFailed(this.currentTuple);
                }
                this.currentTuple = null;
            }
            this.newBuffer.close();
            TempTableStoreImpl.this.groupToTupleSourceID.put(this.groupKey, this.newBuffer);
            this.oldBuffer.remove();
            this.done = true;
            return Arrays.asList(this.updateCount);
        }

        protected void addTuple(List<?> tuple) throws TeiidComponentException {
            this.newBuffer.addTuple(tuple);
        }

        protected abstract void tuplePassed(List<?> var1) throws ExpressionEvaluationException, BlockedException, TeiidComponentException;

        protected abstract void tupleFailed(List<?> var1) throws TeiidComponentException;

        public List<SingleElementSymbol> getSchema() {
            return Command.getUpdateCommandSymbol();
        }

        @Override
        public void closeSource() {
        }

        @Override
        public int available() {
            return 0;
        }
    }
}

