/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.validator;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.teiid.core.TeiidException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.validator.AbstractValidationVisitor;

public class UpdateValidationVisitor
extends AbstractValidationVisitor {
    private QueryMetadataInterface metadata;
    private Collection elementsInSelect;

    public UpdateValidationVisitor(QueryMetadataInterface metadata) {
        this.metadata = metadata;
        this.elementsInSelect = new HashSet();
    }

    @Override
    protected QueryMetadataInterface getMetadata() {
        return this.metadata;
    }

    @Override
    public void visit(SetQuery obj) {
        this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0001"));
    }

    @Override
    public void visit(StoredProcedure obj) {
        this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0002"));
    }

    @Override
    public void visit(Insert obj) {
        this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0003"));
    }

    @Override
    public void visit(Update obj) {
        this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0004"));
    }

    @Override
    public void visit(Delete obj) {
        this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0005"));
    }

    @Override
    public void visit(Query obj) {
        if (obj.getGroupBy() != null || obj.getHaving() != null) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0006"));
        }
    }

    @Override
    public void visit(Select obj) {
        for (SingleElementSymbol symbol : obj.getProjectedSymbols()) {
            Expression expr;
            if (symbol instanceof AliasSymbol) {
                symbol = ((AliasSymbol)symbol).getSymbol();
            }
            if (symbol instanceof AggregateSymbol) {
                this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0007", new Object[]{symbol}));
                continue;
            }
            if (!(symbol instanceof ExpressionSymbol) || (expr = ((ExpressionSymbol)symbol).getExpression()) != null && !(expr instanceof Function)) continue;
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0008", new Object[]{symbol}));
        }
        this.elementsInSelect = ElementCollectorVisitor.getElements((LanguageObject)obj, false);
    }

    @Override
    public void visit(From obj) {
        Iterator groupIter = obj.getGroups().iterator();
        GroupSymbol group = (GroupSymbol)groupIter.next();
        if (groupIter.hasNext()) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0009", obj.getGroups()));
        } else {
            try {
                Object groupID = group.getMetadataID();
                if (groupID instanceof TempMetadataID) {
                    this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0002"));
                } else {
                    for (Object elementID : this.getMetadata().getElementIDsInGroupID(groupID)) {
                        ElementSymbol lookupSymbol = new ElementSymbol(this.getMetadata().getFullName(elementID));
                        if (this.elementsInSelect.contains(lookupSymbol)) continue;
                        lookupSymbol.setMetadataID(elementID);
                        this.validateElementNotRequired(lookupSymbol);
                    }
                }
            }
            catch (TeiidException e) {
                this.handleException(e);
            }
        }
    }

    private void validateElementNotRequired(ElementSymbol element) {
        try {
            if (this.getMetadata().elementSupports(element.getMetadataID(), 4)) {
                return;
            }
            if (this.getMetadata().elementSupports(element.getMetadataID(), 7)) {
                return;
            }
            if (this.getMetadata().elementSupports(element.getMetadataID(), 8)) {
                return;
            }
            this.handleValidationError(QueryPlugin.Util.getString("ERR.015.012.0010", new Object[]{element}));
        }
        catch (TeiidException e) {
            this.handleException(e);
        }
    }
}

