/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.vdb.runtime;

import java.io.Serializable;
import org.teiid.core.util.HashCodeUtil;

public class VDBKey
implements Serializable {
    private static final long serialVersionUID = -7249750823144856081L;
    private String name;
    private String version;

    public VDBKey(String name, String version) {
        this.name = name.toUpperCase();
        if (version != null) {
            this.version = version.toUpperCase();
        }
    }

    public VDBKey(String name, int version) {
        this.name = name.toUpperCase();
        this.version = String.valueOf(version);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)this.name.hashCode(), (Object[])new Object[]{this.version});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VDBKey)) {
            return false;
        }
        VDBKey other = (VDBKey)obj;
        if (!other.name.equals(this.name)) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(other.version) : other.version != null);
    }

    public String toString() {
        return this.name + " " + this.version;
    }
}

