/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.queue;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import javax.resource.spi.work.WorkRejectedException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.adminapi.impl.WorkerPoolStatisticsMetadata;
import org.teiid.common.queue.FakeWorkItem;
import org.teiid.common.queue.FakeWorkManager;
import org.teiid.dqp.internal.process.StatsCapturingWorkManager;

public class TestStatsCapturingWorkManager {
    private WorkManager manager = new FakeWorkManager();

    @Test
    public void testQueuing() throws Exception {
        long SINGLE_WAIT = 50L;
        int WORK_ITEMS = 10;
        int MAX_THREADS = 5;
        StatsCapturingWorkManager pool = new StatsCapturingWorkManager("test", 5, this.manager);
        for (int i = 0; i < 10; ++i) {
            pool.scheduleWork((Work)new FakeWorkItem(50L));
        }
        pool.shutdown();
        pool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)pool.isTerminated());
        WorkerPoolStatisticsMetadata stats = pool.getStats();
        Assert.assertEquals((long)10L, (long)stats.getTotalCompleted());
        Assert.assertEquals((String)"Expected threads to be maxed out", (long)5L, (long)stats.getHighestActiveThreads());
    }

    @Ignore
    @Test
    public void testThreadReuse() throws Exception {
        long SINGLE_WAIT = 50L;
        long NUM_THREADS = 5L;
        StatsCapturingWorkManager pool = new StatsCapturingWorkManager("test", 5, this.manager);
        int i = 0;
        while ((long)i < 5L) {
            pool.scheduleWork((Work)new FakeWorkItem(50L));
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ++i;
        }
        pool.shutdown();
        WorkerPoolStatisticsMetadata stats = pool.getStats();
        Assert.assertEquals((String)"Expected 1 thread for serial execution", (long)1L, (long)stats.getHighestActiveThreads());
        pool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=WorkRejectedException.class)
    public void testShutdown() throws Exception {
        StatsCapturingWorkManager pool = new StatsCapturingWorkManager("test", 5, this.manager);
        pool.shutdown();
        pool.scheduleWork((Work)new FakeWorkItem(1L));
    }

    @Test
    public void testSchedule() throws Exception {
        StatsCapturingWorkManager pool = new StatsCapturingWorkManager("test", 5, this.manager);
        final ArrayList result = new ArrayList();
        pool.scheduleWork(new Work(){

            public void run() {
                result.add("hello");
            }

            public void release() {
            }
        }, null, 5L);
        Thread.sleep(100L);
        pool.shutdown();
        pool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testFailingWork() throws Exception {
        StatsCapturingWorkManager pool = new StatsCapturingWorkManager("test", 5, this.manager);
        final AtomicInteger count = new AtomicInteger();
        pool.scheduleWork(new Work(){

            public void run() {
                count.getAndIncrement();
                throw new RuntimeException();
            }

            public void release() {
            }
        });
        Thread.sleep(100L);
        Assert.assertEquals((long)1L, (long)count.get());
    }
}

