/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.cache;

import junit.framework.TestCase;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.FakeCache;
import org.teiid.dqp.internal.cache.DQPContextCache;
import org.teiid.dqp.internal.process.DQPWorkContext;

public class TestDQPContextCache
extends TestCase {
    DQPContextCache cacheContext = null;

    protected void setUp() throws Exception {
        this.cacheContext = new DQPContextCache();
        this.cacheContext.setCacheFactory((CacheFactory)new FakeCache.FakeCacheFactory());
        this.cacheContext.setProcessName("host-process");
    }

    private DQPWorkContext getContext() {
        DQPWorkContext workContext = new DQPWorkContext();
        workContext.getSession().setVDBName("MyVDB");
        workContext.getSession().setVDBVersion(1);
        workContext.getSession().setSessionId(String.valueOf(1));
        workContext.getSession().setUserName("foo");
        return workContext;
    }

    public void testRequestScope() {
        DQPWorkContext context = this.getContext();
        Cache cache = this.cacheContext.getRequestScopedCache(context.getRequestID(12L).toString());
        cache.put((Object)"key", (Object)"request-value");
        cache = this.cacheContext.getSessionScopedCache(context.getSessionId());
        cache.put((Object)"key", (Object)"session-value");
        TestDQPContextCache.assertEquals((Object)"request-value", (Object)this.cacheContext.getRequestScopedCache(context.getRequestID(12L).toString()).get((Object)"key"));
        TestDQPContextCache.assertEquals((Object)"session-value", (Object)this.cacheContext.getSessionScopedCache(context.getSessionId()).get((Object)"key"));
        this.cacheContext.removeRequestScopedCache(context.getRequestID(12L).toString());
        TestDQPContextCache.assertNull((Object)this.cacheContext.getRequestScopedCache(context.getRequestID(12L).toString()).get((Object)"key"));
        TestDQPContextCache.assertEquals((Object)"session-value", (Object)this.cacheContext.getSessionScopedCache(context.getSessionId()).get((Object)"key"));
    }

    public void testServiceScope() {
        DQPWorkContext context = this.getContext();
        Cache cache = this.cacheContext.getServiceScopedCache("my-connector");
        cache.put((Object)"key", (Object)"service-value");
        TestDQPContextCache.assertEquals((Object)"service-value", (Object)this.cacheContext.getServiceScopedCache("my-connector").get((Object)"key"));
        this.cacheContext.removeServiceScopedCache("my-Connector");
        TestDQPContextCache.assertNull((Object)this.cacheContext.getRequestScopedCache(context.getRequestID(12L).toString()).get((Object)"key"));
    }

    public void testGlobalScope() {
        DQPWorkContext context = this.getContext();
        Cache cache = this.cacheContext.getRequestScopedCache(context.getRequestID(12L).toString());
        cache.put((Object)"key", (Object)"request-value");
        cache = this.cacheContext.getGlobalScopedCache();
        cache.put((Object)"key", (Object)"global-value");
        TestDQPContextCache.assertEquals((Object)"request-value", (Object)this.cacheContext.getRequestScopedCache(context.getRequestID(12L).toString()).get((Object)"key"));
        TestDQPContextCache.assertEquals((Object)"global-value", (Object)this.cacheContext.getGlobalScopedCache().get((Object)"key"));
        this.cacheContext.stop();
        TestDQPContextCache.assertNull((Object)this.cacheContext.getRequestScopedCache(context.getRequestID(12L).toString()).get((Object)"key"));
        TestDQPContextCache.assertEquals((Object)"global-value", (Object)this.cacheContext.getGlobalScopedCache().get((Object)"key"));
    }
}

