/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr.impl;

import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.Execution;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;

public class FakeConnector
extends ExecutionFactory {
    private static final int RESULT_SIZE = 5;
    private boolean executeBlocks;
    private boolean nextBatchBlocks;
    private boolean returnsFinalBatch;
    private boolean driverThrowsExceptionOnCancel;
    private long simulatedBatchRetrievalTime = 1000L;
    private ClassLoader classloader;
    private int connectionCount;
    private int executionCount;

    public int getConnectionCount() {
        return this.connectionCount;
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    public Execution createExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
        ++this.executionCount;
        return new FakeBlockingExecution(executionContext);
    }

    public Object getConnection() {
        return new FakeConnection();
    }

    public Object getConnection(Object factory) throws TranslatorException {
        return factory;
    }

    public void closeConnection(Object connection, Object factory) {
    }

    public boolean isExecuteBlocks() {
        return this.executeBlocks;
    }

    public void setExecuteBlocks(boolean executeBlocks) {
        this.executeBlocks = executeBlocks;
    }

    public boolean isNextBatchBlocks() {
        return this.nextBatchBlocks;
    }

    public void setNextBatchBlocks(boolean nextBatchBlocks) {
        this.nextBatchBlocks = nextBatchBlocks;
    }

    public boolean isReturnsFinalBatch() {
        return this.returnsFinalBatch;
    }

    public void setReturnsFinalBatch(boolean returnsFinalBatch) {
        this.returnsFinalBatch = returnsFinalBatch;
    }

    public boolean isDriverThrowsExceptionOnCancel() {
        return this.driverThrowsExceptionOnCancel;
    }

    public void setDriverThrowsExceptionOnCancel(boolean driverThrowsExceptionOnCancel) {
        this.driverThrowsExceptionOnCancel = driverThrowsExceptionOnCancel;
    }

    public long getSimulatedBatchRetrievalTime() {
        return this.simulatedBatchRetrievalTime;
    }

    public void setSimulatedBatchRetrievalTime(long simulatedBatchRetrievalTime) {
        this.simulatedBatchRetrievalTime = simulatedBatchRetrievalTime;
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    private final class FakeBlockingExecution
    implements ResultSetExecution,
    UpdateExecution {
        private boolean closed = false;
        private boolean cancelled = false;
        private int rowCount;
        ExecutionContext ec;

        public FakeBlockingExecution(ExecutionContext ec) {
            this.ec = ec;
        }

        public void execute(QueryExpression query, int maxBatchSize) throws TranslatorException {
            if (FakeConnector.this.executeBlocks) {
                this.waitForCancel();
            }
            if (FakeConnector.this.classloader != null) {
                Assert.assertSame((Object)FakeConnector.this.classloader, (Object)Thread.currentThread().getContextClassLoader());
            }
        }

        public synchronized void cancel() throws TranslatorException {
            this.cancelled = true;
            this.notify();
        }

        public void close() {
            Assert.assertFalse((String)"The execution should not be closed more than once", (boolean)this.closed);
            this.closed = true;
        }

        public void execute() throws TranslatorException {
            this.ec.addWarning(new Exception("Some warning"));
        }

        public List next() throws TranslatorException, DataNotAvailableException {
            if (FakeConnector.this.nextBatchBlocks) {
                this.waitForCancel();
            }
            if (this.rowCount >= 5 || FakeConnector.this.returnsFinalBatch) {
                return null;
            }
            ++this.rowCount;
            return Arrays.asList(this.rowCount - 1);
        }

        private synchronized void waitForCancel() throws TranslatorException {
            try {
                this.wait(FakeConnector.this.simulatedBatchRetrievalTime);
                if (this.cancelled && FakeConnector.this.driverThrowsExceptionOnCancel) {
                    throw new TranslatorException("Request cancelled");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
            return new int[]{1};
        }
    }

    private class FakeConnection {
        public boolean released = false;

        public FakeConnection() {
            FakeConnector.this.connectionCount++;
        }

        public void close() {
            Assert.assertFalse((String)"The connection should not be released more than once", (boolean)this.released);
            this.released = true;
        }
    }
}

