/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr.impl;

import junit.framework.TestCase;
import org.mockito.Mockito;
import org.teiid.common.buffer.BlockedException;
import org.teiid.dqp.internal.datamgr.impl.ConnectorManager;
import org.teiid.dqp.internal.datamgr.impl.ConnectorWork;
import org.teiid.dqp.internal.datamgr.impl.FakeConnector;
import org.teiid.dqp.internal.datamgr.impl.TestConnectorWorkItem;
import org.teiid.dqp.internal.process.AbstractWorkItem;
import org.teiid.dqp.message.AtomicRequestID;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.RequestID;
import org.teiid.translator.ExecutionFactory;

public final class TestConnectorManager
extends TestCase {
    private AtomicRequestMessage request;
    private ConnectorManager csm;

    static ConnectorManager getConnectorManager() throws Exception {
        final FakeConnector c = new FakeConnector();
        ConnectorManager cm = new ConnectorManager("FakeConnector", "FakeConnector"){

            protected ExecutionFactory getExecutionFactory() {
                return c;
            }

            protected Object getConnectionFactory() {
                return c.getConnection();
            }
        };
        cm.setMaxConnections(1);
        cm.start();
        return cm;
    }

    public TestConnectorManager(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.request = TestConnectorWorkItem.createNewAtomicRequestMessage(1, 1);
        this.csm = TestConnectorManager.getConnectorManager();
    }

    void helpAssureOneState() throws Exception {
        this.csm.executeRequest(this.request, (AbstractWorkItem)Mockito.mock(AbstractWorkItem.class));
        ConnectorWork state = this.csm.getState(this.request.getAtomicRequestID());
        TestConnectorManager.assertEquals((Object)state, (Object)this.csm.getState(this.request.getAtomicRequestID()));
    }

    public void testCreateAndAddRequestState() throws Exception {
        this.helpAssureOneState();
        TestConnectorManager.assertEquals((String)"Expected size of 1", (int)1, (int)this.csm.size());
    }

    public void testIllegalCreate() throws Exception {
        this.helpAssureOneState();
        try {
            this.helpAssureOneState();
            TestConnectorManager.fail((String)"expected exception");
        }
        catch (AssertionError e) {
            TestConnectorManager.assertEquals((String)"State already existed", (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testRemoveRequestState() throws Exception {
        this.helpAssureOneState();
        this.csm.removeState(this.request.getAtomicRequestID());
        TestConnectorManager.assertEquals((String)"Expected size of 0", (int)0, (int)this.csm.size());
    }

    public void testRemoveUnknownRequestState() throws Exception {
        this.helpAssureOneState();
        this.csm.removeState(new AtomicRequestID(new RequestID("ZZZZ", 3210L), 5, 5));
        TestConnectorManager.assertEquals((String)"Expected size of 1", (int)1, (int)this.csm.size());
    }

    public void testQueuing() throws Exception {
        ConnectorWork workItem = this.csm.executeRequest(this.request, (AbstractWorkItem)Mockito.mock(AbstractWorkItem.class));
        workItem.execute();
        AbstractWorkItem awi1 = (AbstractWorkItem)Mockito.mock(AbstractWorkItem.class);
        ConnectorWork workItem1 = this.csm.executeRequest(TestConnectorWorkItem.createNewAtomicRequestMessage(2, 1), awi1);
        AbstractWorkItem awi2 = (AbstractWorkItem)Mockito.mock(AbstractWorkItem.class);
        ConnectorWork workItem2 = this.csm.executeRequest(TestConnectorWorkItem.createNewAtomicRequestMessage(3, 1), awi2);
        try {
            workItem1.execute();
            TestConnectorManager.fail((String)"expected exception");
        }
        catch (BlockedException e) {
            // empty catch block
        }
        workItem.close();
        try {
            workItem2.execute();
            TestConnectorManager.fail((String)"expected exception");
        }
        catch (BlockedException e) {
            // empty catch block
        }
        ((AbstractWorkItem)Mockito.verify((Object)awi1)).moreWork();
        workItem1.execute();
    }
}

