/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr.language;

import junit.framework.TestCase;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.datamgr.language.TstLanguageBridgeFactory;
import org.teiid.language.AggregateFunction;
import org.teiid.language.Literal;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;

public class TestAggregateImpl
extends TestCase {
    public TestAggregateImpl(String name) {
        super(name);
    }

    public static AggregateFunction example(String name, String functionName, boolean distinct, int value) throws Exception {
        AggregateSymbol symbol = new AggregateSymbol(name, functionName, distinct, (Expression)new Constant((Object)new Integer(value)));
        return TstLanguageBridgeFactory.factory.translate(symbol);
    }

    public void testGetName() throws Exception {
        TestAggregateImpl.assertEquals((String)"COUNT", (String)TestAggregateImpl.example("testName", "COUNT", true, 42).getName());
    }

    public void testIsDistinct() throws Exception {
        TestAggregateImpl.assertTrue((boolean)TestAggregateImpl.example("testName", "COUNT", true, 42).isDistinct());
        TestAggregateImpl.assertFalse((boolean)TestAggregateImpl.example("testName", "COUNT", false, 42).isDistinct());
    }

    public void testGetExpression() throws Exception {
        AggregateFunction agg = TestAggregateImpl.example("testName", "COUNT", true, 42);
        TestAggregateImpl.assertNotNull((Object)agg.getExpression());
        TestAggregateImpl.assertTrue((boolean)(agg.getExpression() instanceof Literal));
        TestAggregateImpl.assertEquals((Object)new Integer(42), (Object)((Literal)agg.getExpression()).getValue());
    }

    public void testGetType() throws Exception {
        TestAggregateImpl.assertEquals((Object)DataTypeManager.DefaultDataClasses.INTEGER, (Object)TestAggregateImpl.example("x", "COUNT", true, 42).getType());
    }
}

