/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr.language;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.teiid.dqp.internal.datamgr.language.TestElementImpl;
import org.teiid.dqp.internal.datamgr.language.TstLanguageBridgeFactory;
import org.teiid.language.Comparison;
import org.teiid.language.Join;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;

public class TestJoinImpl
extends TestCase {
    public TestJoinImpl(String name) {
        super(name);
    }

    public static JoinPredicate helpExample(JoinType type) {
        ElementSymbol e1 = TestElementImpl.helpExample("vm1.g1", "e1");
        ElementSymbol e2 = TestElementImpl.helpExample("vm1.g2", "e1");
        ArrayList<CompareCriteria> criteria = new ArrayList<CompareCriteria>();
        criteria.add(new CompareCriteria((Expression)e1, 1, (Expression)e2));
        return new JoinPredicate((FromClause)new UnaryFromClause(e1.getGroupSymbol()), (FromClause)new UnaryFromClause(e2.getGroupSymbol()), type, criteria);
    }

    public static Join example(JoinType type) throws Exception {
        return TstLanguageBridgeFactory.factory.translate(TestJoinImpl.helpExample(type));
    }

    public void testGetLeftItem() throws Exception {
        TestJoinImpl.assertNotNull((Object)TestJoinImpl.example(JoinType.JOIN_CROSS).getLeftItem());
    }

    public void testGetRightItem() throws Exception {
        TestJoinImpl.assertNotNull((Object)TestJoinImpl.example(JoinType.JOIN_CROSS).getRightItem());
    }

    public void testGetJoinType() throws Exception {
        TestJoinImpl.assertEquals((Object)Join.JoinType.CROSS_JOIN, (Object)TestJoinImpl.example(JoinType.JOIN_CROSS).getJoinType());
        TestJoinImpl.assertEquals((Object)Join.JoinType.FULL_OUTER_JOIN, (Object)TestJoinImpl.example(JoinType.JOIN_FULL_OUTER).getJoinType());
        TestJoinImpl.assertEquals((Object)Join.JoinType.INNER_JOIN, (Object)TestJoinImpl.example(JoinType.JOIN_INNER).getJoinType());
        TestJoinImpl.assertEquals((Object)Join.JoinType.LEFT_OUTER_JOIN, (Object)TestJoinImpl.example(JoinType.JOIN_LEFT_OUTER).getJoinType());
        TestJoinImpl.assertEquals((Object)Join.JoinType.RIGHT_OUTER_JOIN, (Object)TestJoinImpl.example(JoinType.JOIN_RIGHT_OUTER).getJoinType());
    }

    public void testGetCriteria() throws Exception {
        Join join = TestJoinImpl.example(JoinType.JOIN_INNER);
        TestJoinImpl.assertTrue((boolean)(join.getCondition() instanceof Comparison));
    }
}

