/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr.language;

import junit.framework.TestCase;
import org.teiid.dqp.internal.datamgr.language.TestElementImpl;
import org.teiid.dqp.internal.datamgr.language.TstLanguageBridgeFactory;
import org.teiid.language.Like;
import org.teiid.language.Literal;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;

public class TestLikeCriteriaImpl
extends TestCase {
    public TestLikeCriteriaImpl(String name) {
        super(name);
    }

    public static MatchCriteria helpExample(String right, char escape, boolean negated) {
        ElementSymbol e1 = TestElementImpl.helpExample("vm1.g1", "e1");
        MatchCriteria match = new MatchCriteria((Expression)e1, (Expression)new Constant((Object)right), escape);
        match.setNegated(negated);
        return match;
    }

    public static Like example(String right, char escape, boolean negated) throws Exception {
        return TstLanguageBridgeFactory.factory.translate(TestLikeCriteriaImpl.helpExample(right, escape, negated));
    }

    public void testGetLeftExpression() throws Exception {
        TestLikeCriteriaImpl.assertNotNull((Object)TestLikeCriteriaImpl.example("abc", '.', false).getLeftExpression());
    }

    public void testGetRightExpression() throws Exception {
        Like like = TestLikeCriteriaImpl.example("abc", '.', false);
        TestLikeCriteriaImpl.assertNotNull((Object)like.getRightExpression());
        TestLikeCriteriaImpl.assertTrue((boolean)(like.getRightExpression() instanceof Literal));
        TestLikeCriteriaImpl.assertEquals((Object)"abc", (Object)((Literal)like.getRightExpression()).getValue());
    }

    public void testGetEscapeCharacter() throws Exception {
        TestLikeCriteriaImpl.assertEquals((Object)new Character('.'), (Object)TestLikeCriteriaImpl.example("abc", '.', false).getEscapeCharacter());
    }

    public void testIsNegated() throws Exception {
        TestLikeCriteriaImpl.assertTrue((boolean)TestLikeCriteriaImpl.example("abc", '.', true).isNegated());
        TestLikeCriteriaImpl.assertFalse((boolean)TestLikeCriteriaImpl.example("abc", '.', false).isNegated());
    }
}

