/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr.metadata;

import java.util.List;
import junit.framework.TestCase;
import org.teiid.dqp.internal.datamgr.metadata.RuntimeMetadataImpl;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.unittest.FakeMetadataObject;
import org.teiid.query.unittest.FakeMetadataStore;

public class TestMetadataFactory
extends TestCase {
    private RuntimeMetadataImpl metadataFactory;
    private FakeMetadataObject pm1g1;

    public TestMetadataFactory(String name) {
        super(name);
    }

    public void setUp() {
        FakeMetadataStore store = new FakeMetadataStore();
        this.pm1g1 = FakeMetadataFactory.createPhysicalGroup("pm1.g1", FakeMetadataFactory.createPhysicalModel("pm1.g1"));
        List<FakeMetadataObject> pm1g1e = FakeMetadataFactory.createElements(this.pm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        store.addObject(this.pm1g1);
        store.addObjects(pm1g1e);
        this.metadataFactory = new RuntimeMetadataImpl((QueryMetadataInterface)new FakeMetadataFacade(store));
    }

    public void testGetVDBResourcePaths() throws Exception {
        String[] expectedPaths = new String[]{"my/resource/path"};
        String[] mfPaths = this.metadataFactory.getVDBResourcePaths();
        TestMetadataFactory.assertEquals((int)expectedPaths.length, (int)mfPaths.length);
        for (int i = 0; i < expectedPaths.length; ++i) {
            TestMetadataFactory.assertEquals((String)expectedPaths[i], (String)mfPaths[i]);
        }
    }

    public void testGetBinaryVDBResource() throws Exception {
        byte[] expectedBytes = "ResourceContents".getBytes();
        byte[] mfBytes = this.metadataFactory.getBinaryVDBResource(null);
        TestMetadataFactory.assertEquals((int)expectedBytes.length, (int)mfBytes.length);
        for (int i = 0; i < expectedBytes.length; ++i) {
            TestMetadataFactory.assertEquals((String)("Byte at index " + i + " differs from expected content"), (byte)expectedBytes[i], (byte)mfBytes[i]);
        }
    }

    public void testGetCharacterVDBResource() throws Exception {
        TestMetadataFactory.assertEquals((String)"ResourceContents", (String)this.metadataFactory.getCharacterVDBResource(null));
    }
}

