/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import org.teiid.common.buffer.BufferManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.id.IDGenerator;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.util.CommandContext;

public class SimpleQueryProcessorFactory
implements QueryProcessor.ProcessorFactory {
    private QueryMetadataInterface metadata;
    private CapabilitiesFinder finder;
    private IDGenerator idGenerator;
    private BufferManager bufferMgr;
    private ProcessorDataManager dataMgr;

    public SimpleQueryProcessorFactory(BufferManager bufferMgr, ProcessorDataManager dataMgr, CapabilitiesFinder finder, IDGenerator idGenerator, QueryMetadataInterface metadata) {
        this.bufferMgr = bufferMgr;
        this.dataMgr = dataMgr;
        this.finder = finder;
        this.idGenerator = idGenerator;
        this.metadata = metadata;
    }

    public QueryProcessor createQueryProcessor(String sql, String recursionGroup, CommandContext commandContext) throws TeiidProcessingException, TeiidComponentException {
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)this.metadata);
        command = QueryRewriter.rewrite((Command)command, (QueryMetadataInterface)this.metadata, (CommandContext)commandContext);
        ProcessorPlan plan = QueryOptimizer.optimizePlan((Command)command, (QueryMetadataInterface)this.metadata, (IDGenerator)this.idGenerator, (CapabilitiesFinder)this.finder, (AnalysisRecord)AnalysisRecord.createNonRecordingRecord(), (CommandContext)commandContext);
        CommandContext copy = (CommandContext)commandContext.clone();
        return new QueryProcessor(plan, copy, this.bufferMgr, this.dataMgr);
    }
}

