/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.internal.process.CodeTableCache;
import org.teiid.query.util.CommandContext;

public class TestCodeTableCache
extends TestCase {
    private static CommandContext TEST_CONTEXT = new CommandContext((Object)"pid", "1", null, "test", 1);
    private static CommandContext TEST_CONTEXT_1 = new CommandContext((Object)"pid", "1", null, "test", 2);

    public TestCodeTableCache(String name) {
        super(name);
    }

    private static List[] exampleResultObject() {
        List<String> record1 = Arrays.asList("US", "USA");
        List<String> record2 = Arrays.asList("Germany", "GM");
        List[] records = new List[]{record1, record2};
        return records;
    }

    private CodeTableCache setUpSampleCodeTable(boolean setDone) {
        CodeTableCache ctc = new CodeTableCache(10, 10, 10);
        TestCodeTableCache.assertEquals((Object)CodeTableCache.CacheState.CACHE_NOT_EXIST, (Object)ctc.cacheExists("countrycode", "code", "country", TEST_CONTEXT));
        CodeTableCache.CacheKey nodeId = ctc.createCacheRequest("countrycode", "code", "country", TEST_CONTEXT);
        List[] results = TestCodeTableCache.exampleResultObject();
        try {
            ctc.loadTable(nodeId, results);
        }
        catch (TeiidProcessingException e) {
            throw new RuntimeException(e);
        }
        ctc.markCacheDone(nodeId, setDone);
        return ctc;
    }

    private CodeTableCache setUpSampleCodeTable2() {
        CodeTableCache ctc = new CodeTableCache(1, 10, 10);
        TestCodeTableCache.assertEquals((Object)CodeTableCache.CacheState.CACHE_NOT_EXIST, (Object)ctc.cacheExists("countrycode", "code", "country", TEST_CONTEXT));
        CodeTableCache.CacheKey nodeId = ctc.createCacheRequest("countrycode", "code", "country", TEST_CONTEXT);
        List[] results = TestCodeTableCache.exampleResultObject();
        try {
            ctc.loadTable(nodeId, results);
        }
        catch (TeiidProcessingException e) {
            throw new RuntimeException(e);
        }
        ctc.markCacheDone(nodeId, true);
        return ctc;
    }

    public void testLookupValue() throws Exception {
        CodeTableCache ctc = this.setUpSampleCodeTable(true);
        String code = (String)ctc.lookupValue("countrycode", "code", "country", (Object)"Germany", TEST_CONTEXT);
        TestCodeTableCache.assertEquals((String)"Actual lookup value doesn't match with expected: ", (String)code, (String)"GM");
    }

    public void testCacheExists1() {
        CodeTableCache ctc = this.setUpSampleCodeTable(true);
        CodeTableCache.CacheState actualState = ctc.cacheExists("countrycode", "code", "country", TEST_CONTEXT);
        TestCodeTableCache.assertEquals((String)"Actual cache state doesn't match with expected: ", (Object)CodeTableCache.CacheState.CACHE_EXISTS, (Object)actualState);
        actualState = ctc.cacheExists("countryCODE", "code", "Country", TEST_CONTEXT);
        TestCodeTableCache.assertEquals((String)"Actual cache state doesn't match with expected: ", (Object)CodeTableCache.CacheState.CACHE_EXISTS, (Object)actualState);
    }

    public void testCacheExists2() {
        CodeTableCache ctc = new CodeTableCache(10, 10, 10);
        ctc.cacheExists("countrycode", "code", "country", TEST_CONTEXT);
        CodeTableCache.CacheState actualState = ctc.cacheExists("countrycode", "code", "country", TEST_CONTEXT);
        TestCodeTableCache.assertEquals((String)"Actual cache state doesn't match with expected: ", (Object)CodeTableCache.CacheState.CACHE_LOADING, (Object)actualState);
    }

    public void testCacheExists3() {
        CodeTableCache ctc = this.setUpSampleCodeTable(true);
        CodeTableCache.CacheState actualState = ctc.cacheExists("countrycode1", "code1", "country1", TEST_CONTEXT);
        TestCodeTableCache.assertEquals((String)"Actual cache state doesn't match with expected: ", (Object)CodeTableCache.CacheState.CACHE_NOT_EXIST, (Object)actualState);
    }

    public void testCacheExists3a() {
        CodeTableCache ctc = this.setUpSampleCodeTable(false);
        CodeTableCache.CacheState actualState = ctc.cacheExists("countrycode", "code", "country", TEST_CONTEXT);
        TestCodeTableCache.assertEquals((String)"Actual cache state doesn't match with expected: ", (Object)CodeTableCache.CacheState.CACHE_NOT_EXIST, (Object)actualState);
    }

    public void testCacheOverload1() {
        CodeTableCache ctc = this.setUpSampleCodeTable2();
        CodeTableCache.CacheState actualState = ctc.cacheExists("countrycode", "something", "country", TEST_CONTEXT);
        TestCodeTableCache.assertEquals((String)"Actual cache state doesn't match with expected: ", (Object)CodeTableCache.CacheState.CACHE_OVERLOAD, (Object)actualState);
    }

    public void testClearAllLoaded() {
        CodeTableCache ctc = this.setUpSampleCodeTable(true);
        ctc.clearAll();
        CodeTableCache.CacheState actualState = ctc.cacheExists("countrycode", "code", "country", TEST_CONTEXT);
        TestCodeTableCache.assertEquals((String)"Actual cache state doesn't match with expected: ", (Object)CodeTableCache.CacheState.CACHE_NOT_EXIST, (Object)actualState);
    }

    public void testClearAllLoading() {
        CodeTableCache ctc = this.setUpSampleCodeTable(true);
        CodeTableCache.CacheState actualState = ctc.cacheExists("countrycode", "code", "country", TEST_CONTEXT);
        TestCodeTableCache.assertEquals((String)"Actual cache state doesn't match with expected: ", (Object)CodeTableCache.CacheState.CACHE_EXISTS, (Object)actualState);
        ctc.clearAll();
        try {
            ctc.lookupValue("countrycode", "code", "country", (Object)"US", TEST_CONTEXT);
            TestCodeTableCache.fail((String)"Expected exception during lookup");
        }
        catch (TeiidComponentException teiidComponentException) {
            // empty catch block
        }
    }

    public void testVdbSpecificCaching() {
        CodeTableCache ctc = this.setUpSampleCodeTable(true);
        CodeTableCache.CacheState actualState = ctc.cacheExists("countrycode", "code", "country", TEST_CONTEXT_1);
        TestCodeTableCache.assertEquals((String)"Actual cache state doesn't match with expected: ", (Object)CodeTableCache.CacheState.CACHE_NOT_EXIST, (Object)actualState);
    }

    public void testDuplicateKeyException() {
        CodeTableCache ctc = new CodeTableCache(1, 10, 10);
        TestCodeTableCache.assertEquals((Object)CodeTableCache.CacheState.CACHE_NOT_EXIST, (Object)ctc.cacheExists("table", "key", "value", TEST_CONTEXT));
        CodeTableCache.CacheKey nodeId = ctc.createCacheRequest("table", "key", "value", TEST_CONTEXT);
        List[] results = new List[]{Arrays.asList(1, 2), Arrays.asList(1, 3)};
        try {
            ctc.loadTable(nodeId, results);
            TestCodeTableCache.fail((String)"expected exception");
        }
        catch (TeiidProcessingException e) {
            TestCodeTableCache.assertEquals((String)"Duplicate code table 'table' key 'value' value '1'", (String)e.getMessage());
        }
    }

    public void testMaxRecords() {
        CodeTableCache ctc = new CodeTableCache(1, 1, 10);
        TestCodeTableCache.assertEquals((Object)CodeTableCache.CacheState.CACHE_NOT_EXIST, (Object)ctc.cacheExists("table", "key", "value", TEST_CONTEXT));
        CodeTableCache.CacheKey nodeId = ctc.createCacheRequest("table", "key", "value", TEST_CONTEXT);
        List[] results = new List[]{Arrays.asList(1, 2), Arrays.asList(2, 3)};
        try {
            ctc.loadTable(nodeId, results);
            TestCodeTableCache.fail((String)"expected exception");
        }
        catch (TeiidProcessingException e) {
            TestCodeTableCache.assertEquals((String)"Error Code:ERR.018.005.0100 Message:Unable to load code table for because result sizes exceeds the allowed parameter - maxCodeTableRecords.", (String)e.getMessage());
        }
    }

    public void testMaxRecordsPerTable() {
        CodeTableCache ctc = new CodeTableCache(10, 10, 1);
        TestCodeTableCache.assertEquals((Object)CodeTableCache.CacheState.CACHE_NOT_EXIST, (Object)ctc.cacheExists("table", "key", "value", TEST_CONTEXT));
        CodeTableCache.CacheKey nodeId = ctc.createCacheRequest("table", "key", "value", TEST_CONTEXT);
        List[] results = new List[]{Arrays.asList(1, 2), Arrays.asList(2, 3)};
        try {
            ctc.loadTable(nodeId, results);
            TestCodeTableCache.fail((String)"expected exception");
        }
        catch (TeiidProcessingException e) {
            TestCodeTableCache.assertEquals((String)"Error Code:ERR.018.005.0100 Message:Unable to load code table for because result sizes exceeds the allowed parameter - maxCodeTables.", (String)e.getMessage());
        }
    }
}

