/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.dqp.internal.datamgr.impl.ConnectorManager;
import org.teiid.dqp.internal.datamgr.impl.ConnectorManagerRepository;
import org.teiid.dqp.internal.process.CachedFinder;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;

public class TestConnectorCapabilitiesFinder
extends TestCase {
    public TestConnectorCapabilitiesFinder(String name) {
        super(name);
    }

    public void testFind() throws Exception {
        String modelName = "model";
        String functionName = "fakeFunction";
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setFunctionSupport("fakeFunction", true);
        ArrayList<String> bindings = new ArrayList<String>();
        bindings.add(modelName);
        VDBMetaData vdb = (VDBMetaData)Mockito.mock(VDBMetaData.class);
        ModelMetaData model = (ModelMetaData)Mockito.mock(ModelMetaData.class);
        Mockito.stub((Object)vdb.getModel(modelName)).toReturn((Object)model);
        Mockito.stub((Object)model.getSourceNames()).toReturn(bindings);
        BasicSourceCapabilities basicSourceCapabilities = new BasicSourceCapabilities();
        basicSourceCapabilities.setFunctionSupport(functionName, true);
        ConnectorManagerRepository repo = (ConnectorManagerRepository)Mockito.mock(ConnectorManagerRepository.class);
        ConnectorManager cm = (ConnectorManager)Mockito.mock(ConnectorManager.class);
        Mockito.stub((Object)cm.getCapabilities()).toReturn((Object)basicSourceCapabilities);
        Mockito.stub((Object)repo.getConnectorManager(Mockito.anyString())).toReturn((Object)cm);
        CachedFinder finder = new CachedFinder(repo, vdb);
        SourceCapabilities actual = finder.findCapabilities(modelName);
        TestConnectorCapabilitiesFinder.assertEquals((String)"Did not get expected capabilities", (boolean)true, (boolean)actual.supportsFunction(functionName));
    }
}

