/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import junit.framework.TestCase;
import org.mockito.Mockito;
import org.teiid.client.RequestMessage;
import org.teiid.core.TeiidException;
import org.teiid.dqp.internal.datamgr.impl.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.impl.FakeTransactionService;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.DataTierManagerImpl;
import org.teiid.dqp.internal.process.DataTierTupleSource;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.internal.process.SimpleQueryProcessorFactory;
import org.teiid.dqp.internal.process.TestDQPCoreRequestHandling;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.RequestID;
import org.teiid.dqp.service.AutoGenDataService;
import org.teiid.dqp.service.BufferService;
import org.teiid.dqp.service.FakeBufferService;
import org.teiid.dqp.service.TransactionService;
import org.teiid.metadata.TransformationMetadata;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestDataTierManager
extends TestCase {
    private DQPCore rm;
    private DataTierManagerImpl dtm;
    private CommandContext context;
    private AtomicRequestMessage request;
    private Command command;
    private DataTierTupleSource info;
    private AutoGenDataService connectorManager;
    private RequestWorkItem workItem;

    public TestDataTierManager(String name) {
        super(name);
    }

    private static Command helpGetCommand(String sql, QueryMetadataInterface metadata) throws Exception {
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        return command;
    }

    private void helpSetup(int nodeId) throws Exception {
        this.helpSetup("SELECT * FROM BQT1.SmallA", nodeId);
    }

    private void helpSetup(String sql, int nodeId) throws Exception {
        TransformationMetadata metadata = FakeMetadataFactory.exampleBQTCached();
        DQPWorkContext workContext = FakeMetadataFactory.buildWorkContext((QueryMetadataInterface)metadata, FakeMetadataFactory.exampleBQTVDB());
        this.connectorManager = new AutoGenDataService();
        this.rm = new DQPCore();
        this.rm.setTransactionService((TransactionService)new FakeTransactionService());
        FakeBufferService bs = new FakeBufferService();
        ConnectorManagerRepository repo = (ConnectorManagerRepository)Mockito.mock(ConnectorManagerRepository.class);
        Mockito.stub((Object)repo.getConnectorManager(Mockito.anyString())).toReturn((Object)this.connectorManager);
        this.dtm = new DataTierManagerImpl(this.rm, repo, (BufferService)bs, 20, 1000, 1000);
        this.command = TestDataTierManager.helpGetCommand(sql, (QueryMetadataInterface)metadata);
        RequestMessage original = new RequestMessage();
        original.setExecutionId(1L);
        RequestID requestID = workContext.getRequestID(original.getExecutionId());
        this.context = new CommandContext();
        this.context.setProcessorID((Object)requestID);
        this.context.setVdbName("test");
        this.context.setVdbVersion(1);
        this.context.setQueryProcessorFactory((QueryProcessor.ProcessorFactory)new SimpleQueryProcessorFactory(bs.getBufferManager(), (ProcessorDataManager)this.dtm, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), null, (QueryMetadataInterface)metadata));
        this.workItem = TestDQPCoreRequestHandling.addRequest(this.rm, original, requestID, null, workContext);
        this.request = new AtomicRequestMessage(original, workContext, nodeId);
        this.request.setCommand(this.command);
        this.request.setConnectorName("FakeConnectorID");
        this.info = new DataTierTupleSource(this.command.getProjectedSymbols(), this.request, this.dtm, this.request.getConnectorName(), this.workItem);
    }

    public void testDataTierTupleSource() throws Exception {
        this.helpSetup(1);
        this.info.nextTuple();
        TestDataTierManager.assertNotNull((Object)this.workItem.getConnectorRequest(this.request.getAtomicRequestID()));
        this.info.closeSource();
        TestDataTierManager.assertNull((Object)this.workItem.getConnectorRequest(this.request.getAtomicRequestID()));
    }

    public void testCodeTableResponseException() throws Exception {
        this.helpSetup(3);
        this.connectorManager.throwExceptionOnExecute = true;
        try {
            this.dtm.lookupCodeValue(this.context, "BQT1.SmallA", "IntKey", "StringKey", (Object)"49");
            TestDataTierManager.fail((String)"processor should have failed");
        }
        catch (TeiidException e) {
            TestDataTierManager.assertEquals((String)"Connector Exception", (String)e.getMessage());
        }
    }

    public void testNoRowsException() throws Exception {
        this.helpSetup(3);
        this.connectorManager.setRows(0);
        TestDataTierManager.assertNull((Object)this.info.nextTuple());
    }

    public void testCodeTableResponseDataNotAvailable() throws Exception {
        this.helpSetup(3);
        this.connectorManager.dataNotAvailable = 5;
        TestDataTierManager.assertNull((Object)this.dtm.lookupCodeValue(this.context, "BQT1.SmallA", "IntKey", "StringKey", (Object)"49"));
    }
}

