/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.teiid.dqp.internal.process.AbstractWorkItem;

public class TestWorkItemState
extends TestCase {
    public TestWorkItemState(String name) {
        super(name);
    }

    public void testInitialState() {
        TestWorkItem item = new TestWorkItem();
        item.assertMoreWorkState();
    }

    public void testGotoIdleState() {
        TestWorkItem item = new TestWorkItem();
        item.run();
        item.assertIdleState();
    }

    public void testGotoMoreWorkState() {
        TestWorkItem item = new TestWorkItem();
        item.run();
        item.moreWork();
        item.assertMoreWorkState();
    }

    public void testGotoWorkingState() {
        TestWorkItem item = new TestWorkItem();
        item.run();
        item.moreWork();
        item.run();
    }

    public void testResume() {
        TestWorkItem item = new TestWorkItem();
        item.run();
        TestWorkItemState.assertFalse((boolean)item.resumed);
        item.moreWork();
        TestWorkItemState.assertTrue((boolean)item.resumed);
    }

    public void testResumeDuringWorking() {
        TestWorkItem item = new TestWorkItem(false, true);
        TestWorkItemState.assertFalse((boolean)item.resumed);
        item.run();
        TestWorkItemState.assertTrue((boolean)item.resumed);
    }

    public void testRunAfterDone() {
        TestWorkItem item = new TestWorkItem(true, false);
        item.run();
        item.assertDoneState();
        try {
            item.run();
            TestWorkItemState.fail((String)"exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testRunDuringIdle() {
        TestWorkItem item = new TestWorkItem();
        item.run();
        item.assertIdleState();
        try {
            item.run();
            TestWorkItemState.fail((String)"exception expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private class TestWorkItem
    extends AbstractWorkItem {
        private boolean isDone;
        private boolean callMoreWork;
        private boolean resumed;

        private TestWorkItem() {
            this(false, false);
        }

        private TestWorkItem(boolean done, boolean callMoreWork) {
            this.isDone = done;
            this.callMoreWork = callMoreWork;
        }

        protected boolean isDoneProcessing() {
            return this.isDone;
        }

        protected void process() {
            this.assertWorkingState();
            if (this.callMoreWork) {
                this.moreWork();
            }
        }

        protected void resumeProcessing() {
            this.resumed = true;
        }

        public String toString() {
            return "TestItem";
        }

        private void checkState(AbstractWorkItem.ThreadState expectedState) {
            Assert.assertEquals((Object)expectedState, (Object)this.getThreadState());
        }

        private void assertIdleState() {
            this.checkState(AbstractWorkItem.ThreadState.IDLE);
        }

        private void assertMoreWorkState() {
            this.checkState(AbstractWorkItem.ThreadState.MORE_WORK);
        }

        private void assertWorkingState() {
            this.checkState(AbstractWorkItem.ThreadState.WORKING);
        }

        private void assertDoneState() {
            this.checkState(AbstractWorkItem.ThreadState.DONE);
        }
    }
}

