/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.transaction;

import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.Xid;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.client.xa.XATransactionException;
import org.teiid.client.xa.XidImpl;
import org.teiid.common.queue.FakeWorkManager;
import org.teiid.dqp.internal.transaction.TransactionServerImpl;
import org.teiid.dqp.service.TransactionContext;

public class TestTransactionServer {
    private TransactionServerImpl server;
    private XATerminator xaTerminator;
    private TransactionManager tm;
    private Transaction txn;
    private static final String THREAD1 = "1";
    private static final String THREAD2 = "2";
    private static final XidImpl XID1 = new XidImpl(0, new byte[]{1}, new byte[0]);
    private static final XidImpl XID2 = new XidImpl(0, new byte[]{2}, new byte[0]);

    @Before
    public void setUp() throws Exception {
        this.server = new TransactionServerImpl();
        this.xaTerminator = (XATerminator)Mockito.mock(XATerminator.class);
        this.tm = (TransactionManager)Mockito.mock(TransactionManager.class);
        this.txn = (Transaction)Mockito.mock(Transaction.class);
        Mockito.stub((Object)this.tm.getTransaction()).toReturn((Object)this.txn);
        Mockito.stub((Object)this.tm.suspend()).toReturn((Object)this.txn);
        this.server.setXaTerminator(this.xaTerminator);
        this.server.setTransactionManager(this.tm);
        this.server.setWorkManager((WorkManager)new FakeWorkManager());
    }

    @Test
    public void testTransactionExclusion() throws Exception {
        this.server.begin(THREAD1);
        try {
            this.server.start(THREAD1, XID1, 0, 100, false);
            Assert.fail((String)"exception expected");
        }
        catch (XATransactionException ex) {
            Assert.assertEquals((Object)"Client thread already involved in a transaction. Transaction nesting is not supported. The current transaction must be completed first.", (Object)ex.getMessage());
        }
    }

    @Test
    public void testTransactionExclusion1() throws Exception {
        this.server.start(THREAD1, XID1, 0, 100, false);
        try {
            this.server.begin(THREAD1);
            Assert.fail((String)"exception expected");
        }
        catch (XATransactionException ex) {
            Assert.assertEquals((Object)"Client thread already involved in a transaction. Transaction nesting is not supported. The current transaction must be completed first.", (Object)ex.getMessage());
        }
    }

    @Test
    public void testTransactionExclusion2() throws Exception {
        this.server.start(THREAD1, XID1, 0, 100, false);
        try {
            this.server.start(THREAD2, XID1, 0, 100, false);
            Assert.fail((String)"exception expected");
        }
        catch (XATransactionException ex) {
            Assert.assertEquals((Object)"Global transaction Teiid-Xid global:1 branch:null format:0 already exists.", (Object)ex.getMessage());
        }
    }

    @Test
    public void testTransactionExclusion3() throws Exception {
        this.server.start(THREAD1, XID1, 0, 100, false);
        try {
            this.server.start(THREAD1, XID2, 0, 100, false);
            Assert.fail((String)"exception expected");
        }
        catch (XATransactionException ex) {
            Assert.assertEquals((Object)"Client thread already involved in a transaction. Transaction nesting is not supported. The current transaction must be completed first.", (Object)ex.getMessage());
        }
    }

    @Test
    public void testTransactionExclusion4() throws Exception {
        this.server.begin(THREAD1);
        try {
            this.server.begin(THREAD1);
            Assert.fail((String)"exception expected");
        }
        catch (XATransactionException ex) {
            Assert.assertEquals((Object)"Client thread already involved in a transaction. Transaction nesting is not supported. The current transaction must be completed first.", (Object)ex.getMessage());
        }
    }

    @Test
    public void testTransactionExclusion5() throws Exception {
        this.server.start(THREAD1, XID1, 0, 100, false);
        this.server.start(THREAD2, XID2, 0, 100, false);
        this.server.end(THREAD2, XID2, 0x4000000, false);
        try {
            this.server.start(THREAD1, XID2, 0x200000, 100, false);
            Assert.fail((String)"exception expected");
        }
        catch (XATransactionException ex) {
            Assert.assertEquals((Object)"Client thread already involved in a transaction. Transaction nesting is not supported. The current transaction must be completed first.", (Object)ex.getMessage());
        }
    }

    @Test
    public void testLocalCommit() throws Exception {
        this.server.begin(THREAD1);
        this.server.commit(THREAD1);
        ((TransactionManager)Mockito.verify((Object)this.tm)).commit();
        try {
            this.server.commit(THREAD1);
        }
        catch (XATransactionException e) {
            Assert.assertEquals((Object)"No transaction found for client 1.", (Object)e.getMessage());
        }
    }

    @Test
    public void testTwoPhaseCommit() throws Exception {
        this.server.start(THREAD1, XID1, 0, 100, false);
        this.server.end(THREAD1, XID1, 0x4000000, false);
        this.server.commit(THREAD1, XID1, false, false);
        ((XATerminator)Mockito.verify((Object)this.xaTerminator)).commit((Xid)XID1, false);
    }

    @Test
    public void testLocalRollback() throws Exception {
        this.server.begin(THREAD1);
        this.server.rollback(THREAD1);
        ((TransactionManager)Mockito.verify((Object)this.tm)).rollback();
        try {
            this.server.rollback(THREAD1);
        }
        catch (XATransactionException e) {
            Assert.assertEquals((Object)"No transaction found for client 1.", (Object)e.getMessage());
        }
    }

    @Test
    public void testConcurrentEnlistment() throws Exception {
        this.server.start(THREAD1, XID1, 0, 100, false);
        try {
            this.server.start(THREAD1, XID1, 0x200000, 100, false);
            Assert.fail((String)"exception expected");
        }
        catch (XATransactionException ex) {
            Assert.assertEquals((Object)"Concurrent enlistment in global transaction Teiid-Xid global:1 branch:null format:0 is not supported.", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSuspend() throws Exception {
        this.server.start(THREAD1, XID1, 0, 100, false);
        this.server.end(THREAD1, XID1, 0x2000000, false);
        try {
            this.server.end(THREAD1, XID1, 0x2000000, false);
            Assert.fail((String)"exception expected");
        }
        catch (XATransactionException ex) {
            Assert.assertEquals((Object)"Client is not currently enlisted in transaction Teiid-Xid global:1 branch:null format:0.", (Object)ex.getMessage());
        }
    }

    @Test
    public void testSuspendResume() throws Exception {
        this.server.start(THREAD1, XID1, 0, 100, false);
        this.server.end(THREAD1, XID1, 0x2000000, false);
        this.server.start(THREAD1, XID1, 0x8000000, 100, false);
        this.server.end(THREAD1, XID1, 0x2000000, false);
        try {
            this.server.start(THREAD2, XID1, 0x8000000, 100, false);
            Assert.fail((String)"exception expected");
        }
        catch (XATransactionException ex) {
            Assert.assertEquals((Object)"Cannot resume, transaction Teiid-Xid global:1 branch:null format:0 was not suspended by client 2.", (Object)ex.getMessage());
        }
    }

    @Test
    public void testUnknownFlags() throws Exception {
        try {
            this.server.start(THREAD1, XID1, Integer.MAX_VALUE, 100, false);
            Assert.fail((String)"exception expected");
        }
        catch (XATransactionException ex) {
            Assert.assertEquals((Object)"Unknown flags", (Object)ex.getMessage());
        }
    }

    @Test
    public void testUnknownGlobalTransaction() throws Exception {
        try {
            this.server.end(THREAD1, XID1, 0x4000000, false);
            Assert.fail((String)"exception expected");
        }
        catch (XATransactionException ex) {
            Assert.assertEquals((Object)"No global transaction found for Teiid-Xid global:1 branch:null format:0.", (Object)ex.getMessage());
        }
    }

    @Test
    public void testPrepareWithSuspended() throws Exception {
        this.server.start(THREAD1, XID1, 0, 100, false);
        this.server.end(THREAD1, XID1, 0x2000000, false);
        try {
            this.server.prepare(THREAD1, XID1, false);
            Assert.fail((String)"exception expected");
        }
        catch (XATransactionException ex) {
            Assert.assertEquals((Object)"Suspended work still exists on transaction Teiid-Xid global:1 branch:null format:0.", (Object)ex.getMessage());
        }
    }

    @Test
    public void testGetTransactionContext() throws Exception {
        Assert.assertSame((Object)this.server.getOrCreateTransactionContext(THREAD1), (Object)this.server.getOrCreateTransactionContext(THREAD1));
    }

    @Test
    public void testGetTransactions() throws Exception {
        this.server.start(THREAD1, XID1, 0, 100, false);
        this.server.begin(THREAD2);
        Assert.assertEquals((long)2L, (long)this.server.getTransactions().size());
        this.server.commit(THREAD2);
        Assert.assertEquals((long)1L, (long)this.server.getTransactions().size());
        org.teiid.adminapi.Transaction t = (org.teiid.adminapi.Transaction)this.server.getTransactions().iterator().next();
        Assert.assertEquals((long)Long.parseLong(THREAD1), (long)t.getAssociatedSession());
        Assert.assertNotNull((Object)t.getId());
    }

    @Test
    public void testGlobalPrepare() throws Exception {
        this.server.start(THREAD1, XID1, 0, 100, false);
        TransactionContext tc = this.server.getOrCreateTransactionContext(THREAD1);
        this.server.end(THREAD1, XID1, 0x4000000, false);
        this.server.prepare(THREAD1, XID1, false);
        ((XATerminator)Mockito.verify((Object)this.xaTerminator)).prepare(tc.getXid());
        this.server.commit(THREAD1, XID1, true, false);
    }

    @Test
    public void testGlobalPrepareFail() throws Exception {
        this.server.start(THREAD1, XID1, 0, 100, false);
        this.server.end(THREAD1, XID1, 0x20000000, false);
        ((Transaction)Mockito.verify((Object)this.txn)).setRollbackOnly();
    }

    @Test
    public void testGlobalOnePhaseCommit() throws Exception {
        this.server.start(THREAD1, XID1, 0, 100, false);
        TransactionContext tc = this.server.getOrCreateTransactionContext(THREAD1);
        this.server.end(THREAD1, XID1, 0x4000000, false);
        this.server.prepare(THREAD1, XID1, false);
        this.server.commit(THREAD1, XID1, true, false);
        ((XATerminator)Mockito.verify((Object)this.xaTerminator)).commit(tc.getXid(), false);
    }

    @Test
    public void testGlobalOnePhaseCommit_force_prepare_through() throws Exception {
        this.server.start(THREAD1, XID1, 0, 100, false);
        TransactionContext tc = this.server.getOrCreateTransactionContext(THREAD1);
        this.server.end(THREAD1, XID1, 0x4000000, false);
        this.server.commit(THREAD1, XID1, true, false);
        ((XATerminator)Mockito.verify((Object)this.xaTerminator)).prepare(tc.getXid());
        ((XATerminator)Mockito.verify((Object)this.xaTerminator)).commit(tc.getXid(), false);
    }

    @Test
    public void testGlobalOnePhaseCommit_force_prepare() throws Exception {
        this.server.start(THREAD1, XID1, 0, 100, false);
        TransactionContext tc = this.server.getOrCreateTransactionContext(THREAD1);
        this.server.end(THREAD1, XID1, 0x4000000, false);
        this.server.commit(THREAD1, XID1, true, false);
        ((XATerminator)Mockito.verify((Object)this.xaTerminator)).prepare(tc.getXid());
        ((XATerminator)Mockito.verify((Object)this.xaTerminator)).commit(tc.getXid(), false);
    }

    @Test
    public void testGlobalOnePhase_teiid_multiple() throws Exception {
        this.server.start(THREAD1, XID1, 0, 100, false);
        TransactionContext tc = this.server.getOrCreateTransactionContext(THREAD1);
        this.server.end(THREAD1, XID1, 0x4000000, false);
        this.server.prepare(THREAD1, XID1, false);
        this.server.commit(THREAD1, XID1, true, false);
        ((XATerminator)Mockito.verify((Object)this.xaTerminator)).commit(tc.getXid(), false);
    }

    @Test
    public void testGlobalOnePhaseRoolback() throws Exception {
        this.server.start(THREAD1, XID1, 0, 100, false);
        TransactionContext tc = this.server.getOrCreateTransactionContext(THREAD1);
        this.server.end(THREAD1, XID1, 0x4000000, false);
        this.server.prepare(THREAD1, XID1, false);
        this.server.rollback(THREAD1, XID1, false);
        ((XATerminator)Mockito.verify((Object)this.xaTerminator)).rollback(tc.getXid());
    }

    @Test
    public void testRequestCommit() throws Exception {
        TransactionContext tc = this.server.getOrCreateTransactionContext(THREAD1);
        this.server.begin(tc);
        this.server.commit(tc);
        ((TransactionManager)Mockito.verify((Object)this.tm)).commit();
    }

    @Test
    public void testRequestRollback() throws Exception {
        TransactionContext tc = this.server.getOrCreateTransactionContext(THREAD1);
        this.server.begin(tc);
        this.server.rollback(tc);
        ((TransactionManager)Mockito.verify((Object)this.tm)).rollback();
    }

    @Test
    public void testLocalCancel() throws Exception {
        this.server.begin(THREAD1);
        this.server.cancelTransactions(THREAD1, false);
        ((Transaction)Mockito.verify((Object)this.txn)).setRollbackOnly();
    }

    @Test
    public void testRequestCancel() throws Exception {
        TransactionContext tc = this.server.getOrCreateTransactionContext(THREAD1);
        this.server.begin(tc);
        this.server.cancelTransactions(THREAD1, true);
        ((Transaction)Mockito.verify((Object)this.txn)).setRollbackOnly();
    }
}

