/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.message;

import java.io.Serializable;
import junit.framework.TestCase;
import org.teiid.client.RequestMessage;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.dqp.internal.datamgr.language.TestQueryImpl;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.RequestID;
import org.teiid.query.sql.lang.Command;

public class TestAtomicRequestMessage
extends TestCase {
    public TestAtomicRequestMessage(String name) {
        super(name);
    }

    public static AtomicRequestMessage example() {
        RequestMessage rm = new RequestMessage();
        DQPWorkContext workContext = new DQPWorkContext();
        workContext.getSession().setSessionId(String.valueOf(2));
        AtomicRequestMessage message = new AtomicRequestMessage(rm, workContext, 1000);
        message.setCommand((Command)TestQueryImpl.helpExample(true));
        message.setFetchSize(100);
        message.setPartialResults(true);
        message.setRequestID(new RequestID(5000L));
        message.setConnectorName("connectorBindingID");
        return message;
    }

    public void testSerialize() throws Exception {
        AtomicRequestMessage example = TestAtomicRequestMessage.example();
        AtomicRequestMessage copy = (AtomicRequestMessage)UnitTestUtil.helpSerialize((Serializable)example);
        TestAtomicRequestMessage.assertEquals((Object)TestQueryImpl.helpExample(true), (Object)copy.getCommand());
        TestAtomicRequestMessage.assertEquals((int)100, (int)copy.getFetchSize());
        TestAtomicRequestMessage.assertEquals((long)example.getProcessingTimestamp(), (long)copy.getProcessingTimestamp());
        TestAtomicRequestMessage.assertEquals((Object)new RequestID(5000L), (Object)copy.getRequestID());
        TestAtomicRequestMessage.assertEquals((String)"2", (String)copy.getWorkContext().getSessionId());
        TestAtomicRequestMessage.assertEquals((String)"connectorBindingID", (String)copy.getConnectorName());
        TestAtomicRequestMessage.assertEquals((int)1000, (int)copy.getAtomicRequestID().getNodeID());
    }
}

