/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.internal.core.xml;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.internal.core.xml.JdomHelper;

public class TestJdomHelper
extends TestCase {
    private static final String TEST_DOCUMENT1 = "testdoc.xml";

    public TestJdomHelper(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document helpBuildDocumentFromStream(String filename, boolean validateXML) throws Exception {
        FileInputStream stream = null;
        Document result = null;
        try {
            stream = new FileInputStream(UnitTestUtil.getTestDataFile((String)filename));
            result = JdomHelper.buildDocument((InputStream)stream, (boolean)validateXML);
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {}
            }
        }
        TestJdomHelper.assertNotNull((String)("The Document built from \"" + filename + "\" is null"), (Object)result);
        TestJdomHelper.assertNotNull((String)("The Document built from \"" + filename + "\" is empty"), (Object)result.getRootElement());
        return result;
    }

    public void testBuildFromStream1() throws Exception {
        this.helpBuildDocumentFromStream(TEST_DOCUMENT1, false);
    }

    public void testWritingDocWithEmbeddedDoc() throws Exception {
        Document doc = JdomHelper.createNewDocument((String)"A");
        Element elementB = new Element("B");
        doc.getRootElement().addContent((Content)elementB);
        Element elementC = new Element("C");
        elementB.addContent((Content)elementC);
        Document embeddedDoc = this.helpBuildDocumentFromStream(TEST_DOCUMENT1, false);
        String embeddedDocString = JdomHelper.write((Document)embeddedDoc);
        elementC.setText(embeddedDocString);
        String docString = JdomHelper.write((Document)doc);
        TestJdomHelper.assertEquals((int)728, (int)docString.length());
        String defaultIndent = "  ";
        boolean newlines = true;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JdomHelper.write((Document)doc, (OutputStream)baos, (String)"  ", (boolean)true);
        TestJdomHelper.assertEquals((int)728, (int)baos.size());
    }
}

