/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.metadata.CompositeMetadataStore;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.TransformationMetadata;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.unittest.FakeMetadataFactory;

public class TestTransformationMetadata {
    @Test
    public void testAmbiguousProc() throws Exception {
        HashMap<String, Datatype> datatypes = new HashMap<String, Datatype>();
        datatypes.put("string", new Datatype());
        MetadataFactory mf = new MetadataFactory("x", datatypes, new Properties());
        mf.addProcedure("y");
        MetadataFactory mf1 = new MetadataFactory("x1", datatypes, new Properties());
        mf1.addProcedure("y");
        CompositeMetadataStore cms = new CompositeMetadataStore(Arrays.asList(mf.getMetadataStore(), mf1.getMetadataStore()));
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("vdb");
        vdb.setVersion(1);
        vdb.addModel(this.buildModel("x"));
        vdb.addModel(this.buildModel("x1"));
        TransformationMetadata tm = new TransformationMetadata(vdb, cms, null, null);
        try {
            tm.getStoredProcedureInfoForProcedure("y");
            Assert.fail((String)"expected exception");
        }
        catch (QueryMetadataException e) {
            Assert.assertEquals((Object)"Procedure 'y' is ambiguous, use the fully qualified name instead", (Object)e.getMessage());
        }
    }

    ModelMetaData buildModel(String name) {
        ModelMetaData model = new ModelMetaData();
        model.setName(name);
        model.setModelType(Model.Type.PHYSICAL);
        model.setVisible(Boolean.valueOf(true));
        return model;
    }

    @Test
    public void testAmbiguousTableWithPrivateModel() throws Exception {
        HashMap<String, Datatype> datatypes = new HashMap<String, Datatype>();
        datatypes.put("string", new Datatype());
        MetadataFactory mf = new MetadataFactory("x", datatypes, new Properties());
        mf.addTable("y");
        MetadataFactory mf1 = new MetadataFactory("x1", datatypes, new Properties());
        mf1.addTable("y");
        CompositeMetadataStore cms = new CompositeMetadataStore(Arrays.asList(mf.getMetadataStore(), mf1.getMetadataStore()));
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("foo");
        vdb.setVersion(1);
        ModelMetaData model = new ModelMetaData();
        model.setName("x1");
        vdb.addModel(model);
        ModelMetaData model2 = new ModelMetaData();
        model2.setName("x");
        model2.setVisible(Boolean.valueOf(true));
        vdb.addModel(model2);
        TransformationMetadata tm = new TransformationMetadata(vdb, cms, null, null);
        Collection result = tm.getGroupsForPartialName("y");
        Assert.assertEquals((long)2L, (long)result.size());
        FakeMetadataFactory.buildWorkContext((QueryMetadataInterface)tm, vdb);
        model.setVisible(Boolean.valueOf(false));
        tm = new TransformationMetadata(vdb, cms, null, null);
        result = tm.getGroupsForPartialName("y");
        Assert.assertEquals((long)1L, (long)result.size());
    }
}

