/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.source;

import java.io.File;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.util.TimeZone;
import net.sf.saxon.trans.XPathException;
import org.jdom.Attribute;
import org.jdom.Element;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.FileUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.function.source.XMLSystemFunctions;

public class TestXMLSystemFunctions {
    public String getContentOfTestFile(String testFilePath) {
        File file = UnitTestUtil.getTestDataFile((String)testFilePath);
        FileUtil util = new FileUtil(file.getAbsolutePath());
        return util.read();
    }

    public String helpTestXpathValue(String xmlFilePath, String xpath, String expected) throws XPathException, TeiidProcessingException {
        String actual = this.helpGetNode(xmlFilePath, xpath);
        Assert.assertEquals((Object)expected, (Object)actual);
        return actual;
    }

    public String helpGetNode(String xmlFilePath, String xpath) throws XPathException, TeiidProcessingException {
        String xmlContent = this.getContentOfTestFile(xmlFilePath);
        return XMLSystemFunctions.xpathValue((Object)xmlContent, (String)xpath);
    }

    public void helpCheckElement(Object jdomNode, String name, String prefix, String namespaceUri, String textContent) {
        Assert.assertTrue((String)"Supplied JDOM node is not an Element", (boolean)(jdomNode instanceof Element));
        Element element = (Element)jdomNode;
        Assert.assertEquals((Object)name, (Object)element.getName());
        Assert.assertEquals((Object)prefix, (Object)element.getNamespacePrefix());
        Assert.assertEquals((Object)namespaceUri, (Object)element.getNamespaceURI());
        String actualTextContent = element.getText();
        if (textContent == null) {
            Assert.assertEquals((long)0L, (long)actualTextContent.length());
        } else {
            Assert.assertEquals((Object)textContent, (Object)actualTextContent);
        }
    }

    public void helpCheckElement(Object jdomNode, String name, String prefix, String namespaceUri) {
        Assert.assertTrue((String)"Supplied JDOM node is not an Element", (boolean)(jdomNode instanceof Element));
        Element element = (Element)jdomNode;
        Assert.assertEquals((Object)name, (Object)element.getName());
        Assert.assertEquals((Object)prefix, (Object)element.getNamespacePrefix());
        Assert.assertEquals((Object)namespaceUri, (Object)element.getNamespaceURI());
    }

    public void helpCheckAttribute(Object jdomNode, String name, String prefix, String namespaceUri, String value) {
        Assert.assertTrue((String)"Supplied JDOM node is not an Attribute", (boolean)(jdomNode instanceof Attribute));
        Attribute attribute = (Attribute)jdomNode;
        Assert.assertEquals((Object)name, (Object)attribute.getName());
        Assert.assertEquals((Object)prefix, (Object)attribute.getNamespacePrefix());
        Assert.assertEquals((Object)namespaceUri, (Object)attribute.getNamespaceURI());
        String actualTextContent = attribute.getValue();
        Assert.assertEquals((Object)value, (Object)actualTextContent);
    }

    @Test
    public void testElement() throws Exception {
        String doc = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b><c>test</c></b></a>";
        String xpath = "a/b/c";
        String value = XMLSystemFunctions.xpathValue((Object)doc, (String)xpath);
        Assert.assertEquals((Object)"test", (Object)value);
    }

    @Test
    public void testAttribute() throws Exception {
        String doc = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b c=\"test\"></b></a>";
        String xpath = "a/b/@c";
        String value = XMLSystemFunctions.xpathValue((Object)doc, (String)xpath);
        Assert.assertEquals((Object)"test", (Object)value);
    }

    @Test
    public void testText() throws Exception {
        String doc = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b><c>test</c></b></a>";
        String xpath = "a/b/c/text()";
        String value = XMLSystemFunctions.xpathValue((Object)doc, (String)xpath);
        Assert.assertEquals((Object)"test", (Object)value);
    }

    @Test
    public void testNoMatch() throws Exception {
        String doc = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b><c>test</c></b></a>";
        String xpath = "x";
        String value = XMLSystemFunctions.xpathValue((Object)doc, (String)xpath);
        Assert.assertEquals(null, (Object)value);
    }

    @Test
    public void testNoXMLHeader() throws Exception {
        String doc = "<a><b><c>test</c></b></a>";
        String xpath = "a/b/c/text()";
        String value = XMLSystemFunctions.xpathValue((Object)doc, (String)xpath);
        Assert.assertEquals((Object)"test", (Object)value);
    }

    @Test
    public void testXMLInput() throws Exception {
        XMLType doc = new XMLType((SQLXML)new SQLXMLImpl("<foo/>"));
        String xpath = "a/b/c";
        String value = XMLSystemFunctions.xpathValue((Object)doc, (String)xpath);
        Assert.assertNull((Object)value);
    }

    @Test(expected=XPathException.class)
    public void testBadXPath() throws Exception {
        String doc = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b><c>test</c></b></a>";
        String xpath = ":BOGUS:";
        XMLSystemFunctions.xpathValue((Object)doc, (String)xpath);
    }

    @Test(expected=XPathException.class)
    public void testValidateXpath_Defect15088() throws Exception {
        String xpath = "//*[local-name()='bookName\"]";
        XMLSystemFunctions.validateXpath((String)"//*[local-name()='bookName\"]");
    }

    @Test
    public void testValidateXpath_null() throws Exception {
        XMLSystemFunctions.validateXpath(null);
    }

    @Test
    public void testValidateXpath_valid() throws Exception {
        XMLSystemFunctions.validateXpath((String)"//shipTo/@country");
    }

    @Test
    public void testGetSingleMatch_01_001() throws Exception {
        String xmlFilePath = "testdoc.xml";
        String xpath = "//shipTo/@country";
        String expectedValue = "US";
        this.helpTestXpathValue("testdoc.xml", "//shipTo/@country", "US");
    }

    @Test
    public void testGetSingleMatch_01_002() throws Exception {
        String xmlFilePath = "testdoc.xml";
        String xpath = "//@partNum";
        String expectedValue = "872-AA";
        this.helpTestXpathValue("testdoc.xml", "//@partNum", "872-AA");
    }

    @Test
    public void testGetSingleMatch_01_003() throws Exception {
        String xmlFilePath = "testdoc.xml";
        String xpath = "//productName";
        String expectedValue = "Lawnmower";
        this.helpTestXpathValue("testdoc.xml", "//productName", "Lawnmower");
    }

    @Test
    public void testGetSingleMatch_03() throws Exception {
        String xmlFilePath = "testdoc.xml";
        String xpath = "//*[local-name()=\"ReadOnly\"]";
        this.helpTestXpathValue("testdoc.xml", "//*[local-name()=\"ReadOnly\"]", "false");
    }

    @Test
    public void testGetSingleMatch_04() throws Exception {
        String xmlFilePath = "testdoc.xml";
        String xpath = "//*:ReadOnly";
        this.helpTestXpathValue("testdoc.xml", "//*:ReadOnly", "false");
    }

    @Test
    public void testInvokeXmlElement2() throws Exception {
        Assert.assertEquals((Object)"1969-12-31T18:00:00", (Object)XMLSystemFunctions.getStringValue((Object)new Timestamp(0L)));
    }

    @Test
    public void testNameEscaping() throws Exception {
        Assert.assertEquals((Object)"_u003A_b", (Object)XMLSystemFunctions.escapeName((String)":b", (boolean)true));
    }

    @Test
    public void testNameEscaping1() throws Exception {
        Assert.assertEquals((Object)"a_u005F_x", (Object)XMLSystemFunctions.escapeName((String)"a_x", (boolean)true));
    }

    @Test
    public void testNameEscaping2() throws Exception {
        Assert.assertEquals((Object)"_u000A_", (Object)XMLSystemFunctions.escapeName((String)new String(new char[]{'\n'}), (boolean)true));
    }

    @BeforeClass
    public static void setUpOnce() {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-6:00"));
    }

    @AfterClass
    public static void tearDownOnce() {
        TimeZone.setDefault(null);
    }
}

