/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational;

import java.util.Collection;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.client.plan.Annotation;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.FakeMetadataFactory;

public class TestMaterialization {
    @Test
    public void testMaterializedTransformation() throws Exception {
        String userSql = "SELECT MATVIEW.E1 FROM MATVIEW";
        QueryMetadataInterface metadata = FakeMetadataFactory.exampleMaterializedView();
        AnalysisRecord analysis = new AnalysisRecord(true, false);
        Command command = TestOptimizer.helpGetCommand(userSql, metadata, null);
        TestOptimizer.helpPlanCommand(command, metadata, TestOptimizer.getGenericFinder(), analysis, new String[]{"SELECT g_0.e1 FROM MatTable.MatTable AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        Collection annotations = analysis.getAnnotations();
        Assert.assertNotNull((String)"Expected annotations but got none", (Object)annotations);
        Assert.assertTrue((String)"Expected one annotation", (annotations.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Expected catagory mat view", (Object)((Annotation)annotations.iterator().next()).getCategory(), (Object)"Materialized View");
    }

    @Ignore(value="we no longer auto detect this case, if we need this logic it will have to be added to the rewriter since it changes select into to an insert")
    @Test
    public void testMaterializedTransformationLoading() throws Exception {
        String userSql = "SELECT MATVIEW.E1 INTO MatTable.MatStage FROM MATVIEW";
        QueryMetadataInterface metadata = FakeMetadataFactory.exampleMaterializedView();
        AnalysisRecord analysis = new AnalysisRecord(true, false);
        Command command = TestOptimizer.helpGetCommand(userSql, metadata, null);
        TestOptimizer.helpPlanCommand(command, metadata, TestOptimizer.getGenericFinder(), analysis, new String[]{"SELECT g_0.x FROM MatSrc.MatSrc AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        Collection annotations = analysis.getAnnotations();
        Assert.assertNotNull((String)"Expected annotations but got none", (Object)annotations);
        Assert.assertTrue((String)"Expected one annotation", (annotations.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Expected catagory mat view", (Object)((Annotation)annotations.iterator().next()).getCategory(), (Object)"Materialized View");
    }

    @Test
    public void testMaterializedTransformationNoCache() throws Exception {
        String userSql = "SELECT MATVIEW.E1 FROM MATVIEW OPTION NOCACHE MatView.MatView";
        QueryMetadataInterface metadata = FakeMetadataFactory.exampleMaterializedView();
        AnalysisRecord analysis = new AnalysisRecord(true, false);
        Command command = TestOptimizer.helpGetCommand(userSql, metadata, null);
        TestOptimizer.helpPlanCommand(command, metadata, TestOptimizer.getGenericFinder(), analysis, new String[]{"SELECT g_0.x FROM MatSrc.MatSrc AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        Collection annotations = analysis.getAnnotations();
        Assert.assertNotNull((String)"Expected annotations but got none", (Object)annotations);
        Assert.assertTrue((String)"Expected one annotation", (annotations.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Expected catagory mat view", (Object)((Annotation)annotations.iterator().next()).getCategory(), (Object)"Materialized View");
    }

    @Test
    public void testMaterializedTransformationNoCache2() throws Exception {
        String userSql = "SELECT MATVIEW.E1 FROM MATVIEW OPTION NOCACHE";
        QueryMetadataInterface metadata = FakeMetadataFactory.exampleMaterializedView();
        AnalysisRecord analysis = new AnalysisRecord(true, false);
        Command command = TestOptimizer.helpGetCommand(userSql, metadata, null);
        TestOptimizer.helpPlanCommand(command, metadata, TestOptimizer.getGenericFinder(), analysis, new String[]{"SELECT g_0.x FROM MatSrc.MatSrc AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        Collection annotations = analysis.getAnnotations();
        Assert.assertNotNull((String)"Expected annotations but got none", (Object)annotations);
        Assert.assertTrue((String)"Expected one annotation", (annotations.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Expected catagory mat view", (Object)((Annotation)annotations.iterator().next()).getCategory(), (Object)"Materialized View");
    }

    @Test
    public void testNoCacheInTransformation() throws Exception {
        String userSql = "SELECT VGROUP.E1 FROM VGROUP";
        QueryMetadataInterface metadata = FakeMetadataFactory.exampleMaterializedView();
        AnalysisRecord analysis = new AnalysisRecord(true, false);
        Command command = TestOptimizer.helpGetCommand(userSql, metadata, null);
        TestOptimizer.helpPlanCommand(command, metadata, TestOptimizer.getGenericFinder(), analysis, new String[]{"SELECT g_0.x FROM MatSrc.MatSrc AS g_0"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testTableNoCacheDoesntCascade() throws Exception {
        String userSql = "SELECT MATVIEW1.E1 FROM MATVIEW1 option nocache matview.matview1";
        QueryMetadataInterface metadata = FakeMetadataFactory.exampleMaterializedView();
        AnalysisRecord analysis = new AnalysisRecord(true, false);
        Command command = TestOptimizer.helpGetCommand(userSql, metadata, null);
        TestOptimizer.helpPlanCommand(command, metadata, TestOptimizer.getGenericFinder(), analysis, new String[]{"SELECT g_0.e1 FROM MatTable.MatTable AS g_0 WHERE g_0.e1 = '1'"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testNoCacheCascade() throws Exception {
        String userSql = "SELECT MATVIEW1.E1 FROM MATVIEW1 option nocache";
        QueryMetadataInterface metadata = FakeMetadataFactory.exampleMaterializedView();
        AnalysisRecord analysis = new AnalysisRecord(true, false);
        Command command = TestOptimizer.helpGetCommand(userSql, metadata, null);
        TestOptimizer.helpPlanCommand(command, metadata, TestOptimizer.getGenericFinder(), analysis, new String[]{"SELECT g_0.x FROM MatSrc.MatSrc AS g_0 WHERE g_0.x = '1'"}, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }
}

