/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;

public class TestFrameUtil {
    static GroupSymbol getGroup(int id) {
        return new GroupSymbol(String.valueOf(id));
    }

    @Test
    public void testFindJoinSourceNode() {
        PlanNode root = TestFrameUtil.getExamplePlan();
        PlanNode joinSource = FrameUtil.findJoinSourceNode((PlanNode)root);
        Assert.assertSame((Object)root, (Object)joinSource);
    }

    @Test
    public void testFindJoinSourceNode1() {
        PlanNode root = TestFrameUtil.getExamplePlan();
        PlanNode joinSource = FrameUtil.findJoinSourceNode((PlanNode)root.getLastChild());
        Assert.assertEquals((long)8L, (long)joinSource.getType());
    }

    @Test
    public void testFindSourceNode() {
        PlanNode root = TestFrameUtil.getExamplePlan();
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(TestFrameUtil.getGroup(1));
        PlanNode originatingNode = FrameUtil.findOriginatingNode((PlanNode)root, groups);
        Assert.assertEquals((long)1024L, (long)originatingNode.getType());
    }

    @Test
    public void testFindSourceNodeWithAccessSource() {
        PlanNode root = TestFrameUtil.getExamplePlan();
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(TestFrameUtil.getGroup(2));
        PlanNode originatingNode = FrameUtil.findOriginatingNode((PlanNode)root, groups);
        Assert.assertEquals((long)8L, (long)originatingNode.getType());
    }

    @Test
    public void testFindSourceNode2() {
        PlanNode root = TestFrameUtil.getExamplePlan();
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(TestFrameUtil.getGroup(3));
        PlanNode originatingNode = FrameUtil.findOriginatingNode((PlanNode)root, groups);
        Assert.assertEquals((long)128L, (long)originatingNode.getType());
    }

    @Test
    public void testNonExistentSource() {
        PlanNode root = TestFrameUtil.getExamplePlan();
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(TestFrameUtil.getGroup(4));
        PlanNode originatingNode = FrameUtil.findOriginatingNode((PlanNode)root, groups);
        Assert.assertNull((Object)originatingNode);
    }

    @Test
    public void testJoinGroups() throws Exception {
        PlanNode joinNode = TestFrameUtil.getExamplePlan();
        PlanNode projectNode = NodeFactory.getNewNode((int)16);
        ElementSymbol e1 = new ElementSymbol("e1");
        e1.setGroupSymbol(TestFrameUtil.getGroup(3));
        projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, Arrays.asList(e1));
        projectNode.addFirstChild(joinNode);
        projectNode.addGroup(TestFrameUtil.getGroup(3));
        PlanNode sourceNode = NodeFactory.getNewNode((int)128);
        sourceNode.addFirstChild(projectNode);
        GroupSymbol four = TestFrameUtil.getGroup(4);
        sourceNode.addGroup(four);
        ElementSymbol e2 = new ElementSymbol("e2");
        e2.setGroupSymbol(four);
        SymbolMap sm = SymbolMap.createSymbolMap(Arrays.asList(e2), Arrays.asList(e1));
        sourceNode.setProperty(NodeConstants.Info.SYMBOL_MAP, (Object)sm);
        PlanNode projectNode1 = NodeFactory.getNewNode((int)16);
        projectNode1.addFirstChild(sourceNode);
        projectNode1.addGroup(four);
        projectNode1.setProperty(NodeConstants.Info.PROJECT_COLS, Arrays.asList(e2));
        SymbolMap replacement = SymbolMap.createSymbolMap(Arrays.asList(e1), Arrays.asList(new Constant(null)));
        FrameUtil.convertFrame((PlanNode)NodeEditor.findNodePreOrder((PlanNode)joinNode, (int)128), (GroupSymbol)TestFrameUtil.getGroup(3), null, (Map)replacement.asMap(), null);
        Assert.assertEquals((long)2L, (long)joinNode.getGroups().size());
        Assert.assertEquals((long)0L, (long)NodeEditor.findNodePreOrder((PlanNode)joinNode, (int)32).getGroups().size());
        Assert.assertEquals((long)1L, (long)projectNode1.getGroups().size());
        Assert.assertEquals((long)0L, (long)projectNode.getGroups().size());
    }

    @Test
    public void testJoinGroups1() throws Exception {
        PlanNode joinNode = TestFrameUtil.getExamplePlan();
        PlanNode projectNode = NodeFactory.getNewNode((int)16);
        ElementSymbol e1 = new ElementSymbol("e1");
        e1.setGroupSymbol(TestFrameUtil.getGroup(3));
        projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, Arrays.asList(e1));
        projectNode.addFirstChild(joinNode);
        projectNode.addGroup(TestFrameUtil.getGroup(3));
        PlanNode sourceNode = NodeFactory.getNewNode((int)128);
        sourceNode.addFirstChild(projectNode);
        GroupSymbol four = TestFrameUtil.getGroup(4);
        sourceNode.addGroup(four);
        ElementSymbol e2 = new ElementSymbol("e2");
        e2.setGroupSymbol(four);
        SymbolMap sm = SymbolMap.createSymbolMap(Arrays.asList(e2), Arrays.asList(e1));
        sourceNode.setProperty(NodeConstants.Info.SYMBOL_MAP, (Object)sm);
        PlanNode projectNode1 = NodeFactory.getNewNode((int)16);
        projectNode1.addFirstChild(sourceNode);
        projectNode1.addGroup(four);
        projectNode1.setProperty(NodeConstants.Info.PROJECT_COLS, Arrays.asList(e2));
        SymbolMap replacement = SymbolMap.createSymbolMap(Arrays.asList(e1), Arrays.asList(new Constant(null)));
        FrameUtil.convertFrame((PlanNode)NodeEditor.findNodePreOrder((PlanNode)joinNode, (int)128), (GroupSymbol)TestFrameUtil.getGroup(3), new HashSet<GroupSymbol>(Arrays.asList(TestFrameUtil.getGroup(5), TestFrameUtil.getGroup(6))), (Map)replacement.asMap(), null);
        Assert.assertEquals((long)4L, (long)joinNode.getGroups().size());
        Assert.assertEquals((long)0L, (long)NodeEditor.findNodePreOrder((PlanNode)joinNode, (int)32).getGroups().size());
        Assert.assertEquals((long)1L, (long)projectNode1.getGroups().size());
        Assert.assertEquals((long)0L, (long)projectNode.getGroups().size());
    }

    public static PlanNode getExamplePlan() {
        PlanNode joinNode = NodeFactory.getNewNode((int)8);
        joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, (Object)JoinType.JOIN_CROSS);
        joinNode.addGroup(TestFrameUtil.getGroup(1));
        joinNode.addGroup(TestFrameUtil.getGroup(2));
        joinNode.addGroup(TestFrameUtil.getGroup(3));
        PlanNode nullNode = NodeFactory.getNewNode((int)1024);
        nullNode.addGroup(TestFrameUtil.getGroup(1));
        joinNode.addFirstChild(nullNode);
        PlanNode childCriteria = NodeFactory.getNewNode((int)32);
        childCriteria.setProperty(NodeConstants.Info.SELECT_CRITERIA, (Object)new IsNullCriteria((Expression)new Constant((Object)1)));
        childCriteria.addGroup(TestFrameUtil.getGroup(2));
        joinNode.addLastChild(childCriteria);
        PlanNode childJoinNode = NodeFactory.getNewNode((int)8);
        childJoinNode.setProperty(NodeConstants.Info.JOIN_TYPE, (Object)JoinType.JOIN_CROSS);
        childJoinNode.addGroup(TestFrameUtil.getGroup(2));
        childJoinNode.addGroup(TestFrameUtil.getGroup(3));
        childCriteria.addFirstChild(childJoinNode);
        PlanNode accessNode = NodeFactory.getNewNode((int)2);
        accessNode.addGroup(TestFrameUtil.getGroup(2));
        childJoinNode.addFirstChild(accessNode);
        PlanNode sourceNode = NodeFactory.getNewNode((int)128);
        sourceNode.addGroup(TestFrameUtil.getGroup(3));
        childJoinNode.addFirstChild(sourceNode);
        return joinNode;
    }
}

