/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import junit.framework.TestCase;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.xml.SourceNodeGenaratorVisitor;
import org.teiid.query.optimizer.xml.XMLNodeMappingVisitor;
import org.teiid.query.processor.xml.TestXMLProcessor;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.unittest.FakeMetadataFacade;

public class TestXMLNodeMappingVisitor
extends TestCase {
    public TestXMLNodeMappingVisitor(String arg0) {
        super(arg0);
    }

    public void helpTestMapping(Criteria crit, String expectedCritString, MappingDocument mappingDoc, QueryMetadataInterface metadata) throws QueryPlannerException, TeiidComponentException {
        crit = XMLNodeMappingVisitor.convertCriteria((Criteria)crit, (MappingDocument)mappingDoc, (QueryMetadataInterface)metadata);
        String actualCritString = crit.toString();
        TestXMLNodeMappingVisitor.assertEquals((String)"Got incorrect converted string: ", (String)expectedCritString, (String)actualCritString);
    }

    public void testMappingCriteria() throws Exception {
        FakeMetadataFacade metadata = TestXMLProcessor.exampleMetadata();
        GroupSymbol doc = new GroupSymbol("xmltest.doc1");
        doc.setMetadataID(metadata.getGroupID(doc.getName()));
        MappingDocument mappingDoc = (MappingDocument)metadata.getMappingNode(doc.getMetadataID());
        mappingDoc = SourceNodeGenaratorVisitor.extractSourceNodes((MappingDocument)mappingDoc);
        ElementSymbol es = new ElementSymbol("Catalogs.Catalog.Items.Item.Name");
        es.setGroupSymbol(doc);
        es.setMetadataID(metadata.getElementID("xmltest.doc1.Catalogs.Catalog.Items.Item.Name"));
        CompareCriteria crit = new CompareCriteria((Expression)es, 1, (Expression)new Constant((Object)"abc"));
        this.helpTestMapping((Criteria)crit, "xmltest.\"group\".items.itemName = 'abc'", mappingDoc, (QueryMetadataInterface)metadata);
    }
}

