/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.id.IDGenerator;
import org.teiid.core.id.IntegerIDFactory;
import org.teiid.core.id.ObjectIDFactory;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingSequenceNode;
import org.teiid.query.mapping.xml.Namespace;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.xml.CriteriaPlanner;
import org.teiid.query.optimizer.xml.XMLPlanner;
import org.teiid.query.optimizer.xml.XMLPlannerEnvironment;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.xml.BlockInstruction;
import org.teiid.query.processor.xml.EndBlockInstruction;
import org.teiid.query.processor.xml.ExecSqlInstruction;
import org.teiid.query.processor.xml.ExecStagingTableInstruction;
import org.teiid.query.processor.xml.MoveCursorInstruction;
import org.teiid.query.processor.xml.Program;
import org.teiid.query.processor.xml.TestXMLProcessor;
import org.teiid.query.processor.xml.WhileInstruction;
import org.teiid.query.processor.xml.XMLPlan;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.unittest.FakeMetadataObject;
import org.teiid.query.unittest.FakeMetadataStore;
import org.teiid.query.util.CommandContext;

public class TestXMLPlanner
extends TestCase {
    private static final boolean DEBUG = false;

    public TestXMLPlanner(String name) {
        super(name);
    }

    public static XMLPlan helpPlan(String sql, QueryMetadataInterface md) throws Exception {
        Command command = TestXMLProcessor.helpGetCommand(sql, md);
        return TestXMLPlanner.preparePlan(command, md, TestOptimizer.getGenericFinder(), null);
    }

    private void helpPlanException(String sql, QueryMetadataInterface md) throws QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        Command command = TestXMLProcessor.helpGetCommand(sql, md);
        try {
            TestXMLPlanner.preparePlan(command, md, TestOptimizer.getGenericFinder(), null);
            TestXMLPlanner.fail((String)("Expected exception for planning " + sql));
        }
        catch (QueryPlannerException e) {
            // empty catch block
        }
    }

    public static FakeMetadataFacade example1() {
        FakeMetadataObject pm1 = FakeMetadataFactory.createPhysicalModel("pm1");
        FakeMetadataObject vm1 = FakeMetadataFactory.createVirtualModel("vm1");
        FakeMetadataObject pm1g1 = FakeMetadataFactory.createPhysicalGroup("pm1.g1", pm1);
        FakeMetadataObject pm1g2 = FakeMetadataFactory.createPhysicalGroup("pm1.g2", pm1);
        FakeMetadataObject pm1g3 = FakeMetadataFactory.createPhysicalGroup("pm1.g3", pm1);
        FakeMetadataObject pm1g4 = FakeMetadataFactory.createPhysicalGroup("pm1.g4", pm1);
        FakeMetadataObject pm1g5 = FakeMetadataFactory.createPhysicalGroup("pm1.g5", pm1);
        List<FakeMetadataObject> pm1g1e = FakeMetadataFactory.createElements(pm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm1g2e = FakeMetadataFactory.createElements(pm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm1g3e = FakeMetadataFactory.createElements(pm1g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm1g4e = FakeMetadataFactory.createElements(pm1g4, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm1g5e = FakeMetadataFactory.createElements(pm1g5, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        QueryNode vm1g1n1 = new QueryNode("vm1.g1", "SELECT * FROM tm1.g1");
        FakeMetadataObject vm1g1 = FakeMetadataFactory.createVirtualGroup("vm1.g1", vm1, vm1g1n1);
        QueryNode vm1g2n1 = new QueryNode("vm1.g2", "SELECT * FROM pm1.g2 where pm1.g2.e1=?");
        vm1g2n1.addBinding("vm1.g1.e1");
        FakeMetadataObject vm1g2 = FakeMetadataFactory.createVirtualGroup("vm1.g2", vm1, vm1g2n1);
        QueryNode vm1g3n1 = new QueryNode("vm1.g3", "SELECT * FROM pm1.g3 where pm1.g3.e1=?");
        vm1g3n1.addBinding("vm1.g2.e1");
        FakeMetadataObject vm1g3 = FakeMetadataFactory.createVirtualGroup("vm1.g3", vm1, vm1g3n1);
        QueryNode vm1g4n1 = new QueryNode("vm1.g4", "SELECT * FROM pm1.g4");
        FakeMetadataObject vm1g4 = FakeMetadataFactory.createVirtualGroup("vm1.g4", vm1, vm1g4n1);
        QueryNode vm1g5n1 = new QueryNode("vm1.g5", "SELECT * FROM pm1.g5 where pm1.g5.e1=? AND pm1.g5.e2=?");
        vm1g5n1.addBinding("vm1.g4.e1");
        vm1g5n1.addBinding("vm1.g1.e1");
        FakeMetadataObject vm1g5 = FakeMetadataFactory.createVirtualGroup("vm1.g5", vm1, vm1g5n1);
        QueryNode tempGroup1 = new QueryNode("tm1.g1", "SELECT * FROM pm1.g1 where e2 < '5'");
        FakeMetadataObject tm1g1 = FakeMetadataFactory.createVirtualGroup("tm1.g1", vm1, tempGroup1);
        List<FakeMetadataObject> vm1g1e = FakeMetadataFactory.createElements(vm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm1g2e = FakeMetadataFactory.createElements(vm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm1g3e = FakeMetadataFactory.createElements(vm1g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm1g4e = FakeMetadataFactory.createElements(vm1g4, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm1g5e = FakeMetadataFactory.createElements(vm1g5, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> tm1g1e = FakeMetadataFactory.createElements(tm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        FakeMetadataObject doc1 = FakeMetadataFactory.createVirtualGroup("vm1.doc1", vm1, TestXMLPlanner.doc1());
        List<FakeMetadataObject> docE1 = FakeMetadataFactory.createElements(doc1, new String[]{"a0", "a0.a1", "a0.a1.a1", "a0.a1.b1", "a0.a1.c1"}, new String[]{"string", "string", "string", "string", "string"});
        FakeMetadataObject doc2 = FakeMetadataFactory.createVirtualGroup("vm1.doc2", vm1, TestXMLPlanner.doc2());
        List<FakeMetadataObject> docE2 = FakeMetadataFactory.createElements(doc2, new String[]{"a1"}, new String[]{"string"});
        FakeMetadataObject doc3 = FakeMetadataFactory.createVirtualGroup("vm1.doc3", vm1, TestXMLPlanner.doc3());
        List<FakeMetadataObject> docE3 = FakeMetadataFactory.createElements(doc3, new String[]{"root", "root.n1", "root.n1.m1", "root.n1.m1.n2", "root.n1.m1.n2.leaf1"}, new String[]{"string", "string", "string", "string", "string"});
        FakeMetadataObject doc4 = FakeMetadataFactory.createVirtualGroup("vm1.doc4", vm1, TestXMLPlanner.doc4());
        List<FakeMetadataObject> docE4 = FakeMetadataFactory.createElements(doc4, new String[]{"root", "root.n4a", "root.n4a.n4b", "root.n4a.n4c", "root.n4a.fake", "root.n4a.n4c.n4d", "root.n4a.n4c.n4e", "root.n4a.n4c.n4e.n4f"}, new String[]{"string", "string", "string", "string", "string", "string", "string", "string"});
        FakeMetadataObject doc5 = FakeMetadataFactory.createVirtualGroup("vm1.doc5", vm1, TestXMLPlanner.doc5());
        List<FakeMetadataObject> docE5 = FakeMetadataFactory.createElements(doc5, new String[]{"root", "root.nodea", "root.nodea.nodeb", "root.nodea.nodec", "root.nodea.nodec.noded", "root.nodea.nodec.nodee", "root.nodea.nodec.nodee.nodef", "root.nodea.nodec.nodee.nodeg", "root.nodea.nodec.nodee.nodeg.nodeh", "root.nodea.nodec.nodee.nodeg.nodeI", "root.nodea.nodec.nodee.nodeg.nodeI.nodeJ"}, new String[]{"string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string"});
        FakeMetadataObject doc6 = FakeMetadataFactory.createVirtualGroup("vm1.doc6", vm1, TestXMLPlanner.doc6());
        List<FakeMetadataObject> docE6 = FakeMetadataFactory.createElements(doc6, new String[]{"tempGroupTest"}, new String[]{"string"});
        FakeMetadataObject docWithExcluded = FakeMetadataFactory.createVirtualGroup("vm1.docWithExcluded", vm1, TestXMLPlanner.docWithExcluded());
        List<FakeMetadataObject> docWithExcludedElements = FakeMetadataFactory.createElements(docWithExcluded, new String[]{"root", "root.n1", "root.n1.m1", "root.n1.m1.n2", "root.n1.m1.n2.leaf1"}, new String[]{"string", "string", "string", "string", "string"});
        FakeMetadataObject doc2WithExcluded = FakeMetadataFactory.createVirtualGroup("vm1.docWithExcluded2", vm1, TestXMLPlanner.docWithExcluded2());
        List<FakeMetadataObject> doc2WithExcludedElements = FakeMetadataFactory.createElements(doc2WithExcluded, new String[]{"root", "root.n1", "root.n1.m1", "root.n1.m2", "root.n1.m3"}, new String[]{"string", "string", "string", "string", "string"});
        FakeMetadataObject docWithAttribute = FakeMetadataFactory.createVirtualGroup("vm1.docWithAttribute", vm1, TestXMLPlanner.docTestConvertCriteriaWithAttribute());
        FakeMetadataObject docWithAttribute3 = FakeMetadataFactory.createVirtualGroup("vm1.docWithAttribute3", vm1, TestXMLPlanner.docTestCriteriaWithAttribute());
        List<FakeMetadataObject> docWithAttributeElements = FakeMetadataFactory.createElements(docWithAttribute, new String[]{"root", "root.myElement", "root.@myAttribute"}, new String[]{"string", "string", "string"});
        FakeMetadataObject docWithAttribute2 = FakeMetadataFactory.createVirtualGroup("vm1.docWithAttribute2", vm1, TestXMLPlanner.docTestConvertCriteriaWithAttribute2());
        List<FakeMetadataObject> docWithAttributeElements2 = FakeMetadataFactory.createElements(docWithAttribute2, new String[]{"root", "root.myElement", "root.@myAttribute"}, new String[]{"string", "string", "string"});
        List<FakeMetadataObject> docWithAttributeElements3 = FakeMetadataFactory.createElements(docWithAttribute3, new String[]{"root", "root.myElement", "root.@type"}, new String[]{"string", "string", "string"});
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(pm1);
        store.addObject(pm1g1);
        store.addObjects(pm1g1e);
        store.addObject(pm1g2);
        store.addObjects(pm1g2e);
        store.addObject(pm1g3);
        store.addObjects(pm1g3e);
        store.addObject(pm1g4);
        store.addObjects(pm1g4e);
        store.addObject(pm1g5);
        store.addObjects(pm1g5e);
        store.addObject(vm1);
        store.addObject(vm1g1);
        store.addObjects(vm1g1e);
        store.addObject(vm1g2);
        store.addObjects(vm1g2e);
        store.addObject(vm1g3);
        store.addObjects(vm1g3e);
        store.addObject(vm1g4);
        store.addObjects(vm1g4e);
        store.addObject(vm1g5);
        store.addObjects(vm1g5e);
        store.addObject(tm1g1);
        store.addObjects(tm1g1e);
        store.addObject(doc1);
        store.addObject(doc2);
        store.addObject(doc3);
        store.addObject(doc4);
        store.addObject(doc5);
        store.addObject(doc6);
        store.addObject(docWithExcluded);
        store.addObject(doc2WithExcluded);
        store.addObject(docWithAttribute);
        store.addObject(docWithAttribute2);
        store.addObject(docWithAttribute3);
        store.addObjects(docE1);
        store.addObjects(docE2);
        store.addObjects(docE3);
        store.addObjects(docE4);
        store.addObjects(docE5);
        store.addObjects(docE6);
        store.addObjects(docWithExcludedElements);
        store.addObjects(doc2WithExcludedElements);
        store.addObjects(docWithAttributeElements);
        store.addObjects(docWithAttributeElements2);
        store.addObjects(docWithAttributeElements3);
        return new FakeMetadataFacade(store);
    }

    private static MappingDocument doc1() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement node = doc.addChildElement(new MappingElement("a0"));
        MappingElement sourceNode = node.addChildElement(new MappingElement("a1"));
        sourceNode.setSource("vm1.g1");
        sourceNode.addStagingTable("tm1.g1");
        sourceNode.addChildElement(new MappingElement("a1", "vm1.g1.e1"));
        sourceNode.addChildElement(new MappingElement("b1", "vm1.g1.e2"));
        sourceNode.addChildElement(new MappingElement("c1", "vm1.g1.e3"));
        return doc;
    }

    private static MappingDocument doc2() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement A1 = doc.addChildElement(new MappingElement("a1", "vm1.g1.e1"));
        A1.setSource("vm1.g1");
        return doc;
    }

    private static MappingDocument docTestConvertCriteriaWithAttribute() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        root.setSource("vm1.g1");
        root.addChildElement(new MappingElement("myElement", "vm1.g1.e2"));
        root.addAttribute(new MappingAttribute("myAttribute", "vm1.g1.e1"));
        return doc;
    }

    private static MappingDocument docTestConvertCriteriaWithAttribute2() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        root.setSource("vm1.g1");
        root.addAttribute(new MappingAttribute("myAttribute", "vm1.g1.e1"));
        MappingSequenceNode seq = root.addSequenceNode(new MappingSequenceNode());
        seq.addChildElement(new MappingElement("myElement", "vm1.g1.e2"));
        return doc;
    }

    private static MappingDocument doc3() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingElement n1 = root.addChildElement(new MappingElement("n1"));
        n1.setSource("vm1.g1");
        MappingElement m1 = n1.addChildElement(new MappingElement("m1"));
        MappingElement n2 = m1.addChildElement(new MappingElement("n2"));
        n2.setSource("vm1.g2");
        n2.addStagingTable("tm1.g1");
        n2.addChildElement(new MappingElement("leaf1", "vm1.g1.e1"));
        return doc;
    }

    private static MappingDocument doc4() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingElement n4a = root.addChildElement(new MappingElement("n4a"));
        n4a.setMaxOccurrs(-1);
        n4a.setSource("vm1.g1");
        n4a.addStagingTable("tm1.g1");
        n4a.addChildElement(new MappingElement("n4b", "vm1.g1.e1"));
        MappingElement n4c = n4a.addChildElement(new MappingElement("n4c"));
        n4c.setMaxOccurrs(-1);
        n4c.setSource("vm1.g2");
        MappingElement fake = n4a.addChildElement(new MappingElement("fake"));
        fake.setSource("fakeResultSet");
        n4c.addChildElement(new MappingElement("n4d", "vm1.g2.e1"));
        MappingElement n4e = n4c.addChildElement(new MappingElement("n4e"));
        n4e.setSource("vm1.g3");
        n4e.setMaxOccurrs(-1);
        n4e.addChildElement(new MappingElement("n4f", "vm1.g3.e1"));
        return doc;
    }

    private static MappingDocument doc5() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingElement nodea = root.addChildElement(new MappingElement("nodea"));
        nodea.setSource("vm1.g1");
        nodea.addStagingTable("tm1.g1");
        nodea.setMaxOccurrs(-1);
        nodea.addChildElement(new MappingElement("nodeb", "vm1.g1.e1"));
        MappingElement nodec = nodea.addChildElement(new MappingElement("nodec"));
        nodec.setMaxOccurrs(-1);
        nodec.setSource("vm1.g2");
        nodec.addChildElement(new MappingElement("noded", "vm1.g2.e1"));
        MappingElement nodee = nodec.addChildElement(new MappingElement("nodee"));
        nodee.setSource("vm1.g3");
        nodee.setMaxOccurrs(-1);
        nodee.addChildElement(new MappingElement("nodef", "vm1.g3.e1"));
        MappingElement nodeg = nodee.addChildElement(new MappingElement("nodeg"));
        nodeg.setSource("vm1.g4");
        nodeg.setMaxOccurrs(-1);
        nodeg.addChildElement(new MappingElement("nodeh", "vm1.g4.e1"));
        MappingElement nodeI = nodeg.addChildElement(new MappingElement("nodeI"));
        nodeI.setMaxOccurrs(-1);
        nodeI.setSource("vm1.g5");
        nodeI.addChildElement(new MappingElement("nodeJ", "vm1.g5.e1"));
        return doc;
    }

    private static MappingDocument doc6() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement simpleRoot = doc.addChildElement(new MappingElement("tempGroupTest"));
        simpleRoot.setSource("vm1.g1");
        simpleRoot.addStagingTable("tm1.g1");
        return doc;
    }

    private static MappingDocument docWithExcluded() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingElement n1 = root.addChildElement(new MappingElement("n1"));
        n1.setSource("vm1.g1");
        MappingElement m1 = n1.addChildElement(new MappingElement("m1", "vm1.g1.e1"));
        MappingElement n2 = m1.addChildElement(new MappingElement("n2"));
        n2.setSource("vm1.g2");
        n2.setExclude(true);
        n2.addChildElement(new MappingElement("leaf1", "vm1.g2.e2"));
        return doc;
    }

    private static MappingDocument docWithExcluded2() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingElement n1 = root.addChildElement(new MappingElement("n1"));
        n1.setSource("vm1.g1");
        n1.addChildElement(new MappingElement("m1", "vm1.g1.e1"));
        MappingElement m2 = n1.addChildElement(new MappingElement("m2", "vm1.g1.e2"));
        m2.setExclude(true);
        n1.addChildElement(new MappingElement("m3", "vm1.g1.e3"));
        return doc;
    }

    private static MappingDocument docTestCriteriaWithAttribute() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        root.setSource("vm1.g1");
        root.addAttribute(new MappingAttribute("type", new Namespace("xsi", "")));
        root.addAttribute(new MappingAttribute("type", "vm1.g1.e1"));
        root.addChildElement(new MappingElement("myElement", "vm1.g1.e2"));
        return doc;
    }

    public void test1() throws Exception {
        TestXMLPlanner.helpPlan("SELECT * FROM vm1.doc1", (QueryMetadataInterface)TestXMLPlanner.example1());
    }

    public void test1_defect7341() throws Exception {
        this.helpPlanException("SELECT * FROM vm1.doc1 WHERE a0 = '3'", (QueryMetadataInterface)TestXMLPlanner.example1());
    }

    public void test1_defect7341_a() throws Exception {
        this.helpPlanException("SELECT * FROM vm1.doc3 WHERE context(m1, m1) = '3'", (QueryMetadataInterface)TestXMLPlanner.example1());
    }

    public void test2() throws Exception {
        TestXMLPlanner.helpPlan("SELECT * FROM vm1.doc2", (QueryMetadataInterface)TestXMLPlanner.example1());
    }

    public void test3() throws Exception {
        TestXMLPlanner.helpPlan("SELECT * FROM vm1.doc1 where a0.a1.a1='x'", (QueryMetadataInterface)TestXMLPlanner.example1());
    }

    public void test4() throws Exception {
        TestXMLPlanner.helpPlan("SELECT * FROM vm1.doc3", (QueryMetadataInterface)TestXMLPlanner.example1());
    }

    public void testTempGroupPlan() throws Exception {
        FakeMetadataFacade qmi = TestXMLPlanner.example1();
        XMLPlan plan = TestXMLPlanner.helpPlan("SELECT * FROM vm1.doc6", (QueryMetadataInterface)qmi);
        Program program = plan.getOriginalProgram();
        int i = 0;
        TestXMLPlanner.assertTrue((boolean)(program.getInstructionAt(i++) instanceof ExecStagingTableInstruction));
        TestXMLPlanner.assertTrue((boolean)(program.getInstructionAt(i++) instanceof ExecSqlInstruction));
        TestXMLPlanner.assertTrue((boolean)(program.getInstructionAt(i++) instanceof BlockInstruction));
        TestXMLPlanner.assertTrue((boolean)(program.getInstructionAt(i++) instanceof MoveCursorInstruction));
        TestXMLPlanner.assertTrue((boolean)(program.getInstructionAt(i++) instanceof WhileInstruction));
        TestXMLPlanner.assertTrue((boolean)(program.getInstructionAt(i++) instanceof EndBlockInstruction));
        TestXMLPlanner.assertTrue((boolean)(program.getInstructionAt(i++) instanceof ExecStagingTableInstruction));
    }

    public void testPreparePlan() throws Exception {
        TestXMLPlanner.helpPlan("SELECT * FROM vm1.doc1 ORDER BY vm1.doc1.a0.a1.c1", (QueryMetadataInterface)TestXMLPlanner.example1());
    }

    public void testPreparePlan2() throws Exception {
        TestXMLPlanner.helpPlan("SELECT root.@myAttribute FROM vm1.docWithAttribute", (QueryMetadataInterface)TestXMLPlanner.example1());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLPlan preparePlan(Command command, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        IDGenerator idGenerator = new IDGenerator();
        idGenerator.setDefaultFactory((ObjectIDFactory)new IntegerIDFactory());
        AnalysisRecord analysis = new AnalysisRecord(false, false);
        XMLPlan xMLPlan = XMLPlanner.preparePlan((Command)command, (QueryMetadataInterface)metadata, (AnalysisRecord)analysis, (XMLPlannerEnvironment)new XMLPlannerEnvironment(metadata), (IDGenerator)idGenerator, (CapabilitiesFinder)capFinder, (CommandContext)context);
        return xMLPlan;
    }

    public void testDefect18227() throws Exception {
        FakeMetadataFacade metadata = TestXMLPlanner.example1();
        String sql = "select * from vm1.docWithAttribute3 where root.@type = '3'";
        Query query = (Query)TestXMLProcessor.helpGetCommand(sql, (QueryMetadataInterface)metadata);
        try {
            TestXMLPlanner.preparePlan((Command)query, (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder(), new CommandContext());
            TestXMLPlanner.fail((String)"Expected to get error about criteria against unmapped type attribute");
        }
        catch (QueryPlannerException e) {
            // empty catch block
        }
    }

    public void testDefect21983() throws Exception {
        FakeMetadataFacade metadata = TestXMLPlanner.example1();
        String sql = "select root.@type from vm1.docWithAttribute3";
        Query query = (Query)TestXMLProcessor.helpGetCommand(sql, (QueryMetadataInterface)metadata);
        TestXMLPlanner.preparePlan((Command)query, (QueryMetadataInterface)metadata, TestOptimizer.getGenericFinder(), new CommandContext());
    }

    public void testRootStagingTableCase4308() throws Exception {
        String sql = "select * from vm1.doc1 where stagingTable2.e1 IN ('a', 'b', 'c')";
        FakeMetadataFacade metadata = this.exampleCase4308();
        Query query = (Query)new QueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)query, (QueryMetadataInterface)metadata);
        String expectedStagingTableResultSet = "tm1.stagingTable2";
        String actualStagingTableResultSet = CriteriaPlanner.getStagingTableForConjunct((Criteria)query.getCriteria(), (QueryMetadataInterface)metadata);
        TestXMLPlanner.assertEquals((String)expectedStagingTableResultSet, (String)actualStagingTableResultSet);
    }

    private FakeMetadataFacade exampleCase4308() {
        FakeMetadataObject pm1 = FakeMetadataFactory.createPhysicalModel("pm1");
        FakeMetadataObject vm1 = FakeMetadataFactory.createVirtualModel("vm1");
        FakeMetadataObject pm1g1 = FakeMetadataFactory.createPhysicalGroup("pm1.g1", pm1);
        List<FakeMetadataObject> pm1g1e = FakeMetadataFactory.createElements(pm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        QueryNode stagingTableNode = new QueryNode("tm1.stagingTable2", "SELECT * FROM pm1.g1");
        FakeMetadataObject stagingTable = FakeMetadataFactory.createVirtualGroup("tm1.stagingTable2", vm1, stagingTableNode);
        List<FakeMetadataObject> stagingTableElements = FakeMetadataFactory.createElements(stagingTable, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        ArrayList<String> stagingTables = new ArrayList<String>(1);
        stagingTables.add("tm1.stagingTable2");
        root.setStagingTables(stagingTables);
        FakeMetadataObject doc1 = FakeMetadataFactory.createVirtualGroup("vm1.doc1", vm1, doc);
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(pm1);
        store.addObject(pm1g1);
        store.addObjects(pm1g1e);
        store.addObject(stagingTable);
        store.addObjects(stagingTableElements);
        store.addObject(doc1);
        return new FakeMetadataFacade(store);
    }
}

