/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.parser;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.parser.TestParser;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.CriteriaSelector;
import org.teiid.query.sql.proc.DeclareStatement;
import org.teiid.query.sql.proc.HasCriteria;
import org.teiid.query.sql.proc.IfStatement;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.symbol.AllSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.SelectSymbol;

public class TestOptionsAndHints {
    @Test
    public void testOptionMakeNotDepInline4() {
        GroupSymbol g1 = new GroupSymbol("db.g1");
        GroupSymbol g2 = new GroupSymbol("c", "db.g2");
        ElementSymbol a = new ElementSymbol("a");
        ElementSymbol b = new ElementSymbol("b");
        CompareCriteria crit = new CompareCriteria((Expression)a, 1, (Expression)b);
        From from = new From();
        UnaryFromClause clause = new UnaryFromClause(g1);
        clause.setMakeNotDep(true);
        from.addClause((FromClause)clause);
        UnaryFromClause clause1 = new UnaryFromClause(g2);
        clause1.setMakeNotDep(true);
        from.addClause((FromClause)clause1);
        Select select = new Select();
        select.addSymbol((SelectSymbol)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("Select a From db.g1 MAKENOTDEP, db.g2 AS c MAKENOTDEP WHERE a = b", "SELECT a FROM db.g1 MAKENOTDEP, db.g2 AS c MAKENOTDEP WHERE a = b", (Command)query);
    }

    @Test
    public void testOptionMakeDepInline1() {
        GroupSymbol g1 = new GroupSymbol("db.g1");
        GroupSymbol g2 = new GroupSymbol("db.g2");
        ElementSymbol a = new ElementSymbol("a");
        ElementSymbol b = new ElementSymbol("b");
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)a, 1, (Expression)b));
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(g1), (FromClause)new UnaryFromClause(g2), JoinType.JOIN_INNER, crits);
        jp.getRightClause().setMakeDep(true);
        From from = new From();
        from.addClause((FromClause)jp);
        Select select = new Select();
        select.addSymbol((SelectSymbol)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select a From db.g1 JOIN db.g2 MAKEDEP ON a = b", "SELECT a FROM db.g1 INNER JOIN db.g2 MAKEDEP ON a = b", (Command)query);
    }

    @Test
    public void testOptionMakeDepInline2() {
        GroupSymbol g1 = new GroupSymbol("db.g1");
        GroupSymbol g2 = new GroupSymbol("db.g2");
        ElementSymbol a = new ElementSymbol("a");
        ElementSymbol b = new ElementSymbol("b");
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)a, 1, (Expression)b));
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(g1), (FromClause)new UnaryFromClause(g2), JoinType.JOIN_INNER, crits);
        jp.getLeftClause().setMakeDep(true);
        From from = new From();
        from.addClause((FromClause)jp);
        Select select = new Select();
        select.addSymbol((SelectSymbol)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select a From db.g1 MAKEDEP JOIN db.g2 ON a = b", "SELECT a FROM db.g1 MAKEDEP INNER JOIN db.g2 ON a = b", (Command)query);
    }

    @Test
    public void testOptionMakeDepInline3() {
        GroupSymbol g1 = new GroupSymbol("db.g1");
        GroupSymbol g2 = new GroupSymbol("db.g2");
        GroupSymbol g3 = new GroupSymbol("db.g3");
        ElementSymbol a = new ElementSymbol("a");
        ElementSymbol b = new ElementSymbol("b");
        ElementSymbol c = new ElementSymbol("c");
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)a, 1, (Expression)b));
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(g1), (FromClause)new UnaryFromClause(g2), JoinType.JOIN_INNER, crits);
        jp.getLeftClause().setMakeDep(true);
        ArrayList<CompareCriteria> crits2 = new ArrayList<CompareCriteria>();
        crits2.add(new CompareCriteria((Expression)a, 1, (Expression)c));
        JoinPredicate jp2 = new JoinPredicate((FromClause)jp, (FromClause)new UnaryFromClause(g3), JoinType.JOIN_LEFT_OUTER, crits2);
        jp2.getRightClause().setMakeDep(true);
        From from = new From();
        from.addClause((FromClause)jp2);
        Select select = new Select();
        select.addSymbol((SelectSymbol)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select a From (db.g1 MAKEDEP JOIN db.g2 ON a = b) LEFT OUTER JOIN db.g3 MAKEDEP ON a = c", "SELECT a FROM (db.g1 MAKEDEP INNER JOIN db.g2 ON a = b) LEFT OUTER JOIN db.g3 MAKEDEP ON a = c", (Command)query);
    }

    @Test
    public void testOptionMakeDepInline4() {
        GroupSymbol g1 = new GroupSymbol("db.g1");
        GroupSymbol g2 = new GroupSymbol("c", "db.g2");
        ElementSymbol a = new ElementSymbol("a");
        ElementSymbol b = new ElementSymbol("b");
        CompareCriteria crit = new CompareCriteria((Expression)a, 1, (Expression)b);
        From from = new From();
        UnaryFromClause clause = new UnaryFromClause(g1);
        clause.setMakeDep(true);
        from.addClause((FromClause)clause);
        UnaryFromClause clause1 = new UnaryFromClause(g2);
        clause1.setMakeDep(true);
        from.addClause((FromClause)clause1);
        Select select = new Select();
        select.addSymbol((SelectSymbol)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)crit);
        TestParser.helpTest("Select a From db.g1 MAKEDEP, db.g2 AS c MAKEDEP WHERE a = b", "SELECT a FROM db.g1 MAKEDEP, db.g2 AS c MAKEDEP WHERE a = b", (Command)query);
    }

    @Test
    public void testOptionMakedep() throws Exception {
        String sql = "SELECT A.alert_id FROM (FSK_ALERT AS A MAKEDEP INNER JOIN Core.FSC_PARTY_DIM AS C ON A.primary_entity_key = C.PARTY_KEY) LEFT OUTER JOIN FSK_SCENARIO AS S ON A.scenario_id = S.scenario_id ";
        Query command = (Query)new QueryParser().parseCommand(sql);
        JoinPredicate predicate = (JoinPredicate)command.getFrom().getClauses().get(0);
        Assert.assertTrue((boolean)((JoinPredicate)predicate.getLeftClause()).getLeftClause().isMakeDep());
    }

    @Test
    public void testOptionMakeNotDepInline1() {
        GroupSymbol g1 = new GroupSymbol("db.g1");
        GroupSymbol g2 = new GroupSymbol("db.g2");
        ElementSymbol a = new ElementSymbol("a");
        ElementSymbol b = new ElementSymbol("b");
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)a, 1, (Expression)b));
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(g1), (FromClause)new UnaryFromClause(g2), JoinType.JOIN_INNER, crits);
        jp.getRightClause().setMakeNotDep(true);
        From from = new From();
        from.addClause((FromClause)jp);
        Select select = new Select();
        select.addSymbol((SelectSymbol)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select a From db.g1 JOIN db.g2 MAKENOTDEP ON a = b", "SELECT a FROM db.g1 INNER JOIN db.g2 MAKENOTDEP ON a = b", (Command)query);
    }

    @Test
    public void testOptionMakeNotDepInline2() {
        GroupSymbol g1 = new GroupSymbol("db.g1");
        GroupSymbol g2 = new GroupSymbol("db.g2");
        ElementSymbol a = new ElementSymbol("a");
        ElementSymbol b = new ElementSymbol("b");
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)a, 1, (Expression)b));
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(g1), (FromClause)new UnaryFromClause(g2), JoinType.JOIN_INNER, crits);
        jp.getLeftClause().setMakeNotDep(true);
        From from = new From();
        from.addClause((FromClause)jp);
        Select select = new Select();
        select.addSymbol((SelectSymbol)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select a From db.g1 MAKENOTDEP JOIN db.g2 ON a = b", "SELECT a FROM db.g1 MAKENOTDEP INNER JOIN db.g2 ON a = b", (Command)query);
    }

    @Test
    public void testOptionMakeNotDepInline3() {
        GroupSymbol g1 = new GroupSymbol("db.g1");
        GroupSymbol g2 = new GroupSymbol("db.g2");
        GroupSymbol g3 = new GroupSymbol("db.g3");
        ElementSymbol a = new ElementSymbol("a");
        ElementSymbol b = new ElementSymbol("b");
        ElementSymbol c = new ElementSymbol("c");
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)a, 1, (Expression)b));
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(g1), (FromClause)new UnaryFromClause(g2), JoinType.JOIN_INNER, crits);
        jp.getLeftClause().setMakeNotDep(true);
        ArrayList<CompareCriteria> crits2 = new ArrayList<CompareCriteria>();
        crits2.add(new CompareCriteria((Expression)a, 1, (Expression)c));
        JoinPredicate jp2 = new JoinPredicate((FromClause)jp, (FromClause)new UnaryFromClause(g3), JoinType.JOIN_LEFT_OUTER, crits2);
        jp2.getRightClause().setMakeNotDep(true);
        From from = new From();
        from.addClause((FromClause)jp2);
        Select select = new Select();
        select.addSymbol((SelectSymbol)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select a From (db.g1 MAKENOTDEP JOIN db.g2 ON a = b) LEFT OUTER JOIN db.g3 MAKENOTDEP ON a = c", "SELECT a FROM (db.g1 MAKENOTDEP INNER JOIN db.g2 ON a = b) LEFT OUTER JOIN db.g3 MAKENOTDEP ON a = c", (Command)query);
    }

    @Test
    public void testDepOptions2() {
        GroupSymbol a = new GroupSymbol("a");
        GroupSymbol b = new GroupSymbol("b");
        ElementSymbol x = new ElementSymbol("a.x", true);
        ElementSymbol y = new ElementSymbol("b.y", true);
        CompareCriteria criteria = new CompareCriteria((Expression)x, 1, (Expression)new Function("func", new Expression[]{y}));
        JoinPredicate predicate = new JoinPredicate((FromClause)new UnaryFromClause(a), (FromClause)new UnaryFromClause(b), JoinType.JOIN_INNER, Arrays.asList(criteria));
        From from = new From(Arrays.asList(predicate));
        predicate.getLeftClause().setMakeNotDep(true);
        predicate.getRightClause().setMakeDep(true);
        Select select = new Select(Arrays.asList(x, y));
        Query query = new Query(select, from, null, null, null, null, null);
        TestParser.helpTest("Select a.x, b.y From a MAKENOTDEP INNER JOIN b MAKEDEP ON a.x = func(b.y)", "SELECT a.x, b.y FROM a MAKENOTDEP INNER JOIN b MAKEDEP ON a.x = func(b.y)", (Command)query);
    }

    @Test
    public void testOptionNoCache1() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((SelectSymbol)a);
        Option option = new Option();
        option.setNoCache(true);
        option.addNoCacheGroup("a.b.c");
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOption(option);
        TestParser.helpTest("Select a From db.g Option nocache a.b.c", "SELECT a FROM db.g OPTION NOCACHE a.b.c", (Command)query);
    }

    @Test
    public void testOptionNoCache2() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((SelectSymbol)a);
        Option option = new Option();
        option.setNoCache(true);
        option.addNoCacheGroup("a.b.c");
        option.addNoCacheGroup("d.e.f");
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOption(option);
        TestParser.helpTest("Select a From db.g Option nocache a.b.c, d.e.f", "SELECT a FROM db.g OPTION NOCACHE a.b.c, d.e.f", (Command)query);
    }

    @Test
    public void testOptionNoCache3() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((SelectSymbol)a);
        Option option = new Option();
        option.setNoCache(true);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOption(option);
        TestParser.helpTest("Select a From db.g Option nocache", "SELECT a FROM db.g OPTION NOCACHE", (Command)query);
    }

    @Test
    public void testFailsIllegalOption() {
        TestParser.helpException("SELECT a from g OPTION xyx");
    }

    @Test
    public void testInsertWithOption() {
        Insert insert = new Insert();
        insert.setGroup(new GroupSymbol("m.g"));
        ArrayList<ElementSymbol> vars = new ArrayList<ElementSymbol>();
        vars.add(new ElementSymbol("a"));
        insert.setVariables(vars);
        ArrayList<Reference> values = new ArrayList<Reference>();
        values.add(new Reference(0));
        insert.setValues(values);
        Option option = new Option();
        option.setNoCache(true);
        insert.setOption(option);
        TestParser.helpTest("INSERT INTO m.g (a) VALUES (?) OPTION NOCACHE", "INSERT INTO m.g (a) VALUES (?) OPTION NOCACHE", (Command)insert);
    }

    @Test
    public void testDeleteWithOption() {
        Delete delete = new Delete();
        delete.setGroup(new GroupSymbol("m.g"));
        Option option = new Option();
        option.setNoCache(true);
        delete.setOption(option);
        TestParser.helpTest("DELETE FROM m.g OPTION NOCACHE", "DELETE FROM m.g OPTION NOCACHE", (Command)delete);
    }

    @Test
    public void testUpdateWithOption() {
        Update update = new Update();
        update.setGroup(new GroupSymbol("m.g"));
        update.addChange(new ElementSymbol("a"), (Expression)new Reference(0));
        Option option = new Option();
        option.setNoCache(true);
        CompareCriteria crit = new CompareCriteria((Expression)new ElementSymbol("b"), 1, (Expression)new Reference(1));
        update.setCriteria((Criteria)crit);
        TestParser.helpTest("UPDATE m.g SET a = ? WHERE b = ? OPTION NOCACHE", "UPDATE m.g SET a = ? WHERE b = ? OPTION NOCACHE", (Command)update);
    }

    @Test
    public void testOptionalFromClause1() {
        String sql = "SELECT * FROM /* optional */ t1, t2";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new AllSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("t1"));
        ufc.setOptional(true);
        from.addClause((FromClause)ufc);
        from.addGroup(new GroupSymbol("t2"));
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM /* optional */ t1, t2", (Command)query);
    }

    @Test
    public void testOptionalFromClause1_1() {
        String sql = "SELECT * FROM /* optional*/ t1, t2";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new AllSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("t1"));
        ufc.setOptional(true);
        from.addClause((FromClause)ufc);
        from.addGroup(new GroupSymbol("t2"));
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM /* optional */ t1, t2", (Command)query);
    }

    @Test
    public void testOptionalFromClause1_2() {
        String sql = "SELECT * FROM /*optional */ t1, t2";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new AllSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("t1"));
        ufc.setOptional(true);
        from.addClause((FromClause)ufc);
        from.addGroup(new GroupSymbol("t2"));
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM /* optional */ t1, t2", (Command)query);
    }

    @Test
    public void testOptionalFromClause1_3() {
        String sql = "SELECT * FROM /* optional  */ t1, t2";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new AllSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("t1"));
        ufc.setOptional(true);
        from.addClause((FromClause)ufc);
        from.addGroup(new GroupSymbol("t2"));
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM /* optional */ t1, t2", (Command)query);
    }

    @Test
    public void testOptionalFromClause1_4() {
        String sql = "SELECT * /* optional */ FROM /* OptiOnal  */ t1, t2";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new AllSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("t1"));
        ufc.setOptional(true);
        from.addClause((FromClause)ufc);
        from.addGroup(new GroupSymbol("t2"));
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM /* optional */ t1, t2", (Command)query);
    }

    @Test
    public void testOptionalFromClause1_5() {
        String sql = "SELECT * FROM /* OptiOnal  */ t1, t2";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new AllSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("t1"));
        ufc.setOptional(true);
        from.addClause((FromClause)ufc);
        from.addGroup(new GroupSymbol("t2"));
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM /* optional */ t1, t2", (Command)query);
    }

    @Test
    public void testOptionalFromClause2() {
        String sql = "SELECT * FROM t1, /* optional */ t2";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new AllSymbol());
        query.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("t1"));
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("t2"));
        ufc.setOptional(true);
        from.addClause((FromClause)ufc);
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM t1, /* optional */ t2", (Command)query);
    }

    @Test
    public void testOptionalFromClause3() {
        String sql = "SELECT * FROM /* optional */ t1 AS a, t2";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new AllSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("a", "t1"));
        ufc.setOptional(true);
        from.addClause((FromClause)ufc);
        from.addGroup(new GroupSymbol("t2"));
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM /* optional */ t1 AS a, t2", (Command)query);
    }

    @Test
    public void testOptionalFromClause4() {
        String sql = "SELECT * FROM t1, /* optional */ t2 as a";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new AllSymbol());
        query.setSelect(select);
        From from = new From();
        from.addGroup(new GroupSymbol("t1"));
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("a", "t2"));
        ufc.setOptional(true);
        from.addClause((FromClause)ufc);
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM t1, /* optional */ t2 AS a", (Command)query);
    }

    @Test
    public void testOptionalFromClause5() {
        String sql = "SELECT * FROM t1, /* optional */ (select * from t1, t2) as x";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new AllSymbol());
        query.setSelect(select);
        From from = new From();
        Query query2 = new Query();
        select = new Select();
        select.addSymbol((SelectSymbol)new AllSymbol());
        query2.setSelect(select);
        From from2 = new From();
        from2.addGroup(new GroupSymbol("t1"));
        from2.addGroup(new GroupSymbol("t2"));
        query2.setFrom(from2);
        SubqueryFromClause sfc = new SubqueryFromClause("x", (Command)query2);
        sfc.setOptional(true);
        from.addGroup(new GroupSymbol("t1"));
        from.addClause((FromClause)sfc);
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM t1, /* optional */ (SELECT * FROM t1, t2) AS x", (Command)query);
    }

    @Test
    public void testOptionalFromClause6() {
        String sql = "SELECT * FROM t1 INNER JOIN /* optional */ (select a from t1, t2) AS x ON t1.a=x.a";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new AllSymbol());
        query.setSelect(select);
        From from = new From();
        Query query2 = new Query();
        select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("a"));
        From from2 = new From();
        from2.addGroup(new GroupSymbol("t1"));
        from2.addGroup(new GroupSymbol("t2"));
        query2.setSelect(select);
        query2.setFrom(from2);
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("t1"));
        SubqueryFromClause sfc = new SubqueryFromClause("x", (Command)query2);
        sfc.setOptional(true);
        ArrayList<CompareCriteria> criteria = new ArrayList<CompareCriteria>();
        criteria.add(new CompareCriteria((Expression)new ElementSymbol("t1.a"), 1, (Expression)new ElementSymbol("x.a")));
        JoinPredicate joinPredicate = new JoinPredicate((FromClause)ufc, (FromClause)sfc, JoinType.JOIN_INNER, criteria);
        from.addClause((FromClause)joinPredicate);
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT * FROM t1 INNER JOIN /* optional */ (SELECT a FROM t1, t2) AS x ON t1.a = x.a", (Command)query);
    }

    @Test
    public void testOptionalFromClause7() {
        String sql = "SELECT b FROM t1, /* optional */ (t2 INNER JOIN t3 ON t2.a = t3.a)";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("b"));
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("t2"));
        UnaryFromClause ufc2 = new UnaryFromClause();
        ufc2.setGroup(new GroupSymbol("t3"));
        ArrayList<CompareCriteria> criteria = new ArrayList<CompareCriteria>();
        criteria.add(new CompareCriteria((Expression)new ElementSymbol("t2.a"), 1, (Expression)new ElementSymbol("t3.a")));
        JoinPredicate joinPredicate = new JoinPredicate((FromClause)ufc, (FromClause)ufc2, JoinType.JOIN_INNER, criteria);
        joinPredicate.setOptional(true);
        UnaryFromClause ufc3 = new UnaryFromClause();
        ufc3.setGroup(new GroupSymbol("t1"));
        from.addClause((FromClause)ufc3);
        from.addClause((FromClause)joinPredicate);
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT b FROM t1, /* optional */ (t2 INNER JOIN t3 ON t2.a = t3.a)", (Command)query);
    }

    @Test
    public void testOptionalFromClause8() {
        String sql = "SELECT b FROM t1, /* optional */ (/* optional */ (SELECT * FROM t1, t2) AS x INNER JOIN t3 ON x.a = t3.a)";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("b"));
        query.setSelect(select);
        From from = new From();
        Query query2 = new Query();
        select = new Select();
        select.addSymbol((SelectSymbol)new AllSymbol());
        From from2 = new From();
        from2.addGroup(new GroupSymbol("t1"));
        from2.addGroup(new GroupSymbol("t2"));
        query2.setSelect(select);
        query2.setFrom(from2);
        SubqueryFromClause sfc = new SubqueryFromClause("x", (Command)query2);
        sfc.setOptional(true);
        UnaryFromClause ufc2 = new UnaryFromClause();
        ufc2.setGroup(new GroupSymbol("t3"));
        ArrayList<CompareCriteria> criteria = new ArrayList<CompareCriteria>();
        criteria.add(new CompareCriteria((Expression)new ElementSymbol("x.a"), 1, (Expression)new ElementSymbol("t3.a")));
        JoinPredicate joinPredicate = new JoinPredicate((FromClause)sfc, (FromClause)ufc2, JoinType.JOIN_INNER, criteria);
        joinPredicate.setOptional(true);
        UnaryFromClause ufc3 = new UnaryFromClause();
        ufc3.setGroup(new GroupSymbol("t1"));
        from.addClause((FromClause)ufc3);
        from.addClause((FromClause)joinPredicate);
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT b FROM t1, /* optional */ (/* optional */ (SELECT * FROM t1, t2) AS x INNER JOIN t3 ON x.a = t3.a)", (Command)query);
    }

    @Test
    public void testOptionalFromClause9() {
        String sql = "SELECT b FROM (t1 LEFT OUTER JOIN /* optional */t2 on t1.a = t2.a) LEFT OUTER JOIN /* optional */t3 on t1.a = t3.a";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new ElementSymbol("b"));
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("t1"));
        UnaryFromClause ufc2 = new UnaryFromClause();
        ufc2.setGroup(new GroupSymbol("t2"));
        ufc2.setOptional(true);
        ArrayList<CompareCriteria> criteria = new ArrayList<CompareCriteria>();
        criteria.add(new CompareCriteria((Expression)new ElementSymbol("t1.a"), 1, (Expression)new ElementSymbol("t2.a")));
        JoinPredicate joinPredicate = new JoinPredicate((FromClause)ufc, (FromClause)ufc2, JoinType.JOIN_LEFT_OUTER, criteria);
        UnaryFromClause ufc3 = new UnaryFromClause();
        ufc3.setGroup(new GroupSymbol("t3"));
        ufc3.setOptional(true);
        criteria = new ArrayList();
        criteria.add(new CompareCriteria((Expression)new ElementSymbol("t1.a"), 1, (Expression)new ElementSymbol("t3.a")));
        JoinPredicate joinPredicate2 = new JoinPredicate((FromClause)joinPredicate, (FromClause)ufc3, JoinType.JOIN_LEFT_OUTER, criteria);
        from.addClause((FromClause)joinPredicate2);
        query.setFrom(from);
        TestParser.helpTest(sql, "SELECT b FROM (t1 LEFT OUTER JOIN /* optional */ t2 ON t1.a = t2.a) LEFT OUTER JOIN /* optional */ t3 ON t1.a = t3.a", (Command)query);
    }

    @Test
    public void testOptionalFromClause10() {
        ElementSymbol var1 = new ElementSymbol("var1");
        String shortType = new String("short");
        DeclareStatement declStmt = new DeclareStatement(var1, shortType);
        ArrayList<ElementSymbol> symbols = new ArrayList<ElementSymbol>();
        symbols.add(new ElementSymbol("a1"));
        Select select = new Select(symbols);
        From from = new From();
        from.addGroup(new GroupSymbol("g"));
        CompareCriteria criteria = new CompareCriteria((Expression)new ElementSymbol("a2"), 1, (Expression)new Constant((Object)new Integer(5)));
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setCriteria((Criteria)criteria);
        Query queryCmd = query;
        AssignmentStatement queryStmt = new AssignmentStatement(var1, (LanguageObject)queryCmd);
        Block ifBlock = new Block();
        ifBlock.addStatement((Statement)queryStmt);
        ElementSymbol var2 = new ElementSymbol("var2");
        DeclareStatement elseDeclStmt = new DeclareStatement(var2, shortType);
        ArrayList<ElementSymbol> elseSymbols = new ArrayList<ElementSymbol>();
        elseSymbols.add(new ElementSymbol("b1"));
        Select elseSelect = new Select(elseSymbols);
        Query elseQuery = new Query();
        elseQuery.setSelect(elseSelect);
        From elseFrom = (From)from.clone();
        UnaryFromClause ufc = new UnaryFromClause();
        ufc.setGroup(new GroupSymbol("h"));
        ufc.setOptional(true);
        elseFrom.addClause((FromClause)ufc);
        elseQuery.setFrom(elseFrom);
        elseQuery.setCriteria((Criteria)criteria);
        Query elseQueryCmd = elseQuery;
        AssignmentStatement elseQueryStmt = new AssignmentStatement(var2, (LanguageObject)elseQueryCmd);
        Block elseBlock = new Block();
        ArrayList<Object> elseStmts = new ArrayList<Object>();
        elseStmts.add(elseDeclStmt);
        elseStmts.add(elseQueryStmt);
        elseBlock.setStatements(elseStmts);
        ElementSymbol a = new ElementSymbol("a");
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(a);
        CriteriaSelector critSelector = new CriteriaSelector();
        critSelector.setSelectorType(8);
        critSelector.setElements(elements);
        HasCriteria hasSelector = new HasCriteria();
        hasSelector.setSelector(critSelector);
        IfStatement stmt = new IfStatement((Criteria)hasSelector, ifBlock, elseBlock);
        Block block = new Block();
        block.addStatement((Statement)declStmt);
        block.addStatement((Statement)stmt);
        CreateUpdateProcedureCommand cmd = new CreateUpdateProcedureCommand();
        cmd.setBlock(block);
        TestParser.helpTest("CREATE PROCEDURE BEGIN DECLARE short var1; IF(HAS IN CRITERIA ON (a)) BEGIN var1 = SELECT a1 FROM g WHERE a2 = 5; END ELSE BEGIN DECLARE short var2; var2 = SELECT b1 FROM g, /* optional */ h WHERE a2 = 5; END END", "CREATE PROCEDURE\nBEGIN\nDECLARE short var1;\nIF(HAS IN CRITERIA ON (a))\nBEGIN\nvar1 = SELECT a1 FROM g WHERE a2 = 5;\nEND\nELSE\nBEGIN\nDECLARE short var2;\nvar2 = SELECT b1 FROM g, /* optional */ h WHERE a2 = 5;\nEND\nEND", (Command)cmd);
    }

    @Test
    public void testStoredQueryWithOption() {
        StoredProcedure storedQuery = new StoredProcedure();
        storedQuery.setProcedureName("proc1");
        Option option = new Option();
        option.setNoCache(true);
        storedQuery.setOption(option);
        TestParser.helpTest("exec proc1() option nocache", "EXEC proc1() OPTION NOCACHE", (Command)storedQuery);
    }

    @Test
    public void testOptionMakeDependent1() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((SelectSymbol)a);
        Option option = new Option();
        option.addDependentGroup("a.b.c");
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOption(option);
        TestParser.helpTest("Select a From db.g Option makedep a.b.c", "SELECT a FROM db.g OPTION MAKEDEP a.b.c", (Command)query);
    }

    @Test
    public void testOptionMakeDependent2() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((SelectSymbol)a);
        Option option = new Option();
        option.addDependentGroup("a.b.c");
        option.addDependentGroup("d.e.f");
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOption(option);
        TestParser.helpTest("Select a From db.g Option makedep a.b.c, d.e.f", "SELECT a FROM db.g OPTION MAKEDEP a.b.c, d.e.f", (Command)query);
    }

    @Test
    public void testOptionMakeDependent3() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((SelectSymbol)a);
        Option option = new Option();
        option.addDependentGroup("a.b.c");
        option.addDependentGroup("d.e.f");
        option.addDependentGroup("x.y.z");
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOption(option);
        TestParser.helpTest("Select a From db.g Option makedep a.b.c, d.e.f, x.y.z", "SELECT a FROM db.g OPTION MAKEDEP a.b.c, d.e.f, x.y.z", (Command)query);
    }

    @Test
    public void testOptionMakeNotDependent1() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((SelectSymbol)a);
        Option option = new Option();
        option.addNotDependentGroup("a.b.c");
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOption(option);
        TestParser.helpTest("Select a From db.g Option makenotdep a.b.c", "SELECT a FROM db.g OPTION MAKENOTDEP a.b.c", (Command)query);
    }

    @Test
    public void testOptionMakeNotDependent2() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((SelectSymbol)a);
        Option option = new Option();
        option.addNotDependentGroup("a.b.c");
        option.addNotDependentGroup("d.e.f");
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOption(option);
        TestParser.helpTest("Select a From db.g Option makeNOTdep a.b.c, d.e.f", "SELECT a FROM db.g OPTION MAKENOTDEP a.b.c, d.e.f", (Command)query);
    }

    @Test
    public void testOptionMakeNotDependent3() {
        GroupSymbol g = new GroupSymbol("db.g");
        From from = new From();
        from.addGroup(g);
        Select select = new Select();
        ElementSymbol a = new ElementSymbol("a");
        select.addSymbol((SelectSymbol)a);
        Option option = new Option();
        option.addNotDependentGroup("a.b.c");
        option.addNotDependentGroup("d.e.f");
        option.addNotDependentGroup("x.y.z");
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        query.setOption(option);
        TestParser.helpTest("Select a From db.g Option makenotdep a.b.c, d.e.f, x.y.z", "SELECT a FROM db.g OPTION MAKENOTDEP a.b.c, d.e.f, x.y.z", (Command)query);
    }

    @Test
    public void testDepOptions1() {
        GroupSymbol a = new GroupSymbol("a");
        GroupSymbol b = new GroupSymbol("b");
        ElementSymbol x = new ElementSymbol("a.x", true);
        ElementSymbol y = new ElementSymbol("b.y", true);
        From from = new From(Arrays.asList(new UnaryFromClause(a), new UnaryFromClause(b)));
        Option option = new Option();
        option.addDependentGroup("a");
        option.addNotDependentGroup("b");
        Select select = new Select(Arrays.asList(x, y));
        CompareCriteria criteria = new CompareCriteria((Expression)x, 1, (Expression)y);
        Query query = new Query(select, from, (Criteria)criteria, null, null, null, option);
        TestParser.helpTest("Select a.x, b.y From a, b WHERE a.x = b.y option makedep a makenotdep b", "SELECT a.x, b.y FROM a, b WHERE a.x = b.y OPTION MAKEDEP a MAKENOTDEP b", (Command)query);
    }

    @Test
    public void testOptionMakeDepInline5() {
        GroupSymbol g1 = new GroupSymbol("db.g1");
        GroupSymbol g2 = new GroupSymbol("db.g2");
        GroupSymbol g3 = new GroupSymbol("db.g3");
        ElementSymbol a = new ElementSymbol("a");
        ElementSymbol b = new ElementSymbol("b");
        ElementSymbol c = new ElementSymbol("c");
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)a, 1, (Expression)b));
        JoinPredicate jp = new JoinPredicate((FromClause)new UnaryFromClause(g1), (FromClause)new UnaryFromClause(g2), JoinType.JOIN_INNER, crits);
        jp.setMakeDep(true);
        ArrayList<CompareCriteria> crits2 = new ArrayList<CompareCriteria>();
        crits2.add(new CompareCriteria((Expression)a, 1, (Expression)c));
        JoinPredicate jp2 = new JoinPredicate((FromClause)jp, (FromClause)new UnaryFromClause(g3), JoinType.JOIN_LEFT_OUTER, crits2);
        From from = new From();
        from.addClause((FromClause)jp2);
        Select select = new Select();
        select.addSymbol((SelectSymbol)a);
        Query query = new Query();
        query.setSelect(select);
        query.setFrom(from);
        TestParser.helpTest("Select a From (db.g1 JOIN db.g2 ON a = b) makedep LEFT OUTER JOIN db.g3 ON a = c", "SELECT a FROM (db.g1 INNER JOIN db.g2 ON a = b) MAKEDEP LEFT OUTER JOIN db.g3 ON a = c", (Command)query);
        TestParser.helpTest(query.toString(), query.toString(), (Command)query);
    }

    @Test
    public void testCache() {
        String sql = "/* cache */ SELECT * FROM t1";
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((SelectSymbol)new AllSymbol());
        query.setSelect(select);
        From from = new From();
        UnaryFromClause ufc = new UnaryFromClause();
        from.addClause((FromClause)ufc);
        ufc.setGroup(new GroupSymbol("t1"));
        query.setFrom(from);
        query.setCache(true);
        TestParser.helpTest(sql, "/* cache */ SELECT * FROM t1", (Command)query);
    }

    @Test
    public void testCache1() {
        String sql = "/* cache */ execute foo()";
        StoredProcedure sp = new StoredProcedure();
        sp.setCache(true);
        sp.setProcedureName("foo");
        TestParser.helpTest(sql, "/* cache */ EXEC foo()", (Command)sp);
    }
}

