/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.metadata.StoredProcedureInfo;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataFactory;
import org.teiid.query.unittest.FakeMetadataObject;

public class FakeDataStore {
    public static List createElements(List elementIDs) {
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        for (int i = 0; i < elementIDs.size(); ++i) {
            FakeMetadataObject elementID = (FakeMetadataObject)elementIDs.get(i);
            ElementSymbol element = new ElementSymbol(elementID.getName());
            elements.add(element);
        }
        return elements;
    }

    private static List getProcResultSetSymbols(List params) {
        ArrayList<ElementSymbol> result = new ArrayList<ElementSymbol>();
        for (SPParameter param : params) {
            if (param.getResultSetColumns() == null) continue;
            result.addAll(param.getResultSetColumns());
        }
        for (SPParameter param : params) {
            if (param.getParameterType() != 3 && param.getParameterType() != 4) continue;
            result.add(param.getParameterSymbol());
        }
        return result;
    }

    public static void sampleData1(FakeDataManager dataMgr) throws QueryMetadataException, TeiidComponentException {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("pm1.g1");
        List elementIDs = metadata.getElementIDsInGroupID(groupID);
        List elementSymbols = FakeDataStore.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList(null, new Integer(1), Boolean.FALSE, new Double(1.0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0))});
        groupID = (FakeMetadataObject)metadata.getGroupID("pm1.g2");
        elementIDs = metadata.getElementIDsInGroupID(groupID);
        elementSymbols = FakeDataStore.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList(null, new Integer(1), Boolean.FALSE, new Double(1.0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0))});
        groupID = (FakeMetadataObject)metadata.getGroupID("pm1.g3");
        elementIDs = metadata.getElementIDsInGroupID(groupID);
        elementSymbols = FakeDataStore.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList(null, new Integer(1), Boolean.FALSE, new Double(1.0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0))});
        groupID = (FakeMetadataObject)metadata.getGroupID("pm2.g1");
        elementIDs = metadata.getElementIDsInGroupID(groupID);
        elementSymbols = FakeDataStore.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList(null, new Integer(1), Boolean.FALSE, new Double(1.0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0))});
        groupID = (FakeMetadataObject)metadata.getGroupID("pm2.g2");
        elementIDs = metadata.getElementIDsInGroupID(groupID);
        elementSymbols = FakeDataStore.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList(null, new Integer(1), Boolean.FALSE, new Double(1.0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0))});
        groupID = (FakeMetadataObject)metadata.getGroupID("pm2.g3");
        elementIDs = metadata.getElementIDsInGroupID(groupID);
        elementSymbols = FakeDataStore.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList(null, new Integer(1), Boolean.FALSE, new Double(1.0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0))});
        groupID = (FakeMetadataObject)metadata.getGroupID("tm1.g1");
        elementIDs = metadata.getElementIDsInGroupID(groupID);
        elementSymbols = FakeDataStore.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList(null, new Integer(1), Boolean.FALSE, new Double(1.0)), Arrays.asList("a", new Integer(3), Boolean.TRUE, new Double(7.0)), Arrays.asList("c", new Integer(1), Boolean.TRUE, null), Arrays.asList("b", new Integer(2), Boolean.FALSE, new Double(0.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0))});
        TempMetadataStore tempStore = new TempMetadataStore();
        StoredProcedureInfo procInfo = metadata.getStoredProcedureInfoForProcedure("pm1.sp1");
        elementSymbols = FakeDataStore.getProcResultSetSymbols(procInfo.getParameters());
        tempStore.addTempGroup("pm1.sp1", elementSymbols);
        TempMetadataID procID = tempStore.getTempGroupID("pm1.sp1");
        dataMgr.registerTuples(procID, elementSymbols, new List[]{Arrays.asList("a", new Integer(0)), Arrays.asList(null, new Integer(1)), Arrays.asList("a", new Integer(3)), Arrays.asList("c", new Integer(1)), Arrays.asList("b", new Integer(2)), Arrays.asList("a", new Integer(0))});
    }

    public static void sampleData2(FakeDataManager dataMgr) throws QueryMetadataException, TeiidComponentException {
        FakeMetadataFacade metadata = FakeMetadataFactory.example1Cached();
        FakeMetadataObject groupID = (FakeMetadataObject)metadata.getGroupID("pm1.g1");
        List elementIDs = metadata.getElementIDsInGroupID(groupID);
        List elementSymbols = FakeDataStore.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("b", new Integer(1), Boolean.TRUE, null), Arrays.asList("c", new Integer(2), Boolean.FALSE, new Double(0.0))});
        groupID = (FakeMetadataObject)metadata.getGroupID("pm1.g2");
        elementIDs = metadata.getElementIDsInGroupID(groupID);
        elementSymbols = FakeDataStore.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("a", new Integer(1), Boolean.TRUE, new Double(2.0)), Arrays.asList("b", new Integer(0), Boolean.FALSE, new Double(0.0)), Arrays.asList("b", new Integer(5), Boolean.TRUE, new Double(2.0)), Arrays.asList("b", new Integer(2), Boolean.FALSE, null), Arrays.asList("d", new Integer(2), Boolean.FALSE, new Double(1.0))});
        groupID = (FakeMetadataObject)metadata.getGroupID("pm2.g1");
        elementIDs = metadata.getElementIDsInGroupID(groupID);
        elementSymbols = FakeDataStore.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("b", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("d", new Integer(3), Boolean.TRUE, new Double(7.0)), Arrays.asList("e", new Integer(1), Boolean.TRUE, null)});
        groupID = (FakeMetadataObject)metadata.getGroupID("pm2.g2");
        elementIDs = metadata.getElementIDsInGroupID(groupID);
        elementSymbols = FakeDataStore.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("a", new Integer(1), Boolean.TRUE, new Double(2.0)), Arrays.asList("b", new Integer(0), Boolean.FALSE, new Double(0.0)), Arrays.asList("b", new Integer(5), Boolean.TRUE, new Double(2.0)), Arrays.asList("b", new Integer(2), Boolean.FALSE, null), Arrays.asList("d", new Integer(2), Boolean.FALSE, new Double(1.0))});
        groupID = (FakeMetadataObject)metadata.getGroupID("pm1.table1");
        elementIDs = metadata.getElementIDsInGroupID(groupID);
        elementSymbols = FakeDataStore.createElements(elementIDs);
        dataMgr.registerTuples(groupID, elementSymbols, new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("b", new Integer(1), Boolean.TRUE, null), Arrays.asList("c", new Integer(2), Boolean.FALSE, new Double(0.0))});
    }
}

