/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.TempTableDataManager;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.tempdata.TempTableStoreImpl;
import org.teiid.query.unittest.FakeMetadataFactory;

public class TestTempTables {
    private TempMetadataAdapter metadata;
    private TempTableDataManager dataManager;

    private void execute(String sql, List[] expectedResults) throws Exception {
        TestProcessor.doProcess(TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)this.metadata), (ProcessorDataManager)this.dataManager, expectedResults, TestProcessor.createCommandContext());
    }

    @Before
    public void setUp() throws TeiidComponentException {
        TempTableStoreImpl tempStore = new TempTableStoreImpl(BufferManagerFactory.getStandaloneBufferManager(), "1", null);
        this.metadata = new TempMetadataAdapter((QueryMetadataInterface)FakeMetadataFactory.example1Cached(), tempStore.getMetadataStore());
        FakeDataManager fdm = new FakeDataManager();
        TestProcessor.sampleData1(fdm);
        this.dataManager = new TempTableDataManager((ProcessorDataManager)fdm, (TempTableStore)tempStore);
    }

    @Test
    public void testInsertWithQueryExpression() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) select e2, e1 from pm1.g1", new List[]{Arrays.asList(6)});
        this.execute("update x set e1 = e2 where e2 > 1", new List[]{Arrays.asList(2)});
    }

    @Test
    public void testOutofOrderInsert() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (1, 'one')", new List[]{Arrays.asList(1)});
        this.execute("select e1, e2 from x", new List[]{Arrays.asList("one", 1)});
    }

    @Test
    public void testUpdate() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        this.execute("insert into x (e2, e1) values (1, 'one')", new List[]{Arrays.asList(1)});
        this.execute("select e1, e2 into x from pm1.g1", new List[]{Arrays.asList(6)});
        this.execute("update x set e1 = e2 where e2 > 1", new List[]{Arrays.asList(2)});
        this.execute("select e1 from x where e2 > 0 order by e1", new List[]{Arrays.asList(new String[]{null}), Arrays.asList("2"), Arrays.asList("3"), Arrays.asList("c"), Arrays.asList("one")});
    }

    @Test
    public void testDelete() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        this.execute("select e1, e2 into x from pm1.g1", new List[]{Arrays.asList(6)});
        this.execute("delete from x where ascii(e1) > e2", new List[]{Arrays.asList(5)});
        this.execute("select e1 from x order by e1", new List[]{Arrays.asList(new String[]{null})});
    }

    @Test
    public void testDelete1() throws Exception {
        this.execute("create local temporary table x (e1 string, e2 integer)", new List[]{Arrays.asList(0)});
        this.execute("select e1, e2 into x from pm1.g1", new List[]{Arrays.asList(6)});
        this.execute("delete from x", new List[]{Arrays.asList(6)});
        this.execute("select e1 from x order by e1", new List[0]);
    }
}

