/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.eval;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.resolver.TestFunctionResolving;
import org.teiid.query.sql.lang.CollectionValueIterator;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.symbol.TestCaseExpression;
import org.teiid.query.sql.symbol.TestSearchedCaseExpression;
import org.teiid.query.sql.util.ValueIterator;
import org.teiid.query.util.CommandContext;

public class TestExpressionEvaluator {
    public void helpTestEval(Expression expr, SingleElementSymbol[] elementList, Object[] valueList, ProcessorDataManager dataMgr, CommandContext context, Object expectedValue) {
        try {
            Object actualValue = this.helpEval(expr, elementList, valueList, dataMgr, context);
            Assert.assertEquals((String)"Did not get expected result", (Object)expectedValue, (Object)actualValue);
        }
        catch (TeiidException e) {
            Assert.fail((String)("Received unexpected exception: " + e.getFullMessage()));
        }
    }

    public Object helpEval(Expression expr, SingleElementSymbol[] elementList, Object[] valueList, ProcessorDataManager dataMgr, CommandContext context) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        HashMap<SingleElementSymbol, Integer> elements = new HashMap<SingleElementSymbol, Integer>();
        if (elementList != null) {
            for (int i = 0; i < elementList.length; ++i) {
                elements.put(elementList[i], new Integer(i));
            }
        }
        ArrayList<Object> tuple = new ArrayList<Object>();
        if (valueList != null) {
            for (int i = 0; i < valueList.length; ++i) {
                tuple.add(valueList[i]);
            }
        }
        return new Evaluator(elements, dataMgr, context).evaluate(expr, tuple);
    }

    @Test
    public void testCaseExpression1() {
        CaseExpression expr = TestCaseExpression.example(3);
        expr.setExpression((Expression)new Constant((Object)"a"));
        this.helpTestEval((Expression)expr, null, null, null, null, new Integer(0));
        expr.setExpression((Expression)new Constant((Object)"b"));
        this.helpTestEval((Expression)expr, null, null, null, null, new Integer(1));
        expr.setExpression((Expression)new Constant((Object)"c"));
        this.helpTestEval((Expression)expr, null, null, null, null, new Integer(2));
        expr.setExpression((Expression)new Constant((Object)"d"));
        this.helpTestEval((Expression)expr, null, null, null, null, new Integer(9999));
    }

    @Test
    public void testSearchedCaseExpression1() {
        SearchedCaseExpression expr = TestSearchedCaseExpression.example(3);
        this.helpTestEval((Expression)expr, new SingleElementSymbol[]{new ElementSymbol("x")}, new Object[]{new Integer(0)}, null, null, new Integer(0));
        this.helpTestEval((Expression)expr, new SingleElementSymbol[]{new ElementSymbol("x")}, new Object[]{new Integer(1)}, null, null, new Integer(1));
        this.helpTestEval((Expression)expr, new SingleElementSymbol[]{new ElementSymbol("x")}, new Object[]{new Integer(2)}, null, null, new Integer(2));
        this.helpTestEval((Expression)expr, new SingleElementSymbol[]{new ElementSymbol("x")}, new Object[]{new Integer(3)}, null, null, new Integer(9999));
    }

    @Test
    public void testConstant() {
        this.helpTestEval((Expression)new Constant((Object)"xyz", String.class), new SingleElementSymbol[0], new Object[0], null, null, "xyz");
    }

    @Test
    public void testElement1() {
        ElementSymbol e1 = new ElementSymbol("e1");
        ElementSymbol e2 = new ElementSymbol("e2");
        SingleElementSymbol[] elements = new SingleElementSymbol[]{e1, e2};
        Object[] values = new Object[]{"xyz", "abc"};
        this.helpTestEval((Expression)e1, elements, values, null, null, "xyz");
    }

    @Test
    public void testElement2() {
        ElementSymbol e1 = new ElementSymbol("e1");
        ElementSymbol e2 = new ElementSymbol("e2");
        SingleElementSymbol[] elements = new SingleElementSymbol[]{e1, e2};
        Object[] values = new Object[]{"xyz", "abc"};
        this.helpTestEval((Expression)e2, elements, values, null, null, "abc");
    }

    @Test
    public void testElement3() throws Exception {
        ElementSymbol e2 = new ElementSymbol("e2");
        SingleElementSymbol[] elements = new SingleElementSymbol[]{};
        Object[] values = new Object[]{"xyz", "abc"};
        try {
            this.helpEval((Expression)e2, elements, values, null, null);
            Assert.fail((String)"Exception expected");
        }
        catch (TeiidComponentException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Error Code:ERR.015.006.0033 Message:Unable to evaluate e2: No value was available");
        }
    }

    @Test
    public void testFunction1() {
        ElementSymbol e1 = new ElementSymbol("e1");
        e1.setType(String.class);
        ElementSymbol e2 = new ElementSymbol("e2");
        e2.setType(String.class);
        Function func = new Function("concat", new Expression[]{e1, e2});
        FunctionDescriptor desc = SystemFunctionManager.getSystemFunctionLibrary().findFunction("concat", new Class[]{String.class, String.class});
        func.setFunctionDescriptor(desc);
        SingleElementSymbol[] elements = new SingleElementSymbol[]{e1, e2};
        Object[] values = new Object[]{"xyz", "abc"};
        this.helpTestEval((Expression)func, elements, values, null, null, "xyzabc");
    }

    @Test
    public void testFunction2() {
        ElementSymbol e1 = new ElementSymbol("e1");
        e1.setType(String.class);
        ElementSymbol e2 = new ElementSymbol("e2");
        e2.setType(String.class);
        Function func = new Function("concat", new Expression[]{e2, e1});
        FunctionDescriptor desc = SystemFunctionManager.getSystemFunctionLibrary().findFunction("concat", new Class[]{String.class, String.class});
        func.setFunctionDescriptor(desc);
        SingleElementSymbol[] elements = new SingleElementSymbol[]{e1, e2};
        Object[] values = new Object[]{"xyz", "abc"};
        this.helpTestEval((Expression)func, elements, values, null, null, "abcxyz");
    }

    @Test
    public void testLookupFunction() {
        ElementSymbol e1 = new ElementSymbol("e1");
        e1.setType(String.class);
        ElementSymbol e2 = new ElementSymbol("e2");
        e1.setType(Integer.class);
        Function func = new Function("lookup", new Expression[]{new Constant((Object)"pm1.g1"), new Constant((Object)"e2"), new Constant((Object)"e1"), e1});
        FunctionDescriptor desc = SystemFunctionManager.getSystemFunctionLibrary().findFunction("lookup", new Class[]{String.class, String.class, String.class, String.class});
        func.setFunctionDescriptor(desc);
        SingleElementSymbol[] elements = new SingleElementSymbol[]{e1, e2};
        Object[] values = new Object[]{"xyz", new Integer(5)};
        FakeDataManager dataMgr = new FakeDataManager();
        HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
        valueMap.put("xyz", new Integer(5));
        dataMgr.defineCodeTable("pm1.g1", "e1", "e2", valueMap);
        this.helpTestEval((Expression)func, elements, values, dataMgr, null, new Integer(5));
    }

    @Test
    public void testScalarSubquery() throws Exception {
        ScalarSubquery expr = new ScalarSubquery((Command)new Query());
        ArrayList<String> values = new ArrayList<String>(1);
        values.add("a");
        String expected = "a";
        this.helpTestWithValueIterator(expr, values, expected);
    }

    private void helpTestWithValueIterator(ScalarSubquery expr, List<?> values, Object expected) throws BlockedException, TeiidComponentException, ExpressionEvaluationException {
        final CollectionValueIterator valueIter = new CollectionValueIterator(values);
        CommandContext cc = new CommandContext();
        Assert.assertEquals((Object)expected, (Object)new Evaluator(Collections.emptyMap(), null, cc){

            protected ValueIterator evaluateSubquery(SubqueryContainer container, List tuple) throws TeiidProcessingException, BlockedException, TeiidComponentException {
                return valueIter;
            }
        }.evaluate((Expression)expr, null));
    }

    @Test
    public void testScalarSubquery2() throws Exception {
        ScalarSubquery expr = new ScalarSubquery((Command)new Query());
        ArrayList<Object> values = new ArrayList<Object>(1);
        values.add(null);
        this.helpTestWithValueIterator(expr, values, null);
    }

    @Test
    public void testScalarSubquery3() throws Exception {
        ScalarSubquery expr = new ScalarSubquery((Command)new Query());
        this.helpTestWithValueIterator(expr, Collections.emptyList(), null);
    }

    @Test
    public void testScalarSubqueryFails() throws Exception {
        ScalarSubquery expr = new ScalarSubquery((Command)new Query());
        ArrayList<String> values = new ArrayList<String>(2);
        values.add("a");
        values.add("b");
        try {
            this.helpTestWithValueIterator(expr, values, null);
            Assert.fail((String)"Expected ExpressionEvaluationException but got none");
        }
        catch (ExpressionEvaluationException e) {
            Assert.assertEquals((Object)"Error Code:ERR.015.006.0058 Message:Unable to evaluate (<undefined>): Error Code:ERR.015.006.0058 Message:The command of this scalar subquery returned more than one value: <undefined>", (Object)e.getMessage());
        }
    }

    @Test
    public void testUser() throws Exception {
        Function func = new Function("user", new Expression[0]);
        FunctionDescriptor desc = SystemFunctionManager.getSystemFunctionLibrary().findFunction("user", new Class[0]);
        func.setFunctionDescriptor(desc);
        FakeDataManager dataMgr = new FakeDataManager();
        CommandContext context = new CommandContext((Object)new Long(1L), null, null, null, 0);
        context.setUserName("logon");
        Assert.assertEquals((Object)context.getUserName(), (Object)new Evaluator(Collections.emptyMap(), (ProcessorDataManager)dataMgr, context).evaluate((Expression)func, Collections.emptyList()));
    }

    @Test
    public void testEnv() throws Exception {
        Function func = new Function("env", new Expression[0]);
        FunctionDescriptor desc = SystemFunctionManager.getSystemFunctionLibrary().findFunction("env", new Class[]{String.class});
        func.setFunctionDescriptor(desc);
        FakeDataManager dataMgr = new FakeDataManager();
        Properties props = new Properties();
        props.setProperty("http_host", "testHostName");
        props.setProperty("http_port", "8000");
        CommandContext context = new CommandContext((Object)new Long(1L), null, null, null, null, 0, props, false, false);
        func.setArgs(new Expression[]{new Constant((Object)"http_host")});
        Assert.assertEquals((Object)"testHostName", (Object)new Evaluator(Collections.emptyMap(), (ProcessorDataManager)dataMgr, context).evaluate((Expression)func, Collections.emptyList()));
        func.setArgs(new Expression[]{new Constant((Object)"http_port")});
        Assert.assertEquals((Object)"8000", (Object)new Evaluator(Collections.emptyMap(), (ProcessorDataManager)dataMgr, context).evaluate((Expression)func, Collections.emptyList()));
    }

    public void helpTestCommandPayload(Serializable payload, String property, String expectedValue) throws Exception {
        Function func = new Function("commandpayload", new Expression[0]);
        Class[] parameterSignature = null;
        parameterSignature = property == null ? new Class[]{} : new Class[]{String.class};
        FunctionDescriptor desc = SystemFunctionManager.getSystemFunctionLibrary().findFunction("commandpayload", parameterSignature);
        func.setFunctionDescriptor(desc);
        FakeDataManager dataMgr = new FakeDataManager();
        CommandContext context = new CommandContext((Object)new Long(-1L), null, "user", payload, "vdb", 1, null, false, false);
        if (property != null) {
            func.setArgs(new Expression[]{new Constant((Object)property)});
        }
        String actual = (String)new Evaluator(Collections.emptyMap(), (ProcessorDataManager)dataMgr, context).evaluate((Expression)func, Collections.emptyList());
        Assert.assertEquals((Object)expectedValue, (Object)actual);
    }

    @Test
    public void testCommandPayloadNoArgsWithPayload() throws Exception {
        this.helpTestCommandPayload((Serializable)((Object)"blah"), null, "blah");
    }

    @Test
    public void testCommandPayloadNoArgsWithoutPayload() throws Exception {
        this.helpTestCommandPayload(null, null, null);
    }

    @Test
    public void testCommandPayloadNoArgsWithNonStringPayload() throws Exception {
        this.helpTestCommandPayload(Boolean.TRUE, null, "true");
    }

    @Test
    public void testCommandPayloadArgWithPayload() throws Exception {
        Properties props = new Properties();
        props.setProperty("p1", "v1");
        props.setProperty("p2", "v2");
        this.helpTestCommandPayload(props, "p1", "v1");
    }

    @Test
    public void testCommandPayloadArgWithPayloadMissingProp() throws Exception {
        Properties props = new Properties();
        props.setProperty("p1", "v1");
        props.setProperty("p2", "v2");
        this.helpTestCommandPayload(props, "BOGUS", null);
    }

    @Test
    public void testCommandPayloadArgWithoutPayload() throws Exception {
        Properties props = new Properties();
        props.setProperty("p1", "v1");
        props.setProperty("p2", "v2");
        this.helpTestCommandPayload(null, "BOGUS", null);
    }

    @Test(expected=ExpressionEvaluationException.class)
    public void testCommandPayloadArgWithBadPayload() throws Exception {
        this.helpTestCommandPayload(Boolean.TRUE, "BOGUS", null);
    }

    @Test
    public void testBigDecimalFromDoubleDivision() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("convert(1.0, bigdecimal)/3");
        Assert.assertEquals((Object)new BigDecimal("0.3333333333333333"), (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testBigDecimalDivision() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("1/convert('3.0', bigdecimal)");
        Assert.assertEquals((Object)new BigDecimal("0.3333333333333333"), (Object)Evaluator.evaluate((Expression)ex));
    }
}

