/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.Arrays;
import junit.framework.TestCase;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.function.aggregate.AggregateFunction;
import org.teiid.query.function.aggregate.Count;
import org.teiid.query.processor.relational.SortingFilter;
import org.teiid.query.sql.symbol.ElementSymbol;

public class TestDuplicateFilter
extends TestCase {
    public TestDuplicateFilter(String arg0) {
        super(arg0);
    }

    public void helpTestDuplicateFilter(Object[] input, Class dataType, int expected) throws TeiidComponentException, TeiidProcessingException {
        BufferManager mgr = BufferManagerFactory.getStandaloneBufferManager();
        SortingFilter filter = new SortingFilter((AggregateFunction)new Count(), mgr, "test", true);
        filter.initialize(dataType, dataType);
        ElementSymbol element = new ElementSymbol("val");
        element.setType(dataType);
        filter.setElements(Arrays.asList(element));
        filter.setSortElements(filter.getElements());
        filter.reset();
        for (int i = 0; i < input.length; ++i) {
            filter.addInputDirect(input[i], null);
        }
        Integer actual = (Integer)filter.getResult();
        TestDuplicateFilter.assertEquals((String)"Did not get expected number of results", (int)expected, (int)actual);
    }

    public void testNoInputs() throws Exception {
        this.helpTestDuplicateFilter(new Object[0], DataTypeManager.DefaultDataClasses.STRING, 0);
    }

    public void testSmall() throws Exception {
        Object[] input = new Object[]{"a", "b", "a", "c", "a", "c", "c", "f"};
        this.helpTestDuplicateFilter(input, DataTypeManager.DefaultDataClasses.STRING, 4);
    }

    public void testBig() throws Exception {
        int NUM_VALUES = 10000;
        int NUM_OUTPUT = 200;
        Object[] input = new Object[NUM_VALUES];
        for (int i = 0; i < NUM_VALUES; ++i) {
            input[i] = new Integer(i % NUM_OUTPUT);
        }
        this.helpTestDuplicateFilter(input, DataTypeManager.DefaultDataClasses.INTEGER, NUM_OUTPUT);
    }
}

