/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.processor.FakeTupleSource;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.FakeRelationalNode;
import org.teiid.query.processor.relational.NodeTestUtil;
import org.teiid.query.processor.relational.ProjectIntoNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.tempdata.TempTableStoreImpl;
import org.teiid.query.util.CommandContext;

public class TestProjectIntoNode
extends TestCase {
    private static final int NUM_ROWS = 1000;

    private void helpTestNextBatch(int tupleBatchSize, boolean doBatching, boolean doBulkInsert, boolean exceptionOnClose) throws Exception {
        ProjectIntoNode node = new ProjectIntoNode(2);
        FakeDataTupleSource tupleSource = new FakeDataTupleSource(1000);
        FakeRelationalNode child = new FakeRelationalNode(1, tupleSource, tupleBatchSize);
        node.addChild((RelationalNode)child);
        node.setIntoGroup(new GroupSymbol("myGroup"));
        ElementSymbol elementSymbol_1 = new ElementSymbol("myGroup.myElement1");
        ElementSymbol elementSymbol_2 = new ElementSymbol("myGroup.myElement2");
        elementSymbol_1.setType(Integer.class);
        elementSymbol_2.setType(String.class);
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        elements.add(elementSymbol_1);
        elements.add(elementSymbol_2);
        node.setIntoElements(elements);
        node.setDoBatching(doBatching);
        node.setDoBulkInsert(doBulkInsert);
        node.setModelName("myModel");
        CommandContext context = new CommandContext();
        context.setProcessorID((Object)"processorID");
        BufferManager bm = NodeTestUtil.getTestBufferManager(tupleBatchSize, tupleBatchSize);
        FakePDM dataManager = new FakePDM(tupleBatchSize, exceptionOnClose);
        child.initialize(context, bm, dataManager);
        node.initialize(context, bm, (ProcessorDataManager)dataManager);
        node.open();
        TupleBatch batch = null;
        while (true) {
            try {
                batch = node.nextBatch();
            }
            catch (BlockedException e) {
                continue;
            }
            break;
        }
        TestProjectIntoNode.assertNotNull((Object)batch);
        List[] tuples = batch.getAllTuples();
        TestProjectIntoNode.assertEquals((int)1, (int)tuples.length);
        Object[] columns = tuples[0].toArray();
        TestProjectIntoNode.assertNotNull((Object)columns);
        TestProjectIntoNode.assertEquals((int)1, (int)columns.length);
        TestProjectIntoNode.assertEquals((Object)new Integer(1000), (Object)columns[0]);
    }

    public void testNextBatch() throws Exception {
        this.helpTestNextBatch(100, true, false, false);
    }

    public void testNextBatch_BulkInsert() throws Exception {
        this.helpTestNextBatch(100, false, true, false);
    }

    public void testNextBatch_NoBatching() throws Exception {
        this.helpTestNextBatch(100, false, false, false);
    }

    public void testNextBatch_Size20Batches() throws Exception {
        this.helpTestNextBatch(20, true, false, false);
    }

    private static final class FakeDataTupleSource
    implements TupleSource {
        private int currentRow = 0;
        private boolean block = true;
        private int rows;

        private FakeDataTupleSource(int rows) {
            this.rows = rows;
        }

        public void closeSource() {
        }

        public List getSchema() {
            return null;
        }

        public List nextTuple() throws TeiidComponentException {
            if (this.currentRow % 100 == 0 && this.block) {
                this.block = false;
                throw BlockedException.INSTANCE;
            }
            return ++this.currentRow > this.rows ? null : Arrays.asList(new Integer(this.currentRow), Integer.toString(this.currentRow));
        }

        public int available() {
            return 0;
        }
    }

    private static final class FakePDM
    implements ProcessorDataManager {
        private int expectedBatchSize;
        private int callCount = 0;
        private boolean exceptionOnClose;

        private FakePDM(int expectedBatchSize, boolean exceptionOnClose) {
            this.expectedBatchSize = expectedBatchSize;
            this.exceptionOnClose = exceptionOnClose;
        }

        public Object lookupCodeValue(CommandContext context, String codeTableName, String returnElementName, String keyElementName, Object keyValue) throws BlockedException, TeiidComponentException {
            return null;
        }

        public TupleSource registerRequest(Object processorID, Command command, String modelName, String connectorBindingId, int nodeID) throws TeiidComponentException, ExpressionEvaluationException {
            List batch;
            ++this.callCount;
            int batchSize = 1;
            if (command instanceof Insert) {
                Insert insert = (Insert)command;
                if (insert.isBulk()) {
                    batch = TempTableStoreImpl.getBulkRows((Insert)insert, (List)insert.getVariables());
                    batchSize = batch.size();
                    Assert.assertEquals((String)("Unexpected batch on call " + this.callCount), (int)this.expectedBatchSize, (int)batchSize);
                    for (int i = 0; i < batchSize; ++i) {
                        this.ensureValue2((List)batch.get(i), 2, (this.callCount - 1) * batchSize + i + 1);
                    }
                } else {
                    this.ensureValue((Insert)command, 2, this.callCount);
                }
            } else if (command instanceof BatchedUpdateCommand) {
                BatchedUpdateCommand bu = (BatchedUpdateCommand)command;
                batch = bu.getSubCommands();
                batchSize = batch.size();
                Assert.assertEquals((String)("Unexpected batch on call " + this.callCount), (int)this.expectedBatchSize, (int)batchSize);
            } else {
                Assert.fail((String)"Unexpected command type");
            }
            List<Object> counts = Arrays.asList(new Integer(batchSize));
            FakeTupleSource fakeTupleSource = new FakeTupleSource(null, new List[]{counts});
            fakeTupleSource.setExceptionOnClose(this.exceptionOnClose);
            return fakeTupleSource;
        }

        private void ensureValue(Insert command, int size, int value) {
            Assert.assertNotNull((Object)command.getValues());
            Assert.assertEquals((int)size, (int)command.getValues().size());
            Assert.assertEquals((Object)new Integer(value), (Object)((Constant)command.getValues().get(0)).getValue());
        }

        private void ensureValue2(List row, int size, int value) {
            Assert.assertNotNull((Object)row);
            Assert.assertEquals((int)size, (int)row.size());
            Object val = row.get(0);
            Assert.assertEquals((Object)new Integer(value), val);
        }

        public void clearCodeTables() {
        }
    }
}

