/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingBaseNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingException;
import org.teiid.query.mapping.xml.MappingLoader;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingRecursiveElement;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.optimizer.xml.SourceNodeGenaratorVisitor;

public class TestSourceNodeGenaratorVisitor
extends TestCase {
    private MappingDocument loadMappingDocument(String xml) throws MappingException {
        MappingLoader reader = new MappingLoader();
        byte[] bytes = xml.getBytes();
        ByteArrayInputStream istream = new ByteArrayInputStream(bytes);
        return reader.loadDocument((InputStream)istream);
    }

    public void testSourceAtRootXML50() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <mappingNode>\r\n        <name>license</name>\r\n        <source>licenseSource</source>\r\n        <minOccurs>0</minOccurs>\r\n        <maxOccurs>unbounded</maxOccurs>\r\n        <tempGroup>testTempGroup1</tempGroup>\r\n        <tempGroup>testTempGroup2</tempGroup>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        MappingDocument doc = this.loadMappingDocument(xml);
        doc = SourceNodeGenaratorVisitor.extractSourceNodes((MappingDocument)doc);
        MappingBaseNode root = doc.getRootNode();
        TestSourceNodeGenaratorVisitor.assertTrue((boolean)(root instanceof MappingSourceNode));
        MappingSourceNode source = (MappingSourceNode)root;
        TestSourceNodeGenaratorVisitor.assertEquals((String)"licenseSource", (String)source.getResultName());
        List list = source.getStagingTables();
        TestSourceNodeGenaratorVisitor.assertEquals((int)2, (int)list.size());
        TestSourceNodeGenaratorVisitor.assertEquals((Object)"testTempGroup1", list.get(0));
        TestSourceNodeGenaratorVisitor.assertEquals((Object)"testTempGroup2", list.get(1));
        MappingBaseNode node = (MappingBaseNode)source.getNodeChildren().get(0);
        TestSourceNodeGenaratorVisitor.assertTrue((boolean)(node instanceof MappingElement));
        MappingElement element = (MappingElement)node;
        TestSourceNodeGenaratorVisitor.assertEquals((String)"license", (String)element.getName());
        TestSourceNodeGenaratorVisitor.assertEquals((int)1, (int)element.getMinOccurence());
        TestSourceNodeGenaratorVisitor.assertEquals((int)1, (int)element.getMaxOccurence());
        TestSourceNodeGenaratorVisitor.assertNull((Object)element.getSource());
    }

    public void testSourceBelowRootXML50() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <mappingNode>\r\n        <name>parentNode</name>\r\n        <minOccurs>0</minOccurs>\r\n        <maxOccurs>unbounded</maxOccurs>\r\n        <tempGroup>testTempGroup1</tempGroup>\r\n       <mappingNode>\r\n        <name>childNode</name>\r\n        <source>childNodeSource</source>\r\n        <tempGroup>testTempGroup2</tempGroup>\r\n       </mappingNode>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        MappingDocument doc = this.loadMappingDocument(xml);
        doc = SourceNodeGenaratorVisitor.extractSourceNodes((MappingDocument)doc);
        MappingBaseNode node = doc.getRootNode();
        TestSourceNodeGenaratorVisitor.assertTrue((boolean)(node instanceof MappingElement));
        MappingElement element = (MappingElement)node;
        List list = element.getStagingTables();
        TestSourceNodeGenaratorVisitor.assertEquals((int)1, (int)list.size());
        TestSourceNodeGenaratorVisitor.assertEquals((Object)"testTempGroup1", list.get(0));
        TestSourceNodeGenaratorVisitor.assertEquals((String)"parentNode", (String)element.getName());
        TestSourceNodeGenaratorVisitor.assertEquals((int)1, (int)element.getMinOccurence());
        TestSourceNodeGenaratorVisitor.assertEquals((int)1, (int)element.getMaxOccurence());
        MappingNode node1 = (MappingNode)element.getNodeChildren().get(0);
        TestSourceNodeGenaratorVisitor.assertTrue((boolean)(node1 instanceof MappingSourceNode));
        MappingSourceNode source = (MappingSourceNode)node1;
        TestSourceNodeGenaratorVisitor.assertEquals((String)"childNodeSource", (String)source.getResultName());
        list = source.getStagingTables();
        TestSourceNodeGenaratorVisitor.assertEquals((int)1, (int)list.size());
        TestSourceNodeGenaratorVisitor.assertEquals((Object)"testTempGroup2", list.get(0));
        node1 = (MappingNode)source.getNodeChildren().get(0);
        TestSourceNodeGenaratorVisitor.assertTrue((boolean)(node instanceof MappingElement));
        element = (MappingElement)node1;
        TestSourceNodeGenaratorVisitor.assertEquals((String)"childNode", (String)element.getName());
        TestSourceNodeGenaratorVisitor.assertNull((Object)element.getSource());
    }

    public void testRecursiveNodeXML50() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n    <mappingNode>\r\n        <name>parentNode</name>\r\n        <source>parentNodeSource</source>\r\n       <mappingNode>\r\n           <name>childNode</name>\r\n           <mappingNode>\r\n               <nodeType>attribute</nodeType>\r\n               <name>attributename</name>\r\n               <default>ddd</default>\r\n               <fixed>fff</fixed>\r\n           </mappingNode>\r\n           <mappingNode>\r\n               <name>recursivenodename</name>\r\n               <isRecursive>TRUE</isRecursive>\r\n               <recursionLimit>8</recursionLimit>\r\n               <recursionCriteria>rrr</recursionCriteria>\r\n               <recursionRootMappingClass>parentNodeSource</recursionRootMappingClass>\r\n           </mappingNode>\r\n       </mappingNode>\r\n    </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        MappingDocument doc = this.loadMappingDocument(xml);
        doc = SourceNodeGenaratorVisitor.extractSourceNodes((MappingDocument)doc);
        MappingBaseNode node = doc.getRootNode();
        TestSourceNodeGenaratorVisitor.assertTrue((boolean)(node instanceof MappingSourceNode));
        MappingSourceNode source = (MappingSourceNode)node;
        TestSourceNodeGenaratorVisitor.assertEquals((String)"parentNodeSource", (String)source.getSource());
        node = (MappingNode)source.getNodeChildren().get(0);
        TestSourceNodeGenaratorVisitor.assertTrue((boolean)(node instanceof MappingElement));
        MappingElement element = (MappingElement)node;
        TestSourceNodeGenaratorVisitor.assertEquals((String)"parentNode", (String)element.getName());
        TestSourceNodeGenaratorVisitor.assertTrue((boolean)element.isRootRecursiveNode());
        TestSourceNodeGenaratorVisitor.assertFalse((boolean)element.isRecursive());
        node = (MappingNode)element.getNodeChildren().get(0);
        TestSourceNodeGenaratorVisitor.assertTrue((boolean)(node instanceof MappingElement));
        element = (MappingElement)node;
        TestSourceNodeGenaratorVisitor.assertEquals((String)"childNode", (String)element.getName());
        List attrs = element.getAttributes();
        TestSourceNodeGenaratorVisitor.assertEquals((int)1, (int)attrs.size());
        MappingAttribute attribute = (MappingAttribute)attrs.get(0);
        TestSourceNodeGenaratorVisitor.assertEquals((String)"attributename", (String)attribute.getName());
        TestSourceNodeGenaratorVisitor.assertEquals((String)"ddd", (String)attribute.getDefaultValue());
        TestSourceNodeGenaratorVisitor.assertEquals((String)"fff", (String)attribute.getValue());
        node = (MappingNode)element.getNodeChildren().get(0);
        TestSourceNodeGenaratorVisitor.assertTrue((boolean)(node instanceof MappingRecursiveElement));
        MappingRecursiveElement recursive = (MappingRecursiveElement)node;
        TestSourceNodeGenaratorVisitor.assertEquals((String)"recursivenodename", (String)recursive.getName());
        TestSourceNodeGenaratorVisitor.assertEquals((int)8, (int)recursive.getRecursionLimit());
        TestSourceNodeGenaratorVisitor.assertFalse((boolean)recursive.isRootRecursiveNode());
        TestSourceNodeGenaratorVisitor.assertTrue((boolean)recursive.isRecursive());
    }

    public void testRecursiveElementXML50() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xmlMapping>\r\n   <mappingNode>\r\n       <name>parentNode</name>\r\n       <source>parentSource</source>\r\n       <mappingNode>           <name>childNode</name>\r\n           <source>childSource</source>\r\n           <recursionRootMappingClass>parentSource</recursionRootMappingClass>           <isRecursive>true</isRecursive>           <recursionLimit>6</recursionLimit>           <recursionCriteria>foo</recursionCriteria>       </mappingNode>   </mappingNode>\r\n</xmlMapping>\r\n\r\n";
        MappingDocument doc = this.loadMappingDocument(xml);
        doc = SourceNodeGenaratorVisitor.extractSourceNodes((MappingDocument)doc);
        MappingBaseNode node = doc.getRootNode();
        TestSourceNodeGenaratorVisitor.assertTrue((boolean)(node instanceof MappingSourceNode));
        MappingSourceNode source = (MappingSourceNode)node;
        TestSourceNodeGenaratorVisitor.assertEquals((String)"parentSource", (String)source.getSource());
        node = (MappingNode)source.getNodeChildren().get(0);
        TestSourceNodeGenaratorVisitor.assertTrue((boolean)(node instanceof MappingElement));
        MappingElement element = (MappingElement)node;
        TestSourceNodeGenaratorVisitor.assertEquals((String)"parentNode", (String)element.getName());
        TestSourceNodeGenaratorVisitor.assertTrue((boolean)element.isRootRecursiveNode());
        TestSourceNodeGenaratorVisitor.assertFalse((boolean)element.isRecursive());
        node = (MappingNode)element.getNodeChildren().get(0);
        source = (MappingSourceNode)node;
        TestSourceNodeGenaratorVisitor.assertEquals((String)"childSource", (String)source.getSource());
        TestSourceNodeGenaratorVisitor.assertEquals((String)"parentSource", (String)source.getAliasResultName());
        node = (MappingNode)source.getNodeChildren().get(0);
        TestSourceNodeGenaratorVisitor.assertTrue((boolean)(node instanceof MappingRecursiveElement));
        MappingRecursiveElement relement = (MappingRecursiveElement)node;
        TestSourceNodeGenaratorVisitor.assertTrue((boolean)relement.isRecursive());
        TestSourceNodeGenaratorVisitor.assertEquals((String)"childNode", (String)relement.getName());
        TestSourceNodeGenaratorVisitor.assertEquals((String)"foo", (String)relement.getCriteria());
        TestSourceNodeGenaratorVisitor.assertEquals((int)6, (int)relement.getRecursionLimit());
    }
}

