/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.math.BigInteger;
import java.sql.Timestamp;
import junit.framework.TestCase;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.processor.xml.XMLValueTranslator;
import org.teiid.query.unittest.TimestampUtil;

public class TestXMLValueTranslator
extends TestCase {
    public TestXMLValueTranslator(String name) {
        super(name);
    }

    public void test24HourDateTimeTranslation() throws Exception {
        Timestamp ts = TimestampUtil.createTimestamp((int)100, (int)0, (int)2, (int)14, (int)14, (int)5, (int)6);
        String value = XMLValueTranslator.translateToXMLValue((Object)ts, (Class)DataTypeManager.DefaultDataClasses.TIMESTAMP, (String)"dateTime");
        TestXMLValueTranslator.assertEquals((String)"2000-01-02T14:14:05.000000006", (String)value);
    }

    public void testDateTimeTranslation() throws Exception {
        Timestamp ts = TimestampUtil.createTimestamp((int)100, (int)0, (int)2, (int)3, (int)4, (int)5, (int)6);
        String value = XMLValueTranslator.translateToXMLValue((Object)ts, (Class)DataTypeManager.DefaultDataClasses.TIMESTAMP, (String)"dateTime");
        TestXMLValueTranslator.assertEquals((String)"2000-01-02T03:04:05.000000006", (String)value);
        ts.setNanos(6000);
        value = XMLValueTranslator.translateToXMLValue((Object)ts, (Class)DataTypeManager.DefaultDataClasses.TIMESTAMP, (String)"dateTime");
        TestXMLValueTranslator.assertEquals((String)"2000-01-02T03:04:05.000006", (String)value);
        ts.setNanos(0);
        value = XMLValueTranslator.translateToXMLValue((Object)ts, (Class)DataTypeManager.DefaultDataClasses.TIMESTAMP, (String)"dateTime");
        TestXMLValueTranslator.assertEquals((String)"2000-01-02T03:04:05", (String)value);
        ts = TimestampUtil.createTimestamp((int)-2000, (int)0, (int)2, (int)3, (int)4, (int)5, (int)6);
        value = XMLValueTranslator.translateToXMLValue((Object)ts, (Class)DataTypeManager.DefaultDataClasses.TIMESTAMP, (String)"dateTime");
        TestXMLValueTranslator.assertEquals((String)"-0101-01-02T03:04:05.000000006", (String)value);
    }

    public void testgYearTranslation() throws Exception {
        String value = XMLValueTranslator.translateToXMLValue((Object)new BigInteger("5"), (Class)DataTypeManager.DefaultDataClasses.BIG_INTEGER, (String)"gYear");
        TestXMLValueTranslator.assertEquals((String)"0005", (String)value);
        value = XMLValueTranslator.translateToXMLValue((Object)new BigInteger("-10000"), (Class)DataTypeManager.DefaultDataClasses.BIG_INTEGER, (String)"gYear");
        TestXMLValueTranslator.assertEquals((String)"-10000", (String)value);
    }

    public void testgYearMonthTranslation() throws Exception {
        Timestamp ts = TimestampUtil.createTimestamp((int)100, (int)0, (int)4, (int)6, (int)8, (int)10, (int)12);
        String value = XMLValueTranslator.translateToXMLValue((Object)ts, (Class)DataTypeManager.DefaultDataClasses.TIMESTAMP, (String)"gYearMonth");
        TestXMLValueTranslator.assertEquals((String)"2000-01", (String)value);
        ts = TimestampUtil.createTimestamp((int)-30000, (int)0, (int)4, (int)6, (int)8, (int)10, (int)12);
        value = XMLValueTranslator.translateToXMLValue((Object)ts, (Class)DataTypeManager.DefaultDataClasses.TIMESTAMP, (String)"gYearMonth");
        TestXMLValueTranslator.assertEquals((String)"-28101-01", (String)value);
    }

    public void testDefaultTranslation() throws Exception {
        String value = XMLValueTranslator.translateToXMLValue((Object)"", (Class)DataTypeManager.DefaultDataClasses.STRING, (String)"string");
        TestXMLValueTranslator.assertNull((Object)value);
    }
}

