/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.teiid.query.processor.xml.Condition;
import org.teiid.query.processor.xml.IfInstruction;
import org.teiid.query.processor.xml.ProcessorInstruction;
import org.teiid.query.processor.xml.Program;
import org.teiid.query.processor.xml.RecurseProgramCondition;
import org.teiid.query.processor.xml.WhileInstruction;

public class XMLProgramUtil {
    public static Map getProgramStats(Program program) {
        HashMap map = new HashMap();
        XMLProgramUtil.getProgramStats(program, map);
        return map;
    }

    private static Map getProgramStats(Program program, Map map) {
        Program childProgram = null;
        if (program == null) {
            return map;
        }
        for (int i = 0; i < program.getProcessorInstructions().size(); ++i) {
            ProcessorInstruction inst = program.getInstructionAt(i);
            if (inst instanceof WhileInstruction) {
                WhileInstruction whileInst = (WhileInstruction)inst;
                childProgram = whileInst.getBlockProgram();
                XMLProgramUtil.getProgramStats(childProgram, map);
            } else if (inst instanceof IfInstruction) {
                IfInstruction ifInst = (IfInstruction)inst;
                XMLProgramUtil.getProgramStats(ifInst.getElseProgram(), map);
                for (int then = 0; then < ifInst.getThenCount(); ++then) {
                    childProgram = ifInst.getThenProgram(then);
                    Condition condition = ifInst.getThenCondition(then);
                    if (condition instanceof RecurseProgramCondition) continue;
                    XMLProgramUtil.getProgramStats(childProgram, map);
                }
            }
            LinkedList<ProcessorInstruction> instrs = (LinkedList<ProcessorInstruction>)map.get(inst.getClass());
            if (instrs == null) {
                instrs = new LinkedList<ProcessorInstruction>();
                map.put(inst.getClass(), instrs);
            }
            instrs.add(inst);
        }
        return map;
    }
}

