/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import java.util.Arrays;
import junit.framework.TestCase;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;

public class TestAssignmentStatement
extends TestCase {
    public TestAssignmentStatement(String name) {
        super(name);
    }

    public static final AssignmentStatement sample1() {
        return new AssignmentStatement(new ElementSymbol("a"), (LanguageObject)new Constant((Object)"1"));
    }

    public static final AssignmentStatement sample2() {
        Query query = new Query();
        query.setSelect(new Select(Arrays.asList(new ElementSymbol("x"))));
        query.setFrom(new From(Arrays.asList(new UnaryFromClause(new GroupSymbol("y")))));
        return new AssignmentStatement(new ElementSymbol("b"), (LanguageObject)query);
    }

    public void testGetVariable() {
        AssignmentStatement s1 = TestAssignmentStatement.sample1();
        TestAssignmentStatement.assertEquals((String)"Didn't get the same parts ", (Object)s1.getVariable(), (Object)new ElementSymbol("a"));
    }

    public void testGetExpression() {
        AssignmentStatement s1 = TestAssignmentStatement.sample1();
        TestAssignmentStatement.assertEquals((String)"Didn't get the same parts ", (Object)s1.getExpression(), (Object)new Constant((Object)"1"));
    }

    public void testGetCommand() throws Exception {
        AssignmentStatement s2 = TestAssignmentStatement.sample2();
        Query query = (Query)QueryParser.getQueryParser().parseCommand("Select x from y");
        TestAssignmentStatement.assertEquals((String)"Didn't get the same parts ", (Object)s2.getCommand(), (Object)query);
    }

    public void testSelfEquivalence() {
        AssignmentStatement s1 = TestAssignmentStatement.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1);
    }

    public void testEquivalence() {
        AssignmentStatement s1 = TestAssignmentStatement.sample1();
        AssignmentStatement s1a = TestAssignmentStatement.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1a);
    }

    public void testNonEquivalence() {
        AssignmentStatement s1 = TestAssignmentStatement.sample1();
        AssignmentStatement s2 = TestAssignmentStatement.sample2();
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s2);
    }
}

