/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import junit.framework.TestCase;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;

public class TestAggregateSymbol
extends TestCase {
    public TestAggregateSymbol(String name) {
        super(name);
    }

    public static final ElementSymbol sampleElement() {
        return new ElementSymbol("m.g.c");
    }

    public static final ElementSymbol sampleElement2() {
        return new ElementSymbol("m.g.c2");
    }

    public static final Constant sampleConstant() {
        return new Constant((Object)new Integer(5));
    }

    public static final Function sampleFunction() {
        return new Function("+", new Expression[]{TestAggregateSymbol.sampleElement(), TestAggregateSymbol.sampleConstant()});
    }

    private void helpParser(AggregateSymbol as, String expected) {
        String toString = as.toString();
        TestAggregateSymbol.assertEquals((String)"Parser string does not match", (String)expected, (String)toString);
    }

    private void helpEquals(AggregateSymbol as1, AggregateSymbol as2, boolean equal) {
        if (equal) {
            TestAggregateSymbol.assertTrue((String)("Aggregate symbols should be equal: " + as1 + ", " + as2), (boolean)as1.equals((Object)as2));
        } else {
            TestAggregateSymbol.assertTrue((String)("Aggregate symbols should not be equal: " + as1 + ", " + as2), (!as1.equals((Object)as2) ? 1 : 0) != 0);
        }
    }

    public void testParser1() {
        AggregateSymbol as = new AggregateSymbol("count", "COUNT", false, (Expression)TestAggregateSymbol.sampleElement());
        this.helpParser(as, "COUNT(m.g.c)");
    }

    public void testParser2() {
        AggregateSymbol as = new AggregateSymbol("count", "COUNT", true, (Expression)TestAggregateSymbol.sampleElement());
        this.helpParser(as, "COUNT(DISTINCT m.g.c)");
    }

    public void testParser3() {
        AggregateSymbol as = new AggregateSymbol("x", "MIN", false, (Expression)TestAggregateSymbol.sampleConstant());
        this.helpParser(as, "MIN(5)");
    }

    public void testParser4() {
        AggregateSymbol as = new AggregateSymbol("x", "MAX", false, (Expression)TestAggregateSymbol.sampleFunction());
        this.helpParser(as, "MAX((m.g.c + 5))");
    }

    public void testParser5() {
        AggregateSymbol as = new AggregateSymbol("x", "COUNT", false, null);
        this.helpParser(as, "COUNT(*)");
    }

    public void testEquals1() {
        AggregateSymbol as = new AggregateSymbol("x", "COUNT", true, (Expression)TestAggregateSymbol.sampleElement());
        this.helpEquals(as, as, true);
    }

    public void testEquals2() {
        AggregateSymbol as1 = new AggregateSymbol("x", "COUNT", true, (Expression)TestAggregateSymbol.sampleElement());
        AggregateSymbol as2 = (AggregateSymbol)as1.clone();
        this.helpEquals(as1, as2, true);
    }

    public void testEquals3() {
        AggregateSymbol as1 = new AggregateSymbol("x", "COUNT", true, (Expression)TestAggregateSymbol.sampleElement());
        AggregateSymbol as2 = new AggregateSymbol("y", "COUNT", true, (Expression)TestAggregateSymbol.sampleElement());
        this.helpEquals(as1, as2, true);
    }

    public void testEquals4() {
        AggregateSymbol as1 = new AggregateSymbol("count", "COUNT", false, null);
        AggregateSymbol as2 = (AggregateSymbol)as1.clone();
        this.helpEquals(as1, as2, true);
    }

    public void testSelfEquivalence() {
        AggregateSymbol test = new AggregateSymbol("x", "COUNT", true, (Expression)TestAggregateSymbol.sampleElement());
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)test, (Object)test);
    }

    public void testEquivalence() {
        AggregateSymbol test1 = new AggregateSymbol("x", "COUNT", true, (Expression)TestAggregateSymbol.sampleElement());
        AggregateSymbol test2 = new AggregateSymbol("x", "COUNT", true, (Expression)TestAggregateSymbol.sampleElement());
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)test1, (Object)test2);
    }

    public void testEquivalenceCountStar() {
        AggregateSymbol test1 = new AggregateSymbol("x", "COUNT", false, null);
        AggregateSymbol test2 = new AggregateSymbol("x", "COUNT", false, null);
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)test1, (Object)test2);
    }

    public void testEquivalenceCaseInsens() {
        AggregateSymbol test1 = new AggregateSymbol("x", "COUNT", true, (Expression)TestAggregateSymbol.sampleElement());
        AggregateSymbol test2 = new AggregateSymbol("X", "COUNT", true, (Expression)TestAggregateSymbol.sampleElement());
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)test1, (Object)test2);
    }

    public void testNonEquivalenceUsingDiffElements() {
        AggregateSymbol test1 = new AggregateSymbol("x", "COUNT", true, (Expression)TestAggregateSymbol.sampleElement());
        AggregateSymbol test2 = new AggregateSymbol("X", "COUNT", true, (Expression)TestAggregateSymbol.sampleElement2());
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)test1, (Object)test2);
    }

    public void testNonEquivalence() {
        AggregateSymbol test1 = new AggregateSymbol("x", "COUNT", true, (Expression)TestAggregateSymbol.sampleElement());
        AggregateSymbol test2 = new AggregateSymbol("y", "COUNT", true, (Expression)TestAggregateSymbol.sampleElement2());
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)test1, (Object)test2);
    }

    public void testNonEquivalence1() {
        AggregateSymbol test1 = new AggregateSymbol("x", "COUNT", true, (Expression)TestAggregateSymbol.sampleElement());
        AggregateSymbol test2 = new AggregateSymbol("x", "COUNT", true, (Expression)TestAggregateSymbol.sampleElement2());
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)test1, (Object)test2);
    }

    public void testNonEquivalence2() {
        AggregateSymbol test1 = new AggregateSymbol("x", "MAX", true, (Expression)TestAggregateSymbol.sampleElement());
        AggregateSymbol test2 = new AggregateSymbol("x", "COUNT", true, (Expression)TestAggregateSymbol.sampleElement2());
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)test1, (Object)test2);
    }
}

