/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.unittest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.metadata.Table;
import org.teiid.metadata.TransformationMetadata;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingSequenceNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.unittest.FakeMetadataFacade;
import org.teiid.query.unittest.FakeMetadataObject;
import org.teiid.query.unittest.FakeMetadataStore;
import org.teiid.query.unittest.RealMetadataFactory;

public class FakeMetadataFactory {
    private static FakeMetadataFacade CACHED_EXAMPLE1 = FakeMetadataFactory.example1();
    private static FakeMetadataFacade CACHED_AGGREGATES = FakeMetadataFactory.exampleAggregates();

    private FakeMetadataFactory() {
    }

    public static FakeMetadataFacade example1Cached() {
        return CACHED_EXAMPLE1;
    }

    public static TransformationMetadata exampleBQTCached() {
        return RealMetadataFactory.exampleBQTCached();
    }

    public static void setCardinality(String group, int cardinality, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        if (metadata instanceof TransformationMetadata) {
            Table t = (Table)metadata.getGroupID(group);
            t.setCardinality(cardinality);
        } else if (metadata instanceof FakeMetadataFacade) {
            FakeMetadataObject fmo = (FakeMetadataObject)metadata.getGroupID(group);
            fmo.putProperty("cardinality", cardinality);
        } else {
            throw new RuntimeException("unknown metadata");
        }
    }

    public static FakeMetadataFacade exampleAggregatesCached() {
        return CACHED_AGGREGATES;
    }

    public static DQPWorkContext buildWorkContext(QueryMetadataInterface metadata, VDBMetaData vdb) {
        DQPWorkContext workContext = new DQPWorkContext();
        SessionMetadata session = new SessionMetadata();
        workContext.setSession(session);
        session.setVDBName(vdb.getName());
        session.setVDBVersion(vdb.getVersion());
        session.setSessionId(String.valueOf(1));
        session.setUserName("foo");
        session.setVdb(vdb);
        workContext.getVDB().addAttchment(QueryMetadataInterface.class, (Object)metadata);
        DQPWorkContext.setWorkContext((DQPWorkContext)workContext);
        return workContext;
    }

    public static FakeMetadataFacade exampleBitwise() {
        FakeMetadataObject phys = FakeMetadataFactory.createPhysicalModel("phys");
        FakeMetadataObject t = FakeMetadataFactory.createPhysicalGroup("phys.t", phys);
        List<FakeMetadataObject> tElem = FakeMetadataFactory.createElements(t, new String[]{"ID", "Name", "source_bits"}, new String[]{"integer", "string", "integer"});
        FakeMetadataObject virt = FakeMetadataFactory.createVirtualModel("virt");
        FakeMetadataObject rs = FakeMetadataFactory.createResultSet("rs", virt, new String[]{"ID", "Name", "source_bits"}, new String[]{"integer", "string", "integer"});
        FakeMetadataObject paramRS = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs);
        QueryNode qn = new QueryNode("agg", "CREATE VIRTUAL PROCEDURE BEGIN         DECLARE integer VARIABLES.BITS;        create local temporary table #temp (id integer, name string, bits integer);        LOOP ON (SELECT DISTINCT phys.t.ID, phys.t.Name FROM phys.t) AS idCursor        BEGIN                VARIABLES.BITS = 0;                LOOP ON (SELECT phys.t.source_bits FROM phys.t WHERE phys.t.ID = idCursor.id) AS bitsCursor                BEGIN                        VARIABLES.BITS = bitor(VARIABLES.BITS, bitsCursor.source_bits);                END                SELECT idCursor.id, idCursor.name, VARIABLES.BITS INTO #temp;        END        SELECT ID, Name, #temp.BITS AS source_bits FROM #temp;END");
        FakeMetadataObject proc = FakeMetadataFactory.createVirtualProcedure("virt.agg", virt, Arrays.asList(paramRS), qn);
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(phys);
        store.addObject(t);
        store.addObjects(tElem);
        store.addObject(virt);
        store.addObject(proc);
        return new FakeMetadataFacade(store);
    }

    public static VDBMetaData example1VDB() {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("example1");
        vdb.setVersion(1);
        vdb.addModel(FakeMetadataFactory.createModel("pm1", true));
        vdb.addModel(FakeMetadataFactory.createModel("pm2", true));
        vdb.addModel(FakeMetadataFactory.createModel("pm3", true));
        vdb.addModel(FakeMetadataFactory.createModel("pm4", true));
        vdb.addModel(FakeMetadataFactory.createModel("pm5", true));
        vdb.addModel(FakeMetadataFactory.createModel("pm6", true));
        vdb.addModel(FakeMetadataFactory.createModel("vm1", false));
        vdb.addModel(FakeMetadataFactory.createModel("vm2", false));
        vdb.addModel(FakeMetadataFactory.createModel("tm1", false));
        return vdb;
    }

    public static ModelMetaData createModel(String name, boolean source) {
        ModelMetaData model = new ModelMetaData();
        model.setName(name);
        if (source) {
            model.setModelType(Model.Type.PHYSICAL);
        } else {
            model.setModelType(Model.Type.PHYSICAL);
        }
        model.setVisible(Boolean.valueOf(true));
        model.setSupportsMultiSourceBindings(false);
        model.addSourceMapping(name, name, null);
        return model;
    }

    /*
     * WARNING - void declaration
     */
    public static FakeMetadataFacade example1() {
        void vsp62;
        void vsp61;
        void vsp60;
        void vsp59;
        void vsp58;
        void vsp57;
        void vsp56;
        void vsp55;
        void vsp54;
        void vsp53;
        void vsp52;
        void vsp51;
        void vsp50;
        void vsp49;
        void vsp48;
        void vsp47;
        void vsp46;
        void vsp45;
        void vsp44;
        void vsp43;
        void vsp42;
        void vsp41;
        void vsp40;
        void vsp39;
        void vsp38;
        void vsp37;
        void vsp32;
        void vsp36;
        void vm1g35e2;
        void vgvp7e4;
        void vgvp7e3;
        void vgvp6e4;
        void vgvp6e3;
        void vgvp5e3;
        void vgvp4e3;
        void vgvp3e3;
        void vgvp2e3;
        void vgvp1e3;
        void vsp35;
        void vsp31;
        void vsp30;
        void vsp26;
        void sp5;
        void sp4;
        void vsp34;
        void vsp33;
        void vsp29;
        void vsp28;
        void vsp27;
        void vsp25;
        void vsp24;
        void vsp23;
        void vsp22;
        void vsp21;
        void vsp20;
        void vsp19;
        void vsp18;
        void vsp17;
        void vsp16;
        void vsp15;
        void vsp14;
        void vsp13;
        void vsp12;
        void vsp11;
        void vsp10;
        void vsp9;
        void vsp8;
        void vsp7;
        void vsp6;
        void vsp5;
        void vsp4;
        void vsp3;
        void vsp2;
        void vsp1;
        void sq19;
        void sq18;
        void sp3;
        void sq17;
        void sq16;
        void sq15;
        void sq14;
        void sq13;
        void sq12;
        void sq11;
        void sp2;
        void sq10;
        void sq9;
        void sq8;
        void sq7;
        void sq6;
        void sq5;
        void sq4;
        void sqsp1;
        void vsp63;
        void store;
        void vspqn63;
        void vspqn62;
        void vspqn61;
        void vspqn60;
        void vspqn59;
        void vspqn58;
        void vspp58;
        void vspqn57;
        void vspqn56;
        void vspqn55;
        void vspp55;
        void vspqn54;
        void vsp54p2;
        void vsp54p1;
        void vsp54rs;
        void vspqn53;
        void vsp53p2;
        void vsp53p1;
        void vsp53rs;
        void vspqn52;
        void vsp52p1;
        void vsp52rs;
        void vspqn51;
        void vsp51p1;
        void vsp51rs;
        void vspqn50;
        void vsp50p1;
        void vsp50rs;
        void vspqn49;
        void vsp49p1;
        void vsp49rs;
        void vspqn48;
        void vsp48p2;
        void vsp48p1;
        void vsp48rs;
        void vspqn46;
        void vspqn43;
        void vspp43;
        void vspqn44;
        void vspp44;
        void vspqn42;
        void vsp42p2;
        void vsp42p1;
        void vsprs42;
        void vspqn36;
        void vsp36p2;
        void vsp36p1;
        void vsprs36;
        void vm1g35e1;
        void vm1g35;
        void vm1g35n1;
        void vgvp6e2;
        void vgvp6e1;
        void vgvp6;
        void vgvpn6;
        void vgvp5e2;
        void vgvp5e1;
        void vgvp5;
        void vgvpn5;
        void vgvp4e2;
        void vgvp4e1;
        void vgvp4;
        void vgvpn4;
        void vgvp3e2;
        void vgvp3e1;
        void vgvp3;
        void vgvpn3;
        void vgvp2e2;
        void vgvp2e1;
        void vgvp2;
        void vgvpn2;
        void vgvp1e2;
        void vgvp1e1;
        void vgvp1;
        void vgvpn1;
        void vspqn26;
        void vspp26_2;
        void vspp26_1;
        void vspp6;
        void vsprs3;
        void vspqn32;
        void vgvp7e2;
        void vgvp7e1;
        void vgvp7;
        void vgvpn7;
        void vspqn47;
        void vspp47_1;
        void vspp47_3;
        void vspp47_2;
        void vsprs47;
        void vspqn45;
        void vspqn34;
        void vspqn35;
        void vspqn33;
        void vspqn37;
        void vspqn41;
        void vspqn40;
        void vspqn39;
        void vspqn38;
        void vspqn31;
        void vsp31p2;
        void vsp31p1;
        void vsprs31;
        void vspqn30;
        void vsp30p1;
        void vsprs30;
        void vspqn29;
        void vspqn28;
        void vspqn27;
        void vspqn25;
        void vspqn24;
        void vspqn23;
        void vspp23;
        void vspqn22;
        void vspp22;
        void vspqn21;
        void vspp21;
        void vspqn20;
        void vspqn19;
        void vspqn18;
        void vspqn17;
        void vspqn16;
        void vspqn15;
        void vspqn14;
        void vspqn13;
        void vspp4;
        void vsprs2;
        void vspqn12;
        void vspqn11;
        void vspqn10;
        void vspp3;
        void vspqn9;
        void vspp9;
        void vspqn8;
        void vspp8;
        void vspqn7;
        void vspp2;
        void vspqn6;
        void vspqn5;
        void vspqn4;
        void vspqn3;
        void vspqn2;
        void vspqn1;
        void vspp1;
        void vsprs1;
        void rs22p2;
        void sq19n1;
        void sq19p2;
        void sq19p1;
        void rs21;
        void sq18n1;
        void sq18p1;
        void rs20;
        void sq17n1;
        void sq17p1;
        void rs19;
        void sq16n1;
        void sq15n1;
        void rs18p3;
        void rs18p2;
        void rs18p1;
        void rs18;
        void sq14n1;
        void rs17p3;
        void rs17p2;
        void rs17p1;
        void rs17;
        void sq13n1;
        void rs16p2;
        void rs16p1;
        void rs16;
        void sq12n1;
        void rs15p3;
        void rs15p2;
        void rs15p1;
        void rs15;
        void sq11n1;
        void rs14p3;
        void rs14p2;
        void rs14p1;
        void rs14;
        void rs13p2;
        void rs13p1;
        void rs13;
        void sq10n1;
        void rs12p3;
        void rs12p2;
        void rs12p1;
        void rs12;
        void sq9n1;
        void rs11p2;
        void rs11p1;
        void rs11;
        void sq8n1;
        void rs10p2;
        void rs10p1;
        void rs10;
        void sq7n1;
        void rs9p1;
        void rs9;
        void sq6n1;
        void rs8p1;
        void rs8;
        void sq5n1;
        void rs7p2;
        void rs7p1;
        void rs7;
        void sq4n1;
        void rs6p1;
        void rs6;
        void sqsp1n1;
        void rs4p1;
        FakeMetadataObject pm1 = FakeMetadataFactory.createPhysicalModel("pm1");
        FakeMetadataObject pm2 = FakeMetadataFactory.createPhysicalModel("pm2");
        FakeMetadataObject pm3 = FakeMetadataFactory.createPhysicalModel("pm3");
        FakeMetadataObject pm4 = FakeMetadataFactory.createPhysicalModel("pm4");
        FakeMetadataObject pm5 = FakeMetadataFactory.createPhysicalModel("pm5");
        FakeMetadataObject pm6 = FakeMetadataFactory.createPhysicalModel("pm6");
        FakeMetadataObject vm1 = FakeMetadataFactory.createVirtualModel("vm1");
        FakeMetadataObject vm2 = FakeMetadataFactory.createVirtualModel("vm2");
        FakeMetadataObject tm1 = FakeMetadataFactory.createVirtualModel("tm1");
        FakeMetadataObject pm1g1 = FakeMetadataFactory.createPhysicalGroup("pm1.g1", pm1);
        FakeMetadataObject pm1g2 = FakeMetadataFactory.createPhysicalGroup("pm1.g2", pm1);
        FakeMetadataObject pm1g3 = FakeMetadataFactory.createPhysicalGroup("pm1.g3", pm1);
        FakeMetadataObject pm1g4 = FakeMetadataFactory.createPhysicalGroup("pm1.g4", pm1);
        FakeMetadataObject pm1g5 = FakeMetadataFactory.createPhysicalGroup("pm1.g5", pm1);
        FakeMetadataObject pm1g6 = FakeMetadataFactory.createPhysicalGroup("pm1.g6", pm1);
        FakeMetadataObject pm1table = FakeMetadataFactory.createPhysicalGroup("pm1.table1", pm1);
        FakeMetadataObject pm2g1 = FakeMetadataFactory.createPhysicalGroup("pm2.g1", pm2);
        FakeMetadataObject pm2g2 = FakeMetadataFactory.createPhysicalGroup("pm2.g2", pm2);
        FakeMetadataObject pm2g3 = FakeMetadataFactory.createPhysicalGroup("pm2.g3", pm2);
        FakeMetadataObject pm3g1 = FakeMetadataFactory.createPhysicalGroup("pm3.g1", pm3);
        FakeMetadataObject pm3g2 = FakeMetadataFactory.createPhysicalGroup("pm3.g2", pm3);
        FakeMetadataObject pm4g1 = FakeMetadataFactory.createPhysicalGroup("pm4.g1", pm4);
        FakeMetadataObject pm4g2 = FakeMetadataFactory.createPhysicalGroup("pm4.g2", pm4);
        FakeMetadataObject pm5g1 = FakeMetadataFactory.createPhysicalGroup("pm5.g1", pm5);
        FakeMetadataObject pm5g2 = FakeMetadataFactory.createPhysicalGroup("pm5.g2", pm5);
        FakeMetadataObject pm5g3 = FakeMetadataFactory.createPhysicalGroup("pm5.g3", pm5);
        FakeMetadataObject pm6g1 = FakeMetadataFactory.createPhysicalGroup("pm6.g1", pm6);
        List<FakeMetadataObject> pm1g1e = FakeMetadataFactory.createElements(pm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm1g2e = FakeMetadataFactory.createElements(pm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm1g3e = FakeMetadataFactory.createElements(pm1g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm1g4e = FakeMetadataFactory.createElements(pm1g4, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        pm1g4e.get(1).putProperty("supSelect", Boolean.FALSE);
        pm1g4e.get(3).putProperty("supSelect", Boolean.FALSE);
        List<FakeMetadataObject> pm1g5e = FakeMetadataFactory.createElements(pm1g5, new String[]{"e1"}, new String[]{"string"});
        pm1g5e.get(0).putProperty("supSelect", Boolean.FALSE);
        List<FakeMetadataObject> pm1g6e = FakeMetadataFactory.createElements(pm1g6, new String[]{"in", "in3"}, new String[]{"string", "string"});
        List<FakeMetadataObject> pm1tablee = FakeMetadataFactory.createElements(pm1table, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm2g1e = FakeMetadataFactory.createElements(pm2g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm2g2e = FakeMetadataFactory.createElements(pm2g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm2g3e = FakeMetadataFactory.createElements(pm2g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm3g1e = FakeMetadataFactory.createElements(pm3g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "date", "time", "timestamp"});
        List<FakeMetadataObject> pm3g2e = FakeMetadataFactory.createElements(pm3g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "date", "time", "timestamp"});
        List<FakeMetadataObject> pm4g1e = FakeMetadataFactory.createElements(pm4g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm4g2e = FakeMetadataFactory.createElements(pm4g2, new String[]{"e1", "e2", "e3", "e4", "e5", "e6"}, new String[]{"string", "integer", "boolean", "double", "string", "integer"});
        List<FakeMetadataObject> pm5g1e = FakeMetadataFactory.createElements(pm5g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm5g2e = FakeMetadataFactory.createElements(pm5g2, new String[]{"e1", "e2", "e3", "e4", "e5", "e6"}, new String[]{"string", "integer", "boolean", "double", "string", "integer"});
        List<FakeMetadataObject> pm5g3e = FakeMetadataFactory.createElements(pm5g3, new String[]{"e1", "e2"}, new String[]{"string", "short"});
        List<FakeMetadataObject> pm6g1e = FakeMetadataFactory.createElements(pm6g1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        ArrayList<FakeMetadataObject> elements = new ArrayList<FakeMetadataObject>(1);
        elements.add(pm4g1e.iterator().next());
        FakeMetadataObject pm4g1ap1 = FakeMetadataFactory.createAccessPattern("pm4.g1.ap1", pm4g1, elements);
        elements = new ArrayList(2);
        Iterator<FakeMetadataObject> iter = pm4g2e.iterator();
        elements.add(iter.next());
        elements.add(iter.next());
        FakeMetadataObject pm4g2ap1 = FakeMetadataFactory.createAccessPattern("pm4.g2.ap1", pm4g2, elements);
        elements = new ArrayList(1);
        elements.add(pm4g2e.get(4));
        FakeMetadataObject pm4g2ap2 = FakeMetadataFactory.createAccessPattern("pm4.g2.ap2", pm4g2, elements);
        elements = new ArrayList(1);
        elements.add(pm5g1e.iterator().next());
        FakeMetadataObject pm5g1ap1 = FakeMetadataFactory.createAccessPattern("pm5.g1.ap1", pm5g1, elements);
        elements = new ArrayList(2);
        iter = pm5g2e.iterator();
        elements.add(iter.next());
        elements.add(iter.next());
        FakeMetadataObject pm5g2ap1 = FakeMetadataFactory.createAccessPattern("pm5.g2.ap1", pm5g2, elements);
        elements = new ArrayList(1);
        elements.add(pm5g2e.get(4));
        FakeMetadataObject pm5g2ap2 = FakeMetadataFactory.createAccessPattern("pm5.g2.ap2", pm5g2, elements);
        FakeMetadataObject tm1g1 = FakeMetadataFactory.createTempGroup("tm1.g1", tm1, null);
        List<FakeMetadataObject> tm1g1e = FakeMetadataFactory.createElements(tm1g1, new String[]{"e1", "e2", "e3", "e4", "node1"}, new String[]{"string", "integer", "boolean", "double", "string"});
        FakeMetadataObject tm1g2 = FakeMetadataFactory.createTempGroup("tm1.g1", tm1, null);
        List<FakeMetadataObject> tm1g2e = FakeMetadataFactory.createElements(tm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        QueryNode vm1g1n1 = new QueryNode("vm1.g1", "SELECT * FROM pm1.g1");
        FakeMetadataObject vm1g1 = FakeMetadataFactory.createUpdatableVirtualGroup("vm1.g1", vm1, vm1g1n1);
        QueryNode vm2g1n1 = new QueryNode("vm2.g1", "SELECT pm1.g1.* FROM pm1.g1, pm1.g2 where pm1.g1.e2 = pm1.g2.e2");
        FakeMetadataObject vm2g1 = FakeMetadataFactory.createUpdatableVirtualGroup("vm2.g1", vm2, vm2g1n1);
        QueryNode vm1g1n1_defect10711 = new QueryNode("vm1.g1a", "SELECT * FROM vm1.g1 as X");
        FakeMetadataObject vm1g1_defect10711 = FakeMetadataFactory.createVirtualGroup("vm1.g1a", vm1, vm1g1n1_defect10711);
        QueryNode vm1g1n1_defect12081 = new QueryNode("vm1.g1b", "SELECT e1, upper(e1) as e1Upper FROM pm1.g1");
        FakeMetadataObject vm1g1_defect12081 = FakeMetadataFactory.createVirtualGroup("vm1.g1b", vm1, vm1g1n1_defect12081);
        QueryNode vm1g1n1c = new QueryNode("vm1.g1c", "SELECT PARSETIMESTAMP(pm1.g1.e1, 'MMM dd yyyy hh:mm:ss') as e5, e2, e3, e4 FROM pm1.g1");
        FakeMetadataObject vm1g1c = FakeMetadataFactory.createVirtualGroup("vm1.g1c", vm1, vm1g1n1c);
        QueryNode vm1g2an1 = new QueryNode("vm1.g2a", "SELECT * FROM pm1.g2");
        FakeMetadataObject vm1g2a = FakeMetadataFactory.createVirtualGroup("vm1.g2a", vm1, vm1g2an1);
        QueryNode vm1g2n1 = new QueryNode("vm1.g2", "SELECT pm1.g1.e1, pm1.g1.e2, pm1.g2.e3, pm1.g2.e4 FROM pm1.g1, pm1.g2 WHERE pm1.g1.e1=pm1.g2.e1");
        FakeMetadataObject vm1g2 = FakeMetadataFactory.createVirtualGroup("vm1.g2", vm1, vm1g2n1);
        QueryNode vm1g4n1 = new QueryNode("vm1.g4", "SELECT e1 FROM pm1.g1 UNION ALL SELECT convert(e2, string) as x FROM pm1.g2 ORDER BY e1");
        FakeMetadataObject vm1g4 = FakeMetadataFactory.createVirtualGroup("vm1.g4", vm1, vm1g4n1);
        QueryNode vm1g5n1 = new QueryNode("vm1.g5", "SELECT concat(e1, 'val'), e2 FROM pm1.g1");
        FakeMetadataObject vm1g5 = FakeMetadataFactory.createVirtualGroup("vm1.g5", vm1, vm1g5n1);
        QueryNode vm1g6n1 = new QueryNode("vm1.g6", "SELECT concat(e1, 'val') AS e, e2 FROM pm1.g1");
        FakeMetadataObject vm1g6 = FakeMetadataFactory.createVirtualGroup("vm1.g6", vm1, vm1g6n1);
        QueryNode vm1g7n1 = new QueryNode("vm1.g7", "SELECT concat(e1, e2) AS e, e2 FROM pm1.g1");
        FakeMetadataObject vm1g7 = FakeMetadataFactory.createVirtualGroup("vm1.g7", vm1, vm1g7n1);
        QueryNode vm1g8n1 = new QueryNode("vm1.g8", "SELECT concat(e1, 'val') AS e, e2 FROM pm1.g1 ORDER BY e");
        FakeMetadataObject vm1g8 = FakeMetadataFactory.createVirtualGroup("vm1.g8", vm1, vm1g8n1);
        QueryNode vm1g9n1 = new QueryNode("vm1.g9", "SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1, pm4.g1 WHERE pm1.g1.e1 = pm4.g1.e1");
        FakeMetadataObject vm1g9 = FakeMetadataFactory.createVirtualGroup("vm1.g9", vm1, vm1g9n1);
        QueryNode vm1g10n1 = new QueryNode("vm1.g10", "SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1, pm4.g2 WHERE pm1.g1.e1 = pm4.g2.e1");
        FakeMetadataObject vm1g10 = FakeMetadataFactory.createVirtualGroup("vm1.g10", vm1, vm1g10n1);
        QueryNode vm1g11n1 = new QueryNode("vm1.g11", "SELECT * FROM pm4.g2");
        FakeMetadataObject vm1g11 = FakeMetadataFactory.createVirtualGroup("vm1.g11", vm1, vm1g11n1);
        QueryNode vm1g12n1 = new QueryNode("vm1.g12", "SELECT DISTINCT * FROM pm3.g1");
        FakeMetadataObject vm1g12 = FakeMetadataFactory.createVirtualGroup("vm1.g12", vm1, vm1g12n1);
        QueryNode vm1g13n1 = new QueryNode("vm1.g13", "SELECT DISTINCT * FROM pm3.g1 ORDER BY e1");
        FakeMetadataObject vm1g13 = FakeMetadataFactory.createVirtualGroup("vm1.g13", vm1, vm1g13n1);
        QueryNode vm1g14n1 = new QueryNode("vm1.g14", "SELECT * FROM pm3.g1 ORDER BY e1");
        FakeMetadataObject vm1g14 = FakeMetadataFactory.createVirtualGroup("vm1.g14", vm1, vm1g14n1);
        QueryNode vm1g15n1 = new QueryNode("vm1.g15", "SELECT e1, concat(e1, convert(e2, string)) AS x FROM pm3.g1");
        FakeMetadataObject vm1g15 = FakeMetadataFactory.createVirtualGroup("vm1.g15", vm1, vm1g15n1);
        QueryNode vm1g16n1 = new QueryNode("vm1.g16", "SELECT concat(e1, 'val') AS e, e2 FROM pm3.g1 ORDER BY e");
        FakeMetadataObject vm1g16 = FakeMetadataFactory.createVirtualGroup("vm1.g16", vm1, vm1g16n1);
        QueryNode vm1g17n1 = new QueryNode("vm1.g17", "SELECT pm3.g1.e1, pm3.g1.e2 FROM pm3.g1 UNION ALL SELECT pm3.g2.e1, pm3.g2.e2 FROM pm3.g2 ORDER BY e2");
        FakeMetadataObject vm1g17 = FakeMetadataFactory.createVirtualGroup("vm1.g17", vm1, vm1g17n1);
        QueryNode vm1g18n1 = new QueryNode("vm1.g18", "SELECT (e4 * 100.0) as x FROM pm1.g1");
        FakeMetadataObject vm1g18 = FakeMetadataFactory.createVirtualGroup("vm1.g18", vm1, vm1g18n1);
        QueryNode vm1g19n1 = new QueryNode("vm1.g19", "Select * from vm1.g4 where not (e1 in (select e1 FROM vm1.g1 WHERE vm1.g4.e1 = e1))");
        FakeMetadataObject vm1g19 = FakeMetadataFactory.createVirtualGroup("vm1.g19", vm1, vm1g19n1);
        QueryNode vm1g20n1 = new QueryNode("vm1.g20", "Select * from vm1.g1 where exists (select e1 FROM vm1.g2 WHERE vm1.g1.e1 = e1)");
        FakeMetadataObject vm1g20 = FakeMetadataFactory.createVirtualGroup("vm1.g20", vm1, vm1g20n1);
        QueryNode vm1g21n1 = new QueryNode("vm1.g21", "Select * from pm1.g1 where exists (select e1 FROM pm2.g1 WHERE pm1.g1.e1 = e1)");
        FakeMetadataObject vm1g21 = FakeMetadataFactory.createVirtualGroup("vm1.g21", vm1, vm1g21n1);
        QueryNode vm1g22n1 = new QueryNode("vm1.g22", "Select e1, e2, e3, e4, (select e4 FROM vm1.g21 WHERE vm1.g20.e4 = e4 and e4 = 7.0) as E5 from vm1.g20");
        FakeMetadataObject vm1g22 = FakeMetadataFactory.createVirtualGroup("vm1.g22", vm1, vm1g22n1);
        QueryNode vm1g23n1 = new QueryNode("vm1.g23", "Select e1, e2, e3, e4, (select e4 FROM vm1.g21 WHERE vm1.g20.e4 = 7.0 and e4 = 7.0) as E5 from vm1.g20");
        FakeMetadataObject vm1g23 = FakeMetadataFactory.createVirtualGroup("vm1.g23", vm1, vm1g23n1);
        QueryNode vm1g24n1 = new QueryNode("vm1.g24", "Select * from vm1.g20 where exists (select * FROM vm1.g21 WHERE vm1.g20.e4 = E4)");
        FakeMetadataObject vm1g24 = FakeMetadataFactory.createVirtualGroup("vm1.g24", vm1, vm1g24n1);
        QueryNode vm1g25n1 = new QueryNode("vm1.g25", "Select e1, e2, e3, e4, (select e4 FROM pm1.g2 WHERE e1 = 'b') as E5 from pm1.g1");
        FakeMetadataObject vm1g25 = FakeMetadataFactory.createVirtualGroup("vm1.g25", vm1, vm1g25n1);
        QueryNode vm1g26n1 = new QueryNode("vm1.g26", "Select e1, e2, e3, e4, (select e4 FROM pm1.g2 WHERE e4 = pm1.g1.e4 and e1 = 'b') as E5 from pm1.g1");
        FakeMetadataObject vm1g26 = FakeMetadataFactory.createVirtualGroup("vm1.g26", vm1, vm1g26n1);
        QueryNode vm1g27n1 = new QueryNode("vm1.g27", "SELECT upper(e1) as x, e1 FROM pm1.g1");
        FakeMetadataObject vm1g27 = FakeMetadataFactory.createVirtualGroup("vm1.g27", vm1, vm1g27n1);
        QueryNode vm1g28n1 = new QueryNode("vm1.g28", "SELECT DISTINCT x as a, lower(e1) as x FROM vm1.g27");
        FakeMetadataObject vm1g28 = FakeMetadataFactory.createVirtualGroup("vm1.g28", vm1, vm1g28n1);
        QueryNode vm1g29n1 = new QueryNode("vm1.g29", "SELECT DISTINCT x, lower(e1) FROM vm1.g27");
        FakeMetadataObject vm1g29 = FakeMetadataFactory.createVirtualGroup("vm1.g29", vm1, vm1g29n1);
        QueryNode vm1g30n1 = new QueryNode("vm1.g30", "SELECT DISTINCT e1 as x, e1 as y FROM pm1.g1");
        FakeMetadataObject vm1g30 = FakeMetadataFactory.createVirtualGroup("vm1.g30", vm1, vm1g30n1);
        QueryNode vm1g31n1 = new QueryNode("vm1.g31", "SELECT e1 as x, e1 as y FROM pm1.g1 ORDER BY x");
        FakeMetadataObject vm1g31 = FakeMetadataFactory.createVirtualGroup("vm1.g31", vm1, vm1g31n1);
        QueryNode vm1g32n1 = new QueryNode("vm1.g32", "SELECT DISTINCT e1 as x, e1 as y FROM pm1.g1 ORDER BY x");
        FakeMetadataObject vm1g32 = FakeMetadataFactory.createVirtualGroup("vm1.g32", vm1, vm1g32n1);
        QueryNode vm1g33n1 = new QueryNode("vm1.g33", "SELECT e2 FROM pm1.g1 WHERE 2 = e2");
        FakeMetadataObject vm1g33 = FakeMetadataFactory.createVirtualGroup("vm1.g33", vm1, vm1g33n1);
        QueryNode vm1g34n1 = new QueryNode("vm1.g34", "SELECT e1 as e1_, e2 as e2_ FROM pm1.g1 UNION ALL SELECT e1 as e1_, e2 as e2_ FROM pm2.g1");
        FakeMetadataObject vm1g34 = FakeMetadataFactory.createVirtualGroup("vm1.g34", vm1, vm1g34n1);
        QueryNode vm1g36n1 = new QueryNode("vm1.g36", "SELECT pm1.g1.e1 as ve1, pm1.g2.e1 as ve2 FROM pm1.g1 LEFT OUTER JOIN /* optional */ pm1.g2 on pm1.g1.e1 = pm1.g2.e1");
        FakeMetadataObject vm1g36 = FakeMetadataFactory.createVirtualGroup("vm1.g36", vm1, vm1g36n1);
        QueryNode vm1g37n1 = new QueryNode("vm1.g37", "SELECT * from pm4.g1");
        FakeMetadataObject vm1g37 = FakeMetadataFactory.createVirtualGroup("vm1.g37", vm1, vm1g37n1);
        vm1g37.putProperty("supUpdate", Boolean.TRUE);
        QueryNode vm1g38n1 = new QueryNode("vm1.g38", "SELECT a.e1, b.e2 from pm1.g1 as a, pm6.g1 as b where a.e1=b.e1");
        FakeMetadataObject vm1g38 = FakeMetadataFactory.createVirtualGroup("vm1.g38", vm1, vm1g38n1);
        QueryNode vm1g39n1 = new QueryNode("vm1.g39", "SELECT * FROM pm1.g39");
        FakeMetadataObject vm1g39 = FakeMetadataFactory.createUpdatableVirtualGroup("vm1.g39", vm1, vm1g39n1, "CREATE VIRTUAL PROCEDURE BEGIN LOOP ON (SELECT pm1.g1.e2 FROM pm1.g1 where pm1.g1.e2=3) AS mycursor begin update pm1.g1 set pm1.g1.e1 = input.e1 where pm1.g1.e1 = input.e1; update pm1.g1 set pm1.g1.e2 = input.e2 where pm1.g1.e2 = input.e2; END END");
        List<FakeMetadataObject> vm1g39e = FakeMetadataFactory.createElements(vm1g39, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm1g1e = FakeMetadataFactory.createElements(vm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm2g1e = FakeMetadataFactory.createElements(vm2g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm1g1e_defect10711 = FakeMetadataFactory.createElements(vm1g1_defect10711, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm1g1e_defect12081 = FakeMetadataFactory.createElements(vm1g1_defect12081, new String[]{"e1", "e1Upper"}, new String[]{"string", "string"});
        List<FakeMetadataObject> vm1g1ce = FakeMetadataFactory.createElements(vm1g1c, new String[]{"e5", "e2", "e3", "e4"}, new String[]{"timestamp", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm1g2ae = FakeMetadataFactory.createElements(vm1g2a, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm1g2e = FakeMetadataFactory.createElements(vm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm1g4e = FakeMetadataFactory.createElements(vm1g4, new String[]{"e1"}, new String[]{"string"});
        List<FakeMetadataObject> vm1g5e = FakeMetadataFactory.createElements(vm1g5, new String[]{"expr", "e2"}, new String[]{"string", "integer"});
        List<FakeMetadataObject> vm1g6e = FakeMetadataFactory.createElements(vm1g6, new String[]{"e", "e2"}, new String[]{"string", "integer"});
        List<FakeMetadataObject> vm1g7e = FakeMetadataFactory.createElements(vm1g7, new String[]{"e", "e2"}, new String[]{"string", "integer"});
        List<FakeMetadataObject> vm1g8e = FakeMetadataFactory.createElements(vm1g8, new String[]{"e", "e2"}, new String[]{"string", "integer"});
        List<FakeMetadataObject> vm1g9e = FakeMetadataFactory.createElements(vm1g9, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        List<FakeMetadataObject> vm1g10e = FakeMetadataFactory.createElements(vm1g10, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        List<FakeMetadataObject> vm1g11e = FakeMetadataFactory.createElements(vm1g11, new String[]{"e1", "e2", "e3", "e4", "e5", "e6"}, new String[]{"string", "integer", "boolean", "double", "string", "integer"});
        List<FakeMetadataObject> vm1g12e = FakeMetadataFactory.createElements(vm1g12, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm1g13e = FakeMetadataFactory.createElements(vm1g13, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm1g14e = FakeMetadataFactory.createElements(vm1g14, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm1g15e = FakeMetadataFactory.createElements(vm1g15, new String[]{"e1", "x"}, new String[]{"string", "string"});
        List<FakeMetadataObject> vm1g16e = FakeMetadataFactory.createElements(vm1g16, new String[]{"e", "e2"}, new String[]{"string", "integer"});
        List<FakeMetadataObject> vm1g17e = FakeMetadataFactory.createElements(vm1g17, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        List<FakeMetadataObject> vm1g18e = FakeMetadataFactory.createElements(vm1g18, new String[]{"x"}, new String[]{"double"});
        List<FakeMetadataObject> vm1g19e = FakeMetadataFactory.createElements(vm1g19, new String[]{"e1"}, new String[]{"string"});
        List<FakeMetadataObject> vm1g20e = FakeMetadataFactory.createElements(vm1g20, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm1g21e = FakeMetadataFactory.createElements(vm1g21, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm1g22e = FakeMetadataFactory.createElements(vm1g22, new String[]{"e1", "e2", "e3", "e4", "e5"}, new String[]{"string", "integer", "boolean", "double", "double"});
        List<FakeMetadataObject> vm1g23e = FakeMetadataFactory.createElements(vm1g23, new String[]{"e1", "e2", "e3", "e4", "e5"}, new String[]{"string", "integer", "boolean", "double", "double"});
        List<FakeMetadataObject> vm1g24e = FakeMetadataFactory.createElements(vm1g24, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm1g25e = FakeMetadataFactory.createElements(vm1g25, new String[]{"e1", "e2", "e3", "e4", "e5"}, new String[]{"string", "integer", "boolean", "double", "double"});
        List<FakeMetadataObject> vm1g26e = FakeMetadataFactory.createElements(vm1g26, new String[]{"e1", "e2", "e3", "e4", "e5"}, new String[]{"string", "integer", "boolean", "double", "double"});
        List<FakeMetadataObject> vm1g27e = FakeMetadataFactory.createElements(vm1g27, new String[]{"x", "e1"}, new String[]{"string", "string"});
        List<FakeMetadataObject> vm1g28e = FakeMetadataFactory.createElements(vm1g28, new String[]{"a", "x"}, new String[]{"string", "string"});
        List<FakeMetadataObject> vm1g29e = FakeMetadataFactory.createElements(vm1g29, new String[]{"x", "expr"}, new String[]{"string", "string"});
        List<FakeMetadataObject> vm1g30e = FakeMetadataFactory.createElements(vm1g30, new String[]{"x", "y"}, new String[]{"string", "string"});
        List<FakeMetadataObject> vm1g31e = FakeMetadataFactory.createElements(vm1g31, new String[]{"x", "y"}, new String[]{"string", "string"});
        List<FakeMetadataObject> vm1g32e = FakeMetadataFactory.createElements(vm1g32, new String[]{"x", "y"}, new String[]{"string", "string"});
        List<FakeMetadataObject> vm1g33e = FakeMetadataFactory.createElements(vm1g33, new String[]{"e2"}, new String[]{"integer"});
        List<FakeMetadataObject> vm1g34e = FakeMetadataFactory.createElements(vm1g34, new String[]{"e1_", "e2_"}, new String[]{"string", "integer"});
        List<FakeMetadataObject> vm1g36e = FakeMetadataFactory.createElements(vm1g36, new String[]{"ve1", "ve2"}, new String[]{"string", "string"});
        List<FakeMetadataObject> vm1g37e = FakeMetadataFactory.createElements(vm1g37, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm1g38e = FakeMetadataFactory.createElements(vm1g38, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        elements = new ArrayList(1);
        elements.add(vm1g37e.iterator().next());
        FakeMetadataObject vm1g37ap1 = FakeMetadataFactory.createAccessPattern("vm1.g37.ap1", vm1g37, elements);
        FakeMetadataObject doc1 = FakeMetadataFactory.createVirtualGroup("xmltest.doc1", vm1, FakeMetadataFactory.exampleDoc1());
        FakeMetadataObject doc2 = FakeMetadataFactory.createVirtualGroup("xmltest.doc2", vm1, FakeMetadataFactory.exampleDoc2());
        FakeMetadataObject doc3 = FakeMetadataFactory.createVirtualGroup("xmltest.doc3", vm1, FakeMetadataFactory.exampleDoc3());
        FakeMetadataObject doc4 = FakeMetadataFactory.createVirtualGroup("xmltest.doc4", vm1, FakeMetadataFactory.exampleDoc4());
        FakeMetadataObject doc5 = FakeMetadataFactory.createVirtualGroup("xmltest.doc5", vm1, FakeMetadataFactory.exampleDoc5());
        FakeMetadataObject doc6 = FakeMetadataFactory.createVirtualGroup("xmltest.doc6", vm1, FakeMetadataFactory.exampleDoc6());
        FakeMetadataObject docAmbiguous1 = FakeMetadataFactory.createVirtualGroup("xmltest2.docA", vm1, FakeMetadataFactory.exampleDoc1());
        FakeMetadataObject docAmbiguous2 = FakeMetadataFactory.createVirtualGroup("xmltest3.docA", vm1, FakeMetadataFactory.exampleDoc2());
        List<FakeMetadataObject> docE1 = FakeMetadataFactory.createElements(doc1, new String[]{"root", "root.node1", "root.node1.node2", "root.node1.node2.node3"}, new String[]{"string", "string", "string", "string"});
        List<FakeMetadataObject> docE2 = FakeMetadataFactory.createElements(doc2, new String[]{"root", "root.node1", "root.node1.node3"}, new String[]{"string", "string", "string"});
        List<FakeMetadataObject> docE3 = FakeMetadataFactory.createElements(doc3, new String[]{"root", "root.node1.node2", "root.node2"}, new String[]{"string", "string", "string"});
        List<FakeMetadataObject> docE4 = FakeMetadataFactory.createElements(doc4, new String[]{"root", "root.@node6", "root.node1", "root.node1.@node2", "root.node3", "root.node3.@node4", "root.node3.node4", "root.node3.root.node6"}, new String[]{"string", "string", "string", "string", "string", "string", "string", "string"});
        HashSet<FakeMetadataObject> tempGroups = new HashSet<FakeMetadataObject>();
        tempGroups.add(tm1g1);
        doc4.putProperty("TEMP_GROUPS", tempGroups);
        List<FakeMetadataObject> docE5 = FakeMetadataFactory.createElements(doc5, new String[]{"root", "root.node1", "root.node1.node2"}, new String[]{"string", "string", "string", "string", "string", "string"});
        QueryNode mc1n1 = new QueryNode("xmltest.mc1", "SELECT e1 FROM pm1.g1 UNION ALL SELECT e1 FROM pm1.g2");
        FakeMetadataObject vm1mc1 = FakeMetadataFactory.createVirtualGroup("xmltest.mc1", vm1, mc1n1);
        List<FakeMetadataObject> vm1mc1e = FakeMetadataFactory.createElements(vm1mc1, new String[]{"e1"}, new String[]{"string"});
        List<FakeMetadataObject> docE6 = FakeMetadataFactory.createElements(doc6, new String[]{"root", "root.node", "root.thenode"}, new String[]{"string", "string", "string"});
        FakeMetadataObject rs1 = FakeMetadataFactory.createResultSet("pm1.rs1", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject rs1p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs1);
        QueryNode sq1n1 = new QueryNode("pm1.sq1", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 FROM pm1.g1; END");
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("pm1.sq1", pm1, Arrays.asList(rs1p1), sq1n1);
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("pm1.rs2", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        FakeMetadataObject rs2p2 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        QueryNode sq2n1 = new QueryNode("pm1.sq2", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 FROM pm1.g1 WHERE e1=pm1.sq2.in; END");
        FakeMetadataObject sq2 = FakeMetadataFactory.createVirtualProcedure("pm1.sq2", pm1, Arrays.asList(rs2p1, rs2p2), sq2n1);
        FakeMetadataObject rs5 = FakeMetadataFactory.createResultSet("pm1.r5", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject rs5p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs5);
        FakeMetadataObject rs5p2 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        FakeMetadataObject rs5p3 = FakeMetadataFactory.createParameter("in2", 3, 1, "integer", null);
        QueryNode sq3n1 = new QueryNode("pm1.sq3", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 FROM pm1.g1 WHERE e1=pm1.sq3.in UNION ALL SELECT e1, e2 FROM pm1.g1 WHERE e2=pm1.sq3.in2; END");
        FakeMetadataObject sq3 = FakeMetadataFactory.createVirtualProcedure("pm1.sq3", pm1, Arrays.asList(rs5p1, rs5p2, rs5p3), sq3n1);
        FakeMetadataObject rs5a = FakeMetadataFactory.createResultSet("pm1.r5a", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject rs5p1a = FakeMetadataFactory.createParameter("in", 1, 1, "string", null);
        FakeMetadataObject rs5p2a = FakeMetadataFactory.createParameter("in2", 3, 1, "integer", null);
        QueryNode sq3n1a = new QueryNode("pm1.sq3a", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 FROM pm1.g1 WHERE e1=pm1.sq3a.in UNION ALL SELECT e1, e2 FROM pm1.g1 WHERE e2=pm1.sq3a.in2; END");
        FakeMetadataObject sq3a = FakeMetadataFactory.createVirtualProcedure("pm1.sq3a", pm1, Arrays.asList(rs5p1a, rs5p2a), sq3n1a);
        FakeMetadataObject rs5b = FakeMetadataFactory.createResultSet("pm1.r5b", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject rs5p1b = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs5b);
        FakeMetadataObject rs5p2b = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        FakeMetadataObject rs5p3b = FakeMetadataFactory.createParameter("in2", 3, 1, "integer", null);
        FakeMetadataObject rs5p4b = FakeMetadataFactory.createParameter("in3", 4, 1, "string", null);
        rs5p3b.putProperty("supNull", Boolean.TRUE);
        rs5p4b.setDefaultValue("YYZ");
        QueryNode sq3n1b = new QueryNode("pm1.sq3b", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 FROM pm1.g1 WHERE e1=pm1.sq3b.in UNION ALL SELECT e1, e2 FROM pm1.g1 WHERE e2=pm1.sq3b.in2; END");
        FakeMetadataObject sq3b = FakeMetadataFactory.createVirtualProcedure("pm1.sq3b", pm1, Arrays.asList(rs5p1b, rs5p2b, rs5p3b, rs5p4b), sq3n1b);
        FakeMetadataObject rsDefaults = FakeMetadataFactory.createResultSet("pm1.rDefaults", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject rsDefaultsParameterReturn = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rsDefaults);
        FakeMetadataObject rsDefaultsParameterString = FakeMetadataFactory.createParameter("inString", 2, 1, "string", null);
        rsDefaultsParameterString.setDefaultValue(new String("x"));
        FakeMetadataObject rsParameterBigDecimal = FakeMetadataFactory.createParameter("inBigDecimal", 3, 1, "bigdecimal", null);
        rsParameterBigDecimal.putProperty("supNull", Boolean.TRUE);
        rsParameterBigDecimal.setDefaultValue(new String("13.0"));
        FakeMetadataObject rsParameterBigInteger = FakeMetadataFactory.createParameter("inBigInteger", 4, 1, "biginteger", null);
        rsParameterBigInteger.putProperty("supNull", Boolean.TRUE);
        rsParameterBigInteger.setDefaultValue(new String("13"));
        FakeMetadataObject rsParameterBoolean = FakeMetadataFactory.createParameter("inBoolean", 5, 1, "boolean", null);
        rsParameterBoolean.putProperty("supNull", Boolean.TRUE);
        rsParameterBoolean.setDefaultValue(new String("True"));
        FakeMetadataObject rsParameterByte = FakeMetadataFactory.createParameter("inByte", 6, 1, "byte", null);
        rsParameterByte.putProperty("supNull", Boolean.TRUE);
        rsParameterByte.setDefaultValue(new String("1"));
        FakeMetadataObject rsParameterChar = FakeMetadataFactory.createParameter("inChar", 7, 1, "char", null);
        rsParameterChar.putProperty("supNull", Boolean.TRUE);
        rsParameterChar.setDefaultValue(new String("q"));
        FakeMetadataObject rsParameterDate = FakeMetadataFactory.createParameter("inDate", 8, 1, "date", null);
        rsParameterDate.putProperty("supNull", Boolean.TRUE);
        rsParameterDate.setDefaultValue(new String("2003-03-20"));
        FakeMetadataObject rsParameterDouble = FakeMetadataFactory.createParameter("inDouble", 9, 1, "double", null);
        rsParameterDouble.putProperty("supNull", Boolean.TRUE);
        rsParameterDouble.setDefaultValue(new String("13.0"));
        FakeMetadataObject rsParameterFloat = FakeMetadataFactory.createParameter("inFloat", 10, 1, "float", null);
        rsParameterFloat.putProperty("supNull", Boolean.TRUE);
        rsParameterFloat.setDefaultValue(new String("13"));
        FakeMetadataObject rsParameterInteger = FakeMetadataFactory.createParameter("inInteger", 11, 1, "integer", null);
        rsParameterInteger.putProperty("supNull", Boolean.TRUE);
        rsParameterInteger.setDefaultValue(new String("13"));
        FakeMetadataObject rsParameterLong = FakeMetadataFactory.createParameter("inLong", 12, 1, "long", null);
        rsParameterLong.putProperty("supNull", Boolean.TRUE);
        rsParameterLong.setDefaultValue(new String("13"));
        FakeMetadataObject rsParameterShort = FakeMetadataFactory.createParameter("inShort", 13, 1, "short", null);
        rsParameterShort.putProperty("supNull", Boolean.TRUE);
        rsParameterShort.setDefaultValue(new String("13"));
        FakeMetadataObject rsParameterTimestamp = FakeMetadataFactory.createParameter("inTimestamp", 14, 1, "timestamp", null);
        rsParameterTimestamp.putProperty("supNull", Boolean.TRUE);
        rsParameterTimestamp.setDefaultValue(new String("2003-03-20 21:26:00.000000"));
        FakeMetadataObject rsParameterTime = FakeMetadataFactory.createParameter("inTime", 15, 1, "time", null);
        rsParameterTime.putProperty("supNull", Boolean.TRUE);
        rsParameterTime.setDefaultValue(new String("21:26:00"));
        QueryNode sqDefaultsNode = new QueryNode("pm1.sqDefaults", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 FROM pm1.g1 WHERE e1=pm1.sqDefaults.inString UNION ALL SELECT e1, e2 FROM pm1.g1 WHERE e2=pm1.sqDefaults.inInteger; END");
        FakeMetadataObject sqDefaults = FakeMetadataFactory.createVirtualProcedure("pm1.sqDefaults", pm1, Arrays.asList(rsDefaultsParameterReturn, rsDefaultsParameterString, rsParameterBigDecimal, rsParameterBigInteger, rsParameterBoolean, rsParameterByte, rsParameterChar, rsParameterDate, rsParameterDouble, rsParameterFloat, rsParameterInteger, rsParameterLong, rsParameterShort, rsParameterTimestamp, rsParameterTime), sqDefaultsNode);
        FakeMetadataObject rsBadDefault = FakeMetadataFactory.createResultSet("pm1.rBadDefault", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject paramBadDefaultRet = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rsBadDefault);
        FakeMetadataObject paramBadDefaultIn = FakeMetadataFactory.createParameter("in", 2, 1, "integer", null);
        paramBadDefaultIn.putProperty("supNull", Boolean.TRUE);
        paramBadDefaultIn.setDefaultValue("Clearly Not An Integer");
        QueryNode sqnBadDefault = new QueryNode("pm1.sqBadDefault", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 FROM pm1.g1 WHERE e2=pm1.sqBadDefault.in; END");
        FakeMetadataObject sqBadDefault = FakeMetadataFactory.createVirtualProcedure("pm1.sqBadDefault", pm1, Arrays.asList(paramBadDefaultRet, paramBadDefaultIn), sqnBadDefault);
        FakeMetadataObject rs3 = FakeMetadataFactory.createResultSet("pm1.rs3", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject rs3p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs3);
        FakeMetadataObject sp1 = FakeMetadataFactory.createStoredProcedure("pm1.sp1", pm1, Arrays.asList(rs3p1), "pm1.sp1");
        FakeMetadataObject rs4 = FakeMetadataFactory.createResultSet("pm1.rs4", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject fakeMetadataObject = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs4);
        QueryNode queryNode = new QueryNode("pm1.sqsp1", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 FROM (EXEC pm1.sp1()) as x; END");
        FakeMetadataObject fakeMetadataObject2 = FakeMetadataFactory.createVirtualProcedure("pm1.sqsp1", pm1, Arrays.asList(rs4p1), sqsp1n1);
        FakeMetadataObject fakeMetadataObject3 = FakeMetadataFactory.createResultSet("pm1.rs6", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject fakeMetadataObject4 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs6);
        QueryNode queryNode2 = new QueryNode("pm1.sq4", "CREATE VIRTUAL PROCEDURE BEGIN EXEC pm1.sq1(); END");
        FakeMetadataObject fakeMetadataObject5 = FakeMetadataFactory.createVirtualProcedure("pm1.sq4", pm1, Arrays.asList(rs6p1), sq4n1);
        FakeMetadataObject fakeMetadataObject6 = FakeMetadataFactory.createResultSet("pm1.rs7", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject fakeMetadataObject7 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs7);
        FakeMetadataObject fakeMetadataObject8 = FakeMetadataFactory.createParameter("in1", 2, 1, "string", null);
        QueryNode queryNode3 = new QueryNode("pm1.sq5", "CREATE VIRTUAL PROCEDURE BEGIN EXEC pm1.sq2(pm1.sq5.in1); END");
        FakeMetadataObject fakeMetadataObject9 = FakeMetadataFactory.createVirtualProcedure("pm1.sq5", pm1, Arrays.asList(rs7p1, rs7p2), sq5n1);
        FakeMetadataObject fakeMetadataObject10 = FakeMetadataFactory.createResultSet("pm1.rs8", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject fakeMetadataObject11 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs8);
        QueryNode queryNode4 = new QueryNode("pm1.sq6", "CREATE VIRTUAL PROCEDURE BEGIN EXEC pm1.sq2('1'); END");
        FakeMetadataObject fakeMetadataObject12 = FakeMetadataFactory.createVirtualProcedure("pm1.sq6", pm1, Arrays.asList(rs8p1), sq6n1);
        FakeMetadataObject fakeMetadataObject13 = FakeMetadataFactory.createResultSet("pm1.rs9", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject fakeMetadataObject14 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs9);
        QueryNode queryNode5 = new QueryNode("pm1.sq7", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 FROM (EXEC pm1.sq1()) as x; END");
        FakeMetadataObject fakeMetadataObject15 = FakeMetadataFactory.createVirtualProcedure("pm1.sq7", pm1, Arrays.asList(rs9p1), sq7n1);
        FakeMetadataObject fakeMetadataObject16 = FakeMetadataFactory.createResultSet("pm1.rs10", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject fakeMetadataObject17 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs10);
        FakeMetadataObject fakeMetadataObject18 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        QueryNode queryNode6 = new QueryNode("pm1.sq8", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 FROM (EXEC pm1.sq1()) as x WHERE x.e1=pm1.sq8.in; END");
        FakeMetadataObject fakeMetadataObject19 = FakeMetadataFactory.createVirtualProcedure("pm1.sq8", pm1, Arrays.asList(rs10p1, rs10p2), sq8n1);
        FakeMetadataObject fakeMetadataObject20 = FakeMetadataFactory.createResultSet("pm1.rs11", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject fakeMetadataObject21 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs11);
        FakeMetadataObject fakeMetadataObject22 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        QueryNode queryNode7 = new QueryNode("pm1.sq9", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 FROM (EXEC pm1.sq2(pm1.sq9.in)) as x; END");
        FakeMetadataObject fakeMetadataObject23 = FakeMetadataFactory.createVirtualProcedure("pm1.sq9", pm1, Arrays.asList(rs11p1, rs11p2), sq9n1);
        FakeMetadataObject fakeMetadataObject24 = FakeMetadataFactory.createResultSet("pm1.rs12", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject fakeMetadataObject25 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs12);
        FakeMetadataObject fakeMetadataObject26 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        FakeMetadataObject fakeMetadataObject27 = FakeMetadataFactory.createParameter("in2", 3, 1, "integer", null);
        QueryNode queryNode8 = new QueryNode("pm1.sq10", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 FROM (EXEC pm1.sq2(pm1.sq10.in)) as x where e2=pm1.sq10.in2; END");
        FakeMetadataObject fakeMetadataObject28 = FakeMetadataFactory.createVirtualProcedure("pm1.sq10", pm1, Arrays.asList(rs12p1, rs12p2, rs12p3), sq10n1);
        FakeMetadataObject fakeMetadataObject29 = FakeMetadataFactory.createResultSet("pm1.rs13", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject fakeMetadataObject30 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs13);
        FakeMetadataObject fakeMetadataObject31 = FakeMetadataFactory.createParameter("in", 2, 1, "integer", null);
        FakeMetadataObject fakeMetadataObject32 = FakeMetadataFactory.createStoredProcedure("pm1.sp2", pm1, Arrays.asList(rs13p1, rs13p2), "pm1.sp2");
        FakeMetadataObject fakeMetadataObject33 = FakeMetadataFactory.createResultSet("pm1.rs14", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject fakeMetadataObject34 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs14);
        FakeMetadataObject fakeMetadataObject35 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        FakeMetadataObject fakeMetadataObject36 = FakeMetadataFactory.createParameter("in2", 3, 1, "integer", null);
        QueryNode queryNode9 = new QueryNode("pm1.sq11", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 FROM (EXEC pm1.sp2(?)) as x where e2=pm1.sq11.in; END");
        FakeMetadataObject fakeMetadataObject37 = FakeMetadataFactory.createVirtualProcedure("pm1.sq11", pm1, Arrays.asList(rs14p1, rs14p2, rs14p3), sq11n1);
        FakeMetadataObject fakeMetadataObject38 = FakeMetadataFactory.createResultSet("pm1.rs15", pm1, new String[]{"count"}, new String[]{"integer"});
        FakeMetadataObject fakeMetadataObject39 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs15);
        FakeMetadataObject fakeMetadataObject40 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        FakeMetadataObject fakeMetadataObject41 = FakeMetadataFactory.createParameter("in2", 3, 1, "integer", null);
        QueryNode queryNode10 = new QueryNode("pm1.sq12", "CREATE VIRTUAL PROCEDURE BEGIN INSERT INTO pm1.g1 ( e1, e2 ) VALUES( pm1.sq12.in, pm1.sq12.in2 ); END");
        FakeMetadataObject fakeMetadataObject42 = FakeMetadataFactory.createVirtualProcedure("pm1.sq12", pm1, Arrays.asList(rs15p1, rs15p2, rs15p3), sq12n1);
        FakeMetadataObject fakeMetadataObject43 = FakeMetadataFactory.createResultSet("pm1.rs16", pm1, new String[]{"count"}, new String[]{"integer"});
        FakeMetadataObject fakeMetadataObject44 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs16);
        FakeMetadataObject fakeMetadataObject45 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        QueryNode queryNode11 = new QueryNode("pm1.sq13", "CREATE VIRTUAL PROCEDURE BEGIN INSERT INTO pm1.g1 ( e1, e2 ) VALUES( pm1.sq13.in, 2 ); END");
        FakeMetadataObject fakeMetadataObject46 = FakeMetadataFactory.createVirtualProcedure("pm1.sq13", pm1, Arrays.asList(rs16p1, rs16p2), sq13n1);
        FakeMetadataObject fakeMetadataObject47 = FakeMetadataFactory.createResultSet("pm1.rs17", pm1, new String[]{"count"}, new String[]{"integer"});
        FakeMetadataObject fakeMetadataObject48 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs17);
        FakeMetadataObject fakeMetadataObject49 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        FakeMetadataObject fakeMetadataObject50 = FakeMetadataFactory.createParameter("in2", 3, 1, "integer", null);
        QueryNode queryNode12 = new QueryNode("pm1.sq14", "CREATE VIRTUAL PROCEDURE BEGIN UPDATE pm1.g1 SET e1 = pm1.sq14.in WHERE e2 = pm1.sq14.in2; END");
        FakeMetadataObject fakeMetadataObject51 = FakeMetadataFactory.createVirtualProcedure("pm1.sq14", pm1, Arrays.asList(rs17p1, rs17p2, rs17p3), sq14n1);
        FakeMetadataObject fakeMetadataObject52 = FakeMetadataFactory.createResultSet("pm1.rs17", pm1, new String[]{"count"}, new String[]{"integer"});
        FakeMetadataObject fakeMetadataObject53 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs18);
        FakeMetadataObject fakeMetadataObject54 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        FakeMetadataObject fakeMetadataObject55 = FakeMetadataFactory.createParameter("in2", 3, 1, "integer", null);
        QueryNode queryNode13 = new QueryNode("pm1.sq15", "CREATE VIRTUAL PROCEDURE BEGIN DELETE FROM pm1.g1 WHERE e1 = pm1.sq15.in AND e2 = pm1.sq15.in2; END");
        FakeMetadataObject fakeMetadataObject56 = FakeMetadataFactory.createVirtualProcedure("pm1.sq15", pm1, Arrays.asList(rs18p1, rs18p2, rs18p3), sq15n1);
        QueryNode queryNode14 = new QueryNode("pm1.sq16", "CREATE VIRTUAL PROCEDURE BEGIN INSERT INTO pm1.g1 ( e1, e2 ) VALUES( 1, 2 ); END");
        FakeMetadataObject fakeMetadataObject57 = FakeMetadataFactory.createVirtualProcedure("pm1.sq16", pm1, new ArrayList(), sq16n1);
        FakeMetadataObject fakeMetadataObject58 = FakeMetadataFactory.createResultSet("pm1.rs19", pm1, new String[]{"xml"}, new String[]{"string"});
        FakeMetadataObject fakeMetadataObject59 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs19);
        QueryNode queryNode15 = new QueryNode("pm1.sq17", "CREATE VIRTUAL PROCEDURE BEGIN SELECT * FROM xmltest.doc1; END");
        FakeMetadataObject fakeMetadataObject60 = FakeMetadataFactory.createVirtualProcedure("pm1.sq17", pm1, Arrays.asList(sq17p1), sq17n1);
        FakeMetadataObject fakeMetadataObject61 = FakeMetadataFactory.createStoredProcedure("pm1.sp3", pm1, new ArrayList(), "pm1.sp3");
        FakeMetadataObject fakeMetadataObject62 = FakeMetadataFactory.createResultSet("pm1.rs20", pm1, new String[]{"xml"}, new String[]{"string"});
        FakeMetadataObject fakeMetadataObject63 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs20);
        QueryNode queryNode16 = new QueryNode("pm1.sq18", "CREATE VIRTUAL PROCEDURE BEGIN SELECT * FROM xmltest.doc1; END");
        FakeMetadataObject fakeMetadataObject64 = FakeMetadataFactory.createVirtualProcedure("pm1.sq18", pm1, Arrays.asList(sq18p1), sq18n1);
        FakeMetadataObject fakeMetadataObject65 = FakeMetadataFactory.createResultSet("pm1.rs21", pm1, new String[]{"xml"}, new String[]{"string"});
        FakeMetadataObject fakeMetadataObject66 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs21);
        FakeMetadataObject fakeMetadataObject67 = FakeMetadataFactory.createParameter("param1", 2, 1, "string", null);
        QueryNode queryNode17 = new QueryNode("pm1.sq19", "CREATE VIRTUAL PROCEDURE BEGIN SELECT * FROM xmltest.doc4 WHERE root.node1 = param1; END");
        FakeMetadataObject fakeMetadataObject68 = FakeMetadataFactory.createVirtualProcedure("pm1.sq19", pm1, Arrays.asList(sq19p1, sq19p2), sq19n1);
        FakeMetadataObject fakeMetadataObject69 = FakeMetadataFactory.createParameter("in", 2, 1, "biginteger", null);
        FakeMetadataObject fakeMetadataObject70 = FakeMetadataFactory.createStoredProcedure("pm1.sp4", pm1, Arrays.asList(rs13p1, rs22p2), "pm1.sp4");
        FakeMetadataObject fakeMetadataObject71 = FakeMetadataFactory.createStoredProcedure("pm1.sp5", pm1, Arrays.asList(new FakeMetadataObject[0]), "pm1.sp5");
        FakeMetadataObject fakeMetadataObject72 = FakeMetadataFactory.createResultSet("pm1.vsprs1", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject fakeMetadataObject73 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", vsprs1);
        QueryNode queryNode18 = new QueryNode("vsp1", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT e2 FROM pm1.g1) AS mycursor BEGIN x=mycursor.e2; IF(x = 15) BEGIN BREAK; END END SELECT e1 FROM pm1.g1 where pm1.g1.e2 = x; END");
        FakeMetadataObject fakeMetadataObject74 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp1", pm1, Arrays.asList(vspp1), vspqn1);
        QueryNode queryNode19 = new QueryNode("vsp2", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT e2 FROM pm1.g1) AS mycursor BEGIN x=mycursor.e2; END SELECT e1 FROM pm1.g1; END");
        FakeMetadataObject fakeMetadataObject75 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp2", pm1, Arrays.asList(vspp1), vspqn2);
        QueryNode queryNode20 = new QueryNode("vsp3", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT e2 FROM pm1.g1) AS mycursor BEGIN x=mycursor.e2; END SELECT e1 FROM pm1.g1 WHERE x=e2; END");
        FakeMetadataObject fakeMetadataObject76 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp3", pm1, Arrays.asList(vspp1), vspqn3);
        QueryNode queryNode21 = new QueryNode("vsp4", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT e2 FROM pm1.g1) AS mycursor BEGIN IF(mycursor.e2 > 10) BEGIN BREAK; END x=mycursor.e2; END SELECT e1 FROM pm1.g1 WHERE x=e2; END");
        FakeMetadataObject fakeMetadataObject77 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp4", pm1, Arrays.asList(vspp1), vspqn4);
        QueryNode queryNode22 = new QueryNode("vsp5", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT e2 FROM pm1.g1) AS mycursor BEGIN IF(mycursor.e2 > 10) BEGIN CONTINUE; END x=mycursor.e2; END SELECT e1 FROM pm1.g1 WHERE x=e2; END");
        FakeMetadataObject fakeMetadataObject78 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp5", pm1, Arrays.asList(vspp1), vspqn5);
        QueryNode queryNode23 = new QueryNode("vsp6", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; x=0; WHILE (x < 15) BEGIN x=x+1; END SELECT e1 FROM pm1.g1 WHERE x=e2; END");
        FakeMetadataObject fakeMetadataObject79 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp6", pm1, Arrays.asList(vspp1), vspqn6);
        FakeMetadataObject fakeMetadataObject80 = FakeMetadataFactory.createParameter("param1", 2, 1, "integer", null);
        QueryNode queryNode24 = new QueryNode("vsp7", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; x=0; WHILE (x < 12) BEGIN x=x+pm1.vsp7.param1; END SELECT e1 FROM pm1.g1 WHERE x=e2; END");
        FakeMetadataObject fakeMetadataObject81 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp7", pm1, Arrays.asList(vspp1, vspp2), vspqn7);
        FakeMetadataObject fakeMetadataObject82 = FakeMetadataFactory.createParameter("param1", 2, 1, "integer", null);
        QueryNode queryNode25 = new QueryNode("vsp8", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; x=0; WHILE (x < 12) BEGIN x=x+pm1.vsp8.param1; END SELECT e1 FROM pm1.g1 WHERE e2 >= param1; END");
        FakeMetadataObject fakeMetadataObject83 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp8", pm1, Arrays.asList(vspp1, vspp8), vspqn8);
        FakeMetadataObject fakeMetadataObject84 = FakeMetadataFactory.createParameter("param1", 2, 1, "integer", null);
        QueryNode queryNode26 = new QueryNode("vsp9", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; x=0; WHILE (x < param1) BEGIN x=x+pm1.vsp9.param1; END SELECT e1 FROM pm1.g1 WHERE e2 >= param1; END");
        FakeMetadataObject fakeMetadataObject85 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp9", pm1, Arrays.asList(vspp1, vspp9), vspqn9);
        FakeMetadataObject fakeMetadataObject86 = FakeMetadataFactory.createParameter("param1", 1, 1, "integer", null);
        QueryNode queryNode27 = new QueryNode("vsp10", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT e2 FROM pm1.g1 WHERE e2=param1) AS mycursor BEGIN x=mycursor.e2; END END");
        FakeMetadataObject fakeMetadataObject87 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp10", pm1, Arrays.asList(vspp3), vspqn10);
        QueryNode queryNode28 = new QueryNode("vsp11", "CREATE VIRTUAL PROCEDURE BEGIN LOOP ON (SELECT e2 FROM pm1.g1) AS mycursor BEGIN LOOP ON (SELECT e1 FROM pm1.g1) AS mycursor BEGIN END END SELECT e1 FROM pm1.g1; END");
        FakeMetadataObject fakeMetadataObject88 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp11", pm1, Arrays.asList(vspp1), vspqn11);
        QueryNode queryNode29 = new QueryNode("vsp12", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT e2 FROM pm1.g1) AS mycursor BEGIN END x=mycursor.e2; SELECT e1 FROM pm1.g1; END");
        FakeMetadataObject fakeMetadataObject89 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp12", pm1, Arrays.asList(vspp1), vspqn12);
        FakeMetadataObject fakeMetadataObject90 = FakeMetadataFactory.createResultSet("pm1.vsprs2", pm1, new String[]{"e1", "const"}, new String[]{"string", "integer"});
        FakeMetadataObject fakeMetadataObject91 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", vsprs2);
        QueryNode queryNode30 = new QueryNode("vsp13", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE string x; LOOP ON (SELECT e1 FROM pm1.g1) AS mycursor BEGIN x=mycursor.e1; END SELECT x, 5; END");
        FakeMetadataObject fakeMetadataObject92 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp13", pm1, Arrays.asList(vspp4), vspqn13);
        QueryNode queryNode31 = new QueryNode("vsp14", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 INTO #temptable FROM pm1.g1; SELECT e1 FROM #temptable; END");
        FakeMetadataObject fakeMetadataObject93 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp14", pm1, Arrays.asList(vspp1), vspqn14);
        QueryNode queryNode32 = new QueryNode("vsp15", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 INTO #temptable FROM pm1.g1; SELECT #temptable.e1 FROM #temptable, pm1.g2 WHERE #temptable.e2 = pm1.g2.e2; END");
        FakeMetadataObject fakeMetadataObject94 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp15", pm1, Arrays.asList(vspp1), vspqn15);
        QueryNode queryNode33 = new QueryNode("vsp16", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 INTO #temptable FROM pm1.g1; SELECT a.e1 FROM (SELECT pm1.g2.e1 FROM #temptable, pm1.g2 WHERE #temptable.e2 = pm1.g2.e2) AS a; END");
        FakeMetadataObject fakeMetadataObject95 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp16", pm1, Arrays.asList(vspp1), vspqn16);
        QueryNode queryNode34 = new QueryNode("vsp17", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; SELECT e1, e2 INTO #temptable FROM pm1.g1; LOOP ON (SELECT e1, e2 FROM #temptable) AS mycursor BEGIN x=mycursor.e2; END SELECT e1 FROM pm1.g1 WHERE x=e2; END");
        FakeMetadataObject fakeMetadataObject96 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp17", pm1, Arrays.asList(vspp1), vspqn17);
        QueryNode queryNode35 = new QueryNode("vsp18", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 INTO temptable FROM pm1.g1; END");
        FakeMetadataObject fakeMetadataObject97 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp18", pm1, Arrays.asList(vspp1), vspqn18);
        QueryNode queryNode36 = new QueryNode("vsp19", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 INTO #temptable FROM pm1.g1; SELECT e1 INTO #temptable FROM pm1.g1; SELECT e1 FROM #temptable; END");
        FakeMetadataObject fakeMetadataObject98 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp19", pm1, Arrays.asList(vspp1), vspqn19);
        QueryNode queryNode37 = new QueryNode("vsp20", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 INTO #temptable FROM pm1.g1; INSERT INTO #temptable(e1) VALUES( 'Fourth'); SELECT e1 FROM #temptable; END");
        FakeMetadataObject fakeMetadataObject99 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp20", pm1, Arrays.asList(vspp1), vspqn20);
        FakeMetadataObject fakeMetadataObject100 = FakeMetadataFactory.createParameter("param1", 2, 1, "integer", null);
        QueryNode queryNode38 = new QueryNode("vsp21", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 INTO #temptable FROM pm1.g1; INSERT INTO #temptable(#temptable.e1, e2) VALUES( 'Fourth', param1); SELECT e1, e2 FROM #temptable; END");
        FakeMetadataObject fakeMetadataObject101 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp21", pm1, Arrays.asList(vspp4, vspp21), vspqn21);
        FakeMetadataObject fakeMetadataObject102 = FakeMetadataFactory.createParameter("param1", 2, 1, "integer", null);
        QueryNode queryNode39 = new QueryNode("vsp22", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 INTO #temptable FROM pm1.g1 where e2 > param1; SELECT e1, e2 FROM #temptable; END");
        FakeMetadataObject fakeMetadataObject103 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp22", pm1, Arrays.asList(vspp4, vspp22), vspqn22);
        FakeMetadataObject fakeMetadataObject104 = FakeMetadataFactory.createParameter("param1", 2, 1, "integer", null);
        QueryNode queryNode40 = new QueryNode("vsp23", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE string x; SELECT e1, e2 INTO #temptable FROM pm1.g1 where e2 > param1; x = SELECT e1 FROM #temptable WHERE e2=15; SELECT x, 15; END");
        FakeMetadataObject fakeMetadataObject105 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp23", pm1, Arrays.asList(vspp4, vspp23), vspqn23);
        QueryNode queryNode41 = new QueryNode("vsp24", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 INTO #temptable FROM pm1.g1; SELECT #temptable.e1 FROM #temptable WHERE #temptable.e2=15; END");
        FakeMetadataObject fakeMetadataObject106 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp24", pm1, Arrays.asList(vspp4), vspqn24);
        QueryNode queryNode42 = new QueryNode("vsp25", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 INTO #temptable FROM pm1.g1 WHERE e1 ='no match'; SELECT e1 FROM #temptable; END");
        FakeMetadataObject fakeMetadataObject107 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp25", pm1, Arrays.asList(vspp1), vspqn25);
        QueryNode queryNode43 = new QueryNode("vsp27", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 from (exec pm1.vsp25())as c; END");
        FakeMetadataObject fakeMetadataObject108 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp27", pm1, Arrays.asList(vspp1), vspqn27);
        QueryNode queryNode44 = new QueryNode("vsp28", "CREATE VIRTUAL PROCEDURE BEGIN SELECT 0 AS e1 ORDER BY e1; END");
        FakeMetadataObject fakeMetadataObject109 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp28", pm1, Arrays.asList(vspp1), vspqn28);
        QueryNode queryNode45 = new QueryNode("vsp29", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 FROM pm1.g1 ORDER BY e1; END");
        FakeMetadataObject fakeMetadataObject110 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp29", pm1, Arrays.asList(vspp1), vspqn29);
        FakeMetadataObject fakeMetadataObject111 = FakeMetadataFactory.createResultSet("pm1.vsprs30", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject fakeMetadataObject112 = FakeMetadataFactory.createParameter("ret", 1, 5, null, vsprs30);
        QueryNode queryNode46 = new QueryNode("vsp30", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 FROM pm1.g1; END");
        FakeMetadataObject fakeMetadataObject113 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp30", pm1, Arrays.asList(vsp30p1), vspqn30);
        FakeMetadataObject fakeMetadataObject114 = FakeMetadataFactory.createResultSet("pm1.vsprs31", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject fakeMetadataObject115 = FakeMetadataFactory.createParameter("ret", 1, 5, null, vsprs31);
        FakeMetadataObject fakeMetadataObject116 = FakeMetadataFactory.createParameter("p1", 2, 1, "integer", null);
        QueryNode queryNode47 = new QueryNode("vsp31", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 FROM pm1.g1 WHERE e2 = pm1.vsp31.p1; END");
        FakeMetadataObject fakeMetadataObject117 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp31", pm1, Arrays.asList(vsp31p1, vsp31p2), vspqn31);
        QueryNode queryNode48 = new QueryNode("vsp38", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer VARIABLES.y; VARIABLES.y=5; EXEC pm1.vsp7(VARIABLES.y); END");
        FakeMetadataObject fakeMetadataObject118 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp38", pm1, Arrays.asList(vspp1), vspqn38);
        QueryNode queryNode49 = new QueryNode("vsp39", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer VARIABLES.x; VARIABLES.x=5; EXEC pm1.vsp7(VARIABLES.x); END");
        FakeMetadataObject fakeMetadataObject119 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp39", pm1, Arrays.asList(vspp1), vspqn39);
        QueryNode queryNode50 = new QueryNode("vsp40", "CREATE VIRTUAL PROCEDURE BEGIN LOOP ON (SELECT e2 FROM pm1.g1) AS mycursor BEGIN EXEC pm1.vsp41(); END END");
        FakeMetadataObject fakeMetadataObject120 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp40", pm1, Arrays.asList(vspp1), vspqn40);
        QueryNode queryNode51 = new QueryNode("vsp41", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1 FROM pm1.g1 where e2=15; END");
        FakeMetadataObject fakeMetadataObject121 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp41", pm1, Arrays.asList(vspp1), vspqn41);
        vm1g1.putProperty("insertProcedure", "CREATE PROCEDURE BEGIN ROWS_UPDATED = INSERT INTO pm1.g1(e1, e2, e3, e4) values(INPUT.e1, INPUT.e2, INPUT.e3, INPUT.e4); END");
        vm1g1.putProperty("updateProcedure", "CREATE PROCEDURE BEGIN ROWS_UPDATED = UPDATE pm1.g1 SET e1 = INPUT.e1, e2 = INPUT.e2, e3 = INPUT.e3, e4=INPUT.e4 WHERE TRANSLATE CRITERIA; END");
        vm1g1.putProperty("deleteProcedure", "CREATE PROCEDURE BEGIN ROWS_UPDATED = DELETE FROM pm1.g1 WHERE TRANSLATE CRITERIA; END");
        vm1g37.putProperty("insertProcedure", "CREATE PROCEDURE BEGIN ROWS_UPDATED = INSERT INTO pm4.g1(e1, e2, e3, e4) values(INPUT.e1, INPUT.e2, INPUT.e3, INPUT.e4); END");
        vm1g37.putProperty("deleteProcedure", "CREATE PROCEDURE BEGIN ROWS_UPDATED = DELETE FROM pm4.g1 where translate criteria; END");
        QueryNode queryNode52 = new QueryNode("vsp37", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; VARIABLES.x=5; INSERT INTO vm1.g1(e2) values(VARIABLES.x); END");
        FakeMetadataObject fakeMetadataObject122 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp37", pm1, Arrays.asList(vspp1), vspqn37);
        QueryNode queryNode53 = new QueryNode("vsp33", new StringBuffer("CREATE VIRTUAL PROCEDURE").append(" BEGIN").append(" SELECT 3 AS temp1 INTO #myTempTable;").append(" SELECT 2 AS temp1 INTO #myTempTable;").append(" SELECT 1 AS temp1 INTO #myTempTable;").append(" SELECT temp1 AS e1 FROM #myTempTable ORDER BY e1;").append(" END").toString());
        FakeMetadataObject fakeMetadataObject123 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp33", pm1, Arrays.asList(vspp1), vspqn33);
        QueryNode queryNode54 = new QueryNode("vsp35", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer VARIABLES.ID; VARIABLES.ID = pm1.vsp35.p1; SELECT e1 FROM pm1.g1 WHERE e2 = VARIABLES.ID; END");
        FakeMetadataObject fakeMetadataObject124 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp35", pm1, Arrays.asList(vsp31p1, vsp31p2), vspqn35);
        QueryNode queryNode55 = new QueryNode("vsp34", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, 0 AS const FROM pm1.g1 ORDER BY const; END");
        FakeMetadataObject fakeMetadataObject125 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp34", pm1, Arrays.asList(vspp4), vspqn34);
        QueryNode queryNode56 = new QueryNode("vsp45", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 INTO #temptable FROM pm1.g1; SELECT #temptable.e1 FROM #temptable where #temptable.e1 in (SELECT pm1.g2.e1 FROM pm1.g2 ); END");
        FakeMetadataObject fakeMetadataObject126 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp45", pm1, Arrays.asList(vspp1), vspqn45);
        QueryNode queryNode57 = new QueryNode("vsp47", "CREATE VIRTUAL PROCEDURE BEGIN IF (pm1.vsp47.param1 IS NOT NULL) BEGIN SELECT 'FOO' as e1, pm1.vsp47.param1 as e2; END ELSE BEGIN SELECT pm1.vsp47.param2 as e1, 2112 as e2; END END");
        FakeMetadataObject fakeMetadataObject127 = FakeMetadataFactory.createResultSet("pm1.vsprs47", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject fakeMetadataObject128 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", vsprs47);
        FakeMetadataObject fakeMetadataObject129 = FakeMetadataFactory.createParameter("param1", 2, 1, "integer", null);
        vspp47_2.putProperty("supNull", Boolean.TRUE);
        FakeMetadataObject fakeMetadataObject130 = FakeMetadataFactory.createParameter("param2", 3, 1, "string", null);
        vspp47_3.putProperty("supNull", Boolean.TRUE);
        FakeMetadataObject fakeMetadataObject131 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp47", pm1, Arrays.asList(vspp47_1, vspp47_2, vspp47_3), vspqn47);
        QueryNode queryNode58 = new QueryNode("vm1.vgvp7", "SELECT P.e2 as ve3, P.e1 as ve4 FROM (EXEC pm1.vsp47(param1=vm1.vgvp7.ve1, param2=vm1.vgvp7.ve2)) as P");
        FakeMetadataObject fakeMetadataObject132 = FakeMetadataFactory.createVirtualGroup("vm1.vgvp7", vm1, vgvpn7);
        FakeMetadataObject fakeMetadataObject133 = FakeMetadataFactory.createElement("vm1.vgvp7.ve1", (FakeMetadataObject)vgvp7, "integer", 0);
        vgvp7e1.putProperty("isProcedureInputElement", Boolean.TRUE);
        vgvp7e1.putProperty("supSelect", Boolean.FALSE);
        FakeMetadataObject fakeMetadataObject134 = FakeMetadataFactory.createElement("vm1.vgvp7.ve2", (FakeMetadataObject)vgvp7, "string", 1);
        vgvp7e2.putProperty("isProcedureInputElement", Boolean.TRUE);
        vgvp7e2.putProperty("supSelect", Boolean.FALSE);
        FakeMetadataObject fakeMetadataObject135 = FakeMetadataFactory.createElement("vm1.vgvp7.ve3", (FakeMetadataObject)vgvp7, "string", 2);
        FakeMetadataObject fakeMetadataObject136 = FakeMetadataFactory.createElement("vm1.vgvp7.ve4", (FakeMetadataObject)vgvp7, "string", 3);
        QueryNode queryNode59 = new QueryNode("vsp32", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; LOOP ON (SELECT e2 FROM pm1.g1) AS #mycursor BEGIN IF(#mycursor.e2 > 10) BEGIN CONTINUE; END x=#mycursor.e2; END SELECT e1 FROM pm1.g1 WHERE x=e2; END");
        FakeMetadataObject fakeMetadataObject137 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp32", pm1, Arrays.asList(vspp1), vspqn32);
        QueryNode queryNode60 = new QueryNode("vsp26", "CREATE VIRTUAL PROCEDURE BEGIN SELECT e1, e2 FROM pm1.g1 WHERE e2 >= pm1.vsp26.param1 and e1 = pm1.vsp26.param2; END");
        FakeMetadataObject fakeMetadataObject138 = FakeMetadataFactory.createParameter("param1", 2, 1, "integer", null);
        FakeMetadataObject fakeMetadataObject139 = FakeMetadataFactory.createParameter("param2", 3, 1, "string", null);
        FakeMetadataObject fakeMetadataObject140 = FakeMetadataFactory.createResultSet("pm1.vsprs3", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject fakeMetadataObject141 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", vsprs3);
        FakeMetadataObject fakeMetadataObject142 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp26", pm1, Arrays.asList(vspp6, vspp26_1, vspp26_2), vspqn26);
        QueryNode queryNode61 = new QueryNode("vm1.vgvp1", "SELECT P.e1 as ve3 FROM (EXEC pm1.vsp26(vm1.vgvp1.ve1, vm1.vgvp1.ve2)) as P");
        FakeMetadataObject fakeMetadataObject143 = FakeMetadataFactory.createVirtualGroup("vm1.vgvp1", vm1, vgvpn1);
        FakeMetadataObject fakeMetadataObject144 = FakeMetadataFactory.createElement("vm1.vgvp1.ve1", (FakeMetadataObject)vgvp1, "integer", 0);
        vgvp1e1.putProperty("isProcedureInputElement", Boolean.TRUE);
        vgvp1e1.putProperty("supSelect", Boolean.FALSE);
        FakeMetadataObject fakeMetadataObject145 = FakeMetadataFactory.createElement("vm1.vgvp1.ve2", (FakeMetadataObject)vgvp1, "string", 1);
        vgvp1e2.putProperty("isProcedureInputElement", Boolean.TRUE);
        vgvp1e2.putProperty("supSelect", Boolean.FALSE);
        FakeMetadataObject fakeMetadataObject146 = FakeMetadataFactory.createElement("vm1.vgvp1.ve3", (FakeMetadataObject)vgvp1, "string", 2);
        QueryNode queryNode62 = new QueryNode("vm1.vgvp2", "SELECT P.e1 as ve3 FROM (EXEC pm1.vsp26(vm1.vgvp2.ve1, vm1.vgvp2.ve2)) as P where P.e1='a'");
        FakeMetadataObject fakeMetadataObject147 = FakeMetadataFactory.createVirtualGroup("vm1.vgvp2", vm1, vgvpn2);
        FakeMetadataObject fakeMetadataObject148 = FakeMetadataFactory.createElement("vm1.vgvp2.ve1", (FakeMetadataObject)vgvp2, "integer", 0);
        vgvp2e1.putProperty("isProcedureInputElement", Boolean.TRUE);
        vgvp2e1.putProperty("supSelect", Boolean.FALSE);
        FakeMetadataObject fakeMetadataObject149 = FakeMetadataFactory.createElement("vm1.vgvp2.ve2", (FakeMetadataObject)vgvp2, "string", 1);
        vgvp2e2.putProperty("isProcedureInputElement", Boolean.TRUE);
        vgvp2e2.putProperty("supSelect", Boolean.FALSE);
        FakeMetadataObject fakeMetadataObject150 = FakeMetadataFactory.createElement("vm1.vgvp2.ve3", (FakeMetadataObject)vgvp2, "string", 2);
        QueryNode queryNode63 = new QueryNode("vm1.vgvp3", "SELECT P.e1 as ve3 FROM (EXEC pm1.vsp26(vm1.vgvp3.ve1, vm1.vgvp3.ve2)) as P, pm1.g2 where P.e1=g2.e1");
        FakeMetadataObject fakeMetadataObject151 = FakeMetadataFactory.createVirtualGroup("vm1.vgvp3", vm1, vgvpn3);
        FakeMetadataObject fakeMetadataObject152 = FakeMetadataFactory.createElement("vm1.vgvp3.ve1", (FakeMetadataObject)vgvp3, "integer", 0);
        vgvp3e1.putProperty("isProcedureInputElement", Boolean.TRUE);
        vgvp3e1.putProperty("supSelect", Boolean.FALSE);
        FakeMetadataObject fakeMetadataObject153 = FakeMetadataFactory.createElement("vm1.vgvp3.ve2", (FakeMetadataObject)vgvp3, "string", 1);
        vgvp3e2.putProperty("isProcedureInputElement", Boolean.TRUE);
        vgvp3e2.putProperty("supSelect", Boolean.FALSE);
        FakeMetadataObject fakeMetadataObject154 = FakeMetadataFactory.createElement("vm1.vgvp3.ve3", (FakeMetadataObject)vgvp3, "string", 2);
        QueryNode queryNode64 = new QueryNode("vm1.vgvp4", "SELECT P.e1 as ve3 FROM (EXEC pm1.vsp26(vm1.vgvp4.ve1, vm1.vgvp4.ve2)) as P, vm1.g1 where P.e1=g1.e1");
        FakeMetadataObject fakeMetadataObject155 = FakeMetadataFactory.createVirtualGroup("vm1.vgvp4", vm1, vgvpn4);
        FakeMetadataObject fakeMetadataObject156 = FakeMetadataFactory.createElement("vm1.vgvp4.ve1", (FakeMetadataObject)vgvp4, "integer", 0);
        vgvp4e1.putProperty("isProcedureInputElement", Boolean.TRUE);
        vgvp4e1.putProperty("supSelect", Boolean.FALSE);
        FakeMetadataObject fakeMetadataObject157 = FakeMetadataFactory.createElement("vm1.vgvp4.ve2", (FakeMetadataObject)vgvp4, "string", 1);
        vgvp4e2.putProperty("isProcedureInputElement", Boolean.TRUE);
        vgvp4e2.putProperty("supSelect", Boolean.FALSE);
        FakeMetadataObject fakeMetadataObject158 = FakeMetadataFactory.createElement("vm1.vgvp4.ve3", (FakeMetadataObject)vgvp4, "string", 2);
        QueryNode queryNode65 = new QueryNode("vm1.vgvp5", "SELECT * FROM vm1.vgvp4 where vm1.vgvp4.ve1=vm1.vgvp5.ve1 and  vm1.vgvp4.ve2=vm1.vgvp5.ve2");
        FakeMetadataObject fakeMetadataObject159 = FakeMetadataFactory.createVirtualGroup("vm1.vgvp5", vm1, vgvpn5);
        FakeMetadataObject fakeMetadataObject160 = FakeMetadataFactory.createElement("vm1.vgvp5.ve1", (FakeMetadataObject)vgvp5, "integer", 0);
        vgvp5e1.putProperty("isProcedureInputElement", Boolean.TRUE);
        vgvp5e1.putProperty("supSelect", Boolean.FALSE);
        FakeMetadataObject fakeMetadataObject161 = FakeMetadataFactory.createElement("vm1.vgvp5.ve2", (FakeMetadataObject)vgvp5, "string", 1);
        vgvp5e2.putProperty("isProcedureInputElement", Boolean.TRUE);
        vgvp5e2.putProperty("supSelect", Boolean.FALSE);
        FakeMetadataObject fakeMetadataObject162 = FakeMetadataFactory.createElement("vm1.vgvp5.ve3", (FakeMetadataObject)vgvp5, "string", 2);
        QueryNode queryNode66 = new QueryNode("vm1.vgvp6", "SELECT P.e1 as ve3, P.e2 as ve4 FROM (EXEC pm1.vsp26(vm1.vgvp6.ve1, vm1.vgvp6.ve2)) as P");
        FakeMetadataObject fakeMetadataObject163 = FakeMetadataFactory.createVirtualGroup("vm1.vgvp6", vm1, vgvpn6);
        FakeMetadataObject fakeMetadataObject164 = FakeMetadataFactory.createElement("vm1.vgvp6.ve1", (FakeMetadataObject)vgvp6, "integer", 0);
        vgvp6e1.putProperty("isProcedureInputElement", Boolean.TRUE);
        vgvp6e1.putProperty("supSelect", Boolean.FALSE);
        FakeMetadataObject fakeMetadataObject165 = FakeMetadataFactory.createElement("vm1.vgvp6.ve2", (FakeMetadataObject)vgvp6, "string", 1);
        vgvp6e2.putProperty("isProcedureInputElement", Boolean.TRUE);
        vgvp6e2.putProperty("supSelect", Boolean.FALSE);
        FakeMetadataObject fakeMetadataObject166 = FakeMetadataFactory.createElement("vm1.vgvp6.ve3", (FakeMetadataObject)vgvp6, "string", 2);
        FakeMetadataObject fakeMetadataObject167 = FakeMetadataFactory.createElement("vm1.vgvp6.ve4", (FakeMetadataObject)vgvp6, "integer", 3);
        QueryNode queryNode67 = new QueryNode("vm1.g35", "SELECT e1, e2 FROM pm1.g1");
        FakeMetadataObject fakeMetadataObject168 = FakeMetadataFactory.createVirtualGroup("vm1.g35", vm1, vm1g35n1);
        FakeMetadataObject fakeMetadataObject169 = FakeMetadataFactory.createElement("vm1.g35.e1", (FakeMetadataObject)vm1g35, "string", 1);
        vm1g35e1.putProperty("supSelect", Boolean.FALSE);
        FakeMetadataObject fakeMetadataObject170 = FakeMetadataFactory.createElement("vm1.g35.e2", (FakeMetadataObject)vm1g35, "string", 2);
        FakeMetadataObject fakeMetadataObject171 = FakeMetadataFactory.createResultSet("pm1.vsprs36", pm1, new String[]{"x"}, new String[]{"integer"});
        FakeMetadataObject fakeMetadataObject172 = FakeMetadataFactory.createParameter("ret", 1, 5, null, vsprs36);
        FakeMetadataObject fakeMetadataObject173 = FakeMetadataFactory.createParameter("param1", 2, 1, "integer", null);
        QueryNode queryNode68 = new QueryNode("vsp36", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE integer x; x = pm1.vsp36.param1 * 2; SELECT x; END");
        FakeMetadataObject fakeMetadataObject174 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp36", pm1, Arrays.asList(vsp36p1, vsp36p2), vspqn36);
        FakeMetadataObject fakeMetadataObject175 = FakeMetadataFactory.createResultSet("pm1.vsprs42", pm1, new String[]{"x"}, new String[]{"integer"});
        FakeMetadataObject fakeMetadataObject176 = FakeMetadataFactory.createParameter("ret", 1, 5, null, vsprs42);
        FakeMetadataObject fakeMetadataObject177 = FakeMetadataFactory.createParameter("param1", 2, 1, "integer", null);
        QueryNode queryNode69 = new QueryNode("vsp42", "CREATE VIRTUAL PROCEDURE BEGIN IF (pm1.vsp42.param1 > 0) SELECT 1 AS x; ELSE SELECT 0 AS x; END");
        FakeMetadataObject fakeMetadataObject178 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp42", pm1, Arrays.asList(vsp42p1, vsp42p2), vspqn42);
        FakeMetadataObject fakeMetadataObject179 = FakeMetadataFactory.createParameter("param1", 2, 1, "integer", null);
        QueryNode queryNode70 = new QueryNode("vsp44", "CREATE VIRTUAL PROCEDURE BEGIN SELECT pm1.vsp44.param1 INTO #temptable; SELECT e1 from pm1.g1; END");
        FakeMetadataObject fakeMetadataObject180 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp44", pm1, Arrays.asList(vspp1, vspp44), vspqn44);
        FakeMetadataObject fakeMetadataObject181 = FakeMetadataFactory.createParameter("param1", 2, 1, "integer", null);
        QueryNode queryNode71 = new QueryNode("vsp43", "CREATE VIRTUAL PROCEDURE BEGIN exec pm1.vsp44(pm1.vsp43.param1); END");
        FakeMetadataObject fakeMetadataObject182 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp43", pm1, Arrays.asList(vspp1, vspp43), vspqn43);
        QueryNode queryNode72 = new QueryNode("vsp46", "CREATE VIRTUAL PROCEDURE BEGIN create local temporary table #temptable (e1 string, e2 string); LOOP ON (SELECT e1 FROM pm1.g1) AS mycursor BEGIN select mycursor.e1, a.e1 as e2 into #temptable from (SELECT pm1.g1.e1 FROM pm1.g1 where pm1.g1.e1 = mycursor.e1) a; END SELECT e1 FROM #temptable; END");
        FakeMetadataObject fakeMetadataObject183 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp46", pm1, Arrays.asList(vspp1), vspqn46);
        FakeMetadataObject fakeMetadataObject184 = FakeMetadataFactory.createResultSet("pm1vsp48.rs", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject fakeMetadataObject185 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", vsp48rs);
        FakeMetadataObject fakeMetadataObject186 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        QueryNode queryNode73 = new QueryNode("vsp48", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE string x; SELECT e1 FROM (EXEC pm1.sq2(pm1.vsp48.in)) as e; END");
        FakeMetadataObject fakeMetadataObject187 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp48", pm1, Arrays.asList(vsp48p1, vsp48p2), vspqn48);
        FakeMetadataObject fakeMetadataObject188 = FakeMetadataFactory.createResultSet("pm1vsp49.rs", pm1, new String[]{"e1", "e2"}, new String[]{"string", "integer"});
        FakeMetadataObject fakeMetadataObject189 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", vsp49rs);
        QueryNode queryNode74 = new QueryNode("vsp49", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE string x; x = 'b'; EXEC pm1.sq2(x); END");
        FakeMetadataObject fakeMetadataObject190 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp49", pm1, Arrays.asList(vsp49p1), vspqn49);
        FakeMetadataObject fakeMetadataObject191 = FakeMetadataFactory.createResultSet("pm1vsp50.rs", pm1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject fakeMetadataObject192 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", vsp50rs);
        QueryNode queryNode75 = new QueryNode("vsp50", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE string x; x = 'b'; SELECT e1 FROM (EXEC pm1.sq2(x)) as e; END");
        FakeMetadataObject fakeMetadataObject193 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp50", pm1, Arrays.asList(vsp50p1), vspqn50);
        FakeMetadataObject fakeMetadataObject194 = FakeMetadataFactory.createResultSet("pm1vsp51.rs", pm1, new String[]{"result"}, new String[]{"string"});
        FakeMetadataObject fakeMetadataObject195 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", vsp51rs);
        QueryNode queryNode76 = new QueryNode("vsp51", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE string x; x = 'b'; LOOP ON (SELECT e1 FROM (EXEC pm1.sq2(x)) as e) AS c BEGIN x = x || 'b'; END SELECT x AS result; END");
        FakeMetadataObject fakeMetadataObject196 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp51", pm1, Arrays.asList(vsp51p1), vspqn51);
        FakeMetadataObject fakeMetadataObject197 = FakeMetadataFactory.createResultSet("pm1vsp52.rs", pm1, new String[]{"result"}, new String[]{"string"});
        FakeMetadataObject fakeMetadataObject198 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", vsp52rs);
        QueryNode queryNode77 = new QueryNode("vsp52", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE string x; x = 'c'; x = SELECT e1 FROM (EXEC pm1.sq2(x)) as e; SELECT x AS result; END");
        FakeMetadataObject fakeMetadataObject199 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp52", pm1, Arrays.asList(vsp52p1), vspqn52);
        FakeMetadataObject fakeMetadataObject200 = FakeMetadataFactory.createResultSet("pm1vsp53.rs", pm1, new String[]{"result"}, new String[]{"string"});
        FakeMetadataObject fakeMetadataObject201 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", vsp53rs);
        FakeMetadataObject fakeMetadataObject202 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        QueryNode queryNode78 = new QueryNode("vsp53", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE string x; x = 'b'; LOOP ON (SELECT e1 FROM (EXEC pm1.sq2(pm1.vsp53.in)) as e) AS c BEGIN x = x || 'b'; END SELECT x AS result; END");
        FakeMetadataObject fakeMetadataObject203 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp53", pm1, Arrays.asList(vsp53p1, vsp53p2), vspqn53);
        FakeMetadataObject fakeMetadataObject204 = FakeMetadataFactory.createResultSet("pm1vsp54.rs", pm1, new String[]{"result"}, new String[]{"string"});
        FakeMetadataObject fakeMetadataObject205 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", vsp54rs);
        FakeMetadataObject fakeMetadataObject206 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        QueryNode queryNode79 = new QueryNode("vsp54", "CREATE VIRTUAL PROCEDURE BEGIN DECLARE string x; x = 'c'; x = SELECT e1 FROM (EXEC pm1.sq2(pm1.vsp54.in)) as e; SELECT x AS result; END");
        FakeMetadataObject fakeMetadataObject207 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp54", pm1, Arrays.asList(vsp54p1, vsp54p2), vspqn54);
        FakeMetadataObject fakeMetadataObject208 = FakeMetadataFactory.createParameter("param1", 2, 1, "integer", null);
        QueryNode queryNode80 = new QueryNode("vsp55", "CREATE VIRTUAL PROCEDURE BEGIN select e1, param1 as a from vm1.g1; END");
        FakeMetadataObject fakeMetadataObject209 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp55", pm1, Arrays.asList(vspp1, vspp55), vspqn55);
        QueryNode queryNode81 = new QueryNode("vsp56", "CREATE VIRTUAL PROCEDURE BEGIN SELECT * INTO #temptable FROM pm1.g1; SELECT #temptable.e1 FROM #temptable; END");
        FakeMetadataObject fakeMetadataObject210 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp56", pm1, Arrays.asList(vspp1), vspqn56);
        QueryNode queryNode82 = new QueryNode("vsp57", "CREATE VIRTUAL PROCEDURE BEGIN SELECT * INTO #temptable FROM pm1.g1; SELECT #temptable.e1 FROM #temptable order by #temptable.e1; END");
        FakeMetadataObject fakeMetadataObject211 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp57", pm1, Arrays.asList(vspp1), vspqn57);
        FakeMetadataObject fakeMetadataObject212 = FakeMetadataFactory.createParameter("inp", 2, 1, "integer", null);
        QueryNode queryNode83 = new QueryNode("vsp58", "CREATE VIRTUAL PROCEDURE BEGIN SELECT vsp58.inp; END");
        FakeMetadataObject fakeMetadataObject213 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp58", pm1, Arrays.asList(vspp1, vspp58), vspqn58);
        QueryNode queryNode84 = new QueryNode("vsp59", "CREATE VIRTUAL PROCEDURE BEGIN SELECT * INTO #temp FROM pm5.g3;INSERT INTO #temp (e1, e2) VALUES('integer',1); END");
        FakeMetadataObject fakeMetadataObject214 = FakeMetadataFactory.createVirtualProcedure("pm5.vsp59", pm6, Arrays.asList(vspp1), vspqn59);
        QueryNode queryNode85 = new QueryNode("vsp60", "CREATE VIRTUAL PROCEDURE BEGIN create local temporary table temp_table (column1 string);insert into temp_table (column1) values ('First');insert into temp_table (column1) values ('Second');insert into temp_table (column1) values ('Third');select * from temp_table; END");
        FakeMetadataObject fakeMetadataObject215 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp60", pm1, Arrays.asList(vspp1), vspqn60);
        QueryNode queryNode86 = new QueryNode("vsp61", "CREATE VIRTUAL PROCEDURE BEGIN create local temporary table temp_table (column1 string);insert into temp_table (column1) values ('First');drop table temp_table;create local temporary table temp_table (column1 string);insert into temp_table (column1) values ('First');insert into temp_table (column1) values ('Second');insert into temp_table (column1) values ('Third');select * from temp_table; END");
        FakeMetadataObject fakeMetadataObject216 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp61", pm1, Arrays.asList(vspp1), vspqn61);
        QueryNode queryNode87 = new QueryNode("vsp62", "CREATE VIRTUAL PROCEDURE BEGIN create local temporary table temp_table (column1 string); select e1 as column1 into temp_table from pm1.g1;select * from temp_table; END");
        FakeMetadataObject fakeMetadataObject217 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp62", pm1, Arrays.asList(vspp1), vspqn62);
        QueryNode queryNode88 = new QueryNode("vsp63", "CREATE VIRTUAL PROCEDURE BEGIN declare string o; if(1>0) begin declare string a; a='b'; o=a; end if(1>0) begin declare string a; a='c'; o=a; end  select o; END");
        FakeMetadataObject fakeMetadataObject218 = FakeMetadataFactory.createVirtualProcedure("pm1.vsp63", pm1, Arrays.asList(vspp1), vspqn63);
        FakeMetadataStore fakeMetadataStore = new FakeMetadataStore();
        store.addObject((FakeMetadataObject)vsp63);
        store.addObject(pm1);
        store.addObject(pm1g1);
        store.addObjects(pm1g1e);
        store.addObject(pm1g2);
        store.addObjects(pm1g2e);
        store.addObject(pm1g3);
        store.addObjects(pm1g3e);
        store.addObject(pm1g4);
        store.addObjects(pm1g4e);
        store.addObject(pm1g5);
        store.addObjects(pm1g5e);
        store.addObject(pm1g6);
        store.addObjects(pm1g6e);
        store.addObject(pm1table);
        store.addObjects(pm1tablee);
        store.addObject(pm2);
        store.addObject(pm2g1);
        store.addObjects(pm2g1e);
        store.addObject(pm2g2);
        store.addObjects(pm2g2e);
        store.addObject(pm2g3);
        store.addObjects(pm2g3e);
        store.addObject(pm3);
        store.addObject(pm3g1);
        store.addObjects(pm3g1e);
        store.addObject(pm3g2);
        store.addObjects(pm3g2e);
        store.addObject(pm4);
        store.addObject(pm4g1);
        store.addObjects(pm4g1e);
        store.addObject(pm4g2);
        store.addObjects(pm4g2e);
        store.addObject(pm4g1ap1);
        store.addObject(pm4g2ap1);
        store.addObject(pm4g2ap2);
        store.addObject(pm5);
        store.addObject(pm5g1);
        store.addObjects(pm5g1e);
        store.addObject(pm5g2);
        store.addObjects(pm5g2e);
        store.addObject(pm5g3);
        store.addObjects(pm5g3e);
        store.addObject(pm5g1ap1);
        store.addObject(pm5g2ap1);
        store.addObject(pm5g2ap2);
        store.addObject(pm6);
        store.addObject(pm6g1);
        store.addObjects(pm6g1e);
        store.addObject(tm1);
        store.addObject(tm1g1);
        store.addObjects(tm1g1e);
        store.addObject(tm1g2);
        store.addObjects(tm1g2e);
        store.addObject(vm1);
        store.addObject(vm1g1);
        store.addObjects(vm1g1e);
        store.addObject(vm1g1_defect10711);
        store.addObjects(vm1g1e_defect10711);
        store.addObject(vm1g1_defect12081);
        store.addObjects(vm1g1e_defect12081);
        store.addObject(vm1g1c);
        store.addObjects(vm1g1ce);
        store.addObject(vm1g2a);
        store.addObjects(vm1g2ae);
        store.addObject(vm1g2);
        store.addObjects(vm1g2e);
        store.addObject(vm1g4);
        store.addObjects(vm1g4e);
        store.addObject(vm1g5);
        store.addObjects(vm1g5e);
        store.addObject(vm1g6);
        store.addObjects(vm1g6e);
        store.addObject(vm1g7);
        store.addObjects(vm1g7e);
        store.addObject(vm1g8);
        store.addObjects(vm1g8e);
        store.addObject(vm1g9);
        store.addObjects(vm1g9e);
        store.addObject(vm1g10);
        store.addObjects(vm1g10e);
        store.addObject(vm1g11);
        store.addObjects(vm1g11e);
        store.addObject(vm1g12);
        store.addObjects(vm1g12e);
        store.addObject(vm1g13);
        store.addObjects(vm1g13e);
        store.addObject(vm1g14);
        store.addObjects(vm1g14e);
        store.addObject(vm1g15);
        store.addObjects(vm1g15e);
        store.addObject(vm1g16);
        store.addObjects(vm1g16e);
        store.addObject(vm1g17);
        store.addObjects(vm1g17e);
        store.addObject(vm1g18);
        store.addObjects(vm1g18e);
        store.addObject(vm1g19);
        store.addObjects(vm1g19e);
        store.addObject(vm1g20);
        store.addObjects(vm1g20e);
        store.addObject(vm1g21);
        store.addObjects(vm1g21e);
        store.addObject(vm1g22);
        store.addObjects(vm1g22e);
        store.addObject(vm1g23);
        store.addObjects(vm1g23e);
        store.addObject(vm1g24);
        store.addObjects(vm1g24e);
        store.addObject(vm1g25);
        store.addObjects(vm1g25e);
        store.addObject(vm1g26);
        store.addObjects(vm1g26e);
        store.addObject(vm1g27);
        store.addObjects(vm1g27e);
        store.addObject(vm1g28);
        store.addObjects(vm1g28e);
        store.addObject(vm1g29);
        store.addObjects(vm1g29e);
        store.addObject(vm1g30);
        store.addObjects(vm1g30e);
        store.addObject(vm1g31);
        store.addObjects(vm1g31e);
        store.addObject(vm1g32);
        store.addObjects(vm1g32e);
        store.addObject(vm1g33);
        store.addObjects(vm1g33e);
        store.addObject(vm1g34);
        store.addObjects(vm1g34e);
        store.addObject(vm1g36);
        store.addObjects(vm1g36e);
        store.addObject(vm1g37);
        store.addObjects(vm1g37e);
        store.addObject(vm1g37ap1);
        store.addObject(vm1g38);
        store.addObjects(vm1g38e);
        store.addObject(vm2);
        store.addObject(vm2g1);
        store.addObjects(vm2g1e);
        store.addObject(doc1);
        store.addObject(doc2);
        store.addObject(doc3);
        store.addObject(doc4);
        store.addObject(doc5);
        store.addObject(doc6);
        store.addObject(docAmbiguous1);
        store.addObject(docAmbiguous2);
        store.addObjects(docE1);
        store.addObjects(docE2);
        store.addObjects(docE3);
        store.addObjects(docE4);
        store.addObjects(docE5);
        store.addObject(vm1mc1);
        store.addObjects(vm1mc1e);
        store.addObjects(docE6);
        store.addObject(rs1);
        store.addObject(sq1);
        store.addObject(rs2);
        store.addObject(sq2);
        store.addObject(rs3);
        store.addObject(sp1);
        store.addObject(rs4);
        store.addObject((FakeMetadataObject)sqsp1);
        store.addObject(rs5);
        store.addObject(rs5a);
        store.addObject(sq3);
        store.addObject(sq3a);
        store.addObject(sq3b);
        store.addObject(sqDefaults);
        store.addObject(sqBadDefault);
        store.addObject((FakeMetadataObject)rs6);
        store.addObject((FakeMetadataObject)sq4);
        store.addObject((FakeMetadataObject)rs7);
        store.addObject((FakeMetadataObject)sq5);
        store.addObject((FakeMetadataObject)rs8);
        store.addObject((FakeMetadataObject)sq6);
        store.addObject((FakeMetadataObject)rs9);
        store.addObject((FakeMetadataObject)sq7);
        store.addObject((FakeMetadataObject)rs10);
        store.addObject((FakeMetadataObject)sq8);
        store.addObject((FakeMetadataObject)rs11);
        store.addObject((FakeMetadataObject)sq9);
        store.addObject((FakeMetadataObject)rs12);
        store.addObject((FakeMetadataObject)sq10);
        store.addObject((FakeMetadataObject)rs13);
        store.addObject((FakeMetadataObject)sp2);
        store.addObject((FakeMetadataObject)rs14);
        store.addObject((FakeMetadataObject)sq11);
        store.addObject((FakeMetadataObject)rs15);
        store.addObject((FakeMetadataObject)sq12);
        store.addObject((FakeMetadataObject)rs16);
        store.addObject((FakeMetadataObject)sq13);
        store.addObject((FakeMetadataObject)rs17);
        store.addObject((FakeMetadataObject)sq14);
        store.addObject((FakeMetadataObject)rs18);
        store.addObject((FakeMetadataObject)sq15);
        store.addObject((FakeMetadataObject)sq16);
        store.addObject((FakeMetadataObject)rs19);
        store.addObject((FakeMetadataObject)sq17);
        store.addObject((FakeMetadataObject)sp3);
        store.addObject((FakeMetadataObject)rs20);
        store.addObject((FakeMetadataObject)sq18);
        store.addObject((FakeMetadataObject)rs21);
        store.addObject((FakeMetadataObject)sq19);
        store.addObject((FakeMetadataObject)vsp1);
        store.addObject((FakeMetadataObject)vsp2);
        store.addObject((FakeMetadataObject)vsp3);
        store.addObject((FakeMetadataObject)vsp4);
        store.addObject((FakeMetadataObject)vsp5);
        store.addObject((FakeMetadataObject)vsp6);
        store.addObject((FakeMetadataObject)vsp7);
        store.addObject((FakeMetadataObject)vsp8);
        store.addObject((FakeMetadataObject)vsp9);
        store.addObject((FakeMetadataObject)vsp10);
        store.addObject((FakeMetadataObject)vsp11);
        store.addObject((FakeMetadataObject)vsp12);
        store.addObject((FakeMetadataObject)vsp13);
        store.addObject((FakeMetadataObject)vsp14);
        store.addObject((FakeMetadataObject)vsp15);
        store.addObject((FakeMetadataObject)vsp16);
        store.addObject((FakeMetadataObject)vsp17);
        store.addObject((FakeMetadataObject)vsp18);
        store.addObject((FakeMetadataObject)vsp19);
        store.addObject((FakeMetadataObject)vsp20);
        store.addObject((FakeMetadataObject)vsp21);
        store.addObject((FakeMetadataObject)vsp22);
        store.addObject((FakeMetadataObject)vsp23);
        store.addObject((FakeMetadataObject)vsp24);
        store.addObject((FakeMetadataObject)vsp25);
        store.addObject((FakeMetadataObject)vsp27);
        store.addObject((FakeMetadataObject)vsp28);
        store.addObject((FakeMetadataObject)vsp29);
        store.addObject((FakeMetadataObject)vsp33);
        store.addObject((FakeMetadataObject)vsp34);
        store.addObject((FakeMetadataObject)sp4);
        store.addObject((FakeMetadataObject)sp5);
        store.addObject((FakeMetadataObject)vsp26);
        store.addObject((FakeMetadataObject)vsprs30);
        store.addObject((FakeMetadataObject)vsp30);
        store.addObject((FakeMetadataObject)vsprs31);
        store.addObject((FakeMetadataObject)vsp31);
        store.addObject((FakeMetadataObject)vsp35);
        store.addObject((FakeMetadataObject)vgvp1);
        store.addObject((FakeMetadataObject)vgvp1e1);
        store.addObject((FakeMetadataObject)vgvp1e2);
        store.addObject((FakeMetadataObject)vgvp1e3);
        store.addObject((FakeMetadataObject)vgvp2);
        store.addObject((FakeMetadataObject)vgvp2e1);
        store.addObject((FakeMetadataObject)vgvp2e2);
        store.addObject((FakeMetadataObject)vgvp2e3);
        store.addObject((FakeMetadataObject)vgvp3);
        store.addObject((FakeMetadataObject)vgvp3e1);
        store.addObject((FakeMetadataObject)vgvp3e2);
        store.addObject((FakeMetadataObject)vgvp3e3);
        store.addObject((FakeMetadataObject)vgvp4);
        store.addObject((FakeMetadataObject)vgvp4e1);
        store.addObject((FakeMetadataObject)vgvp4e2);
        store.addObject((FakeMetadataObject)vgvp4e3);
        store.addObject((FakeMetadataObject)vgvp5);
        store.addObject((FakeMetadataObject)vgvp5e1);
        store.addObject((FakeMetadataObject)vgvp5e2);
        store.addObject((FakeMetadataObject)vgvp5e3);
        store.addObject((FakeMetadataObject)vgvp6);
        store.addObject((FakeMetadataObject)vgvp6e1);
        store.addObject((FakeMetadataObject)vgvp6e2);
        store.addObject((FakeMetadataObject)vgvp6e3);
        store.addObject((FakeMetadataObject)vgvp6e4);
        store.addObject((FakeMetadataObject)vgvp7);
        store.addObject((FakeMetadataObject)vgvp7e1);
        store.addObject((FakeMetadataObject)vgvp7e2);
        store.addObject((FakeMetadataObject)vgvp7e3);
        store.addObject((FakeMetadataObject)vgvp7e4);
        store.addObject((FakeMetadataObject)vm1g35);
        store.addObject((FakeMetadataObject)vm1g35e1);
        store.addObject((FakeMetadataObject)vm1g35e2);
        store.addObject((FakeMetadataObject)vsp36);
        store.addObject((FakeMetadataObject)vsprs36);
        store.addObject((FakeMetadataObject)vsp32);
        store.addObject((FakeMetadataObject)vsp37);
        store.addObject((FakeMetadataObject)vsp38);
        store.addObject((FakeMetadataObject)vsp39);
        store.addObject((FakeMetadataObject)vsp40);
        store.addObject((FakeMetadataObject)vsp41);
        store.addObject((FakeMetadataObject)vsp42);
        store.addObject((FakeMetadataObject)vsp43);
        store.addObject((FakeMetadataObject)vsp44);
        store.addObject((FakeMetadataObject)vsp45);
        store.addObject((FakeMetadataObject)vsp46);
        store.addObject((FakeMetadataObject)vsp47);
        store.addObject((FakeMetadataObject)vsp48rs);
        store.addObject((FakeMetadataObject)vsp48);
        store.addObject((FakeMetadataObject)vsp49rs);
        store.addObject((FakeMetadataObject)vsp49);
        store.addObject((FakeMetadataObject)vsp50rs);
        store.addObject((FakeMetadataObject)vsp50);
        store.addObject((FakeMetadataObject)vsp51rs);
        store.addObject((FakeMetadataObject)vsp51);
        store.addObject((FakeMetadataObject)vsp52rs);
        store.addObject((FakeMetadataObject)vsp52);
        store.addObject((FakeMetadataObject)vsp53rs);
        store.addObject((FakeMetadataObject)vsp53);
        store.addObject((FakeMetadataObject)vsp54rs);
        store.addObject((FakeMetadataObject)vsp54);
        store.addObject((FakeMetadataObject)vsp55);
        store.addObject((FakeMetadataObject)vsp56);
        store.addObject((FakeMetadataObject)vsp57);
        store.addObject((FakeMetadataObject)vsp58);
        store.addObject((FakeMetadataObject)vsp59);
        store.addObject((FakeMetadataObject)vsp60);
        store.addObject((FakeMetadataObject)vsp61);
        store.addObject((FakeMetadataObject)vsp62);
        store.addObject(vm1g39);
        store.addObjects(vm1g39e);
        return new FakeMetadataFacade((FakeMetadataStore)store);
    }

    private static MappingDocument exampleDoc1() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingElement node1 = root.addChildElement(new MappingElement("node1"));
        MappingElement node2 = node1.addChildElement(new MappingElement("node2"));
        node2.addChildElement(new MappingElement("node3"));
        return doc;
    }

    private static MappingDocument exampleDoc2() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingElement node1 = root.addChildElement(new MappingElement("node1"));
        MappingSequenceNode node2 = node1.addSequenceNode(new MappingSequenceNode());
        node2.addChildElement(new MappingElement("node3"));
        root.addChildElement(new MappingElement("node2"));
        return doc;
    }

    private static MappingDocument exampleDoc3() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingSequenceNode node1 = root.addSequenceNode(new MappingSequenceNode());
        node1.addChildElement(new MappingElement("node2"));
        root.addChildElement(new MappingElement("node2"));
        return doc;
    }

    private static MappingDocument exampleDoc4() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        root.addAttribute(new MappingAttribute("node6"));
        root.addStagingTable("tm1.g1");
        MappingElement node1 = root.addChildElement(new MappingElement("node1"));
        node1.addAttribute(new MappingAttribute("node2"));
        MappingElement node3 = root.addChildElement(new MappingElement("node3"));
        node3.addAttribute(new MappingAttribute("node4"));
        MappingElement node5 = node3.addChildElement(new MappingElement("node4"));
        MappingElement duplicateRoot = node5.addChildElement(new MappingElement("root"));
        duplicateRoot.addChildElement(new MappingElement("node6"));
        return doc;
    }

    private static MappingDocument exampleDoc5() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        MappingElement node1 = root.addChildElement(new MappingElement("node1"));
        node1.addChildElement(new MappingElement("node2", "xmltest.mc1.e1"));
        node1.setSource("xmltest.mc1");
        node1.setMaxOccurrs(-1);
        return doc;
    }

    private static MappingDocument exampleDoc6() {
        MappingDocument doc = new MappingDocument(false);
        MappingElement root = doc.addChildElement(new MappingElement("root"));
        root.addChildElement(new MappingElement("node"));
        root.addChildElement(new MappingElement("thenode"));
        return doc;
    }

    public static FakeMetadataFacade example3() {
        FakeMetadataObject pm1 = FakeMetadataFactory.createPhysicalModel("pm1");
        FakeMetadataObject pm2 = FakeMetadataFactory.createPhysicalModel("pm2");
        FakeMetadataObject pm3 = FakeMetadataFactory.createPhysicalModel("pm3");
        FakeMetadataObject pm1g1 = FakeMetadataFactory.createPhysicalGroup("pm1.cat1.cat2.cat3.g1", pm1);
        FakeMetadataObject pm1g2 = FakeMetadataFactory.createPhysicalGroup("pm1.cat1.g2", pm1);
        FakeMetadataObject pm1g3 = FakeMetadataFactory.createPhysicalGroup("pm1.cat2.g3", pm1);
        FakeMetadataObject pm2g1 = FakeMetadataFactory.createPhysicalGroup("pm2.cat1.g1", pm2);
        FakeMetadataObject pm2g2 = FakeMetadataFactory.createPhysicalGroup("pm2.cat2.g2", pm2);
        FakeMetadataObject pm2g3 = FakeMetadataFactory.createPhysicalGroup("pm2.g3", pm2);
        FakeMetadataObject pm2g4 = FakeMetadataFactory.createPhysicalGroup("pm2.g4", pm3);
        FakeMetadataObject pm2g5 = FakeMetadataFactory.createPhysicalGroup("pm2.cat3.g1", pm2);
        List<FakeMetadataObject> pm1g1e = FakeMetadataFactory.createElements(pm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm1g2e = FakeMetadataFactory.createElements(pm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm1g3e = FakeMetadataFactory.createElements(pm1g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm2g1e = FakeMetadataFactory.createElements(pm2g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm2g2e = FakeMetadataFactory.createElements(pm2g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm2g3e = FakeMetadataFactory.createElements(pm2g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm2g4e = FakeMetadataFactory.createElements(pm2g4, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm2g5e = FakeMetadataFactory.createElements(pm2g5, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(pm1);
        store.addObject(pm1g1);
        store.addObjects(pm1g1e);
        store.addObject(pm1g2);
        store.addObjects(pm1g2e);
        store.addObject(pm1g3);
        store.addObjects(pm1g3e);
        store.addObject(pm2);
        store.addObject(pm2g1);
        store.addObjects(pm2g1e);
        store.addObject(pm2g2);
        store.addObjects(pm2g2e);
        store.addObject(pm2g3);
        store.addObject(pm2g4);
        store.addObject(pm2g5);
        store.addObjects(pm2g3e);
        store.addObjects(pm2g4e);
        store.addObjects(pm2g5e);
        store.addObject(pm3);
        return new FakeMetadataFacade(store);
    }

    public static FakeMetadataFacade example4() {
        FakeMetadataObject pm1 = FakeMetadataFactory.createPhysicalModel("pm1");
        FakeMetadataObject pm2 = FakeMetadataFactory.createPhysicalModel("pm2");
        FakeMetadataObject pm3 = FakeMetadataFactory.createPhysicalModel("pm3");
        FakeMetadataObject pm4 = FakeMetadataFactory.createPhysicalModel("pm4");
        FakeMetadataObject vm1 = FakeMetadataFactory.createVirtualModel("vm1");
        FakeMetadataObject pm1g1 = FakeMetadataFactory.createPhysicalGroup("pm1.g1", pm1);
        FakeMetadataObject pm1g2 = FakeMetadataFactory.createPhysicalGroup("pm1.g2", pm1);
        FakeMetadataObject pm1g3 = FakeMetadataFactory.createPhysicalGroup("pm1.g3", pm1);
        FakeMetadataObject pm2g1 = FakeMetadataFactory.createPhysicalGroup("pm2.g1", pm2);
        FakeMetadataObject pm2g2 = FakeMetadataFactory.createPhysicalGroup("pm2.g2", pm2);
        FakeMetadataObject pm2g3 = FakeMetadataFactory.createPhysicalGroup("pm2.g3", pm2);
        FakeMetadataObject pm3g1 = FakeMetadataFactory.createPhysicalGroup("pm3.g1", pm3);
        FakeMetadataObject pm3g2 = FakeMetadataFactory.createPhysicalGroup("pm3.g2", pm3);
        FakeMetadataObject pm3g3 = FakeMetadataFactory.createPhysicalGroup("pm3.g3", pm3);
        FakeMetadataObject pm4g1 = FakeMetadataFactory.createPhysicalGroup("pm4.g1", pm4);
        FakeMetadataObject pm4g2 = FakeMetadataFactory.createPhysicalGroup("pm4.g2", pm4);
        pm1g1.putProperty("cardinality", new Integer(10));
        pm1g2.putProperty("cardinality", new Integer(10));
        pm1g3.putProperty("cardinality", new Integer(10));
        pm2g1.putProperty("cardinality", new Integer(1000));
        pm2g2.putProperty("cardinality", new Integer(1000));
        pm3g1.putProperty("cardinality", new Integer(100000));
        pm3g2.putProperty("cardinality", new Integer(100000));
        pm3g3.putProperty("cardinality", new Integer(100000));
        List<FakeMetadataObject> pm1g1e = FakeMetadataFactory.createElements(pm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm1g2e = FakeMetadataFactory.createElements(pm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm1g3e = FakeMetadataFactory.createElements(pm1g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm2g1e = FakeMetadataFactory.createElements(pm2g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm2g2e = FakeMetadataFactory.createElements(pm2g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm2g3e = FakeMetadataFactory.createElements(pm2g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm3g1e = FakeMetadataFactory.createElements(pm3g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm3g2e = FakeMetadataFactory.createElements(pm3g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm3g3e = FakeMetadataFactory.createElements(pm3g3, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm4g1e = FakeMetadataFactory.createElements(pm4g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm4g2e = FakeMetadataFactory.createElements(pm4g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        FakeMetadataObject pm1g1key1 = FakeMetadataFactory.createKey("pm1.g1.key1", pm1g1, pm1g1e.subList(0, 1));
        FakeMetadataObject pm3g1key1 = FakeMetadataFactory.createKey("pm3.g1.key1", pm3g1, pm3g1e.subList(0, 1));
        FakeMetadataObject pm3g3key1 = FakeMetadataFactory.createKey("pm3.g3.key1", pm3g3, pm3g3e.subList(0, 1));
        FakeMetadataObject pm4g1key1 = FakeMetadataFactory.createKey("pm4.g1.key1", pm4g1, pm4g1e.subList(0, 2));
        FakeMetadataObject pm4g2key1 = FakeMetadataFactory.createForeignKey("pm4.g2.fk", pm4g2, pm4g2e.subList(0, 2), pm4g1key1);
        ArrayList<FakeMetadataObject> elements = new ArrayList<FakeMetadataObject>(1);
        elements.add(pm1g1e.iterator().next());
        FakeMetadataObject pm1g1ap1 = FakeMetadataFactory.createAccessPattern("pm1.g1.ap1", pm1g1, elements);
        elements = new ArrayList(2);
        Iterator<FakeMetadataObject> iter = pm1g3e.iterator();
        elements.add(iter.next());
        elements.add(iter.next());
        FakeMetadataObject pm1g3ap1 = FakeMetadataFactory.createAccessPattern("pm1.g3.ap1", pm1g3, elements);
        elements = new ArrayList(1);
        elements.add(pm2g1e.iterator().next());
        FakeMetadataObject pm2g1ap1 = FakeMetadataFactory.createAccessPattern("pm2.g1.ap1", pm2g1, elements);
        QueryNode vm1g1n1 = new QueryNode("vm1.g1", "SELECT * FROM pm1.g1");
        FakeMetadataObject vm1g1 = FakeMetadataFactory.createUpdatableVirtualGroup("vm1.g1", vm1, vm1g1n1);
        QueryNode vm1g2n1 = new QueryNode("vm1.g2", "SELECT pm1.g2.e1, pm1.g2.e2, pm1.g2.e3 FROM pm1.g2");
        FakeMetadataObject vm1g2 = FakeMetadataFactory.createUpdatableVirtualGroup("vm1.g2", vm1, vm1g2n1);
        QueryNode vm1g3n1 = new QueryNode("vm1.g3", "SELECT pm1.g3.e1 AS x, pm1.g3.e2 AS y from pm1.g3");
        FakeMetadataObject vm1g3 = FakeMetadataFactory.createUpdatableVirtualGroup("vm1.g3", vm1, vm1g3n1);
        QueryNode vm1g4n1 = new QueryNode("vm1.g4", "SELECT distinct pm1.g2.e1 as ve1, pm1.g1.e1 as ve2 FROM pm1.g2 LEFT OUTER JOIN /* optional */ pm1.g1 on pm1.g1.e1 = pm1.g2.e1");
        FakeMetadataObject vm1g4 = FakeMetadataFactory.createVirtualGroup("vm1.g4", vm1, vm1g4n1);
        List<FakeMetadataObject> vm1g4e = FakeMetadataFactory.createElements(vm1g4, new String[]{"ve1", "ve2"}, new String[]{"string", "string"});
        List<FakeMetadataObject> vm1g1e = FakeMetadataFactory.createElements(vm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm1g2e = FakeMetadataFactory.createElements(vm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> vm1g3e = FakeMetadataFactory.createElements(vm1g3, new String[]{"e1", "e2", "x", "y"}, new String[]{"string", "integer", "string", "integer"});
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(pm1);
        store.addObject(pm1g1);
        store.addObjects(pm1g1e);
        store.addObject(pm1g2);
        store.addObjects(pm1g2e);
        store.addObject(pm1g3);
        store.addObjects(pm1g3e);
        store.addObject(pm1g1key1);
        store.addObject(pm1g1ap1);
        store.addObject(pm1g3ap1);
        store.addObject(pm2);
        store.addObject(pm2g1);
        store.addObjects(pm2g1e);
        store.addObject(pm2g2);
        store.addObjects(pm2g2e);
        store.addObject(pm2g3);
        store.addObjects(pm2g3e);
        store.addObject(pm2g1ap1);
        store.addObject(pm3);
        store.addObject(pm3g1);
        store.addObjects(pm3g1e);
        store.addObject(pm3g2);
        store.addObjects(pm3g2e);
        store.addObject(pm3g3);
        store.addObjects(pm3g3e);
        store.addObject(pm3g1key1);
        store.addObject(pm3g3key1);
        store.addObject(pm4);
        store.addObject(pm4g1);
        store.addObjects(pm4g1e);
        store.addObject(pm4g1key1);
        store.addObject(pm4g2);
        store.addObjects(pm4g2e);
        store.addObject(pm4g2key1);
        store.addObject(vm1);
        store.addObject(vm1g1);
        store.addObjects(vm1g1e);
        store.addObject(vm1g2);
        store.addObjects(vm1g2e);
        store.addObject(vm1g3);
        store.addObjects(vm1g3e);
        store.addObject(vm1g4);
        store.addObjects(vm1g4e);
        return new FakeMetadataFacade(store);
    }

    public static FakeMetadataFacade exampleUpdateProc(String procedureType, String procedure) {
        FakeMetadataObject pm1 = FakeMetadataFactory.createPhysicalModel("pm1");
        FakeMetadataObject pm2 = FakeMetadataFactory.createPhysicalModel("pm2");
        FakeMetadataObject vm1 = FakeMetadataFactory.createVirtualModel("vm1");
        FakeMetadataObject pm1g1 = FakeMetadataFactory.createPhysicalGroup("pm1.g1", pm1);
        FakeMetadataObject pm1g2 = FakeMetadataFactory.createPhysicalGroup("pm1.g2", pm1);
        FakeMetadataObject pm2g1 = FakeMetadataFactory.createPhysicalGroup("pm2.g1", pm2);
        FakeMetadataObject pm2g2 = FakeMetadataFactory.createPhysicalGroup("pm2.g2", pm2);
        List<FakeMetadataObject> pm1g1e = FakeMetadataFactory.createElements(pm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm1g2e = FakeMetadataFactory.createElements(pm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm2g1e = FakeMetadataFactory.createElements(pm2g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm2g2e = FakeMetadataFactory.createElements(pm2g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        QueryNode vm1g1n1 = new QueryNode("vm1.g1", "SELECT * FROM pm1.g1");
        FakeMetadataObject vm1g1 = FakeMetadataFactory.createUpdatableVirtualGroup("vm1.g1", vm1, vm1g1n1);
        QueryNode vm1g2n1 = new QueryNode("vm1.g2", "SELECT pm1.g2.e1, pm1.g2.e2, pm1.g2.e3 FROM pm1.g2");
        FakeMetadataObject vm1g2 = FakeMetadataFactory.createUpdatableVirtualGroup("vm1.g2", vm1, vm1g2n1);
        QueryNode vm1g3n1 = new QueryNode("vm1.g3", "SELECT CONCAT(e1, 'm') as x, (e2 +1) as y, Count(*) as e3, e4*50 as e4 FROM pm1.g1");
        FakeMetadataObject vm1g3 = FakeMetadataFactory.createUpdatableVirtualGroup("vm1.g3", vm1, vm1g3n1);
        QueryNode vm1g4n1 = new QueryNode("vm1.g4", "SELECT * FROM pm1.g1");
        FakeMetadataObject vm1g4 = FakeMetadataFactory.createUpdatableVirtualGroup("vm1.g4", vm1, vm1g4n1);
        List vm1g1e = FakeMetadataFactory.createElementsWithDefaults(vm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"}, new Object[]{"xyz", Integer.getInteger("123"), Boolean.valueOf("true"), Double.valueOf("123.456")});
        List vm1g2e = FakeMetadataFactory.createElementsWithDefaults(vm1g2, new String[]{"e1", "e2", "e3"}, new String[]{"string", "integer", "boolean"}, new Object[]{"abc", Integer.getInteger("456"), Boolean.valueOf("false")});
        List vm1g3e = FakeMetadataFactory.createElementsWithDefaults(vm1g3, new String[]{"x", "y", "e3", "e4"}, new String[]{"string", "integer", "integer", "double"}, new Object[]{"mno", Integer.getInteger("789"), Boolean.valueOf("true"), Double.valueOf("789.012")});
        List vm1g4e = FakeMetadataFactory.createElementsWithDefaults(vm1g4, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"}, new Object[]{"xyz", Integer.getInteger("123"), Boolean.valueOf("true"), Double.valueOf("123.456")});
        vm1g1.putProperty(procedureType, procedure);
        vm1g2.putProperty(procedureType, procedure);
        vm1g3.putProperty(procedureType, procedure);
        vm1g4.putProperty(procedureType, procedure);
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(pm1);
        store.addObject(pm1g1);
        store.addObjects(pm1g1e);
        store.addObject(pm1g2);
        store.addObjects(pm1g2e);
        store.addObject(pm2);
        store.addObject(pm2g1);
        store.addObjects(pm2g1e);
        store.addObject(pm2g2);
        store.addObjects(pm2g2e);
        store.addObject(vm1);
        store.addObject(vm1g1);
        store.addObjects(vm1g1e);
        store.addObject(vm1g2);
        store.addObjects(vm1g2e);
        store.addObject(vm1g3);
        store.addObjects(vm1g3e);
        store.addObject(vm1g4);
        store.addObjects(vm1g4e);
        return new FakeMetadataFacade(store);
    }

    public static FakeMetadataFacade exampleUpdateProc(String procedureType, String procedure1, String procedure2) {
        FakeMetadataObject pm1 = FakeMetadataFactory.createPhysicalModel("pm1");
        FakeMetadataObject pm2 = FakeMetadataFactory.createPhysicalModel("pm2");
        FakeMetadataObject vm1 = FakeMetadataFactory.createVirtualModel("vm1");
        FakeMetadataObject pm1g1 = FakeMetadataFactory.createPhysicalGroup("pm1.g1", pm1);
        FakeMetadataObject pm1g2 = FakeMetadataFactory.createPhysicalGroup("pm1.g2", pm1);
        FakeMetadataObject pm2g1 = FakeMetadataFactory.createPhysicalGroup("pm2.g1", pm2);
        FakeMetadataObject pm2g2 = FakeMetadataFactory.createPhysicalGroup("pm2.g2", pm2);
        List<FakeMetadataObject> pm1g1e = FakeMetadataFactory.createElements(pm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm1g2e = FakeMetadataFactory.createElements(pm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm2g1e = FakeMetadataFactory.createElements(pm2g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        List<FakeMetadataObject> pm2g2e = FakeMetadataFactory.createElements(pm2g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"});
        QueryNode vm1g1n1 = new QueryNode("vm1.g1", "SELECT * FROM vm1.g2");
        FakeMetadataObject vm1g1 = FakeMetadataFactory.createUpdatableVirtualGroup("vm1.g1", vm1, vm1g1n1);
        QueryNode vm1g2n1 = new QueryNode("vm1.g2", "SELECT pm1.g2.e1, pm1.g2.e2, pm1.g2.e3, pm1.g2.e4 FROM pm1.g2");
        FakeMetadataObject vm1g2 = FakeMetadataFactory.createUpdatableVirtualGroup("vm1.g2", vm1, vm1g2n1);
        List vm1g1e = FakeMetadataFactory.createElementsWithDefaults(vm1g1, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"}, new Object[]{"xyz", Integer.getInteger("123"), Boolean.valueOf("true"), Double.valueOf("123.456")});
        List vm1g2e = FakeMetadataFactory.createElementsWithDefaults(vm1g2, new String[]{"e1", "e2", "e3", "e4"}, new String[]{"string", "integer", "boolean", "double"}, new Object[]{"abc", Integer.getInteger("456"), Boolean.valueOf("false"), null});
        vm1g1.putProperty(procedureType, procedure1);
        vm1g2.putProperty(procedureType, procedure2);
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(pm1);
        store.addObject(pm1g1);
        store.addObjects(pm1g1e);
        store.addObject(pm1g2);
        store.addObjects(pm1g2e);
        store.addObject(pm2);
        store.addObject(pm2g1);
        store.addObjects(pm2g1e);
        store.addObject(pm2g2);
        store.addObjects(pm2g2e);
        store.addObject(vm1);
        store.addObject(vm1g1);
        store.addObjects(vm1g1e);
        store.addObject(vm1g2);
        store.addObjects(vm1g2e);
        return new FakeMetadataFacade(store);
    }

    public static VDBMetaData exampleBQTVDB() {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("example1");
        vdb.setVersion(1);
        vdb.addModel(FakeMetadataFactory.createModel("BQT1", true));
        vdb.addModel(FakeMetadataFactory.createModel("BQT2", true));
        vdb.addModel(FakeMetadataFactory.createModel("BQT3", true));
        vdb.addModel(FakeMetadataFactory.createModel("LOB", true));
        vdb.addModel(FakeMetadataFactory.createModel("VQT", false));
        vdb.addModel(FakeMetadataFactory.createModel("pm1", true));
        vdb.addModel(FakeMetadataFactory.createModel("pm2", true));
        vdb.addModel(FakeMetadataFactory.createModel("pm3", true));
        vdb.addModel(FakeMetadataFactory.createModel("pm4", true));
        return vdb;
    }

    public static TransformationMetadata exampleBQT() {
        return RealMetadataFactory.exampleBQT();
    }

    public static FakeMetadataFacade exampleYahoo() {
        int i;
        FakeMetadataObject yahoo = FakeMetadataFactory.createPhysicalModel("Yahoo");
        FakeMetadataObject quotes = FakeMetadataFactory.createPhysicalGroup("Yahoo.QuoteServer", yahoo);
        String[] elemNames = new String[]{"TickerSymbol", "LastTrade", "LastTradeDate", "LastTradeTime", "PercentageChange", "TickerSymbol2", "DaysHigh", "DaysLow", "TotalVolume"};
        String[] elemTypes = new String[]{"string", "double", "date", "time", "double", "string", "double", "double", "biginteger"};
        List<FakeMetadataObject> cols = FakeMetadataFactory.createElements(quotes, elemNames, elemTypes);
        String[] nameInSource = new String[]{"Symbol", "Last", "Date", "Time", "Change", "Symbol2", "High", "Low", "Volume"};
        for (i = 0; i < 9; ++i) {
            FakeMetadataObject obj = cols.get(i);
            obj.putProperty("nameInSource", nameInSource[i]);
        }
        cols.get(0).putProperty("supSelect", Boolean.FALSE);
        for (i = 1; i < 9; ++i) {
            cols.get(0).putProperty("supCompare", Boolean.FALSE);
            cols.get(0).putProperty("supLike", Boolean.FALSE);
        }
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(yahoo);
        store.addObject(quotes);
        store.addObjects(cols);
        return new FakeMetadataFacade(store);
    }

    public static QueryMetadataInterface exampleMaterializedView() {
        FakeMetadataObject virtModel = FakeMetadataFactory.createVirtualModel("MatView");
        FakeMetadataObject physModel = FakeMetadataFactory.createPhysicalModel("MatTable");
        FakeMetadataObject physModel_virtSrc = FakeMetadataFactory.createPhysicalModel("MatSrc");
        FakeMetadataObject physGroup = FakeMetadataFactory.createPhysicalGroup("MatTable.MatTable", physModel);
        List<FakeMetadataObject> physElements = FakeMetadataFactory.createElements(physGroup, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject physGroupStage = FakeMetadataFactory.createPhysicalGroup("MatTable.MatStage", physModel);
        List<FakeMetadataObject> physStageElements = FakeMetadataFactory.createElements(physGroupStage, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject physGroup1 = FakeMetadataFactory.createPhysicalGroup("MatTable.MatTable1", physModel);
        List<FakeMetadataObject> physElements1 = FakeMetadataFactory.createElements(physGroup, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject physGroupStage1 = FakeMetadataFactory.createPhysicalGroup("MatTable.MatStage1", physModel);
        List<FakeMetadataObject> physStageElements1 = FakeMetadataFactory.createElements(physGroupStage, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataObject physGroup_virtSrc = FakeMetadataFactory.createPhysicalGroup("MatSrc.MatSrc", physModel_virtSrc);
        List<FakeMetadataObject> physElements_virtSrc = FakeMetadataFactory.createElements(physGroup_virtSrc, new String[]{"X"}, new String[]{"string"});
        QueryNode virtTrans = new QueryNode("MatView.MatView", "SELECT x as e1 FROM MatSrc.MatSrc");
        FakeMetadataObject virtGroup = FakeMetadataFactory.createVirtualGroup("MatView.MatView", virtModel, virtTrans);
        List<FakeMetadataObject> virtElements = FakeMetadataFactory.createElements(virtGroup, new String[]{"e1"}, new String[]{"string"});
        virtGroup.putProperty("matGroup", physGroup);
        virtGroup.putProperty("matStage", physGroupStage);
        QueryNode vTrans = new QueryNode("MatView.VGroup", "SELECT e1 FROM MatView.MatView option NOCACHE");
        FakeMetadataObject vGroup = FakeMetadataFactory.createVirtualGroup("MatView.VGroup", virtModel, vTrans);
        List<FakeMetadataObject> vElements = FakeMetadataFactory.createElements(vGroup, new String[]{"e1"}, new String[]{"string"});
        QueryNode virtTrans1 = new QueryNode("MatView.MatView1", "SELECT e1 FROM MatView.MatView where e1 = 1");
        FakeMetadataObject virtGroup1 = FakeMetadataFactory.createVirtualGroup("MatView.MatView1", virtModel, virtTrans1);
        List<FakeMetadataObject> virtElements1 = FakeMetadataFactory.createElements(virtGroup1, new String[]{"e1"}, new String[]{"string"});
        virtGroup1.putProperty("matGroup", physGroup1);
        virtGroup1.putProperty("matStage", physGroupStage1);
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(virtModel);
        store.addObject(physModel);
        store.addObject(physModel_virtSrc);
        store.addObject(physGroup);
        store.addObjects(physElements);
        store.addObject(physGroupStage);
        store.addObjects(physStageElements);
        store.addObject(physGroup1);
        store.addObjects(physElements1);
        store.addObject(physGroupStage1);
        store.addObjects(physStageElements1);
        store.addObject(physGroup_virtSrc);
        store.addObjects(physElements_virtSrc);
        store.addObject(virtGroup);
        store.addObjects(virtElements);
        store.addObject(vGroup);
        store.addObjects(vElements);
        store.addObject(virtGroup1);
        store.addObjects(virtElements1);
        return new FakeMetadataFacade(store);
    }

    public static VDBMetaData examplePrivatePhysicalModelVDB() {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("example1");
        vdb.setVersion(1);
        ModelMetaData m = FakeMetadataFactory.createModel("pm1", true);
        m.setVisible(Boolean.valueOf(false));
        vdb.addModel(m);
        vdb.addModel(FakeMetadataFactory.createModel("vm1", false));
        return vdb;
    }

    public static FakeMetadataFacade examplePrivatePhysicalModel() {
        FakeMetadataObject pm1 = FakeMetadataFactory.createPhysicalModel("pm1");
        FakeMetadataObject vm1 = FakeMetadataFactory.createVirtualModel("vm1");
        FakeMetadataObject pm1g1 = FakeMetadataFactory.createPhysicalGroup("pm1.g1", pm1);
        QueryNode vm1g1n1 = new QueryNode("vm1.g1", "SELECT * FROM pm1.g1");
        FakeMetadataObject vm1g1 = FakeMetadataFactory.createVirtualGroup("vm1.g1", vm1, vm1g1n1);
        FakeMetadataObject pm1g2 = FakeMetadataFactory.createPhysicalGroup("pm1.g2", pm1);
        List<FakeMetadataObject> pm1g1e = FakeMetadataFactory.createElements(pm1g1, new String[]{"e1"}, new String[]{"short"});
        List<FakeMetadataObject> pm1g2e = FakeMetadataFactory.createElements(pm1g2, new String[]{"e1"}, new String[]{"bigdecimal"});
        FakeMetadataObject e1 = pm1g2e.get(0);
        e1.putProperty("precision", "19");
        e1.putProperty("length", "21");
        e1.putProperty("scale", "4");
        List<FakeMetadataObject> vm1g1e = FakeMetadataFactory.createElements(vm1g1, new String[]{"e1"}, new String[]{"string"});
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(pm1);
        store.addObject(pm1g1);
        store.addObjects(pm1g1e);
        store.addObject(vm1);
        store.addObject(vm1g1);
        store.addObjects(vm1g1e);
        store.addObject(pm1g2);
        store.addObjects(pm1g2e);
        return new FakeMetadataFacade(store);
    }

    public static FakeMetadataFacade exampleBusObj() {
        FakeMetadataObject db2Model = FakeMetadataFactory.createPhysicalModel("db2model");
        FakeMetadataObject db2Table = FakeMetadataFactory.createPhysicalGroup("db2model.DB2_TABLE", db2Model);
        List<FakeMetadataObject> db2Elements = FakeMetadataFactory.createElements(db2Table, new String[]{"PRODUCT", "REGION", "SALES"}, new String[]{"string", "string", "double"});
        FakeMetadataObject salesTable = FakeMetadataFactory.createPhysicalGroup("db2model.SALES", db2Model);
        salesTable.putProperty("cardinality", new Integer(1000000));
        List<FakeMetadataObject> salesElem = FakeMetadataFactory.createElements(salesTable, new String[]{"CITY", "MONTH", "SALES"}, new String[]{"string", "string", "double"});
        FakeMetadataObject geographyTable2 = FakeMetadataFactory.createPhysicalGroup("db2model.GEOGRAPHY2", db2Model);
        geographyTable2.putProperty("cardinality", new Integer(1000));
        List<FakeMetadataObject> geographyElem2 = FakeMetadataFactory.createElements(geographyTable2, new String[]{"CITY", "REGION"}, new String[]{"string", "string"});
        ArrayList<FakeMetadataObject> geoPkElem2 = new ArrayList<FakeMetadataObject>();
        geoPkElem2.add(geographyElem2.get(0));
        FakeMetadataObject geoPk2 = FakeMetadataFactory.createKey("db2model.GEOGRAPHY2.GEOGRAPHY_PK", geographyTable2, geoPkElem2);
        FakeMetadataObject db2Table2 = FakeMetadataFactory.createPhysicalGroup("db2model.DB2TABLE", db2Model);
        List<FakeMetadataObject> db2Elements2 = FakeMetadataFactory.createElements(db2Table2, new String[]{"c0", "c1", "c2"}, new String[]{"integer", "integer", "integer"});
        FakeMetadataObject oraModel = FakeMetadataFactory.createPhysicalModel("oraclemodel");
        FakeMetadataObject oraTable = FakeMetadataFactory.createPhysicalGroup("oraclemodel.Oracle_table", oraModel);
        List<FakeMetadataObject> oracleElements = FakeMetadataFactory.createElements(oraTable, new String[]{"COSTS", "REGION", "YEAR"}, new String[]{"double", "string", "string"});
        FakeMetadataObject geographyTable = FakeMetadataFactory.createPhysicalGroup("oraclemodel.GEOGRAPHY", oraModel);
        geographyTable.putProperty("cardinality", new Integer(1000));
        List<FakeMetadataObject> geographyElem = FakeMetadataFactory.createElements(geographyTable, new String[]{"CITY", "REGION"}, new String[]{"string", "string"});
        ArrayList<FakeMetadataObject> geoPkElem = new ArrayList<FakeMetadataObject>();
        geoPkElem.add(geographyElem.get(0));
        FakeMetadataObject geoPk = FakeMetadataFactory.createKey("oraclemodel.GEOGRAPHY.GEOGRAPHY_PK", geographyTable, geoPkElem);
        FakeMetadataObject oraTable2 = FakeMetadataFactory.createPhysicalGroup("oraclemodel.OraTable", oraModel);
        List<FakeMetadataObject> oracleElements2 = FakeMetadataFactory.createElements(oraTable2, new String[]{"b0", "b1", "b2"}, new String[]{"double", "string", "string"});
        FakeMetadataObject msModel = FakeMetadataFactory.createPhysicalModel("msmodel");
        FakeMetadataObject timeTable = FakeMetadataFactory.createPhysicalGroup("msmodel.TIME", msModel);
        timeTable.putProperty("cardinality", new Integer(120));
        List<FakeMetadataObject> timeElem = FakeMetadataFactory.createElements(timeTable, new String[]{"MONTH", "YEAR"}, new String[]{"string", "string"});
        ArrayList<FakeMetadataObject> timePkElem = new ArrayList<FakeMetadataObject>();
        timePkElem.add(timeElem.get(0));
        FakeMetadataObject timePk = FakeMetadataFactory.createKey("msmodel.TIME.TIME_PK", timeTable, timePkElem);
        FakeMetadataObject virtModel = FakeMetadataFactory.createVirtualModel("logical");
        QueryNode n1 = new QueryNode("vm1.g1", "select sum(c0) as c0, c1, c2 from db2Table group by c1, c2");
        FakeMetadataObject logicalTable1 = FakeMetadataFactory.createVirtualGroup("logical.logicalTable1", virtModel, n1);
        List<FakeMetadataObject> logicalElem1 = FakeMetadataFactory.createElements(logicalTable1, new String[]{"c0", "c1", "c2"}, new String[]{"long", "integer", "integer"});
        QueryNode n2 = new QueryNode("vm1.g1", "select sum(c0) as c0, c1, c2 from db2Table group by c1, c2");
        FakeMetadataObject logicalTable2 = FakeMetadataFactory.createVirtualGroup("logical.logicalTable2", virtModel, n2);
        List<FakeMetadataObject> logicalElem2 = FakeMetadataFactory.createElements(logicalTable2, new String[]{"b0", "b1", "b2"}, new String[]{"long", "integer", "integer"});
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(db2Model);
        store.addObject(db2Table);
        store.addObjects(db2Elements);
        store.addObject(salesTable);
        store.addObjects(salesElem);
        store.addObject(geographyTable2);
        store.addObjects(geographyElem2);
        store.addObject(geoPk2);
        store.addObject(db2Table2);
        store.addObjects(db2Elements2);
        store.addObject(oraModel);
        store.addObject(oraTable);
        store.addObjects(oracleElements);
        store.addObject(geographyTable);
        store.addObjects(geographyElem);
        store.addObject(geoPk);
        store.addObject(oraTable2);
        store.addObjects(oracleElements2);
        store.addObject(msModel);
        store.addObject(timeTable);
        store.addObjects(timeElem);
        store.addObject(timePk);
        store.addObject(virtModel);
        store.addObject(logicalTable1);
        store.addObjects(logicalElem1);
        store.addObject(logicalTable2);
        store.addObjects(logicalElem2);
        return new FakeMetadataFacade(store);
    }

    public static FakeMetadataFacade exampleAggregates() {
        FakeMetadataStore store = new FakeMetadataStore();
        FakeMetadataFactory.addAggregateTablesToModel("m1", store);
        FakeMetadataFactory.addAggregateTablesToModel("m2", store);
        return new FakeMetadataFacade(store);
    }

    public static void addAggregateTablesToModel(String modelName, FakeMetadataStore store) {
        FakeMetadataObject model = FakeMetadataFactory.createPhysicalModel(modelName);
        FakeMetadataObject orders = FakeMetadataFactory.createPhysicalGroup(modelName + ".order", model);
        orders.putProperty("cardinality", new Integer(1000000));
        List<FakeMetadataObject> orderElements = FakeMetadataFactory.createElements(orders, new String[]{"O_OrderID", "O_ProductID", "O_DealerID", "O_Amount", "O_Date"}, new String[]{"integer", "integer", "integer", "bigdecimal", "date"});
        FakeMetadataObject products = FakeMetadataFactory.createPhysicalGroup(modelName + ".product", model);
        products.putProperty("cardinality", new Integer(1000));
        List<FakeMetadataObject> productsElements = FakeMetadataFactory.createElements(products, new String[]{"P_ProductID", "P_Overhead", "P_DivID"}, new String[]{"integer", "bigdecimal", "integer"});
        FakeMetadataObject divisions = FakeMetadataFactory.createPhysicalGroup(modelName + ".division", model);
        divisions.putProperty("cardinality", new Integer(100));
        List<FakeMetadataObject> divisionsElements = FakeMetadataFactory.createElements(divisions, new String[]{"V_DIVID", "V_SectorID"}, new String[]{"integer", "integer"});
        FakeMetadataObject dealers = FakeMetadataFactory.createPhysicalGroup(modelName + ".dealer", model);
        dealers.putProperty("cardinality", new Integer(1000));
        List<FakeMetadataObject> dealersElements = FakeMetadataFactory.createElements(dealers, new String[]{"D_DealerID", "D_State", "D_Address"}, new String[]{"integer", "string", "string"});
        store.addObject(model);
        store.addObject(orders);
        store.addObjects(orderElements);
        store.addObject(products);
        store.addObjects(productsElements);
        store.addObject(divisions);
        store.addObjects(divisionsElements);
        store.addObject(dealers);
        store.addObjects(dealersElements);
    }

    public static VDBMetaData exampleMultiBindingVDB() {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("exampleMultiBinding");
        vdb.setVersion(1);
        ModelMetaData model = new ModelMetaData();
        model.setName("MultiModel");
        model.setModelType(Model.Type.PHYSICAL);
        model.setVisible(Boolean.valueOf(true));
        model.setSupportsMultiSourceBindings(true);
        vdb.addModel(model);
        vdb.addModel(FakeMetadataFactory.createModel("Virt", false));
        return vdb;
    }

    public static FakeMetadataFacade exampleMultiBinding() {
        FakeMetadataObject virtModel = FakeMetadataFactory.createVirtualModel("Virt");
        FakeMetadataObject physModel = FakeMetadataFactory.createPhysicalModel("MultiModel");
        FakeMetadataObject physGroup = FakeMetadataFactory.createPhysicalGroup("MultiModel.Phys", physModel);
        List<FakeMetadataObject> physElements = FakeMetadataFactory.createElements(physGroup, new String[]{"a", "b"}, new String[]{"string", "string"});
        QueryNode virtTrans = new QueryNode("Virt.view", "SELECT * FROM MultiModel.Phys");
        FakeMetadataObject virtGroup = FakeMetadataFactory.createVirtualGroup("Virt.view", virtModel, virtTrans);
        List<FakeMetadataObject> virtElements = FakeMetadataFactory.createElements(virtGroup, new String[]{"a", "b"}, new String[]{"string", "string"});
        FakeMetadataObject rs2 = FakeMetadataFactory.createResultSet("Virt.rs1", virtModel, new String[]{"a", "b"}, new String[]{"string", "string"});
        FakeMetadataObject rs2p1 = FakeMetadataFactory.createParameter("ret", 1, 5, "object", rs2);
        FakeMetadataObject rs2p2 = FakeMetadataFactory.createParameter("in", 2, 1, "string", null);
        QueryNode sq2n1 = new QueryNode("pm1.sq1", "CREATE VIRTUAL PROCEDURE BEGIN\nexecute string 'SELECT a, b FROM MultiModel.Phys where SOURCE_NAME = Virt.sq1.in'; END");
        FakeMetadataObject sq1 = FakeMetadataFactory.createVirtualProcedure("Virt.sq1", virtModel, Arrays.asList(rs2p1, rs2p2), sq2n1);
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(virtModel);
        store.addObject(physModel);
        store.addObject(physGroup);
        store.addObjects(physElements);
        store.addObject(virtGroup);
        store.addObjects(virtElements);
        store.addObject(rs2);
        store.addObject(sq1);
        return new FakeMetadataFacade(store);
    }

    public static FakeMetadataFacade exampleCase3225() {
        FakeMetadataStore store = new FakeMetadataStore();
        FakeMetadataFacade facade = new FakeMetadataFacade(store);
        FakeMetadataObject stock = FakeMetadataFactory.createPhysicalModel("stock");
        FakeMetadataObject xmltest = FakeMetadataFactory.createVirtualModel("xmltest");
        FakeMetadataObject items = FakeMetadataFactory.createPhysicalGroup("stock.items", stock);
        FakeMetadataObject item_supplier = FakeMetadataFactory.createPhysicalGroup("stock.item_supplier", stock);
        FakeMetadataObject suppliers = FakeMetadataFactory.createPhysicalGroup("stock.suppliers", stock);
        FakeMetadataObject orders = FakeMetadataFactory.createPhysicalGroup("stock.orders", stock);
        FakeMetadataObject employees = FakeMetadataFactory.createPhysicalGroup("stock.employees", stock);
        List<FakeMetadataObject> itemElements = FakeMetadataFactory.createElements(items, new String[]{"itemNum", "itemName", "itemQuantity", "itemStatus"}, new String[]{"string", "string", "integer", "string"});
        List<FakeMetadataObject> itemSupplierElements = FakeMetadataFactory.createElements(item_supplier, new String[]{"itemNum", "supplierNum"}, new String[]{"string", "string"});
        List<FakeMetadataObject> supplierElements = FakeMetadataFactory.createElements(suppliers, new String[]{"supplierNum", "supplierName", "supplierZipCode"}, new String[]{"string", "string", "string"});
        List<FakeMetadataObject> stockOrders = FakeMetadataFactory.createElements(orders, new String[]{"orderNum", "itemFK", "supplierFK", "orderDate", "orderQty", "orderStatus"}, new String[]{"string", "string", "string", "string", "integer", "string"});
        List<FakeMetadataObject> supplierEmployees = FakeMetadataFactory.createElements(employees, new String[]{"employeeNum", "supplierNumFK", "specializesInItemNum", "supervisorNum", "firstName", "lastName"}, new String[]{"string", "string", "string", "string", "string", "string"});
        QueryNode rsQuery = new QueryNode("xmltest.items", "SELECT itemNum, itemName, itemQuantity, itemStatus FROM stock.items");
        FakeMetadataObject rsItems = FakeMetadataFactory.createVirtualGroup("xmltest.items", xmltest, rsQuery);
        QueryNode rsQuery2 = new QueryNode("xmltest.suppliers", "SELECT stock.suppliers.supplierNum, supplierName, supplierZipCode, stock.item_supplier.itemNum FROM stock.suppliers, stock.item_supplier WHERE stock.suppliers.supplierNum = stock.item_supplier.supplierNum AND stock.item_supplier.itemNum = ?");
        rsQuery2.addBinding("xmltest.items.itemNum");
        FakeMetadataObject rsSuppliers = FakeMetadataFactory.createVirtualGroup("xmltest.suppliers", xmltest, rsQuery2);
        QueryNode rsQuery3 = new QueryNode("xmltest.orders", "SELECT orderNum, orderDate, orderQty, orderStatus, itemFK, supplierFK FROM stock.orders WHERE itemFK = ? AND supplierFK = ?");
        rsQuery3.addBinding("xmltest.suppliers.itemNum");
        rsQuery3.addBinding("xmltest.suppliers.supplierNum");
        FakeMetadataObject rsOrders = FakeMetadataFactory.createVirtualGroup("xmltest.orders", xmltest, rsQuery3);
        QueryNode rsQuery4 = new QueryNode("xmltest.employees", "SELECT employeeNum, firstName, lastName, supervisorNum, specializesInItemNum, supplierNumFK FROM stock.employees WHERE specializesInItemNum = ? AND supplierNumFK = ?");
        rsQuery4.addBinding("xmltest.suppliers.itemNum");
        rsQuery4.addBinding("xmltest.suppliers.supplierNum");
        FakeMetadataObject rsEmployees = FakeMetadataFactory.createVirtualGroup("xmltest.employees", xmltest, rsQuery4);
        List<FakeMetadataObject> rsItemsElements = FakeMetadataFactory.createElements(rsItems, new String[]{"itemNum", "itemName", "itemQuantity", "itemStatus"}, new String[]{"string", "string", "integer", "string"});
        List<FakeMetadataObject> rsSuppliersElements = FakeMetadataFactory.createElements(rsSuppliers, new String[]{"supplierNum", "supplierName", "supplierZipCode", "itemNum"}, new String[]{"string", "string", "string", "string"});
        List<FakeMetadataObject> rsOrdersElements = FakeMetadataFactory.createElements(rsOrders, new String[]{"orderNum", "orderDate", "orderQty", "orderStatus", "itemFK", "supplierFK"}, new String[]{"string", "string", "integer", "string", "integer", "string"});
        List<FakeMetadataObject> rsEmployeesElements = FakeMetadataFactory.createElements(rsEmployees, new String[]{"employeeNum", "firstName", "lastName", "supervisorNum", "specializesInItemNum", "supplierNumFK"}, new String[]{"string", "string", "string", "string", "integer", "string"});
        MappingDocument doc = new MappingDocument(true);
        MappingElement root = doc.addChildElement(new MappingElement("Catalogs"));
        MappingElement cats = root.addChildElement(new MappingElement("Catalog"));
        MappingElement itemsA = cats.addChildElement(new MappingElement("Items"));
        MappingElement item = itemsA.addChildElement(new MappingElement("Item"));
        item.setSource("xmltest.items");
        item.setMaxOccurrs(-1);
        item.addAttribute(new MappingAttribute("ItemID", "xmltest.items.itemNum"));
        item.addChildElement(new MappingElement("Name", "xmltest.items.itemName"));
        item.addChildElement(new MappingElement("Quantity", "xmltest.items.itemQuantity"));
        MappingElement nestedWrapper = item.addChildElement(new MappingElement("Suppliers"));
        MappingElement supplier = nestedWrapper.addChildElement(new MappingElement("Supplier"));
        supplier.setSource("xmltest.suppliers");
        supplier.setMaxOccurrs(-1);
        supplier.addAttribute(new MappingAttribute("SupplierID", "xmltest.suppliers.supplierNum"));
        supplier.addChildElement(new MappingElement("Name", "xmltest.suppliers.supplierName"));
        supplier.addChildElement(new MappingElement("Zip", "xmltest.suppliers.supplierZipCode"));
        MappingElement ordersWrapper = supplier.addChildElement(new MappingElement("Orders"));
        MappingElement order = ordersWrapper.addChildElement(new MappingElement("Order"));
        order.setSource("xmltest.orders");
        order.setMaxOccurrs(-1);
        order.addAttribute(new MappingAttribute("OrderID", "xmltest.orders.orderNum"));
        order.addChildElement(new MappingElement("OrderDate", "xmltest.orders.orderDate"));
        order.addChildElement(new MappingElement("OrderQuantity", "xmltest.orders.orderQty"));
        order.addChildElement(new MappingElement("OrderStatus", "xmltest.orders.orderStatus")).setMinOccurrs(0);
        MappingElement employeesWrapper = supplier.addChildElement(new MappingElement("Employees"));
        MappingElement employee = employeesWrapper.addChildElement(new MappingElement("Employee"));
        employee.setSource("xmltest.employees");
        employee.setMaxOccurrs(-1);
        employee.addAttribute(new MappingAttribute("EmployeeID", "xmltest.employees.employeeNum"));
        employee.addChildElement(new MappingElement("FirstName", "xmltest.employees.firstName"));
        employee.addChildElement(new MappingElement("LastName", "xmltest.employees.lastName"));
        employee.addAttribute(new MappingAttribute("SupervisorID", "xmltest.employees.supervisorNum"));
        FakeMetadataObject itemsDoc = FakeMetadataFactory.createVirtualGroup("xmltest.itemsDoc", xmltest, doc);
        List<FakeMetadataObject> docE1 = FakeMetadataFactory.createElements(itemsDoc, new String[]{"Catalogs", "Catalogs.Catalog", "Catalogs.Catalog.items", "Catalogs.Catalog.items.item", "Catalogs.Catalog.items.item.@ItemID", "Catalogs.Catalog.items.item.Name", "Catalogs.Catalog.items.item.Quantity", "Catalogs.Catalog.items.item.Suppliers", "Catalogs.Catalog.items.item.Suppliers.Supplier", "Catalogs.Catalog.items.item.Suppliers.Supplier.@SupplierID", "Catalogs.Catalog.items.item.Suppliers.Supplier.Name", "Catalogs.Catalog.items.item.Suppliers.Supplier.Zip", "Catalogs.Catalog.items.item.Suppliers.Supplier.Orders", "Catalogs.Catalog.items.item.Suppliers.Supplier.Orders.Order", "Catalogs.Catalog.items.item.Suppliers.Supplier.Orders.Order.@OrderID", "Catalogs.Catalog.items.item.Suppliers.Supplier.Orders.Order.OrderDate", "Catalogs.Catalog.items.item.Suppliers.Supplier.Orders.Order.OrderQuantity", "Catalogs.Catalog.items.item.Suppliers.Supplier.Orders.Order.OrderStatus", "Catalogs.Catalog.items.item.Suppliers.Supplier.Employees", "Catalogs.Catalog.items.item.Suppliers.Supplier.Employees.Employee", "Catalogs.Catalog.items.item.Suppliers.Supplier.Employees.Employee.@EmployeeID", "Catalogs.Catalog.items.item.Suppliers.Supplier.Employees.Employee.FirstName", "Catalogs.Catalog.items.item.Suppliers.Supplier.Employees.Employee.LastName", "Catalogs.Catalog.items.item.Suppliers.Supplier.Employees.Employee.@SupervisorID"}, new String[]{"string", "string", "string", "string", "string", "string", "integer", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string"});
        QueryNode playersNode = new QueryNode("xmltest.players", "SELECT stock.employees.employeeNum, firstName, lastName, supervisorNum FROM stock.employees WHERE specializesInItemNum is not null");
        FakeMetadataObject rsPlayers = FakeMetadataFactory.createVirtualGroup("xmltest.players", xmltest, playersNode);
        QueryNode managersNode = new QueryNode("xmltest.managers", "SELECT stock.employees.employeeNum, firstName, lastName, supervisorNum FROM stock.employees WHERE stock.employees.employeeNum = ?");
        managersNode.addBinding("xmltest.players.supervisorNum");
        FakeMetadataObject rsManagers = FakeMetadataFactory.createVirtualGroup("xmltest.managers", xmltest, managersNode);
        QueryNode ownersNode = new QueryNode("xmltest.owners", "SELECT stock.employees.employeeNum, firstName, lastName, supervisorNum FROM stock.employees WHERE stock.employees.employeeNum = ?");
        ownersNode.addBinding("xmltest.managers.supervisorNum");
        FakeMetadataObject rsOwners = FakeMetadataFactory.createVirtualGroup("xmltest.owners", xmltest, ownersNode);
        List<FakeMetadataObject> rsPlayersElements = FakeMetadataFactory.createElements(rsPlayers, new String[]{"employeeNum", "firstName", "lastName", "supervisorNum"}, new String[]{"string", "string", "string", "string"});
        List<FakeMetadataObject> rsManagersElements = FakeMetadataFactory.createElements(rsManagers, new String[]{"employeeNum", "firstName", "lastName", "supervisorNum"}, new String[]{"string", "string", "string", "string"});
        List<FakeMetadataObject> rsOwnersElements = FakeMetadataFactory.createElements(rsOwners, new String[]{"employeeNum", "firstName", "lastName", "supervisorNum"}, new String[]{"string", "string", "string", "string"});
        MappingDocument doc2 = new MappingDocument(true);
        MappingElement root2 = doc2.addChildElement(new MappingElement("BaseballPlayers"));
        MappingElement player = root2.addChildElement(new MappingElement("Player"));
        player.setSource("xmltest.players");
        player.setMaxOccurrs(-1);
        player.addAttribute(new MappingAttribute("PlayerID", "xmltest.players.employeeNum"));
        player.addChildElement(new MappingElement("FirstName", "xmltest.players.firstName"));
        player.addChildElement(new MappingElement("LastName", "xmltest.players.lastName"));
        MappingElement manager = player.addChildElement(new MappingElement("Manager"));
        manager.setSource("xmltest.managers");
        manager.setMaxOccurrs(-1);
        manager.addAttribute(new MappingAttribute("ManagerID", "xmltest.managers.employeeNum"));
        manager.addChildElement(new MappingElement("FirstName", "xmltest.managers.firstName"));
        manager.addChildElement(new MappingElement("LastName", "xmltest.managers.lastName"));
        MappingElement owner = manager.addChildElement(new MappingElement("Owner"));
        owner.setSource("xmltest.owners");
        owner.setMaxOccurrs(-1);
        owner.addAttribute(new MappingAttribute("OwnerID", "xmltest.owners.employeeNum"));
        owner.addChildElement(new MappingElement("FirstName", "xmltest.owners.firstName"));
        owner.addChildElement(new MappingElement("LastName", "xmltest.owners.lastName"));
        FakeMetadataObject playersDoc = FakeMetadataFactory.createVirtualGroup("xmltest.playersDoc", xmltest, doc2);
        List<FakeMetadataObject> playersDocElements = FakeMetadataFactory.createElements(playersDoc, new String[]{"BaseballPlayers", "BaseballPlayers.Player", "BaseballPlayers.Player.@PlayerID", "BaseballPlayers.Player.FirstName", "BaseballPlayers.Player.LastName", "BaseballPlayers.Player.Manager", "BaseballPlayers.Player.Manager.@ManagerID", "BaseballPlayers.Player.Manager.FirstName", "BaseballPlayers.Player.Manager.LastName", "BaseballPlayers.Player.Manager.Owner", "BaseballPlayers.Player.Manager.Owner.@OwnerID", "BaseballPlayers.Player.Manager.Owner.FirstName", "BaseballPlayers.Player.Manager.Owner.LastName"}, new String[]{"string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string", "string"});
        store.addObject(stock);
        store.addObject(items);
        store.addObject(item_supplier);
        store.addObject(suppliers);
        store.addObject(orders);
        store.addObject(employees);
        store.addObjects(itemElements);
        store.addObjects(itemSupplierElements);
        store.addObjects(supplierElements);
        store.addObjects(stockOrders);
        store.addObjects(supplierEmployees);
        store.addObject(xmltest);
        store.addObject(rsItems);
        store.addObject(rsSuppliers);
        store.addObject(rsOrders);
        store.addObject(rsEmployees);
        store.addObject(rsPlayers);
        store.addObject(rsManagers);
        store.addObject(rsOwners);
        store.addObjects(rsItemsElements);
        store.addObjects(rsSuppliersElements);
        store.addObjects(rsOrdersElements);
        store.addObjects(rsEmployeesElements);
        store.addObjects(rsPlayersElements);
        store.addObjects(rsManagersElements);
        store.addObjects(rsOwnersElements);
        store.addObject(itemsDoc);
        store.addObject(playersDoc);
        store.addObjects(docE1);
        store.addObjects(playersDocElements);
        return facade;
    }

    public static VDBMetaData exampleXQueryTransformationsVDB() {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("exampleXQueryTransformations");
        vdb.setVersion(1);
        vdb.addModel(FakeMetadataFactory.createModel("m", true));
        return vdb;
    }

    public static FakeMetadataFacade exampleXQueryTransformations() {
        FakeMetadataObject model = FakeMetadataFactory.createPhysicalModel("m");
        FakeMetadataObject xmlrs = FakeMetadataFactory.createResultSet("m.xprocrs", model, new String[]{"xml"}, new String[]{"xml"});
        FakeMetadataObject xml1out = FakeMetadataFactory.createParameter("rs", 1, 5, null, xmlrs);
        QueryNode xproct1 = new QueryNode("m.xproc1", "<test></test>");
        FakeMetadataObject xproc1 = FakeMetadataFactory.createVirtualProcedure("m.xproc1", model, Arrays.asList(xml1out), xproct1);
        QueryNode xproct2 = new QueryNode("m.xproc2", "doc(\"EXEC m.xproc1()\")");
        FakeMetadataObject xproc2 = FakeMetadataFactory.createVirtualProcedure("m.xproc2", model, Arrays.asList(xml1out), xproct2);
        FakeMetadataObject xml3in = FakeMetadataFactory.createParameter("input", 2, 1, "xml", null);
        QueryNode xproct3 = new QueryNode("m.xproc3", "declare variable $INPUT as node() external; <wrap>{ $INPUT }</wrap>");
        FakeMetadataObject xproc3 = FakeMetadataFactory.createVirtualProcedure("m.xproc3", model, Arrays.asList(xml1out, xml3in), xproct3);
        FakeMetadataObject xml4in = FakeMetadataFactory.createParameter("in1", 2, 1, "string", null);
        FakeMetadataObject xml4in2 = FakeMetadataFactory.createParameter("in2", 3, 1, "integer", null);
        QueryNode xproct4 = new QueryNode("m.xproc4", "declare variable $in1 as xs:string external; declare variable $in2 as xs:int external; <wrap><a>{ $in1 }</a><b>{ $in2 }</b></wrap>");
        FakeMetadataObject xproc4 = FakeMetadataFactory.createVirtualProcedure("m.xproc4", model, Arrays.asList(xml1out, xml4in, xml4in2), xproct4);
        FakeMetadataObject xml5in = FakeMetadataFactory.createParameter("procName", 2, 1, "string", null);
        QueryNode xproct5 = new QueryNode("m.xproc5", "declare variable $procName as xs:string external; let $sql := concat('EXEC ', $procName, '()') return <wrap>{doc($sql)}</wrap>");
        FakeMetadataObject xproc5 = FakeMetadataFactory.createVirtualProcedure("m.xproc5", model, Arrays.asList(xml1out, xml5in), xproct5);
        FakeMetadataObject xml6in = FakeMetadataFactory.createParameter("tag", 2, 1, "string", null);
        FakeMetadataObject xml6in2 = FakeMetadataFactory.createParameter("value", 3, 1, "string", null);
        QueryNode xproct6 = new QueryNode("m.maketag", "declare variable $tag as xs:string external; declare variable $value as xs:string external; element { $tag } { $value }");
        FakeMetadataObject xproc6 = FakeMetadataFactory.createVirtualProcedure("m.maketag", model, Arrays.asList(xml1out, xml6in, xml6in2), xproct6);
        FakeMetadataObject xml7in = FakeMetadataFactory.createParameter("wrapperTag", 2, 1, "string", null);
        FakeMetadataObject xml7in2 = FakeMetadataFactory.createParameter("tag1", 3, 1, "string", null);
        FakeMetadataObject xml7in3 = FakeMetadataFactory.createParameter("val1", 4, 1, "string", null);
        FakeMetadataObject xml7in4 = FakeMetadataFactory.createParameter("tag2", 5, 1, "string", null);
        FakeMetadataObject xml7in5 = FakeMetadataFactory.createParameter("val2", 6, 1, "string", null);
        QueryNode xproct7 = new QueryNode("m.combinetags", "declare variable $wrapperTag as xs:string external; declare variable $tag1 as xs:string external; declare variable $val1 as xs:string external; declare variable $tag2 as xs:string external; declare variable $val2 as xs:string external; let $t1 := concat(\"EXEC m.maketag('\", $tag1, \"','\", $val1, \"')\") let $t2 := concat(\"EXEC m.maketag('\", $tag2, \"','\", $val2, \"')\") return element { $wrapperTag } { doc($t1), doc($t2) }");
        FakeMetadataObject xproc7 = FakeMetadataFactory.createVirtualProcedure("m.combinetags", model, Arrays.asList(xml1out, xml7in, xml7in2, xml7in3, xml7in4, xml7in5), xproct7);
        FakeMetadataObject xml8in = FakeMetadataFactory.createParameter("in", 2, 1, "xml", null);
        QueryNode xproct8 = new QueryNode("m.svc8", "declare variable $in as node() external; element { $in//tag/text() } { $in//value/text() }");
        FakeMetadataObject xproc8 = FakeMetadataFactory.createVirtualProcedure("m.svc8", model, Arrays.asList(xml1out, xml8in), xproct8);
        FakeMetadataObject xml9in = FakeMetadataFactory.createParameter("in", 2, 1, "xml", null);
        QueryNode xproct9 = new QueryNode("m.svc9", "declare variable $in as node() external; <results> {  for $value in $in//value   let $tag := $in//tag   return doc(    concat(\"EXEC m.svc8('<in><tag>\", $tag, \"</tag><value>\", $value, \"</value></in>')\"))} </results>");
        FakeMetadataObject xproc9 = FakeMetadataFactory.createVirtualProcedure("m.svc9", model, Arrays.asList(xml1out, xml9in), xproct9);
        QueryNode xproct10 = new QueryNode("m.xproc10", "doc('EXEC m.xproc1()')");
        FakeMetadataObject xproc10 = FakeMetadataFactory.createVirtualProcedure("m.xproc10", model, Arrays.asList(xml1out), xproct10);
        FakeMetadataStore store = new FakeMetadataStore();
        store.addObject(model);
        store.addObject(xproc1);
        store.addObject(xproc2);
        store.addObject(xproc3);
        store.addObject(xproc4);
        store.addObject(xproc5);
        store.addObject(xproc6);
        store.addObject(xproc7);
        store.addObject(xproc8);
        store.addObject(xproc9);
        store.addObject(xproc10);
        return new FakeMetadataFacade(store);
    }

    public static FakeMetadataObject createPhysicalModel(String name) {
        FakeMetadataObject obj = new FakeMetadataObject(name, "Model");
        obj.putProperty("isVirtual", Boolean.FALSE);
        obj.putProperty("supUpdate", Boolean.TRUE);
        return obj;
    }

    public static FakeMetadataObject createVirtualModel(String name) {
        FakeMetadataObject obj = new FakeMetadataObject(name, "Model");
        obj.putProperty("isVirtual", Boolean.TRUE);
        return obj;
    }

    public static FakeMetadataObject createPhysicalGroup(String name, FakeMetadataObject model) {
        FakeMetadataObject obj = new FakeMetadataObject(name, "Group");
        obj.putProperty("model", model);
        obj.putProperty("isVirtual", model.getProperty("isVirtual"));
        obj.putProperty("supUpdate", Boolean.TRUE);
        obj.putProperty("temp", Boolean.FALSE);
        obj.putProperty("nameInSource", name.lastIndexOf(".") == -1 ? name : name.substring(name.lastIndexOf(".") + 1));
        return obj;
    }

    public static FakeMetadataObject createPhysicalGroup(String name, FakeMetadataObject model, boolean flag) {
        FakeMetadataObject obj = new FakeMetadataObject(name, "Group");
        obj.putProperty("model", model);
        obj.putProperty("isVirtual", model.getProperty("isVirtual"));
        obj.putProperty("supUpdate", Boolean.TRUE);
        obj.putProperty("temp", Boolean.FALSE);
        obj.putProperty("nameInSource", name);
        return obj;
    }

    public static FakeMetadataObject createVirtualGroup(String name, FakeMetadataObject model, Object plan) {
        FakeMetadataObject obj = new FakeMetadataObject(name, "Group");
        obj.putProperty("model", model);
        obj.putProperty("isVirtual", model.getProperty("isVirtual"));
        obj.putProperty("plan", plan);
        obj.putProperty("supUpdate", Boolean.FALSE);
        obj.putProperty("temp", Boolean.FALSE);
        return obj;
    }

    public static FakeMetadataObject createTempGroup(String name, FakeMetadataObject model, Object plan) {
        FakeMetadataObject obj = new FakeMetadataObject(name, "Group");
        obj.putProperty("model", model);
        obj.putProperty("isVirtual", Boolean.FALSE);
        obj.putProperty("plan", plan);
        obj.putProperty("supUpdate", Boolean.FALSE);
        obj.putProperty("temp", Boolean.TRUE);
        return obj;
    }

    public static FakeMetadataObject createUpdatableVirtualGroup(String name, FakeMetadataObject model, QueryNode plan) {
        return FakeMetadataFactory.createUpdatableVirtualGroup(name, model, plan, null);
    }

    public static FakeMetadataObject createUpdatableVirtualGroup(String name, FakeMetadataObject model, QueryNode plan, String updatePlan) {
        FakeMetadataObject obj = new FakeMetadataObject(name, "Group");
        obj.putProperty("model", model);
        obj.putProperty("isVirtual", model.getProperty("isVirtual"));
        obj.putProperty("plan", plan);
        obj.putProperty("supUpdate", Boolean.TRUE);
        if (updatePlan != null) {
            obj.putProperty("updateProcedure", updatePlan);
        }
        return obj;
    }

    public static FakeMetadataObject createElement(String name, FakeMetadataObject group, String type, int index) {
        return FakeMetadataFactory.createElement(name, group, type, index, true);
    }

    public static FakeMetadataObject createElement(String name, FakeMetadataObject group, String type, int index, boolean flag) {
        FakeMetadataObject obj = new FakeMetadataObject(name, "Element");
        obj.putProperty("model", group.getProperty("model"));
        obj.putProperty("group", group);
        obj.putProperty("type", type);
        obj.putProperty("supSelect", Boolean.TRUE);
        if (type.equals("string")) {
            obj.putProperty("supLike", Boolean.TRUE);
        } else {
            obj.putProperty("supLike", Boolean.FALSE);
        }
        obj.putProperty("supCompare", Boolean.TRUE);
        obj.putProperty("supNull", Boolean.TRUE);
        obj.putProperty("supAutoIncrement", Boolean.FALSE);
        obj.putProperty("supDefaultvalue", null);
        obj.putProperty("index", new Integer(index));
        obj.putProperty("supUpdate", Boolean.TRUE);
        obj.putProperty("length", "100");
        int indexOfDot = name.lastIndexOf(".");
        name = flag ? name.substring(indexOfDot + 1) : String.valueOf(index);
        obj.putProperty("nameInSource", name);
        return obj;
    }

    public static List<FakeMetadataObject> createElements(FakeMetadataObject group, String[] names, String[] types) {
        String groupRoot = group.getName() + ".";
        ArrayList<FakeMetadataObject> elements = new ArrayList<FakeMetadataObject>();
        for (int i = 0; i < names.length; ++i) {
            FakeMetadataObject element = FakeMetadataFactory.createElement(groupRoot + names[i], group, types[i], i);
            elements.add(element);
        }
        return elements;
    }

    public static List createElements(FakeMetadataObject group, String[] names, String[] types, boolean flag) {
        String groupRoot = group.getName() + ".";
        ArrayList<FakeMetadataObject> elements = new ArrayList<FakeMetadataObject>();
        for (int i = 0; i < names.length; ++i) {
            FakeMetadataObject element = FakeMetadataFactory.createElement(groupRoot + names[i], group, types[i], i, flag);
            elements.add(element);
        }
        return elements;
    }

    public static List createElementsWithDefaults(FakeMetadataObject group, String[] names, String[] types, Object[] defaults) {
        String groupRoot = group.getName() + ".";
        ArrayList<FakeMetadataObject> elements = new ArrayList<FakeMetadataObject>();
        for (int i = 0; i < names.length; ++i) {
            FakeMetadataObject element = FakeMetadataFactory.createElement(groupRoot + names[i], group, types[i], i);
            element.setDefaultValue(defaults[i]);
            elements.add(element);
        }
        return elements;
    }

    public static FakeMetadataObject createIndex(String name, FakeMetadataObject group, List elements) {
        FakeMetadataObject obj = new FakeMetadataObject(name, "Key");
        obj.putProperty("keyType", FakeMetadataObject.TYPE_INDEX);
        obj.putProperty("keyElements", elements);
        ArrayList<FakeMetadataObject> keys = (ArrayList<FakeMetadataObject>)group.getProperty("keys");
        if (keys == null) {
            keys = new ArrayList<FakeMetadataObject>();
            group.putProperty("keys", keys);
        }
        keys.add(obj);
        return obj;
    }

    public static FakeMetadataObject createKey(String name, FakeMetadataObject group, List elements) {
        FakeMetadataObject obj = new FakeMetadataObject(name, "Key");
        obj.putProperty("keyType", FakeMetadataObject.TYPE_PRIMARY_KEY);
        obj.putProperty("keyElements", elements);
        ArrayList<FakeMetadataObject> keys = (ArrayList<FakeMetadataObject>)group.getProperty("keys");
        if (keys == null) {
            keys = new ArrayList<FakeMetadataObject>();
            group.putProperty("keys", keys);
        }
        keys.add(obj);
        return obj;
    }

    public static FakeMetadataObject createForeignKey(String name, FakeMetadataObject group, List elements, FakeMetadataObject primaryKey) {
        FakeMetadataObject obj = new FakeMetadataObject(name, "Key");
        obj.putProperty("keyType", FakeMetadataObject.TYPE_FOREIGN_KEY);
        obj.putProperty("keyElements", elements);
        obj.putProperty("referencedKey", primaryKey);
        ArrayList<FakeMetadataObject> keys = (ArrayList<FakeMetadataObject>)group.getProperty("keys");
        if (keys == null) {
            keys = new ArrayList<FakeMetadataObject>();
            group.putProperty("keys", keys);
        }
        keys.add(obj);
        return obj;
    }

    public static FakeMetadataObject createAccessPattern(String name, FakeMetadataObject group, List elements) {
        FakeMetadataObject obj = new FakeMetadataObject(name, "Key");
        obj.putProperty("keyType", FakeMetadataObject.TYPE_ACCESS_PATTERN);
        obj.putProperty("keyElements", elements);
        ArrayList<FakeMetadataObject> keys = (ArrayList<FakeMetadataObject>)group.getProperty("keys");
        if (keys == null) {
            keys = new ArrayList<FakeMetadataObject>();
            group.putProperty("keys", keys);
        }
        keys.add(obj);
        return obj;
    }

    public static FakeMetadataObject createParameter(String name, int index, int direction, String type, Object resultSet) {
        FakeMetadataObject obj = new FakeMetadataObject(name, "Parameter");
        obj.putProperty("index", new Integer(index));
        obj.putProperty("direction", new Integer(direction));
        if (resultSet != null) {
            obj.putProperty("isRS", resultSet);
            obj.putProperty("type", "integer");
        } else {
            obj.putProperty("type", type);
        }
        obj.putProperty("nameInSource", name);
        return obj;
    }

    public static FakeMetadataObject createStoredProcedure(String name, FakeMetadataObject model, List params, String callableName) {
        FakeMetadataObject obj = new FakeMetadataObject(name, "Procedure");
        obj.putProperty("model", model);
        obj.putProperty("params", params);
        obj.putProperty("callableName", callableName);
        return obj;
    }

    public static FakeMetadataObject createVirtualProcedure(String name, FakeMetadataObject model, List params, Object queryPlan) {
        FakeMetadataObject obj = new FakeMetadataObject(name, "Procedure");
        obj.putProperty("model", model);
        obj.putProperty("params", params);
        obj.putProperty("plan", queryPlan);
        return obj;
    }

    public static FakeMetadataObject createResultSet(String name, FakeMetadataObject model, String[] colNames, String[] colTypes) {
        FakeMetadataObject obj = new FakeMetadataObject(name, "ResultSet");
        obj.putProperty("model", model);
        ArrayList<ElementSymbol> columns = new ArrayList<ElementSymbol>();
        for (int i = 0; i < colNames.length; ++i) {
            ElementSymbol col = new ElementSymbol(colNames[i]);
            col.setType(DataTypeManager.getDataTypeClass((String)colTypes[i]));
            FakeMetadataObject colId = new FakeMetadataObject(colNames[i], "Element");
            colId.putProperty("type", colTypes[i]);
            colId.putProperty("length", "10");
            colId.putProperty("supSelect", Boolean.TRUE);
            col.setMetadataID((Object)colId);
            columns.add(col);
        }
        obj.putProperty("columns", columns);
        return obj;
    }
}

