/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.unittest;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class FakeMetadataObject
implements Comparable,
Serializable {
    public static final String MODEL = "Model";
    public static final String GROUP = "Group";
    public static final String ELEMENT = "Element";
    public static final String KEY = "Key";
    public static final String PROCEDURE = "Procedure";
    public static final String PARAMETER = "Parameter";
    public static final String RESULT_SET = "ResultSet";
    public static final Integer TYPE_PRIMARY_KEY = new Integer(2);
    public static final Integer TYPE_FOREIGN_KEY = new Integer(3);
    public static final Integer TYPE_INDEX = new Integer(4);
    public static final Integer TYPE_ACCESS_PATTERN = new Integer(5);
    private String name;
    private String type;
    private Object defaultValue;
    private Map props = new HashMap();
    private Properties extensionProps;

    public FakeMetadataObject(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void putProperty(String propName, Object value) {
        this.props.put(propName, value);
    }

    public Object getProperty(String propName) {
        return this.props.get(propName);
    }

    public Object getProperty(String propName, Object defaultValue) {
        Object result = this.props.get(propName);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof FakeMetadataObject)) {
            return false;
        }
        FakeMetadataObject other = (FakeMetadataObject)obj;
        return this.getType().equals(other.getType()) && this.getName().equalsIgnoreCase(other.getName());
    }

    public int hashCode() {
        return this.getName().toUpperCase().hashCode();
    }

    public int compareTo(Object obj) {
        FakeMetadataObject other = (FakeMetadataObject)obj;
        if (this.getProperty("index") != null && other.getProperty("index") != null) {
            return this.compareToWithIndices(other);
        }
        return this.compareToWithHashCodes(other);
    }

    private int compareToWithIndices(FakeMetadataObject other) {
        Integer otherIndex = (Integer)other.getProperty("index");
        Integer myIndex = (Integer)this.getProperty("index");
        return myIndex.compareTo(otherIndex);
    }

    private int compareToWithHashCodes(FakeMetadataObject other) {
        int otherHash = other.hashCode();
        int myHash = this.hashCode();
        if (myHash < otherHash) {
            return -1;
        }
        if (myHash > otherHash) {
            return 1;
        }
        return 0;
    }

    public void setExtensionProp(String name, String value) {
        if (this.extensionProps == null) {
            this.extensionProps = new Properties();
        }
        this.extensionProps.setProperty(name, value);
    }

    public Properties getExtensionProps() {
        return this.extensionProps;
    }

    public String toString() {
        return this.getType() + "(" + this.getName() + ")";
    }

    public static class Props {
        public static final String IS_VIRTUAL = "isVirtual";
        public static final String MODEL = "model";
        public static final String TYPE = "type";
        public static final String INDEX = "index";
        public static final String NAME_IN_SOURCE = "nameInSource";
        public static final String PLAN = "plan";
        public static final String UPDATE = "supUpdate";
        public static final String MAX_SET_SIZE = "maxSetSize";
        public static final String TEMP = "temp";
        public static final String KEYS = "keys";
        public static final String CARDINALITY = "cardinality";
        public static final String MAT_GROUP = "matGroup";
        public static final String MAT_STAGE = "matStage";
        public static final String XML_SCHEMAS = "xmlSchemas";
        public static final String GROUP = "group";
        public static final String SELECT = "supSelect";
        public static final String SEARCHABLE_LIKE = "supLike";
        public static final String SEARCHABLE_COMPARE = "supCompare";
        public static final String NULL = "supNull";
        public static final String AUTO_INCREMENT = "supAutoIncrement";
        public static final String DEFAULT_VALUE = "supDefaultvalue";
        public static final String LENGTH = "length";
        public static final String CASE_SENSITIVE = "caseSensitive";
        public static final String SIGNED = "signed";
        public static final String PRECISION = "precision";
        public static final String SCALE = "scale";
        public static final String RADIX = "radix";
        public static final String NATIVE_TYPE = "nativeType";
        public static final String MAX_VALUE = "maxValue";
        public static final String MIN_VALUE = "minValue";
        public static final String IS_PROC_INPUT = "isProcedureInputElement";
        public static final String DISTINCT_VALUES = "distinctValues";
        public static final String NULL_VALUES = "nullValues";
        public static final String MODELED_TYPE = "modeledType";
        public static final String MODELED_BASE_TYPE = "baseType";
        public static final String MODELED_PRIMITIVE_TYPE = "primitiveType";
        public static final String KEY_TYPE = "keyType";
        public static final String KEY_ELEMENTS = "keyElements";
        public static final String REFERENCED_KEY = "referencedKey";
        public static final String PARAMS = "params";
        public static final String INSERT_PROCEDURE = "insertProcedure";
        public static final String UPDATE_PROCEDURE = "updateProcedure";
        public static final String DELETE_PROCEDURE = "deleteProcedure";
        public static final String CALLABLE_NAME = "callableName";
        public static final String UPDATE_COUNT = "updateCount";
        public static final String DIRECTION = "direction";
        public static final String RESULT_SET = "isRS";
        public static final String COLUMNS = "columns";
    }
}

