/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminshell;

import groovy.sql.TeiidSql;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.Properties;
import org.teiid.adminshell.AdminShell;
import org.teiid.adminshell.Help;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.script.io.ResultSetReader;

public class GroovySqlExtensions {
    private static Help help = new Help(GroovySqlExtensions.class);

    @Help.Doc(text="Get a Teiid connection with a URL")
    public static TeiidSql connect(@Help.Doc(text="url") String url) throws SQLException {
        return GroovySqlExtensions.connect(url, null, null);
    }

    @Help.Doc(text="Get a Teiid connection")
    public static TeiidSql connect(@Help.Doc(text="url") String url, @Help.Doc(text="user") String user, @Help.Doc(text="password") String password) throws SQLException {
        Connection c;
        Properties info = new Properties();
        if (user != null) {
            info.setProperty("user", user);
        }
        if (password != null) {
            info.setProperty("password", password);
        }
        if ((c = TeiidDriver.getInstance().connect(url, info)) == null) {
            throw new SQLException("Invalid url " + url);
        }
        return new TeiidSql(c);
    }

    @Help.Doc(text="Get a SQL connection using the defaults from connection.properties")
    public static TeiidSql connect() throws SQLException {
        AdminShell.loadConnectionProperties();
        return GroovySqlExtensions.connect(AdminShell.p.getProperty("jdbc.url", "jdbc:teiid:VDB@mm://localhost:31000"), AdminShell.p.getProperty("jdbc.user", "admin"), AdminShell.p.getProperty("jdbc.password", "teiid"));
    }

    @Help.Doc(text="Alternate row to String method that pretty prints SQL/XML", moreText={"e.g. sql.eachRow(\"select * from tables\", {row -> println rowToString(row) })"})
    public static String rowToString(ResultSet results) throws SQLException {
        StringBuilder sb = new StringBuilder();
        int columnCount = results.getMetaData().getColumnCount();
        for (int col = 1; col <= columnCount; ++col) {
            int type = results.getMetaData().getColumnType(col);
            if (type == 2004) {
                Object anObj = results.getObject(col);
                sb.append(anObj != null ? "BLOB" : "null");
            } else if (type == 2009) {
                SQLXML xml = results.getSQLXML(col);
                sb.append(xml != null ? ResultSetReader.prettyPrint(xml) : "null");
            } else {
                String str = results.getString(col);
                sb.append(str != null ? str : "null");
            }
            if (col == columnCount) continue;
            sb.append("    ");
        }
        return sb.toString();
    }

    @Help.Doc(text="Pretty prints the ResultSetMetadata", moreText={"e.g. sql.eachRow(\"select * from tables\", {rsmd -> println resultSetMetaDataToString(rsmd)},", "                {row -> println rowToString(row) })"})
    public static String resultSetMetaDataToString(ResultSetMetaData rsmd) throws SQLException {
        return ResultSetReader.resultSetMetaDataToString(rsmd, "    ");
    }

    @Help.Doc(text="Show help for all SQL Extension methods")
    public static void sqlHelp() {
        help.help();
    }

    @Help.Doc(text="Show help for the given SQL Extension method")
    public static void sqlHelp(@Help.Doc(text="method name") String method) {
        help.help(method);
    }
}

