/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.id;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teiid.core.CorePlugin;
import org.teiid.core.id.IntegerIDFactory;
import org.teiid.core.id.InvalidIDException;
import org.teiid.core.id.LongIDFactory;
import org.teiid.core.id.ObjectID;
import org.teiid.core.id.ObjectIDFactory;
import org.teiid.core.id.ParsedObjectID;
import org.teiid.core.id.StringIDFactory;
import org.teiid.core.id.UUIDFactory;

public class IDGenerator {
    private static final IDGenerator INSTANCE = new IDGenerator();
    private final Map factories = new HashMap();
    private final Set protocols = new HashSet();
    private ObjectIDFactory defaultFactory;

    public static IDGenerator getInstance() {
        return INSTANCE;
    }

    public IDGenerator() {
        UUIDFactory newDefaultFactory = new UUIDFactory();
        this.addFactory(newDefaultFactory);
        if (!this.hasDefaultFactory()) {
            this.setDefaultFactory(newDefaultFactory);
        }
    }

    public void addBuiltInFactories() {
        UUIDFactory newDefaultFactory = new UUIDFactory();
        this.addFactory(newDefaultFactory);
        if (!this.hasDefaultFactory()) {
            this.setDefaultFactory(newDefaultFactory);
        }
        this.addFactory(new IntegerIDFactory());
        this.addFactory(new LongIDFactory());
        this.addFactory(new StringIDFactory());
    }

    public void addFactory(ObjectIDFactory factory) {
        if (factory == null) {
            return;
        }
        String protocol = factory.getProtocol();
        if (!this.factories.containsKey(protocol)) {
            this.factories.put(protocol, factory);
        }
        this.protocols.add(protocol);
    }

    public boolean removeFactory(String protocol) {
        if (protocol == null) {
            return false;
        }
        Object previous = this.factories.remove(protocol);
        if (previous != null) {
            this.protocols.remove(protocol);
            return true;
        }
        return false;
    }

    public Collection getFactories() {
        return this.factories.values();
    }

    public ObjectIDFactory getFactory(String protocol) {
        return (ObjectIDFactory)this.factories.get(protocol);
    }

    public Set getProtocols() {
        return this.factories.keySet();
    }

    public boolean hasDefaultFactory() {
        return this.defaultFactory != null;
    }

    public ObjectIDFactory getDefaultFactory() {
        return this.defaultFactory;
    }

    public void setDefaultFactory(ObjectIDFactory factory) {
        this.defaultFactory = factory;
    }

    public void setDefaultFactory(String protocol) {
        ObjectIDFactory factory;
        this.defaultFactory = factory = this.getFactory(protocol);
    }

    public ObjectID create() {
        if (this.defaultFactory != null) {
            return this.defaultFactory.create();
        }
        throw new IllegalArgumentException(CorePlugin.Util.getString("IDGenerator.No_default_id_factory_has_been_defined"));
    }

    public ObjectID create(String protocol) {
        if (protocol == null) {
            String msg = CorePlugin.Util.getString("IDGenerator.The_protocol_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        ObjectIDFactory factory = (ObjectIDFactory)this.factories.get(protocol);
        if (factory != null) {
            return factory.create();
        }
        throw new IllegalArgumentException(CorePlugin.Util.getString("IDGenerator.The_specified_ObjectID_protocol___8", protocol));
    }

    public String toString(ObjectID id) {
        return ((Object)id).toString();
    }

    public String toString(ObjectID id, char delim) {
        return id.toString(delim);
    }

    public ObjectID stringToObject(String id) throws InvalidIDException {
        if (id == null) {
            String msg = CorePlugin.Util.getString("IDGenerator.The_stringified_ID_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        ParsedObjectID parsedID = ParsedObjectID.parsedStringifiedObjectID(id, this.protocols);
        ObjectIDFactory factory = (ObjectIDFactory)this.factories.get(parsedID.getProtocol());
        ObjectID result = null;
        if (factory != null) {
            result = factory.stringWithoutProtocolToObject(parsedID.getRemainder());
        }
        if (result == null) {
            throw new InvalidIDException(CorePlugin.Util.getString("IDGenerator.The_stringified_ObjectID_has_an_unknown_protocol___16") + parsedID.getProtocol());
        }
        return result;
    }

    public ObjectID stringToObject(String id, String protocol) throws InvalidIDException {
        if (id == null) {
            String msg = CorePlugin.Util.getString("IDGenerator.The_stringified_ID_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        ParsedObjectID parsedID = ParsedObjectID.parsedStringifiedObjectID(id, protocol);
        ObjectIDFactory factory = (ObjectIDFactory)this.factories.get(parsedID.getProtocol());
        ObjectID result = null;
        if (factory != null) {
            result = factory.stringWithoutProtocolToObject(parsedID.getRemainder());
        }
        if (result == null) {
            throw new InvalidIDException(CorePlugin.Util.getString("IDGenerator.The_stringified_ObjectID_has_an_unknown_protocol___16") + parsedID.getProtocol());
        }
        return result;
    }

    public ObjectID stringToObject(String id, char delim) throws InvalidIDException {
        if (id == null) {
            String msg = CorePlugin.Util.getString("IDGenerator.The_stringified_ID_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        ParsedObjectID parsedID = ParsedObjectID.parsedStringifiedObjectID(id, delim);
        ObjectIDFactory factory = (ObjectIDFactory)this.factories.get(parsedID.getProtocol());
        ObjectID result = null;
        if (factory != null) {
            result = factory.stringWithoutProtocolToObject(parsedID.getRemainder());
        }
        if (result == null) {
            throw new InvalidIDException(CorePlugin.Util.getString("IDGenerator.The_stringified_ObjectID_has_an_unknown_protocol___16") + parsedID.getProtocol());
        }
        return result;
    }
}

