/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.id;

import java.io.Serializable;
import org.teiid.core.CorePlugin;
import org.teiid.core.id.IntegerID;
import org.teiid.core.id.InvalidIDException;
import org.teiid.core.id.ObjectID;
import org.teiid.core.id.ObjectIDFactory;
import org.teiid.core.id.ParsedObjectID;

public class IntegerIDFactory
implements ObjectIDFactory,
Serializable {
    private int lastID = 0;

    @Override
    public String getDescription() {
        return CorePlugin.Util.getString("IntegerIDFactory.Description");
    }

    protected int getNextValue() {
        return ++this.lastID;
    }

    @Override
    public ObjectID create() {
        return new IntegerID(this.getNextValue());
    }

    public boolean validate(ObjectID id) {
        return id instanceof IntegerID;
    }

    @Override
    public ObjectID stringToObject(String value) throws InvalidIDException {
        ParsedObjectID parsedID = ParsedObjectID.parsedStringifiedObjectID(value, "mmint");
        try {
            return new IntegerID(Integer.parseInt(parsedID.getRemainder()));
        }
        catch (NumberFormatException e) {
            throw new InvalidIDException(CorePlugin.Util.getString("IntegerIDFactory.The_specified_ID_value_is_invalid", value, this.getProtocol()));
        }
    }

    @Override
    public ObjectID stringWithoutProtocolToObject(String value) throws InvalidIDException {
        try {
            return new IntegerID(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new InvalidIDException(CorePlugin.Util.getString("IntegerIDFactory.The_specified_ID_value_is_invalid", value, this.getProtocol()));
        }
    }

    @Override
    public String getProtocol() {
        return "mmint";
    }
}

