/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.id;

import java.io.Serializable;
import org.teiid.core.CorePlugin;
import org.teiid.core.id.InvalidIDException;
import org.teiid.core.id.LongID;
import org.teiid.core.id.ObjectID;
import org.teiid.core.id.ObjectIDFactory;
import org.teiid.core.id.ParsedObjectID;

public class LongIDFactory
implements ObjectIDFactory,
Serializable {
    private long lastID = 0L;

    @Override
    public String getDescription() {
        return CorePlugin.Util.getString("LongIDFactory.Description");
    }

    protected long getNextValue() {
        return ++this.lastID;
    }

    @Override
    public ObjectID create() {
        return new LongID(this.getNextValue());
    }

    public boolean validate(ObjectID id) {
        return id instanceof LongID;
    }

    @Override
    public ObjectID stringWithoutProtocolToObject(String value) throws InvalidIDException {
        try {
            return new LongID(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            throw new InvalidIDException(CorePlugin.Util.getString("LongIDFactory.The_specified_ID_value_is_invalid", value, this.getProtocol()));
        }
    }

    @Override
    public ObjectID stringToObject(String value) throws InvalidIDException {
        ParsedObjectID parsedID = ParsedObjectID.parsedStringifiedObjectID(value, "mmlong");
        try {
            return new LongID(Long.parseLong(parsedID.getRemainder()));
        }
        catch (NumberFormatException e) {
            throw new InvalidIDException(CorePlugin.Util.getString("LongIDFactory.The_specified_ID_value_is_invalid", value, this.getProtocol()));
        }
    }

    @Override
    public String getProtocol() {
        return "mmlong";
    }
}

