/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.transform.Source;
import org.teiid.core.util.ReaderInputStream;

public abstract class InputStreamFactory
implements Source {
    private String systemId;
    private long length = -1L;

    public abstract InputStream getInputStream() throws IOException;

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void free() throws IOException {
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public Reader getCharacterStream() throws IOException {
        return null;
    }

    public static class SQLXMLInputStreamFactory
    extends InputStreamFactory {
        private SQLXML sqlxml;

        public SQLXMLInputStreamFactory(SQLXML sqlxml) {
            this.sqlxml = sqlxml;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                return this.sqlxml.getBinaryStream();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }

        @Override
        public Reader getCharacterStream() throws IOException {
            try {
                return this.sqlxml.getCharacterStream();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
    }

    public static class BlobInputStreamFactory
    extends InputStreamFactory {
        private Blob blob;

        public BlobInputStreamFactory(Blob blob) {
            this.blob = blob;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                return this.blob.getBinaryStream();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }

        @Override
        public long getLength() {
            try {
                return this.blob.length();
            }
            catch (SQLException e) {
                return -1L;
            }
        }
    }

    public static class ClobInputStreamFactory
    extends InputStreamFactory {
        private Clob clob;
        private Charset charset = Charset.forName("UTF-8");

        public ClobInputStreamFactory(Clob clob) {
            this.clob = clob;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                return new ReaderInputStream(this.clob.getCharacterStream(), this.charset);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }

        @Override
        public Reader getCharacterStream() throws IOException {
            try {
                return this.clob.getCharacterStream();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
    }

    public static class FileInputStreamFactory
    extends InputStreamFactory {
        private File f;

        public FileInputStreamFactory(File f) {
            this.f = f;
            this.setSystemId(f.toURI().toASCIIString());
        }

        @Override
        public long getLength() {
            return this.f.length();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.f));
        }
    }

    public static interface StreamFactoryReference {
        public void setStreamFactory(InputStreamFactory var1);
    }
}

