/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.naming.ConfigurationException;
import org.teiid.core.TeiidRuntimeException;

public class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static Iterator getChildrenIterator(Throwable e) {
        return new NestedExceptionIterator(e);
    }

    public static void printNestedStackTrace(Throwable exception, PrintStream output) {
        if (exception != null) {
            exception.printStackTrace(output);
            Iterator children = ExceptionUtil.getChildrenIterator(exception);
            while (children.hasNext()) {
                exception = (Throwable)children.next();
                output.print(TeiidRuntimeException.CAUSED_BY_STRING);
                exception.printStackTrace(output);
            }
        }
    }

    public static String getLinkedMessagesVerbose(Throwable exception) {
        return ExceptionUtil.getLinkedMessagesVerbose(exception, 0);
    }

    public static String getLinkedMessagesVerbose(Throwable exception, int level) {
        if (exception != null) {
            StringBuffer buf = new StringBuffer();
            String lastMessage = ExceptionUtil.appendMessage("", buf, null, exception);
            Iterator children = ExceptionUtil.getChildrenIterator(exception);
            while (children.hasNext()) {
                ++level;
                exception = (Throwable)children.next();
                lastMessage = ExceptionUtil.appendMessage("->", buf, lastMessage, exception);
            }
            return buf.toString();
        }
        return "";
    }

    public static String getLinkedMessages(Throwable exception) {
        return ExceptionUtil.getLinkedMessages(exception, 0);
    }

    public static String getLinkedMessages(Throwable exception, int level) {
        if (exception != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(exception.getMessage());
            Iterator children = ExceptionUtil.getChildrenIterator(exception);
            while (children.hasNext()) {
                ++level;
                exception = (Throwable)children.next();
                buf.append(exception.getMessage());
            }
            return buf.toString();
        }
        return "";
    }

    private static final String appendMessage(String prefix, StringBuffer buffer, String lastMessage, Throwable exception) {
        String message = exception.getMessage();
        buffer.append(prefix);
        buffer.append(ExceptionUtil.getClassName(exception));
        if (message != null && !message.equals(lastMessage)) {
            buffer.append('-');
            buffer.append(message);
        }
        return message;
    }

    private static final String getClassName(Throwable exception) {
        String className = exception.getClass().getName();
        int index = className.lastIndexOf(46);
        if (index >= 0 && index < className.length() - 1) {
            return className.substring(index + 1);
        }
        return className;
    }

    public static class NestedExceptionIterator
    implements Iterator {
        Throwable exception;
        Throwable child;

        public NestedExceptionIterator(Throwable e) {
            this.exception = e;
        }

        @Override
        public boolean hasNext() {
            this.check();
            return this.child != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.exception = this.child;
            this.child = null;
            return this.exception;
        }

        private void check() {
            if (this.child == null) {
                if (this.exception instanceof ConfigurationException) {
                    ConfigurationException e = (ConfigurationException)this.exception;
                    this.child = e.getRootCause();
                } else if (this.exception instanceof SQLException) {
                    SQLException e = (SQLException)this.exception;
                    this.child = e.getNextException();
                }
                if (this.child == null) {
                    this.child = this.exception.getCause();
                }
                if (this.child == this.exception) {
                    this.child = null;
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

