/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public final class HashCodeUtil {
    private static final int PRIME = 1000003;

    public static final int hashCode(int previous, boolean x) {
        return 1000003 * previous + (x ? 1 : 0);
    }

    public static final int hashCode(int previous, int x) {
        return 1000003 * previous + x;
    }

    public static final int hashCode(int previous, long x) {
        return 1000003 * previous + (int)(1000003L * (x >>> 32) + (x & 0xFFFFFFFFFFFFFFFFL));
    }

    public static final int hashCode(int previous, float x) {
        return HashCodeUtil.hashCode(previous, x == 0.0f ? 0 : Float.floatToIntBits(x));
    }

    public static final int hashCode(int previous, double x) {
        return HashCodeUtil.hashCode(previous, x == 0.0 ? 0L : Double.doubleToLongBits(x));
    }

    public static final int hashCode(int previous, Object ... x) {
        if (x == null) {
            return 1000003 * previous;
        }
        int hc = previous;
        for (int i = 0; i < x.length; ++i) {
            hc = x[i] == null ? 1000003 * hc : 1000003 * hc + x[i].hashCode();
        }
        return hc;
    }

    public static final int expHashCode(int previous, Object[] x) {
        if (x == null) {
            return 1000003 * previous;
        }
        int hc = 1000003 * previous + x.length;
        int xlen = x.length + 1;
        for (int index = 1; index < xlen; index <<= 1) {
            hc = HashCodeUtil.hashCode(hc, x[index - 1]);
        }
        return hc;
    }

    public static final int expHashCode(int previous, List x) {
        if (x == null || x.size() == 0) {
            return 1000003 * previous;
        }
        int size = x.size();
        int hc = 1000003 * previous + size;
        if (x instanceof RandomAccess) {
            int xlen = x.size() + 1;
            for (int index = 1; index < xlen; index <<= 1) {
                hc = HashCodeUtil.hashCode(hc, x.get(index - 1));
            }
        } else {
            int skip = 0;
            Iterator iter = x.iterator();
            Object obj = iter.next();
            for (int total = 0; total < size; total += skip) {
                for (int i = 0; i < skip; ++i) {
                    obj = iter.next();
                }
                hc = HashCodeUtil.hashCode(hc, obj);
                skip = skip == 0 ? 1 : skip << 1;
            }
        }
        return hc;
    }

    public static final int expHashCode(String x) {
        if (x == null) {
            return 0;
        }
        int hc = x.length();
        int xlen = x.length() + 1;
        for (int index = 1; index < xlen; index <<= 1) {
            hc = 1000003 * hc + x.charAt(index - 1);
        }
        return hc;
    }
}

