/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.id;

import java.util.HashSet;
import java.util.Random;
import junit.framework.TestCase;
import org.teiid.core.id.InvalidIDException;
import org.teiid.core.id.ObjectID;
import org.teiid.core.id.UUID;

public class TestUUID
extends TestCase {
    private static final int NGEN_POWERS = 63;
    private static final int NGEN_RANDOM = 10000;

    public TestUUID(String name) {
        super(name);
    }

    private static void helpTestGenPowers(int nGen) {
        UUID uuid = null;
        for (int j = 0; j < Math.min(nGen, 63); ++j) {
            long v1 = 1L << j;
            long v2 = (1L << j) / 2L;
            uuid = new UUID(v1, v2);
            TestUUID.checkStringToObject(uuid);
        }
    }

    private static void helpTestGenRandom(int nGen) {
        UUID uuid = null;
        Random rng = new Random();
        for (int k = 0; k < nGen; ++k) {
            long v1 = rng.nextLong();
            long v2 = rng.nextLong();
            uuid = new UUID(v1, v2);
            TestUUID.checkStringToObject(uuid);
        }
    }

    private static void helpTestDuplicates(int nGen) {
        UUID uuid = null;
        HashSet<UUID> uuids = new HashSet<UUID>();
        for (int j = 0; j < Math.min(nGen, 63); ++j) {
            long v1 = 1L << j;
            long v2 = (1L << j) / 2L;
            uuid = new UUID(v1, v2);
            TestUUID.assertTrue((String)("UUID '" + uuid + "' is a duplicate!"), (!uuids.contains(uuid) ? 1 : 0) != 0);
            uuids.add(uuid);
        }
        Random rng = new Random();
        for (int k = 0; k < nGen; ++k) {
            long v2;
            long v1 = rng.nextLong();
            uuid = new UUID(v1, v2 = rng.nextLong());
            if (uuids.contains(uuid)) {
                TestUUID.fail((String)("UUID '" + uuid + "' is a duplicate!"));
            }
            uuids.add(uuid);
        }
    }

    public static void checkStringToObject(UUID id1) {
        String uuidString = id1.exportableForm();
        UUID id2 = null;
        try {
            id2 = (UUID)UUID.stringToObject((String)uuidString);
        }
        catch (InvalidIDException e) {
            TestUUID.fail((String)("Could not convert UUID exportable form '" + uuidString + "' to UUID: " + e.getMessage()));
        }
        TestUUID.assertTrue((String)("UUID '" + id1 + "' conversion to string and back failed: " + "most significant part did not match."), (UUID.getPart1((ObjectID)id1) == UUID.getPart1((ObjectID)id2) ? 1 : 0) != 0);
        TestUUID.assertTrue((String)("UUID '" + id1 + "' conversion to string and back failed: " + "least significant part did not match."), (UUID.getPart2((ObjectID)id1) == UUID.getPart2((ObjectID)id2) ? 1 : 0) != 0);
    }

    public void testGenPowers() {
        TestUUID.helpTestGenPowers(63);
    }

    public void testGenRandom() {
        TestUUID.helpTestGenRandom(10000);
    }

    public void testDuplicates() {
        TestUUID.helpTestDuplicates(10000);
    }
}

