/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.id;

import junit.framework.TestCase;
import org.teiid.core.id.InvalidIDException;
import org.teiid.core.id.UUIDFactory;

public class TestUUIDFactoryWithoutCreation
extends TestCase {
    private static final String STRINGIFIED_ID_1 = "mmuuid:fdb70a40-f02f-1e59-972f-9c0cb9386e57";
    private static final String STRINGIFIED_ID_2 = "mmuuid:fdb70a41-f02f-1e59-972f-9c0cb9386e57";
    private static final String STRINGIFIED_ID_3 = "mmuuid:060f4540-f030-1e59-972f-9c0cb9386e57";
    private static final String STRINGIFIED_ID_4 = "mmuuid:060f4541-f030-1e59-972f-9c0cb9386e57";

    public TestUUIDFactoryWithoutCreation(String name) {
        super(name);
    }

    public void helpTestStringToObject(UUIDFactory factory, String id) {
        try {
            factory.stringToObject(id);
        }
        catch (InvalidIDException e) {
            throw new RuntimeException(e);
        }
    }

    public void testFactoryCreationTimeWithMultipleParses() {
        long start = System.currentTimeMillis();
        UUIDFactory myFactory = new UUIDFactory();
        this.helpTestStringToObject(myFactory, STRINGIFIED_ID_1);
        this.helpTestStringToObject(myFactory, STRINGIFIED_ID_2);
        this.helpTestStringToObject(myFactory, STRINGIFIED_ID_3);
        this.helpTestStringToObject(myFactory, STRINGIFIED_ID_4);
        TestUUIDFactoryWithoutCreation.assertTrue((System.currentTimeMillis() - start < 500L ? 1 : 0) != 0);
    }
}

