/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialClob;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.util.UnitTestUtil;

public class TestClobValue {
    @Test
    public void testClobValue() throws Exception {
        String testString = "this is test clob";
        SerialClob clob = new SerialClob(testString.toCharArray());
        ClobType cv = new ClobType((Clob)clob);
        Assert.assertEquals((Object)testString, (Object)cv.getSubString(1L, (int)cv.length()));
    }

    @Test
    public void testClobValuePersistence() throws Exception {
        String testString = "this is test clob";
        SerialClob clob = new SerialClob(testString.toCharArray());
        String key = "keytodata";
        ClobType cv = new ClobType((Clob)clob);
        cv.setReferenceStreamId(key);
        File saved = new File(UnitTestUtil.getTestScratchPath() + "/clobassaved.bin");
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(saved));
        out.writeObject(cv);
        out.close();
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(saved));
        ClobType read = (ClobType)in.readObject();
        Assert.assertTrue((read.length() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)key, (Object)read.getReferenceStreamId());
        Assert.assertNull((Object)read.getReference());
        saved.delete();
    }

    @Test
    public void testClobSubstring() throws Exception {
        ClobImpl clob = new ClobImpl(){

            public Reader getCharacterStream() throws SQLException {
                return new Reader(){
                    int pos = 0;

                    @Override
                    public void close() throws IOException {
                    }

                    @Override
                    public int read(char[] cbuf, int off, int len) throws IOException {
                        if (this.pos < 2) {
                            cbuf[off] = 97;
                            ++this.pos;
                            return 1;
                        }
                        return -1;
                    }
                };
            }
        };
        Assert.assertEquals((Object)"aa", (Object)clob.getSubString(1L, 3));
    }
}

