/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import javax.xml.transform.stream.StreamSource;
import junit.framework.TestCase;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.util.ObjectConverterUtil;

public class TestSQLXMLImpl
extends TestCase {
    String testStr = "<foo>test</foo>";

    public void testGetSource() throws Exception {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        TestSQLXMLImpl.assertTrue((boolean)(xml.getSource(null) instanceof StreamSource));
        StreamSource ss = (StreamSource)xml.getSource(null);
        TestSQLXMLImpl.assertEquals((String)this.testStr, (String)new String(ObjectConverterUtil.convertToByteArray((InputStream)ss.getInputStream()), "UTF-8"));
    }

    public void testGetCharacterStream() throws Exception {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        TestSQLXMLImpl.assertEquals((String)this.testStr, (String)this.getContents(xml.getCharacterStream()));
    }

    public void testGetBinaryStream() throws Exception {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        TestSQLXMLImpl.assertEquals((String)this.testStr, (String)new String(ObjectConverterUtil.convertToByteArray((InputStream)xml.getBinaryStream()), "UTF-8"));
    }

    public void testGetString() throws Exception {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        TestSQLXMLImpl.assertEquals((String)this.testStr, (String)xml.getString());
    }

    public void testSetBinaryStream() throws Exception {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        try {
            xml.setBinaryStream();
            TestSQLXMLImpl.fail((String)"we do not support this yet..");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testSetCharacterStream() throws Exception {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        try {
            xml.setCharacterStream();
            TestSQLXMLImpl.fail((String)"we do not support this yet..");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testSetString() throws Exception {
        SQLXMLImpl xml = new SQLXMLImpl(this.testStr);
        try {
            xml.setString(this.testStr);
            TestSQLXMLImpl.fail((String)"we do not support this yet..");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private String getContents(Reader reader) throws IOException {
        StringBuffer sb = new StringBuffer();
        int chr = reader.read();
        while (chr != -1) {
            sb.append((char)chr);
            chr = reader.read();
        }
        reader.close();
        return sb.toString();
    }
}

