/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLXML;
import junit.framework.TestCase;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.UnitTestUtil;

public class TestXMLValue
extends TestCase {
    public void testXMLValue() throws Exception {
        String testString = "<foo>this is an xml value test</foo>";
        SQLXMLImpl xml = new SQLXMLImpl(testString);
        XMLType xv = new XMLType((SQLXML)xml);
        TestXMLValue.assertEquals((String)testString, (String)xv.getString());
    }

    public void testXMLValuePersistence() throws Exception {
        String testString = "<foo>this is an xml value test</foo>";
        SQLXMLImpl xml = new SQLXMLImpl(testString);
        String key = "keytodata";
        String pkey = "peresistkeytodata";
        XMLType xv = new XMLType((SQLXML)xml);
        xv.setReferenceStreamId(key);
        File saved = new File(UnitTestUtil.getTestScratchPath() + "/xmlsaved.bin");
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(saved));
        out.writeObject(xv);
        out.close();
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(saved));
        XMLType read = (XMLType)in.readObject();
        TestXMLValue.assertEquals((String)key, (String)read.getReferenceStreamId());
        TestXMLValue.assertNull((Object)read.getReference());
        saved.delete();
    }
}

